/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985, 1987, 1990, 1991, 1992  Digital Research Inc.	    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/dsk/rcs/deskfpd.h 4.9 92/04/03 17:12:57 sbc Exp $
* $Log:	deskfpd.h $
 * Revision 4.9  92/04/03  17:12:57  sbc
 * WNODEs and PNODEs to fars, lots of other housekeeping
 * 
 * Revision 4.8  92/03/26  14:45:28  sbc
 * WNODEs and PNODEs to far ptrs. Also merge in RSF's changes
 * 
 * Revision 4.7  92/03/13  14:43:59  sbc
 * Merge in Keiko's changes required for Double Byte Character Support
 * 
 * Revision 4.6  92/03/05  09:29:25  sbc
 * Hook up use of New Program Item dialog and INODE structure.
 * 
 * Revision 4.5  92/02/27  09:40:23  sbc
 * Allow assignment of icon to ordinary FNODE.
 * 
 * Revision 4.4  92/02/25  08:13:01  sbc
 * Add New Icon Dialog and allow assignment of icons (only) to FNODEs/ANODEs.
 * 
 * Revision 4.3  92/02/20  15:56:52  sbc
 * Various changes to ANODE structure and defines
 * 
 * Revision 4.2  92/02/19  16:06:50  sbc
 * FAR => far
 * 
 * Revision 4.1  91/12/20  13:29:00  anderson
 * ViewMAX 3 baseline.  Got rid of TNODEs...using FNODEs only.  Packed 
 * TNODE->level in as high nibble of FNODE->istree.  Added macros for getting
 * and setting each nibble independently.
 * 
 * Revision 3.1  91/08/19  16:30:59  system
 * ViewMAX 2 sources
 * 
Date	Who	Spr	Comments
----	---	---	--------
911031	K.H		Move IBM graphics characters to resource file.
910520	RSF		Reverse +/- vs SHOW/HIDEKIDS.
910501	RSF		Merge in Heather's C-E tree work.
*****************************************************************************/

#ifndef DESKFPD_INCLUDED
#define DESKFPD_INCLUDED

#include <dir.h>

#define	LEN_PASSW	MAXFILE			/* 9	    from dir.h	*/
#define LEN_ZFNAME	(MAXFILE+MAXEXT-1)	/* (9+5-1)  from dir.h	*/

#define	MAX_LEVEL  10
						/* MAXDRIVE=3 (dir.h)	*/
#define LEN_ZPATH (MAXDRIVE+((LEN_ZFNAME+LEN_PASSW+1)*(MAX_LEVEL+1)))

#define OP_COUNT 0
#define OP_DELETE 1
#define OP_COPY 2

#define D_PERM 0x0001

#define V_ICON 0
#define V_TEXT 1

#define S_NAME 0
#define S_DATE 1
#define S_SIZE 2
#define S_TYPE 3
#define S_DISK 4

#define E_NOERROR 0
#define E_NOFNODES 100
#define E_NOPNODES 101
#define E_NODNODES 102

#define NUM_TNODES 400
#define NUM_FNODES (400 + 339)		/* 339 extra to use space gained by  */
					/* by reducing TNODE allocation from */
					/* 800 @ 37 ea. to 400 @ 35 ea.	     */

#define NUM_PNODES ((NUM_WNODES*2) + 1)	/*   one more than windows	*/
					/*   for unopen disk copy	*/

#define LEN_FNODE	55		/* # chars: text view highlight bar */

/* funny IBM characters for drawing lines for tree windows */
extern UBYTE 	VERT_BAR;
extern UBYTE	HORIZ_BAR;
extern UBYTE	RIGHT_ELL;
extern UBYTE	LEFT_TEE;

/* (hca: treetag values: collapsed/expanded state) */
#define	SHOWKIDS	'+'
#define	NOKIDS		HORIZ_BAR
#define HIDEKIDS	'-'

/* the first five fields of this structure should match ANODE, below */
#define INODE struct inode_struct
INODE
{
	INODE		*i_next;
	BYTE		i_flags;		/* AF_ISDESK, AF_ISPARM	*/
	BYTE		i_type;			/* AT_ISPITM		*/
	BYTE *		i_label;		/* icon label		*/
	BYTE		i_icon;			/* program item icon #	*/
	BYTE		i_docicon;		/* data icon #		*/
	BYTE *		i_cmdline;		/* command line 	*/
	BYTE *		i_doctypes;     	/* document types       */
};

#define ANODE struct applstr
ANODE
{
	ANODE		*a_next;
	BYTE		a_flags;		/* AF_ISDESK, AF_ISDEF	*/
	BYTE		a_type;			/* AT_ISFOLD, AT_ISFILE */
	BYTE		*a_match;		/* wildcard to match	*/
	BYTE		a_icon;			/* icon #		*/
};
#define A_LETTER a_match[0]			/* letter for disk icon	*/

#define FNODE struct filenode
FNODE
{
	FNODE far	*f_next;
	BYTE		f_junk;		/* to align on even boundaries	*/
	BYTE		f_attr;
	UWORD		f_time;
	UWORD		f_date;
	LONG		f_size;
	BYTE		f_name[LEN_ZFNAME];
	BYTE		f_istree;		/* low nibble is tree flag: */
					        /*     (TRUE = tree node)   */
						/* high nibble is directory */
						/* level of the folder */
						/* USE MACROS BELOW TO ACCESS */
	BYTE		f_tree[MAX_LEVEL+1];
 	BYTE		f_treetag;
	WORD		f_wid;
	WORD		f_obid;
	void *		f_pa;
};

#define GET_TLVL(pf)		( (BYTE) (((FNODE far *)pf)->f_istree >> 4) )
#define SET_TLVL(pf, lvl)	( (BYTE) (((FNODE far *)pf)->f_istree = \
			    (((FNODE far *)pf)->f_istree & 0x0f) | (lvl << 4)) )

#define GET_ISTREE(pf)		( (BYTE) (((FNODE far *)pf)->f_istree & 0x0f) )
#define SET_ISTREE(pf, is)	( (BYTE) (((FNODE far *)pf)->f_istree = \
				    (((FNODE far *)pf)->f_istree & 0xf0) | is) )

#define PNODE struct pathnode
PNODE
{
	PNODE far *	p_next;
	BYTE far	p_spec[LEN_ZPATH];
	FNODE far *	p_flist;
	WORD		p_count;
	LONG		p_size;
};

#endif /* ndef DESKFPD_INCLUDED */

/*
 *	EOF:	deskfpd.h
 */
