/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   COPYRIGHT (c) 1985,1991,1992 Digital Research Inc.			    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/dsk/rcs/deskins.c 4.10 92/03/26 14:43:15 sbc Exp $
* $Log:	deskins.c $
 * Revision 4.10  92/03/26  14:43:15  sbc
 * WNODEs and PNODEs to far ptrs. Also merge in RSF's changes
 * 
 * Revision 4.9  92/03/12  13:56:36  rsf
 * Merge in RSF's changes for icons on desktop and (LONG) => (TREE).
 * 
 * Revision 4.8  92/02/25  08:13:23  sbc
 * Add New Icon Dialog and allow assignment of icons (only) to FNODEs/ANODEs.
 * 
 * Revision 4.7  92/02/20  15:56:13  sbc
 * Various changes to ANODE structure and defines
 * 
 * Revision 4.6  92/02/19  16:02:31  sbc
 * VOID => void, EXTERN => extern, FAR => far, G.a_trees[] => rsrc_gaddr(),
 * AF_ISCRYS and AF_ISGRAF => AF_ISGEM.
 * 
 * Revision 4.5  92/02/18  16:07:53  sbc
 * make various functions global to be called from deskpgrp.c (probably
 * will move or remove these later...)
 * /
 * 
 * Revision 4.4  92/02/14  15:02:20  sbc
 * generalize code for ins_app() used to display icon listbox in Configure
 * App dialog.
 * 
 * Revision 4.3  92/02/12  15:48:23  sbc
 * rename gl_num_icons to gl_num_icos
 * also display the proper data icon next to an app icon rather than just
 * the next one in the list. 
 * Remove the title string from the icon list box.
 * 
 * Revision 4.2  92/01/28  15:00:18  rsf
 * *** empty log message ***
 * 
 * Revision 4.2  92/01/21  13:36:31  Fontes
 * Screen Saver and Background work merged w/ Jan 7 sources from Heather
 * 
 * Revision 4.1  92/01/06  13:11:08  anderson
 * Color icon work from Becky.
 * 
 * Revision 3.1  91/08/19  16:37:59  system
 * ViewMAX 2 sources
 * 
* Revision 3.7  91/07/19  15:21:13  fontes
* set_3d_color calls
* 
* Revision 3.6  91/07/10  10:34:23  fontes
* Add end_draw parm
* 
* Revision 3.5  91/07/09  14:46:32  sbc
* fun_alert() => alert(); alert defines ST* => ER*
* 
* Revision 3.4  91/06/21  13:32:41  sbc
* fixes to configure app dialog.
* .,
* 
* Revision 3.3  91/06/11  14:07:59  sbc
* change form_do() to call to xform_do().
* 
* Revision 3.2  91/06/04  13:03:50  sbc
* misc housekeeping and other ravings...
* 
* Revision 3.1  91/05/16  14:42:37  fontes
* Separate branch for Beta bug fixes, separate from split-mode windows
* 
* Revision 2.1.1.3  91/05/08  16:22:19  whf
* resolve rsc object ordering dependencies
* 
* Revision 2.1.1.2  91/03/25  14:19:06  anderson
* Converted to Medium model, prototyped, and generally cleaned up.
* 
*****************************************************************************/

/****************************************************************************
* File:		deskins.c
*
* Description:	
*
* Build Info:	ndmake -f vm2.mak
*
* Overview:	
*  
*****************************************************************************/


#include "shell.h"
#include "list.h"
#include "exobdefs.h"
#include "exproto.h"

extern WORD	gl_hbox;
extern BYTE	gl_lngstr[256];

extern WORD	gl_pstart;

extern WORD	gl_num_icos;
extern WORD	gl_num_icfs;

extern GLOBES	G;

MLOCAL ICONBLK	gl_aib;
MLOCAL ICONBLK	gl_dib;

/* object offsets for children comprising a scroller. */
#define SCROLLUP	1
#define SCROLLDN	2
#define SCROLLAREA	3
#define SCROLLKNOB	4

/*-----------------------------------------------------------------------------
*	Routine to tell if an icon has an associated document type.
*/
WORD is_installed( ANODE * pa )
{
    return( *pa->a_match != '*' && 
	    *pa->a_match != '?' && 
	    *pa->a_match != NULL ) ;
}

/*----------------------------------------------------------------------*/
void insa_icon( TREE tree, WORD obj, WORD nicon, ICONBLK *pic, BYTE *ptext )
{
	init_icon((ICONBLK far *)pic, nicon);
	pic->ib_ptext = ADDR( ptext );
	(tree+obj)->ob_type = G_CLRICN ;
	(tree+obj)->ob_spec = (FBYTE *)pic ;
	
} /* insa_icon() */

/*----------------------------------------------------------------------*/
/* assumes that the icon objects are right next to each other		*/
void update_icon_pair( TREE tree, WORD obj, WORD icon )
{
    strcpy( G.g_1text, ini_str( STAPPL ) );	/* "Application"	*/
    insa_icon( tree, obj, icon, &gl_aib, G.g_1text );

    strcpy( G.g_2text, ini_str( STDOCU ) );	/* "Files"      	*/
    insa_icon( tree, obj+1, G.g_iconlist[icon].file_icon, &gl_dib, G.g_2text );

} /* update_icon_pair() */

/*----------------------------------------------------------------------*/
void insa_elev( TREE tree, WORD parent, WORD item, WORD range )
{

    if ( range > 1 )
	(tree+parent+SCROLLKNOB)->ob_box.y = 
	    mul_div( item, (tree+parent+SCROLLAREA)->ob_box.h - 
				(tree+parent+SCROLLKNOB)->ob_box.h, range-1 );

    update_icon_pair( tree, PITMEXE, IA_GENERIC+item ) ;

} /* insa_elev() */

/*------------------------------*/
/*	ob_actxywh		*/
/*------------------------------*/
MLOCAL void ob_actxywh( TREE tree, WORD obj, GRECT * p )
{
				/* get x,y,w,h for specified object	*/
	objc_offset( tree, obj, &p->g_x, &p->g_y );
	p->g_w = (tree+obj)->ob_box.w ;
	p->g_h = (tree+obj)->ob_box.h ;
} /* ob_actxywh */

/*----------------------------------------------------------------------*/
/* Init color categories for Configure App list box.			*/
void color_cats( TREE tree, WORD parent )
{
    set_3d_color( (tree+parent+SCROLLUP), CC_BUTTON ) ;
    set_3d_color( (tree+parent+SCROLLDN), CC_BUTTON ) ;
    set_3d_color( (tree+parent+SCROLLKNOB), CC_BUTTON ) ;
    set_3d_color( (tree+parent+SCROLLAREA), CC_SLIDER ) ;

} /* color_cats() */

/*----------------------------------------------------------------------*/
WORD hndl_scroller( TREE tree, WORD parent, WORD obj, 
					    WORD old_value, WORD range )
{
WORD		value			= 0 ;
WORD		mx, my, kret, bret ;
GRECT		pt;
	
  graf_mkstate( &mx, &my, &kret, &bret );
	
  switch( obj-parent ) {
      
      case SCROLLUP :
	  value = -1;
	  (tree+obj)->ob_state = NORMAL ;
	  draw_fld( tree, obj );
	  break;
	  
      case SCROLLDN :
	  value = 1;
	  (tree+obj)->ob_state = NORMAL ;
	  draw_fld( tree, obj );
	  break;
	  
      case SCROLLAREA:
	  ob_actxywh( tree, parent+SCROLLKNOB, &pt );
	  pt.g_x -= 3;
	  pt.g_w += 6;
	  if ( inside( mx, my, &pt ) )
	      goto dofelev;
	  value = ( my <= pt.g_y ) ? -1 : 1;
	  break;
	  
      case SCROLLKNOB:
dofelev:
	  wind_update( 3 );
	  (tree+parent+SCROLLAREA)->ob_box.x += 3 ;
	  (tree+parent+SCROLLAREA)->ob_box.w -= 6 ;
	  value = graf_slidebox( tree, parent+SCROLLAREA, 
						parent+SCROLLKNOB, TRUE );
	  (tree+parent+SCROLLAREA)->ob_box.x -= 3 ;
	  (tree+parent+SCROLLAREA)->ob_box.w += 6 ;
	  wind_update( 2 );
	  value = mul_div( value, range-1, 1000 ) - old_value ;
	  break;
	  
      } /* switch( parent-obj ) */
  
      return value ;
      
} /* hndl_scroller() */

/************************************************************************/
/* s i z e _ s c r o l l e r            				*/
/*----------------------------------------------------------------------*/
/* correctly sizes and positions scroller. Objects must be arranged
   in the following order: 
		    Parent
			|- Up Arrow			(Parent+1)
			|- Down Arrow			(Parent+2)
			|- Scroll Area			(Parent+3)
				|- Scroll Knob		(ScrollArea+1)
*************************************************************************/
void size_scroller( TREE tree, WORD parent, WORD slots, WORD range )
{
WORD	height ;

    height = (tree+parent)->ob_box.h ;
    
    (tree+parent+SCROLLUP)->ob_box.h	= gl_hbox + 2 ;
    (tree+parent+SCROLLAREA)->ob_box.y	= gl_hbox + 2 ;
    (tree+parent+SCROLLAREA)->ob_box.h	= height - ( 2 * ( gl_hbox + 2 ) ) ;
    (tree+parent+SCROLLDN)->ob_box.y	= height - ( gl_hbox + 2 ) ;
    (tree+parent+SCROLLDN)->ob_box.h	= gl_hbox + 2 ;
    (tree+parent+SCROLLKNOB)->ob_box.y = 0 ;

    height = (tree+parent+SCROLLAREA)->ob_box.h ;
    if ( range > slots )
    {
	height = mul_div( slots, height, range );
	height = max( ( gl_hbox/2 )+2, height );  /* min size elevator	*/
    }
    (tree+parent+SCROLLKNOB)->ob_box.h = height ;

} /* size_scroller() */

/*
 *	deskins.c
 */
