/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985,1991,1992  Digital Research Inc.			    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in far 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: g:/groups/panther/dsk/rcs/deskmain.c 4.25 92/04/10 16:07:45 sbc Exp $
* $Log:	deskmain.c $
 * Revision 4.25  92/04/10  16:07:45  sbc
 * Rm unused members in WSAVE. Replace others with refs to equivs in WNODE
 * 
 * Revision 4.24  92/04/10  13:40:39  sbc
 * Rm redundant preferences vars. Create new struct PREFS
 * 
 * Revision 4.23  92/04/09  14:54:58  sbc
 * Merge Becky's memory management improvements re backgrounds
 * 
 * Revision 4.22  92/04/09  13:35:01  sbc
 * make extract return a path name WITHOUT the trailing \, unless its the drive level
 * 
 * Revision 4.21  92/04/06  09:44:15  Fontes
 * Initial cut to extract/display Windows exe embedded icons.
 * 
 * Revision 4.20  92/04/03  17:15:01  sbc
 * WNODEs and PNODEs to fars, lots of other housekeeping
 * 
 * Revision 4.19  92/03/26  14:45:40  sbc
 * WNODEs and PNODEs to far ptrs. Also merge in RSF's changes
 * 
 * Revision 4.18  92/03/23  12:55:18  sbc
 * comment out code to support dos in a window.
 * 
 * Revision 4.17  92/03/13  14:42:58  sbc
 * Merge in Keiko's changes required for Double Byte Character Support
 * 
 * Revision 4.16  92/03/12  13:54:38  rsf
 * Merge in RSF's changes for icons on desktop and (LONG) => (TREE).
 * 
 * Revision 4.13  92/03/04  14:17:30  Fontes
 * Use mouse coordinates in WM_TOPPED message to select object in newly topped window
 * 
 * Revision 4.15  92/03/05  09:29:59  sbc
 * Hook up use of New Program Item dialog and INODE structure.
 * 
 * Revision 4.14  92/03/02  11:35:48  sbc
 * changes to ANODE structure: a_aicon => a_icon, a_pappl => a_match
 * 
 * Revision 4.13  92/02/28  14:06:38  sbc
 * Allow user to change folder icons as well as file icons.
 * 
 * Revision 4.12  92/02/27  15:32:26  rsf
 * Communication and display of chosen background image
 * 
 * Revision 4.11  92/02/27  10:33:29  sbc
 * Allow assignment of icon to ordinary FNODE.
 * 
 * Revision 4.10  92/02/20  15:56:19  sbc
 * Various changes to ANODE structure and defines
 * 
 * Revision 4.9  92/02/19  15:53:36  sbc
 * Replace refs to G.a_trees[] with calls to rsrc_gaddr().
 * 
 * Revision 4.8  92/02/18  16:05:57  sbc
 * replace call to ins_app() with NewProgramItem() for Configure App.
 * 
 * Revision 4.7  92/02/14  11:02:49  sbc
 * merged Tom Rolander's changes for Mobile Netware version of ViewMAX.
 * 
 * Revision 4.6  92/02/06  15:48:27  sbc
 * remove cleanup code trailing main loop; move to cleanup() in deskinit.c
 * 
 * Revision 4.5  92/02/06  12:10:42  sbc
 * rename WNODE member w_split to w_type
 * 
 * Revision 4.4  92/02/05  18:05:04  anderson
 * Cleaned up extract() so its input path doesn't have to end in '\'.  Changed
 * View:Refresh back to updating all windows showing same drive.  Deleting saved
 * tree files between runs.
 * 
* Date		Who	Comments
* ------------  ---	-------------------------------------------------
911128	K.H		Use full step aside to execute FORMAT program, when
			the system has not enough memory. (#if FSAFMT)
911107	K.H		Use temporary buffer instead of gl_lngstr to display
			ERNOFILE alert message, because alert_s uses gl_lngstr.
911031	K.H		Use graphic bar characters in resource file.
911016  K.H		Changed hot_close to use international prev_path_ch
			function.
			Add supporting double byte character set. (#if DBCS)
911030	K.H		Removed country to use APPSLIB.
*****************************************************************************/

#include "shell.h"
#include "deskkeys.h"
#include "exproto.h"
#include "viewapps.h"

#ifdef USE_MOBILE_NETWARE													/* USE_MOBILE_NETWARE  tar  02/13/92 */
#include "deskmnvm.h"														/* USE_MOBILE_NETWARE  tar  02/13/92 */
#endif /* USE_MOBILE_NETWARE */																		/* USE_MOBILE_NETWARE  tar  02/13/92 */

extern WORD	whnorebld ;		/* don't do anything that will cause */
					/* a tree_open on this window handle */

extern WORD	DOS_ERR;
extern char	start_path[ 65 ];	/* Path we ran from  */
extern WORD	gl_wchar;
extern WORD	gl_height;
extern GRECT	gl_rfull;
extern WORD	gl_stdrv;

BYTE SeenEROBJMIS ;

extern PREFS	prefs;
extern GLOBES	G;
extern WORD	taskmax_avail;	 /* Whether TaskMAX is loaded		*/
extern WORD	taskmax_control; /* Whether TaskMAX controlled via	*/

extern TREE	dktp_tree;
				 /*   ViewMAX dialog.			*/
MLOCAL WORD	ig_close;

MLOCAL BYTE	ILL_ITEM[] = {L2ITEM,L3ITEM,L4ITEM,L5ITEM,L6ITEM,L7ITEM,L8ITEM,
				L9ITEM,0};
MLOCAL BYTE	ILL_FILE[] = {FORMITEM,0};
MLOCAL BYTE	ILL_DOCU[] = {FORMITEM,IAPPITEM,0};
MLOCAL BYTE	ILL_FOLD[] = {FORMITEM,TYPITEM,/*IAPPITEM,*/0};
MLOCAL BYTE	ILL_FDSK[] = { PASSITEM,TYPITEM,IAPPITEM,0};
MLOCAL BYTE	ILL_HDSK[] = { PASSITEM,TYPITEM,FORMITEM,IAPPITEM,0};
MLOCAL BYTE	ILL_NOSEL[] = {OPENITEM,SHOWITEM,FORMITEM,DELTITEM,
				COPYITEM,PASSITEM,IAPPITEM, TYPITEM, 0};
MLOCAL BYTE	ILL_ROOT[] = { FORMITEM,DELTITEM, SHOWITEM,
				COPYITEM,PASSITEM,IAPPITEM, TYPITEM, 0};
MLOCAL BYTE	ILL_FAKE[] = { FORMITEM,DELTITEM,
				COPYITEM,PASSITEM,IAPPITEM, TYPITEM, 0};
MLOCAL BYTE	ILL_DISK[] = { CLOSITEM, WILDITEM, NAMEITEM, TYPEITEM, SIZEITEM,
				DATEITEM, 0 };

MLOCAL BYTE	ILL_COPY[] = { COPYITEM, 0 };

MLOCAL BYTE	ILL_NETW[] = { PASSITEM, 0 };

MLOCAL BYTE	ILL_TREE[] = { WILDITEM, NAMEITEM, TYPEITEM, SIZEITEM,
                              		DATEITEM, ICONITEM, TEXTITEM, 0 };

MLOCAL BYTE	ILL_YSEL[] = {OPENITEM, FORMITEM, SHOWITEM, 
					PASSITEM, TYPITEM, 0};

MLOCAL BYTE	ILL_TMAX[] = { UNDEITEM, 0};

BYTE	ILL_TYPE[] = {OPENITEM, SHOWITEM, FORMITEM, PASSITEM, TYPITEM,
					IAPPITEM, FRSHITEM,
					NAMEITEM, TYPEITEM, SIZEITEM, DATEITEM,
					TREEITEM, WILDITEM, COPYITEM, PASSITEM,
					ICONITEM, DELTITEM, 0};

extern BYTE	gl_defdrv;		/* letter of lowest drive	*/
MLOCAL WORD	cursor_flag;

MLOCAL WORD	kx, ky;
GLOBAL WORD	in_type=FALSE;

#define	HIGHLIGHTED	0x100
#define UNHIGHLIGHTED	0x200

/*** define this converter to wind_set specially because we use ADDR() ***/
GLOBAL WORD wind_set2(WORD w_handle,WORD w_field,LONG w2w3,WORD w4,WORD w5)
{
    return( wind_set(w_handle, w_field, LOWORD(w2w3), HIWORD(w2w3), w4, w5));
}

/****************************************************************
 *
 ****************************************************************/
void hilite_obj( WORD on_flag)
{
	TREE	tree;
	WORD	obj;
	UWORD	state;
	GRECT	c;
#if 0
	if (G.g_cwin == ROOT)
		return;		/*  RSF: just for now.  Heather, you want to
			          work from your tree of desktop icons in
			          this case.
				*/
#endif /* 0 */
	if( cursor_flag == FALSE ) return;

	wind_get( G.g_cwin, WF_TOP, &c.g_x, &c.g_y, &c.g_w, &c.g_h );
	if( c.g_x != G.g_cwin )	
	  return;	/* Only when this window is on top */

	wind_get(G.g_cwin, WF_WXYWH, &c.g_x, &c.g_y, &c.g_w, &c.g_h);
	tree = (G.g_cwin == ROOT) ? dktp_tree : (TREE)&G.g_screen[ROOT];
	if (G.g_cwin == ROOT)
		obj = objc_find(tree, ROOT, 2, kx, ky);
	else
		obj = gr_obfind(tree, G.g_croot, kx, ky);
	
	state = (tree+obj)->ob_state;
	
	if( obj==0 || obj==NIL )
	  return;
	
	if( on_flag && !(state&HIGHLIGHTED) )
	{
	    state|=HIGHLIGHTED;
	    objc_change( tree, obj, 0, c.g_x, c.g_y, c.g_w, c.g_h, 
		    state, TRUE );
	}
	
	if( !on_flag && state&HIGHLIGHTED )
	{
	    state|=UNHIGHLIGHTED;
	    state^=HIGHLIGHTED;
	    objc_change( tree, obj, 0, c.g_x, c.g_y, c.g_w, c.g_h, 
		    state, TRUE );
	    state^=UNHIGHLIGHTED;
	    objc_change( tree, obj, 0, c.g_x, c.g_y, c.g_w, c.g_h, 
		    state, FALSE );
	}
}


/****************************************************************
 *
 ****************************************************************/
void disable_cursor(void)
{
	cursor_flag = FALSE;
}

/****************************************************************
 *
 ****************************************************************/
void enable_cursor(void)
{
	cursor_flag = TRUE;
}

/****************************************************************
 *  Set cursor for keyboard operations at top left.     
 ****************************************************************/
void cursor_init(void)
{
GRECT c;

	wind_get( 0, WF_TOP, &c.g_x, &c.g_y, &c.g_w, &c.g_h );
	if (c.g_x == ROOT)
	{
		/* Need to do the right thing with kx/ky; is this it? */
		objc_offset(dktp_tree, 1, &kx, &ky);
		kx += dktp_tree[1].ob_box.w/2;
		ky += dktp_tree[1].ob_box.h/2;		
	}
	else
	{
		wind_get( c.g_x, WF_WXYWH, &c.g_x, &c.g_y, &c.g_w, &c.g_h);
		kx = c.g_x+(G.g_iwspc/2); /* Point to 1st object */
		ky = c.g_y+(G.g_ihspc/2);
	}
}

/****************************************************************
 *  Made this work with TREEWINs as well by ignoring any
 *  hidden children in calculation of offset.
 ****************************************************************/
MLOCAL WORD	cursor_offset(FNODE far *start, FNODE far *file_object, WORD first_obj)
{
	FNODE far	*offset_obj;
	WORD		offset;
	
	for (offset_obj = start; 
		offset_obj->f_obid != first_obj;
		offset_obj = offset_obj->f_next);
	offset = 0;
	while (offset_obj->f_obid != file_object->f_obid)
	{
		if (offset_obj->f_obid != NIL)	/* ignore hidden children */
			offset++;
		offset_obj = offset_obj->f_next;
	}
	return(offset);
}

/******************************************************************
 *  Set cursor to the specified object in the window described by
 *  the rectangle c.  Note that this routine assumes that the upper
 *  left corner of the window contains an object which preceeds the
 *  desired object.  t_offset is the total number of objects that 
 *  preceed the desired object.
*******************************************************************/
void	cursor_set(FNODE far *file_object, GRECT *c)
{
WNODE far *	pw;
WORD		first_obj;
WORD		col, row, offset;
	
	pw = win_find(G.g_cwin);
	
	kx = c->g_x+(G.g_iwspc/2); /* Point to 1st object in window now */
	ky = c->g_y+(G.g_ihspc/2);
	first_obj = gr_obfind((TREE)&G.g_screen[ROOT], G.g_croot, kx, ky);
				   /* obj id's not necessarily sequential */
				   /* so must count them.		  */
	offset = cursor_offset(pw->w_path->p_flist, file_object, first_obj);

	row = offset/pw->w_pncol;
	col = offset%pw->w_pncol;
				/* Scroll down more if necessary */
	if (row > pw->w_pnrow - 1)
	{
		desk_clear( G.g_cwin );
		win_blt(pw, pw->w_cvrow + (row/pw->w_pnrow)*pw->w_pnrow);
				/* Re-compute offset */
		first_obj = gr_obfind((TREE)&G.g_screen[ROOT], G.g_croot, kx, ky);
		offset = cursor_offset(pw->w_path->p_flist, file_object, 
			first_obj);

		row = offset/pw->w_pncol;
		col = offset%pw->w_pncol;
	}

	ky += (row * G.g_ihspc);
	kx += (col * G.g_iwspc);
	
} /* cursor_set */

/****************************************************************
 *  Given a pointer to a path string, pull the 1st directory
 *  (or drive) entry off and put it in the given destination 
 *  string.  Extracted drives will be in the format "X:\".
 *  Return a pointer to the beginning of the next directory in
 *  the path.
 *
 * EXAMPLE1:	thepath = "D:\FOO1\FOO2\"
 *		dststr = "D:\", function returns "FOO1\FOO2\"
 * EXAMPLE2:	thepath = "FOO1\FOO2\"
 *		dststr = "FOO1", function returns "FOO2\"
 ****************************************************************/
BYTE far * extract( BYTE far * thepath, BYTE far * dststr )
{
BYTE far *	pstr ;
unsigned int	len ;

    if (*thepath == NULL)
    {
	*dststr = NULL;
	return(thepath);
    }

#if SBC_920330    
#if DBCS
    while ( *thepath != NULL && *thepath != '\\' )
    {
	if (dbcs_lead(*thepath) && *(thepath+1) != NULL)
	    *dststr++ = *thepath++;
	*dststr++ = *thepath++;
    }
#else /* DBCS */
    while ((*thepath != NULL) && (*thepath != '\\'))
	*dststr++ = *thepath++;
    
    if (*(dststr - 1) == ':')		/* leave final slash on drive item */
	*dststr++ = '\\';
    
    *dststr = NULL;			/* null terminate extracted folder */
    
    if (*thepath == NULL)
	return( thepath );
    
    else return( thepath+1 );		/* skip backslash if not at path end */
	
#endif /* DBCS */
#else  /* SBC_920330 */
    pstr = fstrchr( thepath, '\\' ) ;		/* pt to next path separator */
    len = (unsigned int)( pstr - thepath ) ;	/* don't include \	     */
    
    fmemcpy( dststr, thepath, len ) ;    
    *(dststr+len) = NULL;		/* null terminate extracted folder   */
    
    if ( dststr[1] == ':' )			/* if this is the drive id,  */
	fstrcat( dststr, "\\" ) ;		/* include the \.	     */
    
    return( pstr+1 );
	
#endif /* SBC_920330 */
    
} /* end extract() */

/****************************************************************
 *  Move the mouse and keyboard cursors to the item in the
 *  current (G.g_cwin) TREEWIN that represents the given full 
 *  path name.
 ****************************************************************/
void	cursor_move( BYTE far * thepath)
{
    GRECT	r;
    WNODE far *	pw;
    FNODE far *	dir;
    BYTE	nxtdir[LEN_ZFNAME];
    TREE	tree = (TREE)&G.g_screen[ROOT];
    WORD	state, obj_id;
    WORD	dstrow;
    WORD	depth;
    BOOLEAN	stayhorz;
	
    pw = win_find(G.g_cwin);
    wind_get(pw->w_id, WF_WXYWH, &r.g_x, &r.g_y, &r.g_w, &r.g_h);	

    state = pw->w_cvind;		/* preserve horizontal slider */    
    stayhorz = FALSE;
    
    pw->w_cvrow = 0;			/* Always start from the top */
    win_bldview(pw, r.g_x, r.g_y, r.g_w, r.g_h);
    
    dir = pw->w_path->p_flist;
    dstrow = 0;
    
    for (thepath = extract(thepath, (BYTE far *)nxtdir); *nxtdir; 
	    thepath = extract(thepath, (BYTE far *)nxtdir))
    {
	/* look through FNODEs until we match this subdir */
	for ( ; dir && fstrcmp( dir->f_name, (BYTE far *)nxtdir) != 0;
		dir = dir->f_next, dstrow++)
	{   
	    /* skip over ANY children of a node that's not in the path */
	    depth = fstrlen(dir->f_tree);
	    while (dir->f_next && (depth < fstrlen(dir->f_next->f_tree)))
	    {
		dir = dir->f_next;
		dstrow++;
	    }
	}

	/* The destination folder is hidden, or there's NOT a next that's */
	/* on a LOWER level.  Stop at the last visible parent. */
	if ((dir->f_treetag == SHOWKIDS) ||
	    !((dir->f_next != (FNODE far *) 0L) &&
	      (fstrlen(dir->f_next->f_tree) > fstrlen(dir->f_tree))))
	{
	    stayhorz = TRUE;
	    break;
	}

	/* Match.  Unless that was last to find, start again with next dir */
	if ( *thepath != NULL )
	{
	    dir = dir->f_next;
	    dstrow++;
	}
    } /* for: each folder in the path */
    
    if (dir == (FNODE far *) 0L)	/* tree's FNODE list is truncated */
    {					/* ...so highlight root item */
	dir = pw->w_path->p_flist;
	dstrow = 0;
	pw->w_cvind = 0;
    }
    else 
    {
	pw->w_cvind = state;		/* restore horizontal slider position */
	if (!stayhorz && pw->w_cvind >= 2)
	    pw->w_cvind -= 2;		/* move horizontal slider back a bit */
    }
	
    pw->w_cvrow = dstrow/pw->w_pncol;	/* move the view to the right row */
    pw->w_cvcol = dstrow%pw->w_pncol;
    win_bldview(pw, r.g_x, r.g_y, r.g_w, r.g_h);	

					/* Show where we are now. */
    fun_msg(WM_REDRAW, pw->w_id, r.g_x, r.g_y, r.g_w, r.g_h);

					/* move mouse selector box and select */
    cursor_set(dir, &r);
					/* Don't record obj id till all	*/
					/* possible scrolling is done	*/
					/* because it can change.	*/
    obj_id = dir->f_obid;
    state = (tree+obj_id)->ob_state;
    act_allchg(G.g_cwin, tree, G.g_croot, obj_id,
		&gl_rfull, &r, SELECTED, FALSE, TRUE);
    state |= SELECTED;
    act_chg(G.g_cwin, tree, G.g_croot, obj_id, &r, 
	     SELECTED, state & SELECTED, TRUE, TRUE);

					 /* move the keyboard cursor too */
    kx = G.g_screen[G.g_croot].ob_x + G.g_screen[obj_id].ob_x + (G.g_iwspc/2);
    ky = G.g_screen[G.g_croot].ob_y + G.g_screen[obj_id].ob_y + (G.g_ihspc/2);
	 
} /* cursor_move */

/****************************************************************
 *  Turn on the hour glass to signify a wait and turn it off
 *  when we're done.
 ****************************************************************/
void desk_wait(WORD turnon)
{
	graf_mouse( (turnon) ? HOURGLASS : ARROW, 0x0L);
}

/****************************************************************
 *  Given an icon index, go find the ANODE which it represents.
 ****************************************************************/
ANODE *i_find(WORD wh, WORD item, FNODE far **ppf, WORD *pisapp)
{
ANODE *		pa;
BYTE		pname[LEN_ZFNAME];
WNODE far *	pw;
FNODE far *	pf;

	pa = (ANODE *) NULL;
	pf = (FNODE far *) 0L;

	pw = win_find(wh);
	pf = fpd_ofind(pw->w_path->p_flist, item);
	if (pf)
 	{
	  fstrcpy((BYTE far *)pname, pf->f_name);
	  pa = (ANODE*)pf->f_pa;
	  if ( (pf->f_attr & F_DISK) ||
	       (pf->f_attr & F_SUBDIR) )
	    *pisapp = FALSE;
	  else 
	    *pisapp = wildcmp(pa->a_match, pname);
	}
	*ppf = pf;
	return (pa);
}

/****************************************************************
 *  Enable/Disable the menu items in dlist.
 ****************************************************************/
void men_list(TREE mlist, BYTE *dlist, WORD enable)
{
	while (*dlist)
	  menu_ienable(mlist, *dlist++, enable);
}

/****************************************************************
 *  Do a context save of the current window state.
 ****************************************************************/
void cnx_put(void)
{
WORD		iwin, dummy;
WSAVE *		pws;
WNODE far *	pw;

	for (iwin = 0; iwin < NUM_WNODES; iwin++) 
	{
	  pw = win_find(G.g_wlist[iwin].w_id);
	  pws = &prefs.win[ iwin ];
	  
	  wind_get(pw->w_id, WF_CXYWH, &pws->ws_box.x, &pws->ws_box.y, 
					  &pws->ws_box.w, &pws->ws_box.h);
	  do_xyfix(&pws->ws_box.x, &pws->ws_box.y);	  
	  pws->ws_cvrow = pw->w_cvrow;
	  fstrcpy( (char far *)pws->ws_pth,  pw->w_path->p_spec );
	  
	  /* get values for associated tree wins */
	  pw = win_find( pw->w_twin );
	  wind_get(pw->w_id, WF_CXYWH, &pws->ws_t_x, &dummy, &dummy, &dummy);
	  pws->ws_t_cvind = pw->w_cvind ;
	  pws->ws_t_cvrow = pw->w_cvrow ;
	  
	} /* for */
	
} /* cnx_put */

/****************************************************************	
 *  Based on current selected icons, figure out which menu items
 *  should be selected (deselected).
 ****************************************************************/
void men_update(TREE tree)
{
	WORD		item, nsel, isapp, junk;
	LONG		ljunk;
	BYTE		*pvalue;
	ANODE		*appl;
	FNODE far *	pjunk;
	WNODE far *	pw;
	BOOLEAN		fakesel;
	BYTE far *	fPtr ;
						/* enable all items	*/

	for (item = OPENITEM; item <= SCSVITEM ; item++)
	{
	  menu_ienable(tree, item, TRUE);
	  menu_icheck(tree, item, FALSE);
	}

	  					/* disable some items	*/
	men_list(tree, ILL_ITEM, FALSE);

	fakesel = FALSE;
	nsel = 0;
	for (item = 0; (item = win_isel(G.g_screen, G.g_croot, item)) != 0;
	     nsel++)
	{
	  appl = i_find(G.g_cwin, item, &pjunk, &isapp);
	  switch (appl->a_type)
	  {
	    case AT_ISFILE:
	    case AT_ISWIND:
		if ( (isapp) || is_installed(appl) )
		  pvalue = ILL_FILE;
		else
		{
		  pvalue = ILL_DOCU;
		} 
		break;
	    case AT_ISFOLD:
		if( pjunk->f_attr & F_FAKEFOLD )
		    fakesel = TRUE;
		else
		{
		  pvalue = ILL_FOLD;
		}
		break;
	    case AT_ISDISK:
		pvalue = (appl->a_icon == IG_FLOPPY) ? ILL_FDSK : ILL_HDSK;
		break;
	  } /* switch */
	  if (!fakesel)
	      men_list(tree, pvalue, FALSE);       /* disable certain items	*/
	} /* for */

	if ( nsel != 1 )
	{
	  if (nsel)
	  {
	    pvalue = ILL_YSEL;
	  }
	  else
	  {
	    pvalue = ILL_NOSEL;
	  }
	  men_list(tree, pvalue, FALSE);
	} /* if */
	else if (fakesel)		/* ONLY New Folder selected */
		men_list(tree, ILL_FAKE, FALSE);
	
	if (taskmax_avail && 
		(tm_status(&junk, &junk, &junk, &ljunk, &ljunk) > 1) )
	{
		men_list( tree, ILL_TMAX, FALSE );
	}

	pw = win_find( G.g_cwin ) ;
	menu_icheck( tree, (pw->w_view == V_TEXT) ? TEXTITEM : ICONITEM, TRUE );
	menu_icheck( tree, (pw->w_sort == S_TYPE) ? TYPEITEM : 
			   (pw->w_sort == S_DATE) ? DATEITEM :
			   (pw->w_sort == S_SIZE) ? SIZEITEM : NAMEITEM, TRUE );
	
/* If an item is root directory disable copy, delete etc... */
	item = win_isel(G.g_screen, G.g_croot, 0 );
	appl = i_find(G.g_cwin, item, &pjunk, &isapp);
	if( (pw->w_type & TREEWIN) && (pjunk->f_name[1] == ':') ) 
	  men_list(tree, ILL_ROOT, FALSE );	/* Poison menu if needed */

/* If "other" window (top or bottom) is displaying drive icons, or active */
/* window is a desk accessory, disable COPY */
	if ((G.g_cwin == G.g_wlist[0].w_id) ||
	    (G.g_cwin == G.g_wlist[2].w_id))
	    pw = win_find(G.g_wlist[1].w_id);
	else
	    pw = win_find(G.g_wlist[0].w_id);
	if ((pw->w_path->p_spec[0]=='@') || (G.g_cwin > 4))
	  men_list(tree, ILL_COPY, FALSE);	/* Poison menu if needed */
	pw = win_find(G.g_cwin);		/* go back to active window */

/* Make sure VIEW menu TREE item will show right string (hide/show) */
	rsrc_gaddr( R_STRING, (pw->w_type & (TREEWIN | SIBLWIN) ) ?
		TREEHIDE : TREESHOW, (TREE *)&fPtr ) ;
	(tree+TREEITEM)->ob_spec = fPtr ;
	menu_ienable( tree, TREEITEM, TRUE );
	
/* Make sure FILE menu NEWIITEM item will show right string (folder/group) */
	rsrc_gaddr( R_STRING, 
	    (pw->w_type & GROUPWIN) ? NEWITEM : NEWFOLDR, (TREE *)&fPtr ) ;
	(tree+NEWIITEM)->ob_spec = fPtr ;
	menu_ienable( tree, NEWIITEM, TRUE );
	
/* Disable TEXT and ICON options when in TREEWIN */      
	if (pw->w_type & TREEWIN)
	    men_list( tree, ILL_TREE, FALSE );
	    
	if( pw && pw->w_path->p_spec[0] == '@' )
	{
	  men_list(tree, ILL_DISK, FALSE ); 
	  if( nsel != 1 )	/* None or >1 disk drive selected */
	    menu_ienable(tree, TREEITEM, FALSE );
	}
	else	/* Passwords are bad news for network drives */
	{
	  if( dos_dtype(pw->w_path->p_spec[0]-'A') > 1 )
	    men_list(tree, ILL_NETW, FALSE );
	}
	
	if( in_type ) menu_ienable(tree, TYPITEM, FALSE);
	if ( !taskmax_control ) menu_ienable(tree, TMITEM, FALSE);

} /* men_update */

/****************************************************************
 *
 ****************************************************************/
MLOCAL	WORD do_deskmenu(WORD item)
{
TREE	tree;
WORD	dial, okobj ;

	switch( item )
	{
	  case ABOUITEM:
		dial  = (gl_height > 300) ? DIALINFO : DIALINF2 ;
		okobj = (gl_height > 300) ? INFOOK : INFOOK2 ;
		rsrc_gaddr( R_TREE, dial, &tree ) ;
						/* draw the form	*/
		show_hide(FMD_START, tree);
#if HELP_ALERTS		
		while ( -1 == xform_do( tree, okobj ) )
		    do_help_alert( -1 ) ; /* -1 == no help for info dialog */
#else /* HELP_ALERTS */
	        form_do(tree, okobj );
#endif /* HELP_ALERTS */
		show_hide(FMD_FINISH, tree);
		  (tree+okobj)->ob_state = NORMAL ;
		break;
	}
	return(FALSE);
} /* do_deskmenu() */

/****************************************************************
 *
 ****************************************************************/
MLOCAL	WORD do_helpmenu(WORD item)
{
TREE		tree;
WORD		dial ;
WORD		exit_but;
#if HELP_ALERTS
WORD		help_alert = -1 ;
#endif /* HELP_ALERTS */

	switch( item )
	{
	  case HWINITEM:
		dial = ADWNHELP ;
		exit_but = ADWNOK;
#if HELP_ALERTS
		help_alert = HHLPWIND ;
#endif /* HELP_ALERTS */
		break;
	  case HMENITEM:
		dial = ADMNHELP ;
		exit_but = ADMNOK;
#if HELP_ALERTS
		help_alert = HHLPMENU ;
#endif /* HELP_ALERTS */
		break;
	  case HDIAITEM:
		dial = ADDIHELP ;
		exit_but = ADDIOK;
#if HELP_ALERTS
		help_alert = HHLPDIAL ;
#endif /* HELP_ALERTS */
		break;
	  case HSMWITEM:
		dial = ADSMHELP ;
		exit_but = ADSMOK;
#if HELP_ALERTS
		help_alert = HHLPSPLT ;
#endif /* HELP_ALERTS */
		break;
	}					/* draw the form	*/
	rsrc_gaddr( R_TREE, dial, &tree ) ;
	show_hide( FMD_START, tree );
#if HELP_ALERTS		
	while ( -1 == xform_do( tree, exit_but ) )
	    do_help_alert( help_alert ) ;
#else /* HELP_ALERTS */
	form_do( tree, exit_but );
#endif /* HELP_ALERTS */
	(tree+exit_but)->ob_state = NORMAL ;
	show_hide( FMD_FINISH, tree);
	return(FALSE);

}

/****************************************************************
 *
 ****************************************************************/
MLOCAL	WORD do_filemenu(WORD item)
{
	WORD		done;
	WORD		cur_item, savwin;
	WNODE far *	pw;
	BYTE far *	new_path;
	ANODE		*pa;
	FNODE far	*pf;
	BOOLEAN		isapp ;
	
	done = FALSE;
	pw = win_find(G.g_cwin);
	if (pw)
	{
		win_top( pw );
		cur_item = win_isel(G.g_screen, G.g_croot, 0);
		if (cur_item)
			pa = i_find(G.g_cwin, cur_item, &pf, &isapp);
	}
	
	switch( item )
	{
	  case NEWGITEM:		/* New Program Group */
	      NewProgramGroup() ;
	      cursor_init() ;
	      break ;
	  case NEWIITEM:		/* New Program Item or New Folder */
	      if ( pw->w_type & GROUPWIN ) {	/* add a program item */
		      NewProgramItem( pw, (FNODE far *)0, (INODE *)0 ) ;
	      }	
	      else {	
		      fun_mkdir( pw ) ;		/* add a new folder */
	      }
	      cursor_init() ;
	      break ;
	  case OPENITEM:
	      if (cur_item)
		  done = win_contents();
	      break;
	  case SHOWITEM:
	      if ( pw->w_type & GROUPWIN ) {
		  /* info on program item or group */
		  NewProgramItem( pw, pf, (INODE *)pa ) ;
	      } 
	      else {			/* info on file or folder */
		  if (cur_item) {
		      if ( pf->f_attr & F_PROGITEM )
			  NewProgramItem( pw, pf, (INODE *)pa ) ;
		      else
			  do_info(cur_item);
		  }
	      }
	      break;
 	  case FINDITEM:
		new_path = do_find(pw);
		if (new_path)
		{
			goto_file(new_path, cur_item, pw);
		}
		break;		
 	  case TYPITEM:
		if (cur_item)
		{
		  in_type=TRUE;
	  	  men_list( G.pMenuTree, ILL_TYPE, FALSE );
		  enable_cursor();
		  savwin=G.g_cwin;	/* Top window may change so save it */
		  done = do_type(cur_item);	/* may return negative error flags */
		  if ( done != FALSE && done != TRUE )
		      done = FALSE ;	/* don't exit if error in do_type() */
	  	  G.g_cwin=savwin;
		  disable_cursor();
		  men_list( G.pMenuTree, ILL_TYPE, TRUE );
		  in_type=FALSE;
		}
		win_top( pw );
		win_vistop( pw->w_id, FALSE );
		cursor_init();
		do_chkall( FALSE );
		break;
	  case PASSITEM:
	  	if (cur_item)
		  do_passw(cur_item);
		break;
	  case COPYITEM:
		if( cur_item ) {
		  do_copy(cur_item);
		  whnorebld = FALSE ;
	        }
		break;
	  case DELTITEM:
		if (cur_item)
		  fun_del(pw);
		cursor_init();
		break;
	  case UNDEITEM:
		  /* Run UNDELETE.EXE */
		  done = do_undelete(pw);
		  break;
	  case FORMITEM:
		if (cur_item)
#if FSAFMT
		  done = do_format(cur_item);
#else /* FSAFMT */
		  do_format(cur_item);
#endif /* FSAFMT */
		break;   
	  case QUITITEM:
		if (taskmax_avail)
		{				/* Clean taskmax's	*/
						/*	leavings out	*/
			G.g_cmd[0] = 0;
			G.g_tail[0] = 0;
						/* Relinquish mgt of	*/
						/*   TaskMAX		*/
			if (taskmax_control)
			{
				tm_unregister_mgr();
			}
		}
		pro_exit( (LONG)(BYTE far *)G.g_cmd, (LONG)(BYTE far *)G.g_tail);
		done = TRUE;
		break;
#if DEBUG
	  case DBUGITEM:
		debug_run();
		break;
#endif /* DEBUG */
	}
	if( !done )
	{
		if (item != FINDITEM)
			desk_clear( G.g_cwin );
		men_update( G.pMenuTree );
		cnx_put();
	}
	return(done);
} /* do_filemenu */

/****************************************************************
 *
 ****************************************************************/
WORD do_viewmenu(WORD item)
{
WORD		newview, newsort, cur_item, isapp;
ANODE *		pa;
FNODE far *	pf;
WNODE far *	pw;
WNODE far *	ptw;
		
	pw = win_find(G.g_cwin);
	newview = pw->w_view ;
	newsort = pw->w_sort ;
		
	switch( item )
	{
	  case CLOSITEM:
		fun_msg( WM_CLOSED,G.g_cwin,0,0,0,0 );
		break;
	  case ZOOMITEM:
		if ( pw->w_type & (TREEWIN | SIBLWIN) )
	        {
		    ptw = win_find( pw->w_twin );
		    do_wfull( ptw->w_id );
		    G.g_cwin = pw->w_id;	/* (changed by do_wfull()) */
	        }
		do_wfull( G.g_cwin );
		cursor_init();
		break;
	  case FRSHITEM:
	  	hndl_kbd( F5 );
		break;
	  case ICONITEM:
		newview = V_ICON;
		break;
	  case TEXTITEM:
		newview = V_TEXT;
		break;
	  case TREEITEM:
		if (pw)			/* Have windows been created yet? */
		{
		    if ( pw->w_type & (TREEWIN | SIBLWIN) )	
		    {				/* Window split, JOIN it */
			pw = win_join( pw );
			item = ICONITEM;	/* same place as TEXTITEM now */
		    }
		    else			/* Window joined, SPLIT it */
		    {
			pw = win_split(pw);
			if (pw == (WNODE far *) 0)	/* couldn't open rqstd drive */
			    return(FALSE);
		    }
		}

	      /* pw now points either to a JOINWIN, a TREEWIN, or nothing */
		if ((!pw) || (pw->w_type & TREEWIN))
		{
		    cur_item = win_isel(G.g_screen, G.g_croot, 0);
		    if (cur_item)
		    {
			pa = i_find( G.g_cwin, cur_item, &pf, &isapp );
			if( pa->a_type == AT_ISDISK )
			    do_open(cur_item);
		    }
		}
		break;
	  case NAMEITEM:
		newsort = S_NAME;
		break;
	  case DATEITEM:
		newsort = S_DATE;
		break;
	  case SIZEITEM:
		newsort = S_SIZE;
		break;
	  case TYPEITEM:
		newsort = S_TYPE;
		break;
	  case WILDITEM:
	  	do_wild();
		cursor_init();
		return( TRUE );
	  case SCSVITEM:
		save_screen();
		cursor_init();
		break;
	}

	switch( item )
	{
	  case TEXTITEM:
	  case ICONITEM:
	  case TREEITEM:
	    win_view( pw, newview, newsort );  /* update g_iview/sort, win_vcalc() */
	    cursor_init();			
	    return( item != TREEITEM );
	    
	  case NAMEITEM:
	  case DATEITEM:
	  case SIZEITEM:
	  case TYPEITEM:
	    win_view( pw, newview, newsort );
	    return( TRUE );
      }  
      return( FALSE );
      
} /* end do_viewmenu() */

/****************************************************************
 *
 ****************************************************************/
MLOCAL	WORD do_optnmenu(WORD item)
{
ANODE *		pa;
WORD		done, cur_item, ret, rebld ;
FNODE far *	pf;
WORD		isapp;
BYTE		pstr[LEN_ZFNAME];
GRECT		r;
FDB far *	bmp;
WORD		new_bkgd_type ;
#if SBC_920323
WNODE far *	pw;
WORD		savwin;
#endif /* #if SBC_920323 */

	done = FALSE;

	cur_item = win_isel(G.g_screen, G.g_croot, 0);
	if (cur_item)
	  pa = i_find(G.g_cwin, cur_item, &pf, &isapp);

	switch( item )
	{
	  case IAPPITEM:
		if (pa)
		{
		  if (isapp)
		    fstrcpy((BYTE far *)pstr, pf->f_name );
		  else if (is_installed(pa))
		    strcpy(pstr, pa->a_match);
		  rebld = NewIconDial( pf->f_name, pa ) ;
		  
		}
		if (rebld)
		{
			fmemcpy( (void far *)&r,
			    (void far *)&((TREE)&G.g_screen[ROOT]+cur_item)->ob_box, 
			    sizeof( GRECT ) );
			objc_offset((TREE)&G.g_screen[ROOT], cur_item, &r.g_x, &r.g_y);

			act_chg(G.g_cwin, (TREE)&G.g_screen[ROOT], G.g_croot, cur_item, 
				&r, SELECTED, FALSE, TRUE, TRUE);
			win_rebuild();	/* Updates icons as necessary */
	        }		
	     	break;
	  case GLOBITEM:
	  	passw_global();
		break;
	  case CPRFITEM:
		color_prefs();
		break;
	  case PREFITEM:
		if (inf_pref())
		    {
		    }
		break;
	  case BKGDITEM:
		if ( !choose_bkgd( &new_bkgd_type, pstr ) )
		    break ;		/* no change or cancel */

		if ( new_bkgd_type == 0)
		    bmp = (FDB FAR *)0L;	/* None */
		else if ( strcmp( pstr, prefs.bkgd_name) != 0 ) 
		{
		    /* New image */
		    bmp = load_bmp_file((BYTE FAR *)pstr, TRUE);
		    if (bmp)
			bmp->fd_r1 = new_bkgd_type;
		    else
			bmp = (FDB FAR*)-1L; /* load failed */
		}
		else if ( new_bkgd_type != prefs.bkgd_type)
		{
		    bmp = G.g_bitmap;
		    bmp->fd_r1 = new_bkgd_type;
		}
		else 
		    bmp = (FDB FAR *)-1L;
			
		if ( bmp == (FDB FAR*)-1L )
		{
		    /* Don't change current prefs if attempt to 
			change desktop image fails
			    */
		}
		else
		{
		    xgrf_dtimage(bmp);
		    if ( G.g_bitmap != bmp )
			unload_bmp(G.g_bitmap);
		    G.g_bitmap = bmp;
		    prefs.bkgd_type = new_bkgd_type ;
		    strcpy( prefs.bkgd_name, pstr ) ;
		    cnx_put();
		}
		break;
	  case CFSSITEM:
		config_screensave();
		break;
	  case SAVEITEM:
		desk_wait(TRUE);
		cnx_put();
		app_save();
		desk_wait(FALSE);
		break;
	  case TMITEM:
		taskmax(-1);
		break;
	  case TMPFITEM:
		taskmax_prefs();
		break;
	  case DOSITEM:
		ret = pro_cmd( "\0", "\0", 0, "\0", FALSE);
		if (ret)
		{
		  menu_tnormal(G.pMenuTree, OPTNMENU, TRUE);
		  done = pro_run(FALSE, 2/*, -1, -1*/); /* Full stepaside */
		}
		break;
#if SBC_920323
	  case DOSWNITM:
		/* Access to DR DOS in a window */
		in_type=TRUE;
		pw = win_find(G.g_cwin);
	  	men_list( G.pMenuTree, ILL_TYPE, FALSE );
		enable_cursor();
		savwin=G.g_cwin;	/* Top window may change so save it */

		do_dos_window();

	  	G.g_cwin=savwin;
		disable_cursor();
		men_list( G.pMenuTree, ILL_TYPE, TRUE );
		in_type=FALSE;

		win_top( pw );
		win_vistop( pw->w_id, FALSE );
		cursor_init();
		do_chkall( FALSE );
		break;
#endif /* SBC_920323 */
	}
	return(done);
	
} /* do_optnmenu() */

/****************************************************************
 *
 ****************************************************************/
WORD hndl_button(WORD clicks, WORD mx, WORD my, WORD button, WORD keystate)
{
	WORD		done, junk;
	GRECT		c;
	WORD		wh, dobj, dest_wh;
	
	done = FALSE;

	wh = wind_find(mx, my);
	if (wh != G.g_cwin)
	  desk_clear(G.g_cwin);

	if (wh == 0)				/* if click outside win's*/
	{
	  men_update(G.pMenuTree);

	  /* if (there's stuff on the desktop) Heather: put what's right */
	  /* Undoubtedly, there's more work to do here and elsewhere	*/
	  /* to handle mouse-less stuff.  For my testing, I'm just	*/
	  /* toggling the selected state of the object on the desktop.	*/
	  junk = objc_find(dktp_tree, ROOT, 2, mx, my);
	  if ( (junk != NIL) && (junk != ROOT) )
	  {
		  /* Top the desktop */
		  if (G.g_cwin != ROOT)
		  {
			  enable_cursor();
			  G.g_cwin = ROOT ;
			  win_vistop( G.g_cwin, FALSE);
			  cursor_init();
		  }
		  else
		  {
			  objc_offset(dktp_tree, junk, &kx, &ky);
			  kx += dktp_tree[junk].ob_box.w/2;
			  ky += dktp_tree[junk].ob_box.h/2;		
		  }

		  /* Act upon the click */
		  fmemcpy((char far *)&c, (char far *)&dktp_tree[ROOT].ob_box,
			  sizeof(GRECT));
	  
		  act_bsclick(wh, dktp_tree, ROOT, mx, my,
		      keystate, &c, FALSE, FALSE);
	  }
	  else
	  {
		  wind_update(BEG_UPDATE);
		  while(button & 0x0001)
			  graf_mkstate(&junk, &junk, &button, &junk);
		  wind_update(END_UPDATE);
	  }
	  return(done);
	}

	desk_verify(wh, FALSE);

	wind_get(wh, WF_WXYWH, &c.g_x, &c.g_y, &c.g_w, &c.g_h);

	/* Track the mouse cursor */
	junk = gr_obfind((TREE)&G.g_screen[ROOT],G.g_croot,mx,my);
	
	if ( (junk!=NIL) && (junk!=G.g_croot) 
			 && (my < ((c.g_y+c.g_h)-(G.g_ihspc/2))) )
	{
	  kx = ((((mx-c.g_x)/G.g_iwspc)*G.g_iwspc)+c.g_x)+(G.g_iwspc/2);
	  ky = ((((my-c.g_y)/G.g_ihspc)*G.g_ihspc)+c.g_y)+(G.g_ihspc/2);
	}
		
	if (clicks == 1)
	{
	  act_bsclick(G.g_cwin, (TREE)&G.g_screen[ROOT], G.g_croot, mx, my,
		      keystate, &c, FALSE, TRUE);
	  graf_mkstate(&junk, &junk, &button, &junk);
	  if (button & 0x0001)
	  {
	    dest_wh = act_bdown(G.g_cwin, (TREE)&G.g_screen[ROOT], G.g_croot, &mx, &my, 
				keystate, &c, &dobj);
	    if ( (dest_wh != NIL) && (dest_wh != 0) )
	    {
	      fun_drag(wh, dest_wh, dobj, mx, my);
	      desk_clear(wh);
	      do_chkall(FALSE);	/* Update all windows */
	    } /* if !NIL */
	  
	  } /* if button */
	} /* if clicks */
	else
	{		
	  if (!act_bsclick(G.g_cwin, (TREE)&G.g_screen[ROOT], G.g_croot,
		      mx, my, keystate, &c, TRUE, TRUE)
	      && (junk != G.g_croot))
		done = win_contents();
	} /* else */
	men_update(G.pMenuTree);
	return(done);
	
}  /* end hndl_button() */

/****************************************************************
 *
 ****************************************************************/
GLOBAL WORD hndl_kbd(WORD thechar)
{
WORD		done;
WORD		junk, junkx, prev_y;
WORD		change_h = 0;
WORD		change_w = 0;
WNODE far *	pw;
GRECT		c, req;
TREE		tree;
WORD		root;

	wind_get(G.g_cwin, WF_WXYWH, &c.g_x, &c.g_y, &c.g_w, &c.g_h);
	if (G.g_cwin == ROOT)
	{
		tree = dktp_tree;
		root = ROOT;
	}
	else
	{
		tree = (TREE)&G.g_screen[ROOT];
		root = G.g_croot;
	}
	
	pw = win_find( G.g_cwin );
		
	done = FALSE;

	switch(thechar)		/* window resizing preparations */
	{
	   case CTL_UP:
		break;
	   case CTL_DN:
		break;
	   case CTL_LF:
	   	change_w = -gl_wchar;
		break;
	   case CTL_RT:
	   	change_w = gl_wchar;
	}

	switch(thechar)
	{
	  case ESC:
		desk_clear( G.g_cwin );
		break;
	  case F5:
		if ( pw->w_type & TREEWIN )
		    tree_dirty(pw->w_path->p_spec[0]-'A');
	        if (pw)
		    fun_rebld(pw);
		break;

	  case CTL_Q:
	  	done = do_filemenu( QUITITEM );
		break;
	   case CURS_UP:
	   case CTL_E:
		if (G.g_cwin == ROOT)
		{
		  /* Move to this desktop object's predecessor.		*/
		  /* I have assumed a flat tree, i.e. the tree consists	*/
		  /* of a root and children of that root; no further	*/
		  /* levels.  If greater complexity is required, revisit*/
		  /* this code.						*/
		  junk = objc_find(dktp_tree, ROOT, 2, kx, ky);
		  if (junk == dktp_tree[ROOT].ob_head)
			  junk = dktp_tree[ROOT].ob_tail;
		  else    junk --;
		  objc_offset(dktp_tree, junk, &kx, &ky);
		  kx += dktp_tree[junk].ob_box.w/2;
		  ky += dktp_tree[junk].ob_box.h/2;		
		  
		}
		else
		{
		  if( ky-G.g_ihspc < c.g_y ) /* Scroll up if needed */
		  {
		    junk = gr_obfind((TREE)&G.g_screen[ROOT],G.g_croot,kx,ky);
		    if( junk!=NIL && junk!=G.g_croot )
		    {
		      desk_clear( G.g_cwin );
		      win_arrow( G.g_cwin, WA_UPLINE );
		    }
		  }  
		  else
		    ky-=G.g_ihspc;	/* Move up to line above */
		}
		break;
	   case CURS_DN:
	   case CTL_X:
		if (G.g_cwin == ROOT)
		{
		  /* Move to this desktop object's successor.		*/
		  /* I have assumed a flat tree, i.e. the tree consists	*/
		  /* of a root and children of that root; no further	*/
		  /* levels.  If greater complexity is required, revisit*/
		  /* this code.						*/
		  junk = objc_find(dktp_tree, ROOT, 2, kx, ky);
		  if (junk == dktp_tree[ROOT].ob_tail)
			  junk = dktp_tree[ROOT].ob_head;
		  else    junk ++;
		  objc_offset(dktp_tree, junk, &kx, &ky);
		  kx += dktp_tree[junk].ob_box.w/2;
		  ky += dktp_tree[junk].ob_box.h/2;		
		  break;
		}

		/* If in a normal window */
		
		if( ky+G.g_ihspc > (c.g_y+c.g_h) ) /* Scroll down if needed */
		{
		  desk_clear( G.g_cwin );
		  win_arrow( G.g_cwin, WA_DNLINE ); /* is there an object here ? */
		  junk = gr_obfind((TREE)&G.g_screen[ROOT],G.g_croot,kx,ky);
		  if( junk==NIL || junk==G.g_croot )
		    ky-=G.g_ihspc; /* No - so don't move logical cursor */
		}
		else
		{
		  junk = gr_obfind((TREE)&G.g_screen[ROOT],G.g_croot,kx,ky+G.g_ihspc);
		  if( junk!=NIL && junk !=G.g_croot )
		    ky+=G.g_ihspc; /* is there an object here ? */
		}
		break;
	   case CURS_LF:
	   case CTL_S:
		if (G.g_cwin == ROOT)
		{
		  /* Move to this desktop object's predecessor.		*/
		  /* I have assumed a flat tree, i.e. the tree consists	*/
		  /* of a root and children of that root; no further	*/
		  /* levels.  If greater complexity is required, revisit*/
		  /* this code.						*/
		  junk = objc_find(dktp_tree, ROOT, 2, kx, ky);
		  if (junk == dktp_tree[ROOT].ob_head)
			  junk = dktp_tree[ROOT].ob_tail;
		  else    junk --;
		  objc_offset(dktp_tree, junk, &kx, &ky);
		  kx += dktp_tree[junk].ob_box.w/2;
		  ky += dktp_tree[junk].ob_box.h/2;		
		  break;
		}
		
		/* If in a normal window */
		
		if (pw->w_type & TREEWIN)
		{
			/* H-scroll left if possible */
			win_arrow(G.g_cwin, WA_LFLINE);
		}
		else if( kx-(G.g_iwspc+(G.g_iwspc/2)) < c.g_x )
		{			/* wrap to far right */
		  junk = gr_obfind((TREE)&G.g_screen[ROOT],G.g_croot,kx,ky);
		  if( junk!=NIL && junk!=G.g_croot )
		  {
		    prev_y = ky;
		    disable_cursor();
		    hndl_kbd( CURS_UP );	/* And go up */
		    enable_cursor();
		    if (prev_y != ky)		/* Dont wrap at 1st object */
		    {
			    junkx = (c.g_x+(G.g_iwspc/2)) +
				    (G.g_iwspc*(G.g_incol-1));
			    junk = gr_obfind((TREE)&G.g_screen[ROOT],G.g_croot,junkx,ky);
						    /* Is there an obj */
						    /*  at far right ? */
			    if( junk!=NIL && junk!=G.g_croot ) 
				    kx = junkx;			
		    }
		  }
		}
		else
		  kx-=G.g_iwspc;
		break;
	   case CURS_RT:
	   case CTL_D:
		if (G.g_cwin == ROOT)
		{
		  /* Move to this desktop object's successor.		*/
		  /* I have assumed a flat tree, i.e. the tree consists	*/
		  /* of a root and children of that root; no further	*/
		  /* levels.  If greater complexity is required, revisit*/
		  /* this code.						*/
		  junk = objc_find(dktp_tree, ROOT, 2, kx, ky);
		  if (junk == dktp_tree[ROOT].ob_tail)
			  junk = dktp_tree[ROOT].ob_head;
		  else    junk ++;
		  objc_offset(dktp_tree, junk, &kx, &ky);
		  kx += dktp_tree[junk].ob_box.w/2;
		  ky += dktp_tree[junk].ob_box.h/2;		
		  break;
		}

		/* If in a normal window */
		
		if (pw->w_type & TREEWIN)
		{
			/* H-scroll right */
			win_arrow(G.g_cwin, WA_RTLINE);			
		}
		else if( kx+G.g_iwspc+(G.g_iwspc/2) > (c.g_x+c.g_w) )
		{
		  kx = c.g_x+(G.g_iwspc/2);	/* wrap to left */
		  hndl_kbd( CURS_DN );		/* and go down */
		}
		else
		{
		  junk = gr_obfind((TREE)&G.g_screen[ROOT],G.g_croot,kx+G.g_iwspc,ky);
		  if( junk!=NIL && junk !=G.g_croot )
		    kx+=G.g_iwspc;
		}
		break;
	   /* window resizing in character width or height increment */
	   case CTL_UP:
	   case CTL_DN:
	        break;
	   case CTL_LF:
	   case CTL_RT:
		if (G.g_cwin == ROOT)
			break;
		
	        wind_get(G.g_cwin, WF_CXYWH, &req.g_x, &req.g_y,
					     &req.g_w, &req.g_h);
		req.g_w += change_w;
		req.g_h += change_h;
	   	win_movsiz(pw, &req);
	        break;
	   case SPACE:
		act_bsclick(G.g_cwin, tree, root, kx, ky, K_LSHIFT,
			&c, TRUE, FALSE);
		break;
	   case ENTER:
		if ( !act_bsclick(G.g_cwin, tree, root,
			kx, ky, 0, &c, TRUE, FALSE) )
		{
			done = win_contents();
		}
		break;
	   case PLUS:						/* (RSF) */
	   case NP_PLUS:
	   case ALT_PLUS_EQUAL:
		if (G.g_cwin == ROOT)
			break;
		
		if( pw->w_type & TREEWIN )
		{
			ce_tree(SHOWKIDS, G.g_cwin, (TREE)&G.g_screen[ROOT], G.g_croot, 
				kx, ky, (((UWORD)thechar == ALT_PLUS_EQUAL) 
					? TRUE : FALSE));
		}
		break;
	   case MINUS:						/* (RSF) */
	   case NP_MINUS:
	   case ALT_MINUS:
		if (G.g_cwin == ROOT)
			break;
		if( pw->w_type & TREEWIN )
		{
			ce_tree(HIDEKIDS, G.g_cwin, (TREE)&G.g_screen[ROOT], G.g_croot, 
				kx, ky, (((UWORD)thechar == ALT_MINUS) 
					? TRUE : FALSE));
		}
		break;
	   case HOME:
		/* Move to absolute beginning of display */
		if (pw && pw->w_cvrow)
		{
			pw->w_cvrow = 0;
			win_bldview(pw, c.g_x, c.g_y, c.g_w, c.g_h);
			fun_msg(WM_REDRAW, pw->w_id, c.g_x, c.g_y, 
				c.g_w, c.g_h);
		}
		cursor_init();
		break;
	   case END:
		if (G.g_cwin == ROOT)
		{
		  junk = dktp_tree[ROOT].ob_tail;
		  objc_offset(dktp_tree, junk, &kx, &ky);
		  kx += dktp_tree[junk].ob_box.w/2;
		  ky += dktp_tree[junk].ob_box.h/2;		
		}
		else
		{
		  /* Move to absolute end of display.	 */
		  pw->w_cvrow = pw->w_vnrow - pw->w_pnrow;
		  win_bldview(pw, c.g_x, c.g_y, c.g_w, c.g_h);
		  fun_msg(WM_REDRAW, pw->w_id, c.g_x, c.g_y, c.g_w, c.g_h);
		}
		break;
	} /* switch */
	men_update(G.pMenuTree);		/* clean up menu info	*/
	return(done);
} /* hndl_kbd */

/****************************************************************
 *
 ****************************************************************/
WORD hndl_menu(WORD title, WORD item)
{
WORD		done;
/* WNODE far *	pw;
*/
WORD		cur_window;
	
#if 0	/*RSF: debugging*/
BYTE str[64];
sprintf(str, "[1][  Available Memory: %ld  ][ OK ]", dos_avail() ) ;
form_alert( 0x0101, (LONG)(char far *)str);
#endif

	cur_window=G.g_cwin;  /* This menu causes  */
				/* the active_window to vary so we */
				/* preserve it across the function	*/
	
	desk_verify( G.g_cwin, FALSE );
/*	pw=win_find( G.g_cwin );
*/

	done = FALSE;
	switch( title )
	{
	  case DESKMENU:
		done = do_deskmenu(item);
		break;
	  case FILEMENU:
		done = do_filemenu(item);
		break;
	  case VIEWMENU:
		done = FALSE;
						/* for current window	*/
						/*   go sort again and	*/
						/*   rebuild view	*/
		if (do_viewmenu(item))
		{
		    desk_wait(TRUE);
/*		    if ( pw->w_type & TREEWIN )
		      pw->w_cvrow=G.g_islide[G.g_cwin]; */
		    do_chk( TRUE );		/* redraws current window */
		    desk_wait(FALSE);
		    cnx_put();
		}
		men_update( G.pMenuTree );
		break;
	  case OPTNMENU:
		done = do_optnmenu(item);
		men_update( G.pMenuTree );
		break;
	  case HELPMENU:
	  	done = do_helpmenu(item);
		break;
	}
	menu_tnormal(G.pMenuTree, title, TRUE);
	/* Allow View:CLOSE, View:TREE, File:OPEN, and	*/
	/* (rsf) File:FIND to change the current window.*/
	if ( (item != CLOSITEM) && (item != TREEITEM) && (item != OPENITEM)
		 && (item != FINDITEM) )
	    G.g_cwin=cur_window;	/* restore to window entered with */
	return(done);
}

/****************************************************************
 *  "Close" the path but don't set a new dir. & don't redraw the
 *  window until the button is up or there are no more CLOSED
 *  messages.
 *  If closing with a TREEWIN active, put the new directory
 *  display in its SIBLWIN.
 ****************************************************************/
void hot_close(WORD wh)
{
WORD		drv, done, at_drvs, cnt;
WORD		mx, my, button, kstate;
BYTE		path[LEN_ZPATH], name[MAXFILE], ext[MAXEXT];
#if SBC_920327	    
BYTE *		pend;
#endif /* SBC_920331 */
BYTE far *	pname;
BYTE far *	ppath;
WNODE far *	pw;
WNODE far *	psw;
WNODE far *	ptw;
WORD		saviw, savih;

	pw = win_find(wh);
	ptw = FALSE;
	at_drvs = FALSE;
	done = FALSE;
	cnt = 0;

	do
	{
	  cnt++;
	  if (pw->w_type & TREEWIN)		/* Use SIBLWIN's path */
	  {
	      psw = win_find(pw->w_twin);
	      ppath = psw->w_path->p_spec;
	      pname = psw->w_name;
	  }
	  else 
	  {
	      ppath = pw->w_path->p_spec;
	      pname = pw->w_name;
	  }
	  fpd_parse( ppath, (WORD *)NULL, path, (BYTE *)NULL, (BYTE *)NULL );
	  
	  pw->w_cvrow = 0;			/* reset slider		*/

	  if (path[0] == NULL )	/* No more path; show disk icons */
	  {
	     /* Don't allow drive icons in a TREEWIN or SIBLWIN.  Make a JOINWIN,
	      * but leave it marked as special so that when an item in it is
	      * opened with win_contents(), we can automatically re-split it.
	      */
	      if (pw->w_type & (TREEWIN | SIBLWIN) )
	      {					/* TREEWIN or SIBLWIN */
		  pw = win_join( pw );
		  pw->w_istree = TRUE;
	      }
	    fstrcpy( pname, (char far *)ini_str(STDSKDRV) );
	    fstrcpy( &ppath[3], (char far *)"*.*" ) ;
	    at_drvs = TRUE;
	  }
	  else
	  {			/* Some path left; scan off last dir.	*/
#if SBC_920327	    
	    pend = pname;
	    pend += (strlen(pname) - 3);	/* skip trailing '\ '	*/
						/* Remove last name	*/
	    *(prev_path_ch((UBYTE *)pname, (UBYTE *)pend) + 1) = NULL;
	    					/* now fix path		*/
	    pend = ppath;
	    pend += (fstrlen(ppath) - 5);	/* skip trailing '\*.*'	*/
						/* Remove last name	*/
	    *(prev_path_ch((UBYTE *)ppath, (UBYTE *)pend) + 1) = NULL;
	    fstrcat( ppath, "*.*" );		/* put '*.*' back on	*/
#else /* SBC_920327 */
	    /* "C:\FOO1\FOO2\" => "C:\FOO1\" */
	    *fstrrchr( pname, '\\') = NULL ;	/* rm last \		*/
	    *(1+fstrrchr( pname, '\\')) = NULL ;/* rm last dir		*/
	    
	    /* "C:\FOO1\FOO2\*.*" => "C:\FOO1\*.*" */
	    *fstrrchr( ppath, '\\') = NULL ;	/* rm last \		*/
	    *(1+fstrrchr( ppath, '\\')) = NULL ;/* rm last dir		*/
	    fstrcat( ppath, "*.*" );		/* put '*.*' back on	*/

#endif /* SBC_920327 */
	  } /* else */

	  if (pw->w_type & TREEWIN)
	  {
	      ptw = pw;				/* save TREEWIN & ....*/
	      pw = psw;				/* operate on SIBLWIN */
	      desk_verify(pw->w_id, FALSE);
	      saviw = G.g_iwspc;
	      savih = G.g_ihspc;
	  }
	  win_sname( pw );
	  wind_set2(pw->w_id, WF_NAME, (LONG)pw->w_title, 0, 0);
	  graf_mkstate(&mx, &my, &button, &kstate);
	  if (button == 0x0)
	    done = TRUE;
	  else
	  {
	    evnt_timer(750, 0);
						/* grab the screen	*/
	    graf_mkstate(&mx, &my, &button, &kstate);
	    if (button == 0x0)
	      done = TRUE;
	  } /* else */
	} while ( !done );

	if (!ptw && (pw->w_type & SIBLWIN))	/* TREEWIN's selector 1st */
	{
	    desk_verify(pw->w_twin, FALSE);	/* switch to TREEWIN */
	    cursor_move(pw->w_name);		/* move TREEWIN selector bars */
	    desk_verify(pw->w_id, FALSE);	/* switch back to SIBLWIN */
	}

	if (cnt > 1)
	  ig_close = TRUE;
	fpd_parse( ppath, &drv, path, name, ext);
	if (at_drvs)
	  drv = '@';
	do_fopen(pw, 0, drv, path, name, ext, FALSE, TRUE);
	
	/* TREEWIN was active on entry to hot_close().  SIBLWIN's active now. */
	/* Switch back to TREEWIN. */
	if (ptw != FALSE)
	{
	    G.g_iwspc = saviw;
	    G.g_ihspc = savih;
	    desk_verify(ptw->w_id, FALSE);	/* switch back to original */
	    cursor_move(psw->w_name);		/* move TREEWIN selector bars */
	    win_top(psw);			/* keep SIBLWIN visible */
	    win_vistop( psw->w_id, FALSE );
	    win_top(ptw);
	    win_vistop( G.g_cwin, TRUE );
	}
	cnx_put();
	
} /* hot_close */

/****************************************************************
 *
 ****************************************************************/
WORD hndl_msg(void)
{
WORD		done;
WNODE far *	pw;
WNODE far *	ptw;
WORD		change, menu, obj;
	
	done = change = menu = FALSE;
	pw = win_find(G.g_rmsg[3]);

	if ( G.g_rmsg[0] == WM_CLOSED && ig_close ) /* Can't close a tree */
	{
	  ig_close = FALSE;
	  return(done);
	}
	switch( G.g_rmsg[0] )
	{
	  case WM_TOPPED:
	  case WM_CLOSED:
	  case WM_FULLED:
	  case WM_ARROWED:
	  case WM_VSLID:
	  case WM_SIZED:
	  case WM_MOVED:
	  	desk_clear(G.g_cwin);
		break;
	}
	switch( G.g_rmsg[0] )
	{
	  case MN_SELECTED:
/*		desk_verify(G.g_wlastsel, FALSE);*/
		done = hndl_menu(G.g_rmsg[3], G.g_rmsg[4]);
		break;
	  case WM_REDRAW:
		menu = TRUE;
		do_wredraw(G.g_rmsg[3], G.g_rmsg[4], G.g_rmsg[5], 
			G.g_rmsg[6], G.g_rmsg[7]);
		break;
	  case WM_UNTOPPED:
		enable_cursor();
		cursor_init();
		disable_cursor();
		return( FALSE );	/* Dont do updates	*/
	  case WM_TOPPED:
		enable_cursor();
		G.g_cwin=G.g_rmsg[3];
		if (pw)
		{
#if 1	/* (hca) adding this back in to keep windows ORDERED properly.	*/
	/* (NOTE: This should probably go in at the AES level.)		*/
					/* 1st top a split window's */
		    if ( pw->w_type & (TREEWIN | SIBLWIN) )
		    {			/* other side (TREEWIN or SIBLWIN) */
			ptw = win_find(pw->w_twin);
			win_top(ptw);
			win_vistop(ptw->w_id, FALSE);
		    }
#endif /* 1 */
		  win_top(pw);
		  if ( pw->w_type & (TREEWIN | SIBLWIN) )
		      win_vistop(pw->w_id, TRUE);
		  else win_vistop(pw->w_id, FALSE);
		  desk_verify(pw->w_id, FALSE);
		}
		if (G.g_cwin == 0)	/* Root window has been topped */
			win_vistop(0, FALSE);

		cursor_init();

		if (wind_find(G.g_rmsg[4], G.g_rmsg[5]) == G.g_cwin)
			hndl_button(1, G.g_rmsg[4], G.g_rmsg[5], 0, 0);
		change = TRUE;
		break;
	  case WM_CLOSED:
		hot_close(G.g_rmsg[3]);
		pw = win_find(G.g_cwin);     /* could be a new current WIN */
		if ( ! (pw->w_type & TREEWIN) )  /* only if NOT a TREEWIN */
		    cursor_init();	   /* Zero-ize the cursor position */
		change=TRUE;
		break;
	  case WM_FULLED:
		enable_cursor();
		if (pw)
		{			/* 1st full split window's */
		    if (pw->w_type & (TREEWIN | SIBLWIN) )
		    {			/* other side (TREEWIN or SIBLWIN) */
			ptw = win_find(pw->w_twin);
			win_top(ptw);		/* Make this window topmost */
			wind_set( ptw->w_id, WF_TATTRB, 0,0,0,0 ); 
			win_vcalc( ptw->w_id );
			do_wfull(ptw->w_id);
		    }
		    win_top(pw);		/* Make this window topmost */
		    wind_set( pw->w_id, WF_TATTRB, 0,0,0,0 ); 
		    win_vcalc( pw->w_id );
		    do_wfull( pw->w_id );
		}
		cursor_init();
		change = TRUE;
		break;
	  case WM_ARROWED:
		win_arrow(G.g_rmsg[3], G.g_rmsg[4]);
		break;
	  case WM_VSLID:
		win_slide(G.g_rmsg[3], G.g_rmsg[4], TRUE);
		break;
	  case WM_HSLID:
		win_slide(G.g_rmsg[3], G.g_rmsg[4], FALSE);
		break;
    	  case WM_SIZED:
    	  case WM_MOVED:
		win_movsiz(pw, (GRECT *)&G.g_rmsg[4]);
		cursor_init();
		change = TRUE;
		break;
	}
	switch( G.g_rmsg[0] )
	{
	    case WM_VSLID:
	    case WM_ARROWED:
		obj = gr_obfind((TREE)&G.g_screen[ROOT], G.g_croot, kx, ky);
		if( obj==0 || obj==NIL || obj<=G.g_croot )
		    cursor_init();
		change=TRUE;
		break;
	}
	if (change)
	  cnx_put();
	G.g_rmsg[0] = 0;
	if (!menu)
	  men_update(G.pMenuTree);
	enable_cursor();
	return(done);
} /* hndl_msg */

/****************************************************************
    we've run out of FNODEs and a tree is visible, so hide it
*/
MLOCAL void AutoTreeHide( void ) 
{
    if ( G.g_wlist[SeenEROBJMIS-1].w_type & (TREEWIN | SIBLWIN) )
    {
	G.g_cwin = SeenEROBJMIS;
	hndl_menu(VIEWMENU, TREEITEM);
	/* leave handle of the resulting joined window as g_cwin because */
	/* it is now WF_TOP and will therefore get the keyboard focus.   */
    }
} /* AutoTreeHide() */

/****************************************************************
 *  ViewMAX entry point.
 ****************************************************************/
WORD main(void)
{
	WORD		flags;
	WORD		done	= FALSE ;
	UWORD		ev_which, mx, my, button, kstate, kret, bret;
	WORD		totally_idle = TRUE;
	LONG		ss_time;
#if RSF_920326
/*T*/ WORD		hr1, min1, sec1, hsec1;
/*T*/ WORD		hr2, min2, sec2, hsec2;
/*T*/ WORD		h;
/*T*/ BYTE		str[30];
/*T*/	h = dos_open((LONG)(char far *)"D:\\INITTIME", READWRITE);

/*T*/	dos_gettime(&hr1, &min1, &sec1, &hsec1);
#endif /* RSF_920326 */
	if ( !init() )
	    return FALSE ;
#if RSF_920326
/*T*/	dos_gettime(&hr2, &min2, &sec2, &hsec2);	
/*T*/	sprintf(str, "Stop>  %2d:%2d:%2d\.%2d\n", hr2, min2, sec2, hsec2);
/*T*/	dos_write(h, strlen(str), (LONG)(BYTE far *)str );
/*T*/	sprintf(str, "Start> %2d:%2d:%2d\.%2d\n", hr1, min1, sec1, hsec1);
/*T*/	dos_write(h, strlen(str), (LONG)(BYTE far *)str ) ;
/*T*/	dos_close(h);
#endif /* RSF_920326 */
	
	men_update(G.pMenuTree); 
	enable_cursor();
	cursor_init();
	desk_wait(FALSE);	
						/* get ready for main	*/
						/*   loop		*/

	flags = MU_BUTTON | MU_MESAG | MU_KEYBD;
	ig_close = FALSE;
	
/******************************
 *  Main Event Handling Loop  *
 ******************************/     
	while( !done )
	{

#ifdef USE_MOBILE_NETWARE													/* USE_MOBILE_NETWARE  tar  02/13/92 */
	  if ( mobileNetwareLoaded )											/* USE_MOBILE_NETWARE  tar  02/13/92 */
		ss_time = mobileNetwarePointer->syncFrequency * 1000;				/* USE_MOBILE_NETWARE  tar  02/13/92 */
	  else																	/* USE_MOBILE_NETWARE  tar  02/13/92 */
#endif /* USE_MOBILE_NETWARE */	 /* NOTE: else condition is line below (default) */					/* USE_MOBILE_NETWARE  tar  02/13/92 */

	  ss_time = prefs.scrnsvr_time*30000L;	  /* Because timer must	*/
						  /* elapse twice.	*/
	  if (ss_time > 0L)
		flags |= MU_TIMER;
	  else	flags &= ~MU_TIMER;
	  
	  			/* block for input	*/
	  ev_which = evnt_multi(flags, 0x02, 0x01, 0x01, 
				0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
				(LONG)(WORD far *)G.g_rmsg, 
				    LOWORD(ss_time), HIWORD(ss_time),
				&mx, &my, &button, &kstate, &kret, &bret);
						/* grab the screen	*/
	  wind_update(BEG_UPDATE);
	  hilite_obj( FALSE );
						/* clear out temp dflt psswd */
	  passw_tdf(NULL);
						/* If no other events, save */
						/*  the screen.		    */
	  if (ev_which == MU_TIMER)
	  {
#ifdef USE_MOBILE_NETWARE													/* USE_MOBILE_NETWARE  tar  02/13/92 */
		  if ( mobileNetwareLoaded )										/* USE_MOBILE_NETWARE  tar  02/13/92 */
		  {																	/* USE_MOBILE_NETWARE  tar  02/13/92 */
			totally_idle = FALSE;											/* USE_MOBILE_NETWARE  tar  02/13/92 */
			if ( MobileNetwareUpdateIcon() )								/* USE_MOBILE_NETWARE  tar  02/13/92 */
			{																/* USE_MOBILE_NETWARE  tar  02/13/92 */
				graf_mouse(HOURGLASS, 0x0L);								/* USE_MOBILE_NETWARE  tar  02/13/92 */
				do_chkall(TRUE);											/* USE_MOBILE_NETWARE  tar  02/13/92 */
				graf_mouse(ARROW, 0x0L);									/* USE_MOBILE_NETWARE  tar  02/13/92 */
			}																/* USE_MOBILE_NETWARE  tar  02/13/92 */
		  }																	/* USE_MOBILE_NETWARE  tar  02/13/92 */
		  else																/* USE_MOBILE_NETWARE  tar  02/13/92 */
#endif /* USE_MOBILE_NETWARE */
		  if (totally_idle)
		  {
			  save_screen();
			  cursor_init();
		  }
		  totally_idle = TRUE;
	  }
	  else	totally_idle = FALSE;
						/* handle system message*/
	  while (ev_which & MU_MESAG)
	  {
	    done = hndl_msg();
						/* use quick-out to clean */
						/* out all messages	  */
	    if (done)
	      break;
	    ev_which = evnt_multi(MU_MESAG | MU_TIMER, 0x02, 0x01, 0x01, 
				0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
				(LONG)(WORD far *)G.g_rmsg, 0, 0, 
				&mx, &my, &button, &kstate, &kret, &bret);
	  } /* end (MU_MESAG) */
	  
						/* handle keybd message */
	  if (ev_which & MU_KEYBD)
	    done = hndl_kbd(kret);

						/* handle button down	*/
	  if (ev_which & MU_BUTTON)
	    done = hndl_button(bret, mx, my, button, kstate);

	  if ( SeenEROBJMIS != FALSE )		/* clean up after FNODE... */
	  {					/* ...or TNODE overflow	   */
	      AutoTreeHide() ;
	      SeenEROBJMIS = FALSE;
	  }
	  
	  if( !done ) hilite_obj( TRUE );
	  
	  					/* free the screen	*/
	  wind_update(END_UPDATE);

	} /* end while !done */
	
	cleanup() ;
	
	return(TRUE);
	
} /* main */


/*
 *	EOF:	deskmain.c
 */
