/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985,1991,1992  Digital Research Inc.			    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/dsk/rcs/deskpgrp.c 4.11 92/04/03 17:11:28 sbc Exp $
* $Log:	deskpgrp.c $
 * Revision 4.11  92/04/03  17:11:28  sbc
 * WNODEs and PNODEs to fars, lots of other housekeeping
 * 
 * Revision 4.10  92/03/26  14:45:33  sbc
 * WNODEs and PNODEs to far ptrs. Also merge in RSF's changes
 * 
 * Revision 4.9  92/03/12  13:59:01  rsf
 * Merge in RSF's changes for icons on desktop and (LONG) => (TREE).
 * 
 * Revision 4.8  92/03/05  09:30:57  sbc
 * Hook up use of New Program Item dialog and INODE structure.
 * 
 * Revision 4.7  92/02/28  14:06:53  sbc
 * Allow user to change folder icons as well as file icons.
 * 
****************************************************************************/


#include "shell.h"
#include "exproto.h"
#include "danutil.h"

extern GLOBES	G;
extern WORD	gl_num_icos;
extern WORD	gl_num_icfs;

MLOCAL ICONBLK	gl_aib;

/* num icons available in pairs (exe,doc) */
#define NUM_ICON_PAIRS	gl_num_icos

/* num icons except disk drive icons: */
#define NUM_ICONS	(gl_num_icos+gl_num_icfs+1)	
		
/*---------------------------------------------------------------------------
*	Given a zero-based value used as a scroller index, return an
*	index into the G.g_iconlist[].
*/
MLOCAL WORD i_iconlist( WORD index )
{
/* case 1: icon is an ICF and sits at the far end of G.g_iconlist[] */    
    if ( index > gl_num_icos ) {
	return( index - gl_num_icos + ID_GENERIC - gl_num_icfs ) ;
    }
/* case 2: icon is an ICO and sits at IG_FOLDER and beyond */
    if ( index < gl_num_icos+1 ) {
	return( index + IG_FOLDER ) ;
    }
    return IA_GENERIC ;
} /* i_iconlist() */

/*---------------------------------------------------------------------------
*	Given an offset into G.g_iconlist[], return a zero-based value
*	for use as a scroller index.
*/
MLOCAL WORD i_listbox( WORD icon_number )
{
/* case 1: icon is an ICF and sits at the far end of G.g_iconlist[] */    
    if ( icon_number > ID_GENERIC - gl_num_icfs ) {
	return( icon_number - (ID_GENERIC - gl_num_icfs + 1) + gl_num_icos + 1) ;
    }
/* case 2: icon is an ICO and sits at IG_FOLDER and beyond */
    if ( icon_number < IG_FOLDER + gl_num_icos + 1 ) {
	return( icon_number - IG_FOLDER ) ;
    }
    return 0 ;
} /* i_listbox() */

/*---------------------------------------------------------------------------
*
*/
MLOCAL void GetNewIcon( ANODE * pa, BYTE far * fname, WORD index )
{
ANODE	*new_pa ;

    if ( strpbrk( pa->a_match, "*?" ) != NULL )	{	
/* this is an anode for general purposes, with wildcards to match	*/
/* need to  create a new ANODE specific to this filename		*/
	
	new_pa = app_alloc( TRUE );	
	if ( new_pa == (ANODE *)NULL )
	    return ;				/* ran out of ANODEs	*/
	new_pa->a_match = string_alloc( fname ) ;
	if ( new_pa->a_match == (char *)NULL ) {
	    app_free( new_pa ) ;		/* ran out of gl_buffer[] */
	    return ;
	}
	new_pa->a_flags = pa->a_flags & (~AF_ISDEF) ;  /* clear the default flag */
	new_pa->a_type  = pa->a_type ;
	new_pa->a_icon  = i_iconlist( index ) ;
    }
    else {
/* this is aleady a custom ANODE, with a specific filename to match */	
	pa->a_icon = i_iconlist( index ) ;
    }

} /* GetNewIcon() */

/*---------------------------------------------------------------------------
*
*/
MLOCAL void InitNewIconDial( TREE tree, ANODE * pa )
{
/* size and position scroller */
    size_scroller( tree, ICONSCRP, 1, NUM_ICONS ) ;
    insa_elev( tree, ICONSCRP, i_listbox( pa->a_icon ), 
						    NUM_ICONS );

/* init Current Icon */    
    insa_icon( tree, ICONICON, pa->a_icon, &gl_aib, "" );

/* color button types in listbox */    
    color_cats( tree, ICONSCRP ) ;
    
} /* InitNewIconDial() */

/*---------------------------------------------------------------------------
*	src string is of the form : "ABCDEFGHI".
*	dst string is of the form : "*.ABC,*.DEF,*.GHI". 
*	rm spaces used to indicate extensions with less than 3 characters
*/
MLOCAL void GetDocTypes( char * dst, char * src )
{
char *	end ;
char *	ptr ;

    strupr( src ) ;			/* convert to uppercase		*/
    end = src + strlen( src ) ;		/* ptr to src's z terminator	*/
    *dst = '\0' ;			/* initialize dst		*/
    while ( src < end ) {
	strcat( dst, "*." ) ;		/* beginning of this wildcard	*/
	strncat( dst, src, 3 ) ;	/* append extension characters	*/
	src += 3 ;			/* skip past this extension	*/
	if ( src < end )		/* will there be more?		*/
	    strcat( dst, "," ) ;	/* anticipate separator for next*/
    }

    end = dst + strlen( dst ) ;		/* ptr to dst's z terminator	*/
    ptr = strchr( dst, ' ' ) ;		/* find first space in dst	*/
    while ( ptr != (char *)NULL ) {	/* copy over spaces		*/
	memmove( ptr, ptr+1, (size_t)(end-ptr) ) ;
	ptr = strchr( ptr, ' ' ) ;	/* find next space in dst	*/
    }

} /* GetDocTypes() */

/*---------------------------------------------------------------------------
*	Init Document types editable field. src string is of the form:
*	"*.ABC,*.DEF,*.GHI". dst string becomes : "ABCDEFGHI".
*	(Note that "*.A,*.BCD,*.EF" becomes "A  BCD EF")
*/
MLOCAL void SetDocTypes( char * dst, char * original )
{
char	src[40] ;
char *	ptr ;

    strcpy( src, original ) ;		/* strtok() writes into src	*/
    ptr = strtok( src, "*.," ) ;	/* find first token		*/
    *dst = '\0' ;			/* initialize dst		*/
    while ( ptr != (char *)NULL ) {
	sprintf( dst, "%3s", ptr ) ;	/* pad with spaces in dst	*/
	dst += 3 ;			/* advance dst past this ext.	*/
	ptr = strtok( NULL, "*.," ) ;	/* search for next token	*/
    }
} /* SetDocTypes() */

/*---------------------------------------------------------------------------
*
*/
MLOCAL void GetProgramItem( TREE tree, FNODE far * pf, INODE * pi, WORD icon )
{
BYTE	tmp[ LEN_ZPATH ] ;
BYTE *	pHalf ;

    if ( pi == (INODE*)NULL ) {
	pi = inode_alloc( TRUE ) ;
	if ( pi == (INODE*)NULL )		/* ran out of INODEs	*/
	    return ;
	pi->i_flags = NONE ;
	pi->i_type = AT_ISPITM ;
    }
    
/* get Description editable field */
    tedinfo_get( tree, PITMDESC, (char far *)tmp );
    fstrcpy( pf->f_name, tmp ) ;
    pi->i_label = string_alloc( tmp ) ;
    if ( pi->i_label == (char *)NULL ) {	/* ran out of gl_buffer[] */
	inode_free( pi ) ;
	return ;
    }

/* get Document Types editable field */
    pHalf = tmp + (LEN_ZPATH/2) ;
    tedinfo_get( tree, PITMDOCT, (char far *)pHalf );
    GetDocTypes( tmp, pHalf ) ;
    pi->i_doctypes = string_alloc( tmp ) ;
    if ( pi->i_doctypes == (char *)NULL ) {	/* ran out of gl_buffer[] */
	inode_free( pi ) ;
	return ;
    }

/* get Command Line editable field */
    tedinfo_get( tree, PITMCMDL, (char   far *)tmp );
    pi->i_cmdline = string_alloc( tmp ) ;
    if ( pi->i_cmdline == (char *)NULL ) {	/* ran out of gl_buffer[] */
	inode_free( pi ) ;
	return ;
    }

    pi->i_icon = IA_GENERIC + icon ;
    pi->i_docicon = G.g_iconlist[ pi->i_icon ].file_icon ;
    pf->f_pa = (void *)pi ;
	
} /* GetProgramItem() */

/*---------------------------------------------------------------------------
*
*/
MLOCAL WORD InitProgramItemDial( TREE tree, WNODE far * pw, char far * fname,
								    INODE * pi )
{
BYTE	tmp[ LEN_ZFNAME ] ;
BYTE	tmppth[ LEN_ZPATH ] ;

/* color button types in listbox */    
    color_cats( tree, PITMSCRP ) ;

/* size scroller */    
    size_scroller( tree, PITMSCRP, 1, NUM_ICON_PAIRS ) ;
    
    if ( pi == (INODE*)NULL ) {		/* creating a new program item */
	
/* init Description editable field */    
	fstrcpy( tmp, fname ) ;		/* get a local copy */
	tedinfo_set( tree, PITMDESC, (char far *)tmp );

/* init Command Line editable field */
	fstrcpy( tmppth, pw->w_name ) ;
	strcat( tmppth, tmp ) ;
	tedinfo_set( tree, PITMCMDL, (char far *)tmppth );

/* init Document types editable field */
	tedinfo_set( tree, PITMDOCT, (char far *)"" );

/* position scroller, set icon */
	insa_elev( tree, PITMSCRP, 0, NUM_ICON_PAIRS );
	update_icon_pair( tree, PITMEXE, IA_GENERIC ) ;
	
	return( 0 ) ;
    }
    
/* else: changing an existing program item: */
    
/* init Description editable field */    
    tedinfo_set( tree, PITMDESC, (char far *)pi->i_label );

/* init Command Line editable field */
    tedinfo_set( tree, PITMCMDL, (char far *)pi->i_cmdline );

/* init Document types editable field */
    SetDocTypes( tmppth, pi->i_doctypes ) ;
    tedinfo_set( tree, PITMDOCT, (char far *)tmppth );

/* position scroller, set icon */
    insa_elev( tree, PITMSCRP, pi->i_icon - IA_GENERIC, NUM_ICON_PAIRS );
    update_icon_pair( tree, PITMEXE, pi->i_icon ) ;

    return( pi->i_icon - IA_GENERIC );
    
} /* InitProgramItemDial() */

/*---------------------------------------------------------------------------
*
*/
MLOCAL WORD NewIcon( TREE tree, WORD oicon, WORD value )
{
WORD	nicon = oicon ;

    nicon = max( 0, nicon+value ) ;
    nicon = min( nicon, NUM_ICONS-1 ) ;
    if ( oicon != nicon ) {
	insa_elev( tree, ICONSCRP, nicon, NUM_ICONS );
	insa_icon( tree, ICONICON, i_iconlist( nicon ), &gl_aib, "" );
	draw_fld( tree, ICONSCRA );
	draw_fld( tree, ICONSCRB );
	draw_fld( tree, ICONICON );
    } /* if old != new */
	
    return nicon ;
	
} /* NewIcon() */

/*---------------------------------------------------------------------------
*
*/
MLOCAL WORD NewIconPair( TREE tree, WORD oicon, WORD value )
{
WORD	nicon = oicon ;

    nicon = max( 0, nicon+value ) ;
    nicon = min( nicon, NUM_ICON_PAIRS-1 ) ;
    if ( oicon != nicon ) {
	insa_elev( tree, PITMSCRP, nicon, NUM_ICON_PAIRS );
	update_icon_pair( tree, PITMEXE, nicon + IA_GENERIC ) ;
	draw_fld( tree, PITMSCRA );
	draw_fld( tree, PITMSCRB );
	draw_fld( tree, PITMEXE );
	draw_fld( tree, PITMDOC );
    } /* if old != new */
	
    return nicon ;
	
} /* NewIconPair() */

/*---------------------------------------------------------------------------
*
*/
WORD NewIconDial( char far * fname, ANODE * pa )
{
TREE	tree ;
WORD	obj			= ICONOK ;
WORD	done ;
WORD	nicon			= i_listbox( pa->a_icon ) ;
WORD	value ;

    rsrc_gaddr( R_TREE, ICONDIAL, &tree ) ;

    InitNewIconDial( tree, pa ) ;

    show_hide(FMD_START, tree);

    do {
#if HELP_ALERTS
	obj = xform_do( tree, obj ) ;
	if (obj == -1 ) {
	    do_help_alert( HNEWPITM ) ;
	    continue ;
	}
#else
	obj = form_do( tree, obj ) ;
#endif
	done = inf_what( tree, ICONOK, ICONCNCL ) ;	/* exit button? */
	if ( done == -1 )				/* scroller action */
	    value = hndl_scroller( tree, ICONSCRP, obj, nicon, 
						    NUM_ICONS ) ;

	if ( value && done == -1 )
	    nicon = NewIcon( tree, nicon, value ) ;
	
    } while ( done == -1 ) ;

    if ( done == 1 ) 		/* user picked OK */
	GetNewIcon( pa, fname, nicon ) ;
	
    show_hide( FMD_FINISH, tree);
	
    return( done == 1 ) ;
	
} /* NewIconDial() */

/*---------------------------------------------------------------------------
*
*/
WORD NewProgramItem( WNODE far * pw, FNODE far * pf, INODE * pi )
{
TREE	tree ;
WORD	obj			= PITMDESC ;
WORD	done ;
WORD	nicon ;
WORD	value ;

    rsrc_gaddr( R_TREE, PITMDIAL, &tree ) ;

    nicon = InitProgramItemDial( tree, pw, pf->f_name, pi ) ;

    show_hide(FMD_START, tree);

    do {
#if HELP_ALERTS
	obj = xform_do( tree, obj ) ;
	if (obj == -1 ) {
	    do_help_alert( HNEWPITM ) ;
	    continue ;
	}
#else
	obj = form_do( tree, obj ) ;
#endif
	done = inf_what( tree, PITMOK, PITMCNCL ) ;	/* exit button? */
	if ( done == -1 )				/* scroller action */
	    value = hndl_scroller( tree, PITMSCRP, obj, nicon, NUM_ICON_PAIRS ) ;

	if ( value && done == -1 )
	    nicon = NewIconPair( tree, nicon, value ) ;
	
    } while ( done == -1 ) ;

    if ( done == 1 ) 		/* user picked OK */
	GetProgramItem( tree, pf, pi, nicon ) ;
	
    show_hide( FMD_FINISH, tree);
	
    return TRUE ;
	
} /* NewProgramItem() */

/*---------------------------------------------------------------------------
*
*/
WORD NewProgramGroup( void )
{
TREE	tree ;
BYTE	tmp[ LEN_ZFNAME ] ;
BYTE *	pTitle ;
WORD	wh ;
GRECT	rect ;

    rsrc_gaddr( R_TREE, PGRPDIAL, &tree ) ;

    strcpy( tmp, "description" ) ;
    tedinfo_set( tree, PGRPDESC, (char far *)tmp );
    
    show_hide(FMD_START, tree);
#if HELP_ALERTS
    while ( -1 == xform_do( tree, PGRPDESC ) )
	do_help_alert( HNEWPGRP ) ;
#else
    form_do( tree, PGRPDESC );
#endif

    if (inf_what( tree, PGRPOK, PGRPCNCL))
    {
	tedinfo_get( tree, PGRPDESC, (char far *)tmp );
	pTitle = string_alloc( (char far *)tmp ) ;
	wh = create_window( WKIND_GROUP, pTitle, (char *)NULL, &rect ) ;
    } /* if OK */
	
    show_hide( FMD_FINISH, tree);
	
    return TRUE ;
	
} /* NewProgramGroup() */

/*
 *	deskpgrp.c
 */
