/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1991  Digital Research Inc.  All rights reserved.    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/dsk/rcs/exproto.h 3.4 92/04/03 17:13:02 sbc Exp $
Date	Who	SPR#	Comments
-------	-------	----	------------------------------------------------------
910429	RSF		Add sld_adjust prototype.
910418	RSF		prototypes for vb_ routines and power
910405	RSF		Change LONG to SLONG to correct various bugs.
910328	RSF		Collected all prototypes for extended object support.
*****************************************************************************/

/****************************************************************************
* File:		exproto.h
*
* Description:	Function prototypes for extended object support in ViewMAX II.
*
* Build Info:	ndmake -f vm2.mak
*
*****************************************************************************/

#ifndef EXPROTO_INCLUDED
#define EXPROTO_INCLUDED

#include "exobdefs.h"
    
/*	--------------------------- button.c   -----------------------	*/

extern WORD toggle_button( TREE	tree,	/* Tree address of toggle button.   */
		WORD	obj,		/* Object number of toggle button.  */
		MSTAT	*mst		/* Mouse state at time of touch exit*/
		);

extern WORD radio_button( TREE	tree,	/* Tree address of radio button.    */
		WORD	obj,		/* Object number of radio button.   */
		MSTAT	*mst		/* Mouse state at time of touch exit*/
		);
	
extern short bigMulDiv(	short	mul1,
			short	mul2,
			short	div ) ;
			
/*	--------------------------- deskbkgd.c -----------------------  */
		
extern FLISTITEM *create_listitem(BYTE *data, WORD len, WORD state);
extern void init_bmp_list(FLISTBOX *lb, BOOLEAN prepend_none, 
	BOOLEAN none_sel, BYTE *curr_selection);

/*	--------------------------- desksupp.c -----------------------  */

extern void free_listitems(FLISTITEM *item);


/*	--------------------------- exformdo.c -----------------------	*/

extern WORD form_special( TREE	tree,
		WORD	obj,
		WORD	nclk,
		MSTAT	*mst,
		WORD	*next_obj
		);

extern WORD xform_do( TREE tree,
		WORD	start_fld
		);	

extern WORD tree_scan(
		OBJECT far *tree,          /* the tree to scan                             */
		WORD start_obj,            /* the object where scanning should be started  */
		WORD searched_flag,        /* the flag that should be looked for           */
		WORD direction);           /* scanning direction (TRUE means forward)      */
	
/*	--------------------------- exobj.c    -----------------------	*/

extern BYTE far * get_data_ptr( 
		TREE	tree,		/* Tree address.		    */
		WORD	obj		/* object number.		    */
		);

extern void updState_exobj( TREE	tree,
		WORD	start_obj,
		WORD	state,
		WORD	onoff,
		WORD	redraw
		);
	
extern WORD exobj_num(
		TREE	tree,
		WORD	obj
		);

/*	--------------------------- fndexobj.c -----------------------	*/

extern WORD find_exobj(
		TREE	tree,
		WORD	parent,
		WORD	part
		);

/*	--------------------------- fndexpnt.c -----------------------	*/

extern WORD find_exparent(     
		TREE	tree,
		WORD	obj,
		WORD	prnt_part
		);

/*	--------------------------- listbox.c  -----------------------	*/

extern void lb_scroll( 
		BYTE far * ldata,	/* List box data.		    */
		SLONG	new_start,	/* New first item in list box.	    */
		WORD	redraw		/* Redraw flag.			    */
		);

extern void lb_init( 
		TREE	tree,
		WORD	obj,
		WORD	redraw
		);

/*	--------------------------- listexob.c -----------------------	*/
extern void
lb_deselect( TREE	tree,		/* Tree address of list box.	    */
	     WORD	obj,		/* Object number of list box.	    */
	     WORD	redraw		/* Redraw flag.			    */
	     );

extern FLISTITEM 
*lb_slot_item(
	    FLISTBOX	*lb,	/* listbox data				*/
	    WORD	obj,	/* object number of a slot		*/
	    WORD	*num	/* count to return			*/
	    );
	
extern WORD
lb_update( TREE		tree,		/* Tree of list box.		    */
	   WORD		obj,		/* Number of selected object.	    */
	   MSTAT	*mst,		/* Current mouse state.		    */
	   WORD		nclk 
	   );

/*	--------------------------- listfile.c -----------------------	*/

extern WORD lf_addtypes( 
		FLISTBOX	*lb,		/* File list box data.	*/
		BYTE far	*mem,		/* Memory address.	*/
		WORD		size		/* size of block.	*/
		);

extern void lf_settypes( 
		FLISTFILE	*lf,		/* File list box data.		    */
		BYTE far	*types		/* New list of types.		    */
		);

extern void lf_setpath( 
		FLISTFILE	*lf,		/* List file data.		    */
		BYTE far	*path		/* Pointer to new path.		    */
		);
	
/*	--------------------------- parsestr.c -----------------------	*/

extern BYTE far * get_field(
		BYTE        *str,
		BYTE far    *buff
		);

/*	--------------------------- slider.c   -----------------------	*/

extern WORD sld_update( 
		TREE	tree,
		WORD	obj,
		MSTAT	*mst
		);
extern WORD sld_adjust(
		FSLIDER	*sld,
		SLONG	increment);

/*	--------------------------- slidtran.c -----------------------	*/

extern SLONG power(
		SLONG    val,
		WORD    exp
	   );

extern void set_strans(
		FSLIDER	*sld,
		SLONG	step_size[]
		);
	
extern SLONG scrn_to_val( 
		SLONG	x,
		FSLDTRAN	*st
		);

extern SLONG val_to_scrn( 
		SLONG	val,
		FSLDTRAN	*st
		);
extern void snap_knob( 
		FSLIDER	*sld,
		WORD		redraw
		);

extern void set_val( 
		BYTE far    *vdata,
		SLONG	    val,
		WORD	    redraw
		);

/*	--------------------------- trnsrsc.c  -----------------------	*/

extern void screen_parm( WORD	vdi_handle	/* Handle for the screen virtual    */
						/* workstation.			    */
	     );
     
extern void	set_3d_color( FDOBJECT *o_ptr, LONG color_cat);

extern FAPPLBLK *init_progdef(
		TREE	tree,
		WORD	obj,
		FAPPLBLK	*ab 
		);

extern void trnfm_icon( 
		FDICONBLK	*icon		/* Pointer to icon block.	    */
		);

extern void trnfm_bitblk( 
		FBITBLK	    *bitblk	/* Pointer to bit block.	    */
		);

extern BYTE far *trnfm_rsc( void );

/*	--------------------------- util.c     -----------------------	*/
extern void r_to_xy( 
		RECT  	*rect  ,
		WORD	*xy 
		);

extern void do_linebox( RECT  	*rect );

/*	--------------------------- valuebox.c -----------------------	*/

extern void vb_setMax(TREE tree, WORD obj, SLONG max, WORD redraw);
extern void vb_setVal(TREE tree, WORD obj, SLONG val, WORD redraw);
extern void vb_parse( 
		FVALUE	 *vb,		/* Value box data structure.	    */
		BYTE far *init_str	/* Value box data string.	    */
		);
extern VOID get_value( 
	   TREE	    tree,		/* Address of the tree.		    */
	   WORD	    obj,		/* Number of value box parent.	    */
	   SLONG    *val,		/* Address to return value.	    */
	   SLONG    *mag		/* Address to return magnitude.	    */
	   );

/*    --------------------------- radio.c -----------------------	*/
extern	short	Rbutton_size( void );
extern	void	CUA_InitRbutton( short _wbox, short _hbox );
extern	void	CUA_InitToggle( short _wbox, short _hbox );
extern	void	CUA_ToggleBox( FDPARMBLK *pb_ptr );
extern	void	CUA_RadioButton( FDPARMBLK *pb_ptr );

#endif /* ndef EXPROTO_INCLUDED */

/* end of exproto.h */

