;    File              : $Workfile: COMMAND.ASM$
;
;    Description       : GEM font support
;
;    Original Author   : ?
;
;    Last Edited By    : $Author: AWIGHTMA$
;
;-----------------------------------------------------------------------;
;       Copyright 1999, Caldera Thin Clients, Inc.                      ;
;       This software is licenced under the GNU Public License.         ;
;       Please see LICENSE.TXT for further information.                 ;
;                                                                       ;
;                  Historical Copyright                                 ;
;	Copyright (C) 1976-1992 Digital Research Inc. All rights	;
;	reserved. The Software Code contained in this listing is	;
;	proprietary to Digital Research Inc., Monterey,			;
;	California, and is covered by U.S. and other copyright		;
;	protection. Unauthorized copying, adaption, distribution,	;
;	use or display is prohibited and may be subject to civil	;
;	and criminal penalties. Disclosure to others is			;
;	prohibited. For the terms and conditions of software use,	;
;	refer to the appropriate Digital Research Licence		;
;	Agreement.							;
;-----------------------------------------------------------------------;
;
;    *** Current Edit History ***
;    *** End of Current Edit History ***
;
;    $Log: $
;    COMMAND.ASM 1.1 92/07/23 18:04:35 AWIGHTMA
;    ; 01 Dec 91	K.H	Support double byte character set.
;    
;
;    ENDLOG
include	equates.inc		; contains equates, definitions and externals

; Public entry points.
		public	alt_app
		public	font_switch
if GEM
		public	info_switch
endif
		public	mouse_switch
		public	parse_command_line
		public	proc_switch
		public	resident_switch
		public	screen_switch
		public	skip_to_token
		public	skip_white

; External entry points.
		extrn	check_and_load:near
		extrn	reset_and_exit:near
		extrn	upper_case:near
if DBCS
		extrn	dbcs_lead:near
endif

;************************************************************************
;* parse_command_line							*
;************************************************************************
parse_command_line:
		push	es
		pop	ds			; ds = PSP segment address
		mov	bx, 1			; ds:80h[bx] -> command tail

; If a command line was not specified, bail out.
	assume ds:PSP_SEG
		cmp	CMD_TAIL, 0
	assume ds:DATA
		jz	end_parse_command_line

; Initialize validity flags.
		xor	al, al
		mov	cs:byte ptr alt_app_flag, al ; FWD reference
		;;mov	mouse_valid, al
		mov	resident_valid, al
if GEM
		mov	info_path, al
endif
; Loop over the command line string, extracting appropriate information.
		mov	al, 80h[bx]
pcl_loop:
		cmp	al, AA			; alternate application?
		jne	pcl_check_switch
		call	alt_app
		jmp short pcl_next
pcl_check_switch:
		cmp	al, SW			; switch?
		jne	pcl_next
		call	proc_switch
pcl_next:
		call	skip_to_token
		jnc	pcl_loop

; Parsing is done.  If an alternate application is not being EXECed, pass
; the command tail on to the GEMAES.  Put the command tail address into
; the exec parameter block.  Save the length of the command tail so that
; it can be restored after being wiped out by an FCB.
pcl_parse_done:
		cmp	cs:byte ptr alt_app_flag, 0 ; FWD reference
		jne	end_parse_command_line
		mov	pblock + 2, 80h		; command tail offset
		mov	pblock + 4, ds		; command tail segment (PSP)
	assume ds:PSP_SEG
		mov	al, CMD_TAIL
	assume ds:DATA
		mov	save_tail_len, al

; That's all!
end_parse_command_line:
		ret


;************************************************************************
;* alt_app								*
;*	ds:bx -> alternate application character (/).			*
;*	Returns with bx and alt_app_flag updated.			*
;************************************************************************
alt_app:
		mov	ax, cs
		mov	es, ax
		mov	di, offset app_name	; es:di = app file name
app_loop:
		inc	bx
		mov	al, 80h[bx]
		cmp	al, ' '
		jna	aa_attach_extension
		cmp	al, SW
		je	aa_attach_extension
		cmp	al, '.'			; extension?
		je	aa_extension_given
		stosb
		jmp short app_loop

; An extension occurs with the file name.  Store the '.' and get the remainder
; of the file name.
aa_extension_given:
		stosb
aa_extension_loop:
		inc	bx
		mov	al, 80h[bx]
		cmp	al, SW
		je	alt_app_done
		cmp	al, ' '
		jna	alt_app_done
		stosb
		jmp short aa_extension_loop

; No extension was given.  Use a default of '.EXE'.
aa_attach_extension:
		mov	al, '.'
		stosb
		mov	al, 'e'
		stosb
		mov	al, 'x'
		stosb
		mov	al, 'e'
		stosb

; Tag on a null.
alt_app_done:
		xor	al, al
		stosb
		mov	cs:byte ptr alt_app_flag, 1	; FWD reference
		ret


;************************************************************************
;* proc_switch								*
;*	ds:bx -> switch character (/).					*
;*	Returns with bx updated.					*
;************************************************************************
proc_switch:
		mov	ax, cs
		mov	es, ax
		mov	al, byte ptr 81h[bx]	; get character
		mov	ah, byte ptr 82h[bx]	; get following character
		cmp	ah, '='
		je	ps_candidate
		cmp	ah, ' '
		je	ps_candidate
		inc	bx
		jmp short end_proc_switch

; Find out which switch.
ps_candidate:
;;;;;		push	bx			; save start for blanking
		add	bx, 3			; ds:bx -> switch argument
		call	upper_case
		cmp	al, 'S'
		jne	ps_check_mouse
		call	screen_switch
		jmp short ps_blank
ps_check_mouse:
		cmp	al, 'M'
		jne	ps_check_resident
		call	mouse_switch
		jmp short ps_blank
ps_check_resident:
		cmp	al, 'R'
		jne	ps_check_font
		call	resident_switch
		jmp short ps_blank
ps_check_font:
		cmp	al, 'F'
		jne	ps_check_info
		call	font_switch
		jmp short ps_blank
ps_check_info:
if GEM
		cmp	al, 'I'
		jne	ps_check_override
		call	info_switch
		jmp short ps_blank
endif
ps_check_override:
		cmp	al, 'O'
		jne	ps_blank
		call	over_switch
		jmp short ps_blank
ps_blank:
;;;;;		mov	cx, bx			; cx = end index
;;;;;		pop	bx			; bx= index to start of switch
;;;;;		sub	cx, bx			; cx = # used in switch
;;;;;		je	end_proc_switch		; done if none used
;;;;;		mov	al, ' '			; blank them out
;;;;;ps_bloop:	mov	byte ptr 80h[bx], al	; ds:[dx] = ' '
;;;;;		inc	bx			; bump index
;;;;;		loop	ps_bloop		; until all blanked

end_proc_switch:
		ret


;************************************************************************
;* screen_switch							*
;*	ds:bx -> switch argument.					*
;*	Updates bx.							*
;************************************************************************
screen_switch:
		call	skip_white		; get to argument
		jc	end_screen_switch

; Gather the screen driver name.
		mov	cx, 7			; file name limit (less one)
		mov	di, offset sd_name	; es:di -> name string
		call	upper_case
		stosb				; save first character
ss_loop:
		inc	bx
		mov	al, 80h[bx]		; get next character
		cmp	al, ' '			; is it white?
		jna	ss_loop_done
		cmp	al, SW			; is it a new switch?
		je	ss_loop_done
		cmp	al, '.'			; is it extension start?
		je	ss_loop_done
ss_upper_it:
		call	upper_case
		stosb				; save the character
		loop	ss_loop
		inc	bx
ss_loop_done:
		mov	es:byte ptr [di], '.'
		mov	es:byte ptr 1[di], '*'	; wildcard extension
		mov	es:byte ptr 2[di], 0	; null terminate

; That's all!
end_screen_switch:
		ret


;************************************************************************
;* mouse_switch								*
;*	ds:bx -> switch argument.					*
;*	Updates bx.							*
;************************************************************************
mouse_switch:
		call	skip_white		; get to argument
		jc	end_mouse_switch

; Get two characters for the mouse patch.
		sub	al, '0'
		mov	mouse_1, al
		mov	ah, 81h[bx]		; ah = second byte
		sub	ah, '0'
		mov	mouse_2, ah
		mov	mouse_valid, 1		; indicate valid data
		add	bx, 2

; That's all!
end_mouse_switch:
		ret

;************************************************************************
;* over_switch								*
;*	ds:bx -> switch argument.					*
;*	Updates bx.							*
;************************************************************************
over_switch:
		call	skip_white		; get to argument
		jc	end_over_switch

; Get a character for the override.
		sub	al, '0'
		mov	override, al
		inc	bx
end_over_switch:
		ret


;************************************************************************
;* resident_switch							*
;*	ds:bx -> switch argument.					*
;*	Updates bx.							*
;************************************************************************
resident_switch:
		call	skip_white		; get to argument
		jc	end_resident_switch

; Gather the resident driver name.
		mov	cx, 7			; file name limit (less one)
		mov	di, offset rd_name	; es:di -> name string
		xor	dx, dx			; string length counter
		call	upper_case
		stosb				; save first character
rs_loop:
		inc	bx
		mov	al, 80h[bx]		; get next character
		cmp	al, ' '			; is it white?
		jna	rs_loop_done
		cmp	al, SW			; is it a new switch?
		je	ss_loop_done
		cmp	al, '.'			; is it extension start?
		je	rs_loop_done
rs_upper_it:
		call	upper_case
		stosb				; save the character
		inc	dx
		loop	rs_loop
		inc	bx
rs_loop_done:
		mov	es:byte ptr [di], 0	; null terminate
		inc	dx
		mov	resident_valid, dl	; indicate valid data

; That's all!
end_resident_switch:
		ret


;************************************************************************
;* font_switch								*
;*	ds:bx -> switch argument.					*
;*	Updates bx.							*
;************************************************************************
font_switch:
		call	skip_white		; get to argument
		jc	end_font_switch

; Gather the font path.
		mov	di, offset font_path	; es:di -> font path string
		stosb				; save first character
isf_loop:
		inc	bx
		mov	al, 80h[bx]		; get next character
		cmp	al, ' '			; is it white?
		jna	isf_loop_done
		cmp	al, SW			; is it a new switch?
		je	isf_loop_done
		stosb				; save the character
		jmp short isf_loop
isf_loop_done:
		xor	al, al			; null terminate
		stosb
end_font_switch:
		ret

if GEM
;************************************************************************
;* info_switch								*
;*	ds:bx -> switch argument.					*
;*	Updates bx.							*
;************************************************************************
info_switch:
		call	skip_white		; get to argument
		jc	end_info_switch

; Gather the info path.
		mov	di, offset info_path	; es:di -> info path string
		call	upper_case
		stosb				; save first character
is_loop:
if DBCS
		push	ax
		call	dbcs_lead		; check stored character
		add	sp, 2
		test	ax, ax
		jz	is_not_dbcs
		inc	bx
		mov	al, 80h[bx]		; get next character
		stosb				; store dbcs secound byte
		mov	ah, 0ffh		; set dbcs flag
is_not_dbcs:
ENDIF
		inc	bx
		mov	al, 80h[bx]		; get next character
		cmp	al, ' '			; is it white?
		jna	is_loop_done
		cmp	al, SW			; is it a new switch?
		je	is_loop_done
is_upper_it:
		call	upper_case
		stosb				; save the character
		jmp short is_loop
		inc	bx
is_loop_done:
		dec	di
if DBCS
		test	ah, ah			; last character is dbcs?
		jnz	is_just_dbcs
endif
		cmp	es:byte ptr [di], '\'
		je	is_terminate_with_null
if DBCS
is_just_dbcs:
endif
		inc	di
is_terminate_with_null:
		xor	al, al			; null terminate
		stosb

; That's all!
end_info_switch:
		ret
endif

;************************************************************************
;* skip_white								*
;*	ds:bx -> current character					*
;*	Returns next non-white character in al and updates bx. If	*
;*	done with the string, carry is returned.			*
;************************************************************************
skip_white:
	assume ds:PSP_SEG
		cmp	bl, CMD_TAIL		; check character count
	assume ds:DATA
		ja	sw_done
		mov	al, 80h[bx]		; get next character
		cmp	al, CR			; RETURN?
		je	sw_done
		cmp	al, ' '
		ja	sw_found
		inc	bx
		jmp short skip_white
sw_found:
		clc
		ret
sw_done:
		stc
		ret


;************************************************************************
;* skip_to_token							*
;*	ds:bx -> current character					*
;*	Returns with bx pointing to next token.  The token is returned	*
;*	in al.  If done with the string, carry is set.			*
;************************************************************************
skip_to_token:
	assume ds:PSP_SEG
		cmp	bl, CMD_TAIL
	assume ds:DATA
		ja	stt_done
		mov	al, 80h[bx]		; get character
		cmp	al, CR
		je	stt_done
		cmp	al, SW
		je	stt_found
		inc	bx			; bump to next character
		cmp	al, ' '
		ja	skip_to_token

; Process white.
stt_skip_white:
	assume ds:PSP_SEG
		cmp	bl, CMD_TAIL
	assume ds:DATA
		ja	stt_done
		mov	al, 80h[bx]		; get character
		cmp	al, CR
		je	stt_done
		cmp	al, ' '
		ja	stt_found
		inc	bx
		jmp short stt_skip_white

stt_found:
		clc
		ret
stt_done:
		stc
		ret


;************************************************************************
;* Data area for information which can be discarded after loading.	*
;************************************************************************

alt_app_flag	db	0

CODE	ends
		end
