;    File              : $Workfile: EQUATES.INC$
;
;    Description       : Include file used by all .asm's for common equates
;
;    Original Author   : ?
;
;    Last Edited By    : $Author: AWIGHTMA$
;
;-----------------------------------------------------------------------;
;       Copyright 1999, Caldera Thin Clients, Inc.                      ;
;       This software is licenced under the GNU Public License.         ;
;       Please see LICENSE.TXT for further information.                 ;
;                                                                       ;
;                  Historical Copyright                                 ;
;	Copyright (C) 1976-1992 Digital Research Inc. All rights	;
;	reserved. The Software Code contained in this listing is	;
;	proprietary to Digital Research Inc., Monterey,			;
;	California, and is covered by U.S. and other copyright		;
;	protection. Unauthorized copying, adaption, distribution,	;
;	use or display is prohibited and may be subject to civil	;
;	and criminal penalties. Disclosure to others is			;
;	prohibited. For the terms and conditions of software use,	;
;	refer to the appropriate Digital Research Licence		;
;	Agreement.							;
;-----------------------------------------------------------------------;
;
;    *** Current Edit History ***
;    *** End of Current Edit History ***
;
;    $Log: $
;    EQUATES.INC 1.1 92/07/23 18:06:43 AWIGHTMA
;    ;	Jul 92		atw	Back to normal segment ordering to enable BEZ
;    ;	May 1992 	atw	Created a single equate file with externs and equates
;    ;	16 Jun 1992	atw	enable 16 bit code in all languages
;    
;
;    ENDLOG

CODE	segment	PARA PUBLIC 'CODE'	; ensure CODE is linked first
CODE	ends
DATA	segment WORD PUBLIC 'DATA'	; actually there is no DATA since
DATA	ends				; gemvdi uses code segment (like 8080)
_TEXT	segment	PARA PUBLIC 'CODE'	; this is the 'C' code
_TEXT	ends
_DATA	segment WORD PUBLIC 'DATA'	; this is the 'C' local data
_DATA	ends
CGROUP	group	CODE, _TEXT		; near jumps from 'C' to ASM
DGROUP	group	DATA, _DATA		; avoids no stack error message
CODE	segment	PARA PUBLIC 'CODE'
	assume cs:CODE, ds:DATA, ss:DATA ; for all modules.

FALSE		equ	0
TRUE		equ	NOT FALSE
DEBUG		equ	FALSE		; used in debuga.asm and debentry.asm
GEM		equ	FALSE		; reduces size by disabling fonts etc
DBCS		equ	TRUE		; fully 16 bit enabled for all lang's
CHGENV		equ	TRUE		; fully 16 bit enabled for all lang's

; Memory to allocate for fonts in paragraphs.

SD_FONT_MAX		equ	5120	; max memory for screen fonts (80K)
PD_FONT_MAX		equ	32767	; max memory for non-screen fonts
SD_FONT_FREE		equ	0	; min to leave free (10K)
PD_FONT_FREE		equ	640	; min to leave free (10K)
FONT_MIN		equ	100	; min memory to allocate in any case

; PCDOS interrupts, errors, and function equates.
ALLOCATE		equ	48h	; allocate memory function
EXEC			equ	4bh	; load and execute function
EXIT_PROGRAM		equ	4ch	; exit program function
FILE_CLOSE		equ	3eh	; close file function
FILE_OPEN		equ	3dh	; open file function
FILE_CREATE		equ	3ch	; create file function
FILE_DELETE		equ	41h	; delete file function
FILE_READ		equ	3fh	; read file function
FILE_SEEK		equ	42h	; position file pointer function
FILE_WRITE		equ	40h	; write file function
FIND_FIRST		equ	4eh	; find first matching file function
FIND_NEXT		equ	4fh	; find next matching file function
FREE_MEM		equ	49h	; free allocated memory function
GET_DIR			equ	47h	; return current directory function
GET_DRIVE		equ	19h	; get current drive function
SET_VEC			equ	25h	; Set interrupt vector
GET_DTA			equ	2fh	; get current disk transfer address
GET_VEC			equ	35h	; Get interrupt vector
INPUT_CHARACTER		equ	08h	; direct console input function
INSUFFICIENT_MEMORY	equ	08h	; allocation error:  not enough memory
LOAD			equ	4bh	; load and execute program function
PCDOS			equ	21h	; function request interrupt
PRINT_STRING		equ	09h	; print string function
SET_DIR			equ	3bh	; change current directory function
SET_DRIVE		equ	0eh	; set current drive function
SET_DTA			equ	1ah	; set disk transfer address function
SETBLOCK		equ	4ah	; modify memory block function
GET_RTNCD		equ	4dh	; get return code of child process
GET_DBCSVEC		equ	63h	; get dbcs vector table address

; Stack size equate.
STACK_SIZE		equ	750

; Equates for workstation table.
WS_ENTRIES		equ	8	; entries in workstation table
WS_RES 			equ	1	; driver resident bit
WS_OPEN			equ	2	; driver open bit

; Equates for offsets in the assignment table.
ASS_LENGTH		equ	112     ; length of assignment item
ASS_NAME_LGTH		equ	13	; length of a file name
ASS_WORK_ID		equ	0	; offset to the workstation id
ASS_RES_ID		equ	2	; offset to reserved byte
ASS_FILE_NAME		equ	3	; offset to driver file name
ASS_PATCH       	equ	16	; offset to driver patch word (byte)
ASS_S_NAME		equ	18	; offset to driver short name
ASS_L_NAME		equ	31	; offset to driver long name
ASS_S_NAME_LEN		equ	13	; max length of driver short name
ASS_L_NAME_LEN		equ	81      ; max length of driver long name
ASS_NAMES_VALID		equ	2	; mask for bit if ASS_RES_ID, set if
					;  short and long names are valid

; Equates for offsets in the headers string file.
STR_BUFSIZ		equ	32	; length of string structure
STR_DATE		equ	0	; offset to font file date
STR_TIME		equ	2	; offset to font file time
STR_MULTI_ID		equ	4	; offset to multi-section identifier
STR_SEEK_LO		equ	6	; offset to multi-section seek (low)
STR_SEEK_HI		equ	8	; offset to multi-section seek (high)
STR_FILENAME		equ	16	; offset to font file name string

; Equates for offsets in paged font header items.
PGHD_LENGTH		equ	9	; length of paged font header items
PGHD_INDEX		equ	0	; offset to string index (masked word)
PGHD_FACE		equ	2	; offset to face
PGHD_SIZE		equ	4	; offset to point size
PGHD_TOP		equ	5	; offset to top distance
PGHD_DATASIZE		equ	7	; offset to font data size

; DAO 6/20/88 start separate printer/screen header space fix
PD_FHDR_MIN		equ	40960	; minimum space for font headers
PD_FHDR_MAX		equ	49152	; maximum space for font headers
SD_FHDR_MIN		equ	8192	; minimum space for font headers
SD_FHDR_MAX		equ	16384	; maximum space for font headers
; DAO 6/20/88 end separate printer/screen header space fix

; Equates for enumeration values.
SEL_POINT		equ	0	; point mode
SEL_ABSOLUTE		equ	1	; absolute mode

; Equates for ASCII character mnemonics.
CR			equ	0Dh	; ASCII carriage return character
CTL_Z			equ	1Ah	; ASCII control-z character
LF			equ	0Ah	; ASCII line feed character
NUL			equ	00h	; ASCII null character
TAB			equ	09h	; ASCII tab character

; Command line switch characters
AA			equ	'-'	; alternate application
SW			equ	'/'	; option switch

; The following segment defnitions are needed to allow the source code
; that was written for RASM86 to be converted to TASM with minmum change.
; It is a convienient way to address far segments from a .8080 model without
; increasing the size of the EXE file.
 
FH_SEG		segment
		org	0
; Equates for offsets in font header file header.
FHFH_PHDLOW	label word	; offset to paged header low address
FHFH_PHDCOUNT	equ <word ptr FHFH_PHDLOW+2>	; offset to paged header count
FHFH_EFFSIZE	equ <word ptr FHFH_PHDLOW+4>	; offset to effect buffer size (bytes)
FHFH_INCOMPLETE	equ <word ptr FHFH_PHDLOW+6>	; offset for "incomplete load" flag
; Equates for font headers.
FHDR_SIZE		equ	160	; size of font headers
FH_SEG		ends

FONT_SEG	segment
; Equates for offsets in font header of font files (and other font info).
DATA_PAGED		equ	10h	; font data unavailable flag
COMPRESSED		equ	0020h	; font data compressed flag
ALL_RESIDENT		equ	01h	; all associated headers resident
USE_FULL_ID		equ	2000h	; offset to full font id word
	org	0
FONT_ID		   label word			; 0 offset to font id
POINT_SIZE_BYTE	   equ <byte ptr FONT_ID+2>	; 2 offset to font point size
POINT_SIZE	   equ <word ptr FONT_ID+2>	; 2 offset to font point size
FACE_NAME	   equ <byte ptr FONT_ID+4>	; 4 offset to face name
FONT_FILE_NAME_OFF equ <word ptr FONT_ID+32>	; 32 offset to font file name offset
FONT_FILE_NAME_SEG equ <word ptr FONT_ID+34>	; 34 offset to font file name segment
FONT_FIRST_ADE	   equ <word ptr FONT_ID+36>    ; 36 offset to lowest ade
FONT_TOP	   equ <word ptr FONT_ID+40>    ; 40 offset to top distance
MAX_CELL_WIDTH	   equ <word ptr FONT_ID+52>	; 52 offset to maximum cell width
LEFT_OFF	   equ <word ptr FONT_ID+54>    ; 54 offset to left offset
RIGHT_OFF	   equ <word ptr FONT_ID+56>    ; 56 offset to right offset
FLAGS_WORD	   equ <word ptr FONT_ID+66>    ; 66 offset to font flags
HOR_TABLE_OFF	   equ <word ptr FONT_ID+68>    ; 68 offset to horizontal table offset
HOR_TABLE_SEG	   equ <word ptr FONT_ID+70>    ; 70 offset to horizontal table segment
OFF_TABLE_OFF	   equ <word ptr FONT_ID+72>    ; 72 offset to offset table offset (!?)
OFF_TABLE_SEG	   equ <word ptr FONT_ID+74>    ; 74 offset to offset table segment
DAT_TABLE_OFF	   equ <word ptr FONT_ID+76>    ; 76 offset to data table offset
DAT_TABLE_SEG	   equ <word ptr FONT_ID+78>    ; 78 offset to data table segment
FORM_WIDTH	   equ <word ptr FONT_ID+80>    ; 80 offset to form width
FORM_HEIGHT	   equ <word ptr FONT_ID+82>    ; 82 offset to form height
FONT_PTR_ADDR	   equ <dword ptr FONT_ID+84>   ; 84 next font header pointer
FONT_PTR_OFF	   equ <word ptr FONT_ID+84>    ; 84 offset to next font header offset
FONT_PTR_SEG	   equ <word ptr FONT_ID+86>    ; 86 offset to next font header segment
NEXT_SET_ADDR	   equ <dword ptr FONT_ID+88>   ; 88 multi-set pointer
NEXT_SET_OFF	   equ <word ptr FONT_ID+88>    ; 88 offset to multi-set offset
NEXT_SET_SEG	   equ <word ptr FONT_ID+90>    ; 90 offset to mutli-set segment
USE_COUNT_LO	   equ <word ptr FONT_ID+92>    ; 92 offset to use counter (low word)
USE_COUNT_HI	   equ <word ptr FONT_ID+94>    ; 94 offset to use counter (high word)
FONT_FILE_DATA_OFF equ <word ptr FONT_ID+96>    ; 96 offset to font file data offset
FONT_FILE_DATA_SEG equ <word ptr FONT_ID+98>    ; 98 offset to font file data segment
FONT_FILE_DATA_SIZE equ <word ptr FONT_ID+100>  ; 100 offset to font file data size
FONT_RESERVED	   equ <word ptr FONT_ID+102>   ; 102 offset to reserved section
FONT_STRINDEX	   equ <word ptr FONT_ID+102>   ; 102 offset to font string index
FONT_HDRLRU_LO	   equ <word ptr FONT_ID+104>   ; 104 offset to low word of header LRU
FONT_HDRLRU_HI	   equ <word ptr FONT_ID+106>   ; 106 offset to high word of header LRU
FONT_GDOS_FLAGS	   equ <word ptr FONT_ID+108>   ; 108 offset to GDOS font management flags
FONT_FULL_ID	   equ <word ptr FONT_ID+110>   ; 110 offset to full font id word
COMPRESSED_SIZE	   equ <word ptr FONT_ID+150>   ; 150 offset to compressed data size
FONT_SEG	ends

DH_SEG	segment
DH0	label	byte
DH_ITEMS	equ <word ptr DH0+6>
DH_SIZE		equ <word ptr DH0+8>
DH_IP		equ <word ptr DH0+14h>
DH_COFF		equ <word ptr DH0+16h>
DH_OFFS		equ <word ptr DH0+18h>
DH_SEG	ends

PSP_SEG	segment
	org	0
PSP0	label	byte
PSP_ENV		equ 	<word ptr PSP0+2ch>
CMD_TAIL	equ	<byte ptr PSP0+80h>
PSP_SEG	ends

EXE_SEG	segment
	org	0
EXE0	label	word
EXE_SIG	equ <word ptr EXE0+30h>
EXE_SEG	ends

ifndef	SUPPRESS_EXTERNALS

; These are all the external declarations for the assembly files

		extrn	app_buff:dword
		extrn	app_buff_off:word
		extrn	app_buff_seg:word
		extrn	app_buff_size:word

		extrn	all_loaded:word
		extrn	aside_block:word
		extrn	assign_seg:word
if GEM
		extrn	best_double:word
		extrn	best_double_del:word
		extrn	best_double_off:word
		extrn	best_double_seg:word
		extrn	best_normal:word
		extrn	best_normal_del:word
		extrn	best_normal_off:word
		extrn	best_normal_seg:word
endif
		extrn	copy_contrl:word
		extrn	copy_intin:word
if GEM
		extrn	cur_absize:word
		extrn	cur_face:word
		extrn	cur_point:word
endif
		extrn	driver_count:word
		extrn	driver_head:word
		extrn	driver_off:word
		extrn	driver_seg:word
		extrn	driver_size:word
if GEM
		extrn	eff_size:word
endif
		extrn	entries:word
if GEM
		extrn	fb_free_off:word
		extrn	fb_free_seg:word
		extrn	fb_free_size:word
		extrn	fb_seg:word
		extrn	fb_size:word
		extrn	fhdr_count:word
endif
		extrn	file_count:word
		extrn	file_handle:word
if GEM
		extrn	first_font_seg:word
endif
		extrn	flip:word
if GEM
		extrn	font_block_seg:word
		extrn	font_count:word
		extrn	font_loaded:word
		extrn	font_val:word
		extrn	header_offset:word
		extrn	header_segment:word
		extrn	header_space:word
		extrn	incomplete_load:word
		extrn	last_font_off:word
		extrn	last_font_seg:word
endif
		extrn	load_successful:word
if GEM
		extrn	lruhi:word
		extrn	lrulo:word
		extrn	mfuhi:word
		extrn	mfulo:word
endif
		extrn	multi_id:word
		extrn	opcode:word
		extrn	pblock:word
if GEM
		extrn	phdr_count:word
		extrn	phdr_low:word
endif
		extrn	psp_base:word
		extrn	save_count:word
		extrn	save_end:word
		extrn	save_start:word
if GEM
		extrn	screen_font:word
		extrn	selmode:word
endif
		extrn	step_aside:word
if GEM
		extrn	str_handle:word
		extrn	str_index:word
endif
		extrn	text_buffer_size:word
if GEM
		extrn	this_font_off:word
		extrn	this_font_seg:word
endif
		extrn	work_identifier:word
		extrn	ws_absize:word
		extrn	ws_chead:word
		extrn	ws_coff:word
		extrn	ws_cseg:word
		extrn	ws_dseg:word
		extrn	ws_dsize:word
		extrn	ws_face:word
		extrn	ws_flags:word
		extrn	ws_font_block:word
		extrn	ws_font_seg:word
		extrn	ws_id:word
		extrn	ws_index:word
		extrn	ws_lruhi:word
		extrn	ws_lrulo:word
		extrn	ws_phdr_count:word
		extrn	ws_phdr_low:word
		extrn	ws_point:word
		extrn	ws_root:word
		extrn	ws_selmode:word
		extrn	ws_size:word
		extrn	ws_texbuf:word
		extrn	ws_texbuf_size:word
		extrn	ws_xform:word
		extrn	ws_xres:word
		extrn	ws_yres:word

		extrn	contrl:dword
		extrn	driver_offset:dword
if GEM
		extrn	fb_free_addr:dword
		extrn	last_font_addr:dword
		extrn	this_font_addr:dword
endif
		extrn	intin:dword
		extrn	intout:dword
		extrn	ptsin:dword
		extrn	ptsout:dword
		extrn	save_contrl:dword
		extrn	save_dta:dword

		extrn	app_name:byte
		extrn	aside_com_line:byte
		extrn	aside_error:byte
		extrn	aside_file:byte
		extrn	aside_msg:byte
if GEM
		extrn	attr_val:byte
endif
		extrn	bad_driver:byte
if GEM
		extrn	best_double_pts:byte
		extrn	best_normal_pts:byte
endif
		extrn	command_error:byte
		extrn	dyna_suppress:byte
		extrn	font_path:byte
if GEM
		extrn	font_suffix:byte
endif
		extrn	gdos_drive:byte
		extrn	gdos_dta:byte
		extrn	gdos_path:byte
if GEM
		extrn	info_file:byte
		extrn	info_path:byte
endif
		extrn	location_info:byte
		extrn	mouse_1:byte
		extrn	mouse_2:byte
		extrn	mouse_valid:byte
		extrn	override:byte
		extrn	not_installed_msg:byte
		extrn	rd_name:byte
		extrn	pd_font:byte
if GEM
		extrn	phdr_buf:byte
endif
		extrn	resident_valid:byte
		extrn	resident_driver:byte
		extrn	save_block:byte
		extrn	save_tail_len:byte
		extrn	saved_drive:byte
		extrn	saved_path:byte
		extrn	sb_end:byte
		extrn	sd_font:byte
		extrn	sd_name:byte
if GEM
		extrn	str_buf:byte
		extrn	str_suffix:byte
endif
		extrn	work_table_full:byte

;;K.H
		extrn	fatal_msg:byte
		extrn	app_error:byte
		extrn	invalid_addr:byte
		extrn	no_drivers:byte
		extrn	no_mem:byte
		extrn	no_screen:byte
		extrn	no_table:byte
;;

;************************************************************************
;* Local data area for information which must be retained after loading.*
;************************************************************************

		extrn	prog_size:word
		extrn	assign_table_length:word
		extrn	overlay_segment:word
		extrn	any_key:byte
		extrn	ss_save:word
		extrn	sp_save:word
		extrn	root_path:byte
		extrn	root_drive:byte
		extrn	app_path:byte
		extrn	command_tail:byte
endif

