;    File              : $Workfile: LOADER.ASM$
;
;    Description       : GEM driver and application loading
;
;    Original Author   : ?
;
;    Last Edited By    : $Author: AWIGHTMA$
;
;-----------------------------------------------------------------------;
;       Copyright 1999, Caldera Thin Clients, Inc.                      ;
;       This software is licenced under the GNU Public License.         ;
;       Please see LICENSE.TXT for further information.                 ;
;                                                                       ;
;                  Historical Copyright                                 ;
;	Copyright (C) 1976-1992 Digital Research Inc. All rights	;
;	reserved. The Software Code contained in this listing is	;
;	proprietary to Digital Research Inc., Monterey,			;
;	California, and is covered by U.S. and other copyright		;
;	protection. Unauthorized copying, adaption, distribution,	;
;	use or display is prohibited and may be subject to civil	;
;	and criminal penalties. Disclosure to others is			;
;	prohibited. For the terms and conditions of software use,	;
;	refer to the appropriate Digital Research Licence		;
;	Agreement.							;
;-----------------------------------------------------------------------;
;
;    *** Current Edit History ***
;    *** End of Current Edit History ***
;
;    $Log: $
;    LOADER.ASM 1.1 92/07/23 18:07:09 AWIGHTMA
;    
;    LOADER.ASM 1.1 92/07/17 16:18:56 CLUSBYTA
;    
;
;    ENDLOG
include	equates.inc		; contains equates, definitions and externals

; Public entry points.
		public	overlay_loader
		public	print_driver_info
		public	reset_and_exit
		public	terminate
		
; extrnal entry points.
		extrn	build_assign_table:near
		extrn	check_resident:near
		extrn	find_app:near
		extrn	find_drivers:near
if GEM
		extrn	gem_directory:near
endif
		extrn	loader_code_start:near

		extrn	check_and_load:near
		extrn	clear_ws_table_entry:near
		extrn	gdos_entry:near
		extrn	parse_command_line:near
		extrn	set_gdos_directory:near


;************************************************************************
;* overlay_loader							*
;*	The non-overlayable part of the GDOS loader starts here.	*
;************************************************************************
overlay_loader:

; Shrink the size of the program.  The parameters for the PC DOS setblock
; function (es, bx) were set at the end of the overlayable portion of code.
		clc
		mov	ah, SETBLOCK
		mov	es, psp_base
		int	PCDOS
		jnc	move_assign_table	; no carry -> no error occured
		cmp	ax, 7			; corrupt memory table?
		jne	insuff_mem
		mov	dx, offset no_table
		jmp	reset_and_exit		; print error and exit
insuff_mem:
		cmp	ax, 8			; insufficient memory?
		jne	bad_block
		mov	dx, offset no_mem
		jmp	reset_and_exit		; print error and exit
bad_block:
		mov	dx, offset invalid_addr
		jmp	reset_and_exit		; printer error and exit

; Move the assignment table to the address calculated for it.
move_assign_table:
if not GEM
	AESAPPSIZE	equ	5B00h	;6107h
; For a graceful failure when out of memory on VIEWMAX
		mov	bx,0FFFFh
		mov	ah,ALLOCATE	; Find out remaining TPA
               int 	PCDOS
               cmp	bx,AESAPPSIZE	; Size of AES + special app 
		jae	ok_mem
		mov	dx, offset no_mem
		jmp	reset_and_exit
ok_mem:
endif
		mov	ds, assign_seg		; ds:si -> assignment table
		xor	si, si
		mov	es, overlay_segment
		xor	di, di			; es:di -> new assigntable
		mov	cx, assign_table_length	; cx = count of bytes
	rep	movsb
		mov	assign_seg, es		; es = new table segment

; Load resident drivers.
		mov	si, es
		mov	ds, si
		xor	si, si			; ds:si -> first driver
look_next_driver:
		cmp	word ptr ASS_WORK_ID[si], 0	; done?
		je	exec_app
		cmp	byte ptr ASS_RES_ID[si], 0	; driver resident?
		je	next_driver		; look at next driver
		mov	bx, ds:[si]		; bx = driver ID
		mov	work_identifier, bx	; save driver ID
		push	ds
		push	si
		call	check_and_load		; load the driver
		pop	si
		pop	ds
		cmp	load_successful, 1
		je	update_table
		mov	dx, offset bad_driver
		jmp	reset_and_exit

; Find an empty spot in the workstation table.
update_table:
		mov	di, cs
		mov	es, di
		mov	di, offset ws_id	; es:di = workstation id table
		mov	cx, WS_ENTRIES		; cx = workstation table size
		xor	ax, ax			; ax = null item
	repne	scasw				; scan for an empty spot
		jz	found_empty_entry
		mov	dx, offset work_table_full
		jmp	reset_and_exit		; dump nastygram and abort

; Update the workstation table.
found_empty_entry:
		sub	di, offset ws_id + 2	; di = workstation table index
		mov	ax, work_identifier
		mov	ws_id[di], ax		; store workstation identifier
		mov	ax, driver_off
		mov	ws_coff[di], ax		; store driver code offset
		mov	ax, driver_seg
		mov	ws_cseg[di], ax		; store driver code segment
		mov	ax, driver_head
		mov	ws_chead[di], ax	; store driver header segment
		mov	ax, driver_size
		mov	ws_size[di], ax		; store driver size
		mov	ws_flags[di], WS_RES	; indicate resident driver
		call	print_driver_info
next_driver:
		add	si, ASS_LENGTH		; point to next driver entry
		jmp short look_next_driver

; Prepare to EXEC the requested application.  Patch interrupts.
exec_app:
		mov	ah,GET_VEC		; Get int EF current value
		mov	al,0efh
		int	PCDOS
		push	bx			; Save on stack
		push	es
		push	ds
		mov	ah,SET_VEC		; Set int EF to gdos_entry
		mov	al,0efh
		mov	dx,seg gdos_entry
		mov	ds,dx
		mov	dx,offset gdos_entry
		int	PCDOS
		pop	ds

; Set the drive and directory.
		mov	dl, gdos_drive
		mov	ah, SET_DRIVE
		int	PCDOS
		push	cs
		pop	ds
if GEM
		mov	dx, offset gdos_path	; set gdos path first
		mov	ah, SET_DIR		;  since app_path may be
		int	PCDOS			;  relative (..\gemboot)
endif
		mov	dx, offset app_path
		mov	ah, SET_DIR
		int	PCDOS

; Set up the parameter block for the exec call.  Restore the PSP command tail
; size, which was probably wiped out as part of the first PSP FCB.
		mov	ax, psp_base
		mov	pblock + 6, 5ch		; first FCB offset
		mov	pblock + 8, ax		; first FCB segment
		mov	pblock + 10, 6ch	; second FCB offset
		mov	pblock + 12, ax		; second FCB segment
		mov	es, ax
		mov	al, save_tail_len
	assume ds:PSP_SEG
		mov	es:CMD_TAIL, al		; PSP command tail length
	assume ds:DATA
; Save the environment.
		mov	ss_save, ss
		mov	sp_save, sp

; Load and execute the application.
		mov	dx, offset app_name	; ds:dx -> app file name
		mov	bx, ds
		mov	es, bx
		mov	bx, offset pblock	; es:bx -> parameter block
		mov	ah, EXEC		; load and execute function
		xor	al, al			; load and execute sub-func
		int	PCDOS

; Restore the environment.
		cli
		mov	sp, sp_save
		mov	ss, ss_save
		sti
		pop	ax			; Restore old int EF
		pop	dx
		push	ds
		mov	ds,ax
		mov	ah,SET_VEC		; Set int EF to gdos_entry
		mov	al,0efh
		pushf
		int	PCDOS
		popf
		pop	ds

; Check for an EXEC error.  If one occurred, process it.
		jnc	check_step_aside
		mov	dx, offset aside_error
		push	cs
		pop	ds
		mov	ah, PRINT_STRING
		int	PCDOS
		mov	dx, offset any_key
		int	PCDOS
		mov	ah, INPUT_CHARACTER
		int	PCDOS
		jmp	exec_app

; Has a full step-aside been requested?  If so, process it.  If not,
; that's all!
check_step_aside:
		cmp	step_aside, 0		; step-aside requested?
		jz	terminate		; no:  terminate

; Save the environment.
		mov	ss_save, ss
		mov	sp_save, sp

; Load and execute the application.
		mov	bx, cs
		mov	ds, bx
		mov	dx, offset aside_file	; ds:dx = app file name
		mov	es, bx
		mov	bx, offset aside_block	; es:bx = parameter block
		mov	ah, EXEC		; load and execute function
		xor	al, al			; load and execute sub-func
		int	PCDOS

; Restore the environment and zero out the step-aside flag.
		cli
		mov	sp, sp_save
		mov	ss, ss_save
		sti
		mov	step_aside, 0
		jmp	exec_app

; Error exit.  Output a couple of error messages.
reset_and_exit:
		push	cs
		pop	ds
		mov	ah, PRINT_STRING
		int 	PCDOS
		mov	dx, offset not_installed_msg
		mov	ah, PRINT_STRING
		int 	PCDOS

; Reset the directory and exit.
terminate:
		mov	dl, root_drive
		mov	ah, SET_DRIVE
		int	PCDOS
		
		mov	dx, seg root_path
		mov	ds, dx
		mov	dx, offset root_path
		mov	ah, SET_DIR
		int	PCDOS

		xor	al, al
		mov	ah, EXIT_PROGRAM
		int	PCDOS


;************************************************************************
;* print_driver_info							*
;************************************************************************
print_driver_info:
; Save registers.  Save workstation table index.
		push	ds
		push	si
		mov	bx, di			; bx = workstation table index
		mov	di, cs
		mov	es, di

; Convert the location information into the location info sub-string.  The
; conversion will be performed from right to left.
prep_hex_out:
		std
		push	bx			; save index
		mov	bx, ws_cseg[bx]		; bx = segment of code
		mov	ch, 4			; number of digits
		mov	cl, ch			; bits to shift
		mov	di, offset location_info + 3

next_hex_digit:
		mov	ax, bx
		and	al, 0fh			; mask four bits (hex digit)
		cmp	al, 9
		jle	zero_to_nine
		add	al, 'A' - 10		; convert to alpha character
		jmp short move_next_hex

zero_to_nine:
		add	al, '0'			; convert to numeric character

move_next_hex:
		stosb
		shr	bx, cl			; shift to next hex digit
		dec	ch
		jnz	next_hex_digit		; do four bytes

		pop	bx			; restore index
		mov	bx, ws_coff[bx]		; bx = offset of code
		mov	ch, 4			; number of digits
		mov	cl, ch			; bits to shift
		mov	di, offset location_info + 8 ; SSSS:OOOO

next_hex_digit2:
		mov	ax, bx
		and	al, 0fh			; mask four bits (hex digit)
		cmp	al, 9
		jle	zero_to_nine2
		add	al, 'A' - 10		; convert to alpha character
		jmp short move_next_hex2

zero_to_nine2:
		add	al, '0'			; convert to numeric character

move_next_hex2:
		stosb
		shr	bx, cl			; shift to next hex digit
		dec	ch
		jnz	next_hex_digit2		; do four bytes

; Output the message.
		mov	dx, offset resident_driver
		mov	ax, cs
		mov	ds, ax			; ds:dx = pointer to message
		mov	ah, PRINT_STRING
		int	PCDOS

; Restore.
		pop	si
		pop	ds
		cld
		ret

CODE	ends
		end
