#!/bin/sh
#
# File:		PLUSproduct-info.sh
#
# Product:	Tivoli Module
# Description:	Shell Script
# Author:		Module Generator
#
# Generated:	
#
# (C) COPYRIGHT Tivoli Systems, Inc., 1997
# All Rights Reserved
# Licensed Material - Property of Tivoli Systems, Inc.
#
MODULE_VERSION=3.0; export MODULE_VERSION

#
#	IM2
#
SHORT_Prodname=Im2
SHORT_prodname=im2
SHORT_PRODNAME=IM2
REAL_PRODNAME="IM2"
PATCH_ID=IM

#
#	Product Version Information
#
VERSION_MAJOR=4
VERSION_MINOR=1
VERSION_REV=0
SHORT_VERSION="$VERSION_MAJOR.$VERSION_MINOR"
LONG_VERSION="Revision $SHORT_VERSION"

#
#	Product Naming Information
#
MEDIUM_PRODNAME="HP Insight Integration for Tivoli"
LONG_PRODNAME="$MEDIUM_PRODNAME, $LONG_VERSION"

#
#	Product Manufacturer, serial number, etc.
#
APP_MANUFACTURER="HPQ"
APP_LANGID=""
APP_BUILDID="$SHORT_PRODNAME""PLUS"
APP_PARTNO="part number"
APP_SERIALNO="serial number"
APP_DESCRIPTION=""

#
#	Directory Information
#
PLUSDIR=$INST_DIR/generic_unix/TME/PLUS
LINKDIR=$PLUSDIR/LINK
PRODDIR=$PLUSDIR/$SHORT_PRODNAME
ICONDSL=IM2_icon.d

#
#	Icon Bitmaps
#
#STDBITMAP="$PRODDIR/Standard.xpm"
PLUSBITMAP="$PRODDIR/StandardPlus.xpm"

# replaced above line with following two lines, per Gutierrez's reply
# on dev forum no. 673.1
PLUSBITMAP="$PRODDIR/StandardPlus.xpm"
STDBITMAP="$PRODDIR/Standard.xpm"

#
#	Subscription List Info
#
SUBLIST_PMS=""

#
#	Task Libraries
#
TASKLIB_3_VMAJOR="4"
TASKLIB_3_VMINOR="1"
TASKLIB_2_VMAJOR="4"
TASKLIB_1_VREV="0"
TASKLIB_2_VMINOR="1"
TASKLIB_5_VERSION="4.1.0"
TASKLIB_4_VERSION="4.1.0"
TASKLIB_2_VERSION="4.1.0"
TASKLIB_1_VERSION="4.1.0"
TASKLIB_3_VERSION="4.1.0"
TASKLIB_1_VMAJOR="4"
TASKLIB_1_VMINOR="1"
TASKLIB_2_TLL="HPQ_Insight_SNMP_Adapter_Configuration__V4_1.tll"
TASKLIB_2="Insight SNMP Adapter Configuration"
TASKLIB_4_TLL="HPQ_Insight_Administrative_Tasks__V4_1.tll"
TASKLIB_5_TLL="HPQ_Insight_Hidden_Tasks__V4_1.tll"
TASKLIB_5_VREV="0"
TASKLIB_3_PLATFORM="unknown"
TASKLIB_1_PLATFORM="unknown"
TASKLIB_2_PLATFORM="unknown"
TASKLIB_4_PLATFORM="unknown"
TASKLIB_5_PLATFORM="unknown"
TASKLIB_4="Insight Administrative Tasks"
TASKLIB_4_VREV="0"
TASKLIB_1="Insight Plus Configuration"
TASKLIB_3="Insight TEC Configuration"
TASKLIB_3_VREV="0"
TASKLIB_5_VMAJOR="4"
TASKLIB_1_TLL="HPQ_Insight_Plus_Configuration__V4_1.tll"
TASKLIB_5_VMINOR="1"
TASKLIB_3_TLL="HPQ_Insight_TEC_Configuration__V4_1.tll"
TASKLIB_4_VMAJOR="4"
TASKLIB_5="Insight Hidden Tasks"
TASKLIB_4_VMINOR="1"
TASKLIB_2_VREV="0"
TASKLIBS="TASKLIB_1 TASKLIB_2 TASKLIB_3 TASKLIB_4 TASKLIB_5"

#
#	Application Launch Icon Info
#
LAUNCH_ICONS=""

#
#	Install Options
#
INSTALL_OPTS=""

#
#	Generic Tasks
#
TASK_1_USER=""
TASK_4_ICONDSL="HP_System_Management_Homepage_icon.d"
TASK_1_DIALOG="browser_location_sh.d"
TASK_3="Initiate Inventory Collection"
TASK_3_USER=""
TASK_3_ICONSTATE="STATE_IM2_Initiate_Inventory_Collection_icon.d"
TASK_5_SCRIPT="launch_im7.sh"
TASK_5_ICONSTATE="STATE_IM2_HP_Systems_Insight_Manager_icon.d"
TASK_4_DIALOG="web_agent_sh.d"
TASK_2_JOB="HP Storage Management Appliance Agents"
TASK_1="Set Internet Browser Location"
TASK_5_ICONDSL="HP_Systems_Insight_Manager_icon.d"
TASK_6_DIALOG="launch_iLo_sh.d"
TASK_3_DIALOG="run_collect_sh.d"
TASK_5_JOB="HP Systems Insight Manager"
TASK_6_JOB="HP Remote Server Management"
TASK_1_DEP_1="OS_Version.sh"
TASK_2_DEP_1="OS_Version.sh"
TASK_3_DEP_1="OS_Version.sh"
TASK_4_DEP_1="OS_Version.sh"
TASK_5_DEP_1="OS_Version.sh"
TASK_6_DEP_1="OS_Version.sh"
TASK_2_DIALOG="launch_sans_sh.d"
TASK_1_ICONDSL="Set_Internet_Browser_Location_icon.d"
TASK_2_USER=""
TASK_3_ICONDSL="Initiate_Inventory_Collection_icon.d"
TASK_6_ICONDSL="HP_Remote_Server_Management_icon.d"
TASK_2_ICONSTATE="STATE_IM2_HP_Storage_Management_Appliance_Agents_icon.d"
TASK_4_USER=""
TASK_1_DEP_2="check_tme_server.sh"
TASK_2_DEP_2="check_tme_server.sh"
TASK_3_DEP_2="check_tme_server.sh"
TASK_4_DEP_2="check_tme_server.sh"
TASK_5_DEP_2="check_tme_server.sh"
TASK_6_DEP_2="check_tme_server.sh"
TASK_5_LIBR="$TASKLIB_4"
TASK_4_LIBR="$TASKLIB_4"
TASK_3_LIBR="$TASKLIB_4"
TASK_2_LIBR="$TASKLIB_4"
TASK_1_LIBR="$TASKLIB_4"
TASK_6_LIBR="$TASKLIB_4"
TASK_1_JOB="Set Internet Browser Location"
TASK_6_USER=""
TASK_4_SCRIPT="web_agent.sh"
TASK_6_ICONSTATE="STATE_IM2_HP_Remote_Server_Management_icon.d"
TASK_1_ICONSTATE="STATE_IM2_Set_Internet_Browser_Location_icon.d"
TASK_5_DIALOG="launch_im7_sh.d"
TASK_1_SCRIPT="browser_location.sh"
TASK_2_ICONDSL="HP_Storage_Management_Appliance_Agents_icon.d"
TASK_2="HP Storage Management Appliance Agents"
TASK_5="HP Systems Insight Manager"
TASK_3_JOB="Initiate Inventory Collection"
TASK_3_SCRIPT="run_collect.sh"
TASK_6="HP Remote Server Management"
TASK_6_SCRIPT="launch_iLo.sh"
TASK_5_USER=""
TASK_4="HP System Management Homepage"
TASK_1_TARGETS=""
TASK_2_TARGETS=""
TASK_3_TARGETS=""
TASK_4_TARGETS=""
TASK_5_TARGETS=""
TASK_6_TARGETS=""
TASK_6_DEPS="TASK_6_DEP_1 TASK_6_DEP_2"
TASK_5_DEPS="TASK_5_DEP_1 TASK_5_DEP_2"
TASK_4_DEPS="TASK_4_DEP_1 TASK_4_DEP_2"
TASK_3_DEPS="TASK_3_DEP_1 TASK_3_DEP_2"
TASK_2_DEPS="TASK_2_DEP_1 TASK_2_DEP_2"
TASK_1_DEPS="TASK_1_DEP_1 TASK_1_DEP_2"
TASK_2_SCRIPT="launch_sans.sh"
TASK_4_JOB="HP System Management Homepage"
TASK_4_ICONSTATE="STATE_IM2_HP_System_Management_Homepage_icon.d"
TASKS="TASK_1 TASK_2 TASK_3 TASK_4 TASK_5 TASK_6"

#
#	Dependency Tasks
#


#
#	Sentry Tasks
#


#
#	Plus Configuration Tasks
#
CONFIGTASK_2_DEP_2="OS_Version.sh"
CONFIGTASK_1_DEP_2="OS_Version.sh"
CONFIGTASK_2_JOB="Plus Configuration"
CONFIGTASK_1_DEP_1="check_tme_server.sh"
CONFIGTASK_2_DEP_1="check_tme_server.sh"
CONFIGTASK_2_ICONSTATE="STATE_IM2_Plus_Configuration_icon.d"
CONFIGTASK_1_ICONDSL="About_Insight_Tivoli_Module_icon.d"
CONFIGTASK_1_TARGETS=""
CONFIGTASK_2_TARGETS=""
CONFIGTASK_2_USER=""
CONFIGTASK_1_USER=""
CONFIGTASK_2_ICONDSL="Plus_Configuration_icon.d"
CONFIGTASK_1_SCRIPT="plus_about.sh"
CONFIGTASK_2_DEPS="CONFIGTASK_2_DEP_1 CONFIGTASK_2_DEP_2"
CONFIGTASK_1_DEPS="CONFIGTASK_1_DEP_1 CONFIGTASK_1_DEP_2"
CONFIGTASK_1="About Insight Tivoli Module"
CONFIGTASK_1_JOB="About Insight Tivoli Module"
CONFIGTASK_2="Plus Configuration"
CONFIGTASK_1_ICONSTATE="STATE_IM2_About_Insight_Tivoli_Module_icon.d"
CONFIGTASK_2_LIBR="$TASKLIB_1"
CONFIGTASK_1_LIBR="$TASKLIB_1"
CONFIGTASK_2_SCRIPT="PLUSconfig.sh"
CONFIGTASKS="CONFIGTASK_1 CONFIGTASK_2"

#
#	Hidden Tasks
#
TEC_TT_OPEN_SCRIPT="open_tt.sh"
HIDDENTASK_2_JOB="Verify_Installed"
HIDDENTASK_7="HP Remote Server Management"
HIDDENTASK_4="Run_Job"
HIDDENTASK_7_DEPS="HIDDENTASK_7_DEP_1 HIDDENTASK_7_DEP_2"
HIDDENTASK_7_USER=""
HIDDENTASK_6_USER=""
HIDDENTASK_5_USER=""
HIDDENTASK_4_USER=""
HIDDENTASK_3_USER=""
HIDDENTASK_2_USER=""
HIDDENTASK_1_USER=""
HIDDENTASK_6_SCRIPT="launch_im7.sh"
HIDDENTASK_7_SCRIPT="launch_iLo.sh"
HIDDENTASK_1_DEP_1="check_tec_server.sh"
HIDDENTASK_2_DEP_1="check_tec_server.sh"
HIDDENTASK_3_DEP_1="check_tec_server.sh"
HIDDENTASK_4_DEP_1="check_tec_server.sh"
HIDDENTASK_5_DEP_1="check_tec_server.sh"
HIDDENTASK_6_DEP_1="check_tec_server.sh"
HIDDENTASK_7_DEP_1="check_tec_server.sh"
HIDDENTASK_6_DEPS="HIDDENTASK_6_DEP_1 HIDDENTASK_6_DEP_2"
HIDDENTASK_1_DIALOG="launch_sans_sh.d"
HIDDENTASK_5_DEPS="HIDDENTASK_5_DEP_1 HIDDENTASK_5_DEP_2"
HIDDENTASK_3="Open_Trouble_Ticket"
HIDDENTASK_4_JOB="Run_Job"
HIDDENTASK_4_SCRIPT="cim_exec_job.sh"
HIDDENTASK_1_SCRIPT="launch_sans.sh"
HIDDENTASK_5_DIALOG="web_agent_sh.d"
HIDDENTASK_4_DEPS="HIDDENTASK_4_DEP_1 HIDDENTASK_4_DEP_2"
HIDDENTASK_1_TARGETS=""
HIDDENTASK_2_TARGETS=""
HIDDENTASK_3_TARGETS=""
HIDDENTASK_4_TARGETS=""
HIDDENTASK_5_TARGETS=""
HIDDENTASK_6_TARGETS=""
HIDDENTASK_7_TARGETS=""
HIDDENTASK_2_SCRIPT="verify_installed.sh"
HIDDENTASK_3_DEPS="HIDDENTASK_3_DEP_1 HIDDENTASK_3_DEP_2"
HIDDENTASK_2_DEPS="HIDDENTASK_2_DEP_1 HIDDENTASK_2_DEP_2"
HIDDENTASK_5_JOB="HP System Management Homepage"
HIDDENTASK_1="HP Storage Management Appliance"
HIDDENTASK_5="HP System Management Homepage"
HIDDENTASK_1_DEPS="HIDDENTASK_1_DEP_1 HIDDENTASK_1_DEP_2"
HIDDENTASK_1_JOB="HP Storage Management Appliance"
HIDDENTASK_6_JOB="HP Systems Insight Manager"
HIDDENTASK_5_SCRIPT="web_agent.sh"
HIDDENTASK_1_DEP_2="OS_Version.sh"
HIDDENTASK_2_DEP_2="OS_Version.sh"
HIDDENTASK_3_DEP_2="OS_Version.sh"
HIDDENTASK_4_DEP_2="OS_Version.sh"
HIDDENTASK_5_DEP_2="OS_Version.sh"
HIDDENTASK_6_DEP_2="OS_Version.sh"
HIDDENTASK_7_DEP_2="OS_Version.sh"
HIDDENTASK_6="HP Systems Insight Manager"
HIDDENTASK_3_SCRIPT="open_tt.sh"
HIDDENTASK_2="Verify_Installed"
HIDDENTASK_7_JOB="HP Remote Server Management"
HIDDENTASK_7_DIALOG="launch_iLo_sh.d"
HIDDENTASK_6_DIALOG="launch_im7_sh.d"
HIDDENTASK_3_JOB="Open_Trouble_Ticket"
HIDDENTASK_1_LIBR="$TASKLIB_5"
HIDDENTASK_2_LIBR="$TASKLIB_5"
HIDDENTASK_3_LIBR="$TASKLIB_5"
HIDDENTASK_4_LIBR="$TASKLIB_5"
HIDDENTASK_5_LIBR="$TASKLIB_5"
HIDDENTASK_6_LIBR="$TASKLIB_5"
HIDDENTASK_7_LIBR="$TASKLIB_5"
HIDDENTASKS="HIDDENTASK_1 HIDDENTASK_2 HIDDENTASK_3 HIDDENTASK_4 HIDDENTASK_5 HIDDENTASK_6 HIDDENTASK_7"

#
#	Logfile Adapter Configuration Tasks
#
LOGTASK_1_SCRIPT="config_snmp.sh"
LOGTASK_1_JOB="Configure SNMP Adapter"
LOGTASK_1_LIBR="$TASKLIB_2"
LOGTASK_1_TARGETS=""
LOGTASK_1_DEPS="LOGTASK_1_DEP_1 LOGTASK_1_DEP_2"
LOGTASK_1="Configure SNMP Adapter"
LOGTASK_1_USER=""
LOGTASK_1_DIALOG="config_snmp_sh.d"
LOGTASK_1_DEP_1="check_tme_server.sh"
LOGTASK_1_ICONDSL="Configure_SNMP_Adapter_icon.d"
LOGTASK_1_ICONSTATE="STATE_IM2_Configure_SNMP_Adapter_icon.d"
LOGTASK_1_DEP_2="_INI_File_Entry.sh"
LOGTASKS="LOGTASK_1"

#
#	TEC Configuration Tasks
#
TECTASK_1_DIALOG="config_tec_sh.d"
TECTASK_1_LIBR="$TASKLIB_3"
TECTASK_1_JOB="Setup TEC Event Server"
TECTASK_1_USER=""
TECTASK_1_DEPS="TECTASK_1_DEP_1 TECTASK_1_DEP_2"
TECTASK_1_DEP_1="OS_Version.sh"
TECTASK_1_DEP_2="check_tec_server.sh"
TECTASK_1="Setup TEC Event Server"
TECTASK_1_ICONSTATE="STATE_IM2_Setup_TEC_Event_Server_icon.d"
TECTASK_1_TARGETS=""
TECTASK_1_SCRIPT="config_tec.sh"
TECTASK_1_ICONDSL="Setup_TEC_Event_Server_icon.d"
TECTASKS="TECTASK_1"

#
#	Baroc files
#
TEC_BAROC_FILE_2="$PRODDIR/ins_evt.baroc"
TEC_BAROC_FILE_1="$PRODDIR/tecad_snmp.baroc"
TEC_BAROC_FILES="TEC_BAROC_FILE_1 TEC_BAROC_FILE_2"

#
#	FMT files
#
TEC_FMT_FILES=""

#
#	Rules files
#
TEC_RULE_FILE_1="$PRODDIR/ins_evt.rls"
TEC_RULE_FILE_2="$PRODDIR/ins_start.rls"
TEC_RULE_FILES="TEC_RULE_FILE_1 TEC_RULE_FILE_2"

#
#	File package configuration tasks
#


#
#	File Package Info
#
FILEPACKS=""

#
#	Indicator Collection Info
#
INDCOLLS=""

#
#	Sentry PMs
#
SENTRY_PMS=""

#
#	Monitors
#
MONITORS=""
