#!/bin/sh
#
# File:         config_tec.sh
#
# Product:      Tivoli Module
# Description:  Shell Script
# Author:               Module Generator
#
# Generated:   
#
# (C) COPYRIGHT Tivoli Systems, Inc., 1997
# All Rights Reserved
# Licensed Material - Property of Tivoli Systems, Inc.
#

#-----------------------------------
# custom variables needed throughout this script
#
SCRIPTNAME=config_tec
PLUS_PROD_DIR=IM2
PlusName=CPQ

if [ "`uname`" = "SunOS" -o "`uname`" = "HP-UX" ] ; then
OSType=UNIX
unset CHILD_OF_OSERV
fi

#-----------------------------------
insight_verify_rule_base()
{
	if [ -z "$Rulebase" ]
	then
		errmsg "A rulebase must be defined!"
		backout
	fi
	if wrb -lsrb | grep "^${Rulebase}$"			>/dev/null 2>&1
	then
		CreateNewRulebase=false
	else
		CreateNewRulebase=true
	fi
}

#-----------------------------------

insight_verify_clone_rule_base()
{
	if [ -z "$CloneRulebase" ]
	then
		errmsg "Clone rulebase must be defined!"
		backout
	fi
	if wrb -lsrb | grep "^${CloneRulebase}$"			>/dev/null 2>&1
	then
		debugmsg "$CloneRulebase exists."
	else
		errmsg "$CloneRulebase rulebase must already exist!"
		backout
	fi
}

#-----------------------------------

insight_verify_clone_dir_path()
{
	if [ ! -d "$RulebasePath" ]
	then
		if mkdir.sh $RulebasePath
		then
			debugmsg "Created $RulebasePath"
		else
			errmsg "Cannot create new rulebase path."
			backout
		fi
	fi
}

#-----------------------------------

insight_clean_rbfiles()
{
RulebaseClassPath=$RulebasePath/TEC_CLASSES
# RulebaseRulePath=$RulebasePath/TEC_RULES

for crfile in $cRuleFiles; do
	strip_crfile=`echo $crfile | awk -F/ '{print $NF}'`
	eval strip_crfile='"$'$crfile'"'
      echo $strip_crfile
      if wlsrbrules $Rulebase $strip_crfile    >/dev/null 2>&1
	then
		wdelrbrules ${strip_crfile} $Rulebase  >/dev/null 2>&1
		echo "Deleted $RulesFile from $Rulebase rulebase."
	fi
done

for ccfile in $cClassFiles; do
	strip_ccfile=`echo $ccfile | awk -F/ '{print $NF}'`
      eval strip_ccfile='"$'$ccfile'"'
	cpqcfile_full=${RulebaseClassPath}/${strip_ccfile}  
      if [ -f "$cpqcfile_full" ]; then 
		echo "Deleted $cpqcfile_full from $Rulebase rulebase."
		wdelrbclass ${strip_ccfile} $Rulebase > /dev/null 2>&1
	fi
done

if wlsrbclass "$Rulebase" | grep "COMPAQ_Trap"; then
		errmsg Failed to cleanup rb files in $Rulebase rulebase.
		backout
	fi
}

#-----------------------------------

insight_clean_insrbfiles()
{
RulebaseClassPath=$RulebasePath/TEC_CLASSES
RulebaseRulePath=$RulebasePath/TEC_RULES

for insrfile in $insRuleFiles; do
	strip_insrfile=`echo $insrfile | awk -F/ '{print $NF}'`
	eval strip_insrfile='"$'$insrfile'"'
      echo $strip_insrfile
     if wrb -lsrbrule $strip_insrfile $Rulebase    >/dev/null 2>&1
	then
		wdelrbrules ${strip_insrfile} $Rulebase  >/dev/null 2>&1
		echo "Deleted $RulesFile from $Rulebase rulebase."
      fi
      #cpqrfile_full=${RulebaseRulePath}/${strip_insrfile}  
      #if [ -f "$cpqrfile_full" ]; then 
	#	echo "Deleting ${strip_insrfile} rule from $Rulebase rulebase."
	#	rm -f ${cpqrfile_full} > /dev/null 2>&1
	# fi

done

for inscfile in $insClassFiles; do
	strip_inscfile=`echo $inscfile | awk -F/ '{print $NF}'`
      eval strip_inscfile='"$'$inscfile'"'
	cpqcfile_full=${RulebaseClassPath}/${strip_inscfile}  
      if [ -f "$cpqcfile_full" ]; then 
		echo "Deleted $cpqcfile_full from $Rulebase rulebase."
		wrb -delrbclass ${strip_inscfile} $Rulebase > /dev/null 2>&1
	fi
done

# if wlsrbclass "$Rulebase" | grep "COMPAQ_Trap"; then
# 		errmsg Failed to cleanup rb files in $Rulebase rulebase.
# 		backout
# fi
}

#-----------------------------------

ins_clean_rbffiles()
{
RulebaseFactPath=$RulebasePath/TEC_TEMPLATES

for insffile in $insFactFiles; do
      strip_insffile=`echo $insffile | awk -F/ '{print $NF}'`
      eval strip_insffile='"$'$insffile'"'
	insffile_full=${RulebaseFactPath}/${strip_insffile}  
      if [ -f "$insffile_full" ]; then 
		echo "Deleted $insffile_full from $Rulebase rulebase."
		rm -f ${insffile_full} > /dev/null 2>&1
	fi
done

for inswfile in $insWicFiles; do
      strip_inswfile=`echo $inswfile | awk -F/ '{print $NF}'`
      eval strip_inswfile='"$'$inswfile'"'
	inswfile_full=${RulebaseFactPath}/${strip_inswfile}  
      if [ -f "$inswfile_full" ]; then 
		echo "Deleted $inswfile_full from $Rulebase rulebase."
		rm -f ${inswfile_full} > /dev/null 2>&1
	fi
done

}

#-----------------------------------

insight_import_ffiles()
{

RulebaseFactPath=$RulebasePath/TEC_TEMPLATES

for insffile in $insFactFiles; do
	# strip_insffile=`echo $insffile | awk -F/ '{print $NF}'`
      eval strip_insffile='"$'$insffile'"'
	#for insf_path in $ClassPathSearchOrder; do
		insffile_full=$PRODDIR/${strip_insffile}
            if [ -f "$insffile_full" ]; then 
            	cp $insffile_full $RulebaseFactPath
			debugmsg "copied $strip_insffile into $Rulebase"
		else
			debugmsg "Can not locate IM $strip_insffile Fact file."
		fi
      #done
done
}

#-----------------------------------

insight_compile_rule_base()
{
	RB=$1
	if [ -d "$DEBUGDIR" -o -f "$DEBUGDIR" ]; then
		COMPILE_FLAGS="-trace"
	fi

if [ $OSType = "UNIX" ] ; then
unset CHILD_OF_OSERV
fi

	debugmsg "Compiling $RB rulebase..."
	wrb -comprules $COMPILE_FLAGS $RB >$err_output 2>&1 &&  rm -f $err_output
}

#-----------------------------------

insight_verify_current_rule_base_compiles()
{
	if insight_compile_rule_base $VerificationRB
	then
		debugmsg "Pre-existing $VerificationRB rulebase compiles successfully."
	else
		errmsg	"Pre-existing $VerificationRB rulebase does not compile!
"			"	Please correct before continuing installation:
"
		[ -f $err_output ] && cat $err_output >&2 && rm -f $err_output
		backout
	fi
}

#-----------------------------------

insight_create_new_rule_base()
{
	if error=`wrb -crtrb -path $RulebasePath $Rulebase 2>&1`
	then
		debugmsg "Created $Rulebase rulebase."
            chmod -R 777 $RulebasePath 
		add_to_backout_list RuleBase
	else
		if echo $error | grep "mkdir.*13" >/dev/null 2>&1; then
			error=":  no permission to create \"$RulebasePath\" directory."
		elif [ -n "$error" ]; then
			error=":  $error"
		else
			error=.
		fi
		errmsg "Failed to create $Rulebase rulebase$error"
		backout
	fi
}

#-----------------------------------

insight_clone_rule_base()
{
	if wrb -cprb $CloneRulebase $Rulebase
	then
		debugmsg "Copied $CloneRulebase rulebase to $Rulebase."
	else
		errmsg "Failed to copy $CloneRulebase rulebase to $Rulebase."
		backout
	fi
}

#-----------------------------------

insight_verify_new_rule_base_compiles()
{
	if insight_compile_rule_base $Rulebase
	then
		debugmsg "New $Rulebase rulebase compiles successfully."
	else
		errmsg "New $Rulebase rulebase does not compile:
"
		[ -f $err_output ] && cat $err_output >&2 && rm -f $err_output
		backout
	fi
}

#-----------------------------------

insight_import_new_classes()
{
if [ $OSType = "UNIX" ] ; then
unset CHILD_OF_OSERV
fi

RulebaseClassPath=$RulebasePath/TEC_CLASSES

	for inscfile in $ClassFiles
	do
		strip_inscfile=`echo $inscfile | awk -F/ '{print $NF}'`
		#for insc_path in $ClassPathSearchOrder; do
			inscfile_full=$PRODDIR/${strip_inscfile}
			wimprbclass_cmd="wrb -imprbclass"

			#  make sure tecad_snmp.baroc exist
			#
                       
			if  [ ${strip_inscfile} = "tecad_snmp.baroc" ]; then 
                        tecadcfile_full=${RulebaseClassPath}/"tecad_snmp.baroc"
			      if [ -f "$tecadcfile_full" ]; then
				# if wlsrbclass $Rulebase | grep "SNMP_Trap" >/dev/null 2>&1; then
      				debugmsg tecad_snmp.baroc already exists in $Rulebase rulebase.
				else
					if wrb -imprbclass $inscfile -after "tec.baroc" $Rulebase >/dev/null 2>&1
					then
						debugmsg Imported $strip_inscfile to $Rulebase rulebase.
					fi	
				fi
			else
				debugmsg "trying to import $inscfile_full into $Rulebase"
				if $wimprbclass_cmd $inscfile_full $Rulebase	>/dev/null 2>&1
				then
					debugmsg Imported $inscfile_full to $Rulebase rulebase.
				else
					debugmsg Failed to import $inscfile_full to $Rulebase rulebase.
					backout
				fi
			fi
             #done
	done
}

#-----------------------------------

insight_import_new_rules()
{
	for insrfile in $RulesFiles
	do
		RulesFile=`echo $insrfile | awk -F/ '{print $NF}'`
		if wrb -lsrbrule $RulesFile $Rulebase		>/dev/null 2>&1
		then
			wdelrbrules $RulesFile $Rulebase
			debugmsg  deleted $RulesFile in $Rulebase rulebase.
		fi
		if wrb -imprbrule $insrfile $Rulebase
		then
			debugmsg Imported $RulesFile to $Rulebase rulebase.
			add_to_backout_list $RulesFile $RulesFile
		else
			errmsg Failed to import $insrfile to $Rulebase rulebase.
			backout
		fi
	done
}

#-----------------------------------

insight_load_new_rules()
{
	if wrb -loadrb -use $Rulebase
	then
		debugmsg "Loaded $Rulebase rulebase."
	else
		errmsg "Failed to load $Rulebase into EventServer"
		backout
	fi
}

#-----------------------------------
#
#	cpq Baroc files
#
cClassFile_2="cim_plus.baroc"
cClassFile_6="activity_monitors.baroc"
cClassFile_4="drive_monitors.baroc"
cClassFile_5="processor_monitors.baroc"
cClassFile_1="cim_events.baroc"
cClassFile_3="cim_events16A.baroc"
cClassFiles="cClassFile_1 cClassFile_2 cClassFile_3 cClassFile_4 cClassFile_5 cClassFile_6"

#
#     cpq Rules files
#

cRuleFile_21="cpqtiv_storage3.rls"
cRuleFile_25="cpqtiv_ide.rls"
cRuleFile_2="cpqtiv_storageworks.rls"
cRuleFile_12="cpqtiv_memory.rls"
cRuleFile_31="cpqtiv_array1.rls"
cRuleFile_4="cpqtiv_thermal3.rls"
cRuleFile_11="cpqtiv_ups.rls"
cRuleFile_38="cpqtiv_ide16A.rls"
cRuleFile_15="cpqtiv_cause3.rls"
cRuleFile_26="cpqtiv_storage2.rls"
cRuleFile_20="cpqtiv_storage1.rls"
cRuleFile_7="cim_events.rls"
cRuleFile_14="cpqtiv_hotplug.rls"
cRuleFile_40="cpqtiv_stsys16A.rls"
cRuleFile_9="cpqtiv_power3.rls"
cRuleFile_34="cpqtiv_scsi.rls"
cRuleFile_33="cpqtiv_array4.rls"
cRuleFile_19="cpqtiv_array3.rls"
cRuleFile_6="cpqtiv_cause2.rls"
cRuleFile_17="cpqtiv_tape2.rls"
cRuleFile_30="cpqtiv_power2.rls"
cRuleFile_36="cpqtiv_power4.rls"
cRuleFile_29="cpqtiv_power1.rls"
cRuleFile_1="cpqtiv_array2.rls"
cRuleFile_37="cpqtiv_hlth16A.rls"
cRuleFile_3="cpqtiv_tape1.rls"
cRuleFile_16="cpqtiv_alarm1.rls"
cRuleFile_27="cpqtiv_montrap.rls"
cRuleFile_24="cpqtiv_thermal4.rls"
cRuleFile_23="cpqtiv_tape3.rls"
cRuleFile_13="cpqtiv_cause1.rls"
cRuleFile_39="cpqtiv_steam16A.rls"
cRuleFile_5="cim_monitors.rls"
cRuleFile_8="cpqtiv_alarm2.rls"
cRuleFile_32="cpqtiv_nic2.rls"
cRuleFile_35="cpqtiv_nic1.rls"
cRuleFile_18="cpqtiv_thermal1.rls"
cRuleFile_28="cpqtiv_thermal2.rls"
cRuleFile_22="cpqtiv_gideon.rls"
cRuleFile_10="cim_actions.rls"
cRuleFiles="cRuleFile_1 cRuleFile_2 cRuleFile_3 cRuleFile_4 cRuleFile_5 cRuleFile_6 cRuleFile_7 cRuleFile_8 cRuleFile_9 cRuleFile_10 cRuleFile_11 cRuleFile_12 cRuleFile_13 cRuleFile_14 cRuleFile_15 cRuleFile_16 cRuleFile_17 cRuleFile_18 cRuleFile_19 cRuleFile_20 cRuleFile_21 cRuleFile_22 cRuleFile_23 cRuleFile_24 cRuleFile_25 cRuleFile_26 cRuleFile_27 cRuleFile_28 cRuleFile_29 cRuleFile_30 cRuleFile_31 cRuleFile_32 cRuleFile_33 cRuleFile_34 cRuleFile_35 cRuleFile_36 cRuleFile_37 cRuleFile_38 cRuleFile_39 cRuleFile_40"

#
#  IM Fact Files
#  
insFactFile_2="ins_correl"
insFactFile_1="user_predicates"
insFactFiles="insFactFile_1 insFactFile_2"

#
#  IM wic Files
#  
insWicFile_2="ins_correl.wic"
insWicFile_1="user_predicates.wic"
insWicFiles="insWicFile_1 insWicFile_2"

#
#  IM Class Files
#  
insClassFile_1="ins_evt.baroc"
insClassFiles="insClassFile_1"

#
#  IM Rule Files
#  
insRuleFile_1="ins_evt.rls"
insRuleFiles="insRuleFile_1"

##############################
###
#
#   errecho
#
errecho() {
  echo "$*" >&2
}

###
#
# is_lcf_ep
#
is_lcf_ep() {
  if [ "$DEBUG" = true ]; then set -x; fi
  if [ -z "$ENDPOINT_OID" ]; then
    return 1
  elif echo $ENDPOINT_OID | awk -F\# '{print $1}' | grep "+$" > /dev/null; then
    # found a "+" in the oid, must be a TMA endpoint!
    return 0
  else
    return 1
  fi
}

########################################################################

if [ -n "" ]; then
        DEBUG=true
fi
[ "$DEBUG" = true ] && set -x

TASK_PROGPATH=`echo $0 | sed -e 's.\\\\./.g'`
THIS_SCRIPT="$SCRIPTNAME.sh"

#
#       Make sure we're running on a Managed Node
#
if is_lcf_ep; then
  errecho "Cannot run $THIS_SCRIPT: endpoint $ENDPOINT_OID is not a ManagedNode"
  exit 1
fi

#
#	The standard directory and the /Plus override script
#
ETC=/etc/Tivoli
SCRIPT=PLUSsetup_env.sh

#
#	If this is NT, then etc is in a different location
#
if [ x\"$OS\" = x\"Windows_NT\" ] ; then
     ETC=$SystemRoot/system32/drivers/etc/Tivoli
fi

#
#	Look for our override script, if not there, then use the
#		standard one.
#
if [ ! -f $ETC/$SCRIPT ]; then
	SCRIPT=setup_env.sh
fi

. $ETC/$SCRIPT


#
#	Set up some popular environment variables.
#
OSERV=`objcall 0.0.0 get_oserv`
export OSERV
INST_DIR=`objcall $OSERV query install_dir`
INST_DIR=`echo $INST_DIR | tr "\\\\\\\\" "/"`
export INST_DIR
REGION=`objcall $OSERV query whoami | awk '{print $1}'`

LIBRARY=`wlookup Library`

#
#	Get the region name to avoid collisions
#
IRO=`wlookup InterRegion`
IRONAME=`idlattr -t -g $IRO name string`
IRONAME=`eval echo $IRONAME`

#DEFSEN=\"TivoliSentryDefaults#$IRONAME\"

MNOID=`objcall 0.0.0 get_host_location`
eval MNNAME=`idlattr -t -g $MNOID label string`
export MNNAME

PLUSDIR=$INST_DIR/generic_unix/TME/PLUS
LINKDIR=$PLUSDIR/LINK
PRODDIR=$PLUSDIR/"$PLUS_PROD_DIR"
PATH=$LINKDIR:$PRODDIR:$PATH
export PATH

cd $PRODDIR

. ./PLUSproduct-info.sh
export WINSTRUCTED
export MODULE_VERSION

#
#	Debugging code: by creating a directory called .plusdebug in
#		the appropriate TEMP directory, the output of scripts is
#		redirected to a file in TEMP by the same name as the script.
#
TEMP=/tmp
if [ x"$OS" = x"Windows_NT" ]; then
	TEMP=$DBDIR/tmp
else
	TEMP=/tmp
fi

DEBUGDIR=$TEMP/.plusdebug
[ -d "$DEBUGDIR" ] \
  && echo "*** Results redirected to $DEBUGDIR/$THIS_SCRIPT" \
  && exec > $DEBUGDIR/$THIS_SCRIPT 2>&1 && set -xv
[ -f "$DEBUGDIR" ] && set -xv
if [ -d "$DEBUGDIR" -o -f "$DEBUGDIR" -o "$DEBUG" = true ]; then
  DEBUG=true
else
  DEBUG=false
fi
export DEBUG

#
#	Messages
#
ERRNORULEBASE="Error: Missing value for argument \"Rule Base Name\""

SOURCE_NAME=PLUSTASKS

###################
# Support Functions
###################

errexit()
{
	echo "$*" >&2
	exit 1
}

. $LINKDIR/PLUScommon-tec-install.sh

echo "*** Executing $THIS_SCRIPT ($TASK_PROGPATH)"

###################
# Process Arguments
###################

#
#	Usage Check
#
ARGLIST="Rule_Base_Name__new_or_existing__ Rule_Base_to_clone__if_new__ Path_for_Rule_Base__if_new__ Name_of_Event_Console_to_configure__optional__"

if [ $# -ne `echo $ARGLIST | wc -w` ]; then
	errexit "Usage: $THIS_SCRIPT $ARGLIST"
fi

RB_NAME=$1
RB_TO_CLONE=$2
RB_PATH=$3
EV_CONSOLE=$4

if [ ! "$RB_NAME" ]; then
	errexit "$ERRNORULEBASE"
fi

#
#  Map arguments to some standard variable names
#
if [ "$RB_TO_CLONE" ]; then
  UseNew=on
  NewRulebase="$RB_NAME"
  CloneRulebase="$RB_TO_CLONE"
else
  UseExisting=on
  ExistingRulebase="$RB_NAME"
fi
RulebasePath="$RB_PATH"
EventConsole="$EV_CONSOLE"


if   [ "$UseNew" = on ]; then
	Rulebase=$NewRulebase
	if wlsrb "^${Rulebase}$" > /dev/null 2>&1 ;then
		errmsg "There is an existing '${Rulebase}' rule base."
		exit 1
	fi
elif [ "$UseExisting" = on ]; then
	Rulebase=$ExistingRulebase
	if wlsrb "^${Rulebase}$" >/dev/null 2>&1 ;then
		debugmsg "Found rule base '${Rulebase}'"
	else
		errmsg "The rule base '${Rulebase}' does not exist." >&2
		exit 1
	fi
else
	errmsg "You must specify either a new or an existing rule base."
	exit 1
fi

# verify_clone_dir_path 
Sources="Source1 Source2"
Source1="$SOURCE_NAME"  Source1Bitmap="JLINK"
Source2="SNMP"       Source2Bitmap="logf48"

Filters="Filter"
Filter2="-c HP_Insight_Trap -s SNMP -u HP_Insight_Manager"

for f in $TEC_RULE_FILES; do
	eval RULE_FILE='"$'$f'"'
	RulesFiles="$RULE_FILE $RulesFiles"
done

 for f in $TEC_BAROC_FILES; do
	eval BAROC_FILE='"$'$f'"'
	ClassFiles="$ClassFiles $BAROC_FILE"
 done

ClassIfPresent="${SHORT_Prodname}Base"
LinkClassPath=$LINKDIR
ProdClassPath=$PRODDIR

### Modify this if desired:
ClassPathSearchOrder="$ProdClassPath $LinkClassPath"

# EventGroup="${SHORT_Prodname}Plus"
EventGroup="HP_Insight_Manager"

TEC=`wlookup -r ProductInfo TEC_SERVER 2>/dev/null`
TEC_REVISION=`idlattr -t -g $TEC revision string 2>/dev/null | sed 's/"//g'`
if ( expr $TEC_REVISION \>= 3.6 >/dev/null ); then
	debugmsg "Use TEC 3.7 wrb command."
	UseNew_wrb=true
else
	debugmsg "Use TEC 3.6.x wrb command."
	UseNew_wrb=false
fi 

if [ "$UseNew_wrb" = false ]; then

verify_rule_base
if $CreateNewRulebase; then
	echo Creating new rulebase $Rulebase
	verify_clone_rule_base
	VerificationRB=$CloneRulebase
else
	echo $Rulebase already exists
	VerificationRB=$Rulebase
fi

	verify_current_rule_base_compiles
	if $CreateNewRulebase; then
		create_new_rule_base
            chmod -R 777 $RulebasePath 
		clone_rule_base
		verify_new_rule_base_compiles
	fi

	insight_clean_rbfiles
	verify_new_rule_base_compiles
	insight_import_ffiles
	import_new_classes
	import_new_rules
	verify_new_rule_base_compiles
	load_new_rules

	if [ "$EV_CONSOLE" ]; then
		verify_event_console
		install_new_event_group
		install_new_event_filters
		assign_event_group_to_console
	fi

      # install_new_event_source for TEC 3.6
     if [ -r $BINDIR/bin/wlseg -o -r $BINDIR/bin/wlseg.exe ]; then
        evgroup=`wlseg | grep "$PRODUCT"`
        if [ "$evgroup" = "" ]; then
           echo "Creating the '$PRODUCT' Event Group ..."
           wcrteg "$PRODUCT"
        else
           echo "The '$PRODUCT' Event Group is already created."
        fi
     fi

else

	verify_rule_base
	if $CreateNewRulebase; then
		echo Creating new rulebase $Rulebase
		verify_clone_rule_base
		VerificationRB=$CloneRulebase
	else
		echo $Rulebase already exists
		VerificationRB=$Rulebase
	fi

	insight_verify_current_rule_base_compiles
	if $CreateNewRulebase; then
		insight_create_new_rule_base
            chmod -R 777 $RulebasePath 
		insight_clone_rule_base
		insight_verify_new_rule_base_compiles
	fi
      
	ins_clean_rbffiles
      insight_clean_insrbfiles
	insight_verify_new_rule_base_compiles
	insight_import_ffiles
	insight_import_new_classes
	insight_import_new_rules
     	wrb -imptgtrule ins_evt EventServer $Rulebase
	insight_verify_new_rule_base_compiles
	insight_load_new_rules
fi

install_trouble_ticket_script

restart_event_server