#!/bin/sh 

#  This simple Bourne shell script creates a query library
#  containing the  HP Inventory queries. It must be run by 
#  an administrator with proper TME authorization in the 
#  appropriately configured TMR where the library must reside. 
#  The following queries are created within the specified 
#  query library (default is HP_QUERIES):
#			HP Inventory
#			HP ROM Information
#			HP Software Versions
# 
#  ./hptiv_queries.sh <PolicyRegionName> [QueryLibraryName]
#

if [ $# -lt 1 ] ; then
        echo "Usage: $0 <PolicyRegionName> [QueryLibraryName]"
        exit 1
fi

if [ $# -eq 2 ] ; then
	query_lib="$2"
else
	query_lib='HP_QUERIES'
fi

echo "Creating query library $query_lib in $1..." 
wcrtqlib "$1" "$query_lib"

echo "Creating query HP INVENTORY in $query_lib..." 
wcrtquery -d "Basic HP Inventory " -r invdh_1 -v HPINVDATA \
          -c TME_OBJECT_LABEL \
	    -c TME_OBJECT_ID \
	    -c COMPUTER_SYS_ID \
          -c COMPUTER_SCANTIME \
	  -c IP_ADDR \
	  -c IP_HOSTNAME \
	  -c OS_NAME \
	  -c OS_MAJOR_VERS \
	  -c OS_MINOR_VERS \
          -c CPU_TYPE \
          -c CPU_SPEED \
          -c SYSTEM_NAME \
          -c SYSTEM_ROM_REV \
          -c FLASH_ROM \
          -c ROM_FAMILY \
          -c SERIAL_NUMBER \
          -c TOTAL_SYS_MEMORY \
          -c ASSET_TAG \
          -c OWNERSHIP_TAG \
          -w "order by TME_OBJECT_LABEL" \
"$query_lib" "HP INVENTORY"

echo "Creating query HP SOFTWARE VERSIONS in $query_lib..." 
wcrtquery -d "HP Software Versions" -r invdh_1 -v HPSWVER \
          -c TME_OBJECT_LABEL \
	    -c TME_OBJECT_ID \
	    -c COMPUTER_SYS_ID \
          -c COMPUTER_SCANTIME \
          -c SYSTEM_NAME \
	    -c SYSTEM_ROM_REV \
          -c FLASH_ROM \
          -c ROM_FAMILY \
          -c NAME \
          -c DESCRIPTION \
          -c VERSION \
	    -c RECORD_TIME \
	  -w "order by TME_OBJECT_LABEL" \
"$query_lib" "HP SOFTWARE VERSIONS"

echo "Creating query HP CPU INFORMATION in $query_lib..." 
wcrtquery -d "HP CPU Information" -r invdh_1 -v HPCPU \
          -c COMPUTER_SYS_ID \
	    -c TME_OBJECT_LABEL \
	  -c TME_OBJECT_ID \
	    -c CPU_TYPE \
          -c CPU_NUMBER \
	    -c CPU_SPEED \
	    -c L2_CACHE \
	    -c L3_CACHE \
          -c RECORD_TIME \
          -w "order by TME_OBJECT_LABEL" \
"$query_lib" "HP CPU INFORMATION"

echo "Creating query HP SLOT INFORMATION in $query_lib..." 
wcrtquery -d "HP Slot Information" -r invdh_1 -v HPSLOTS \
          -c COMPUTER_SYS_ID \
	  -c TME_OBJECT_LABEL \
	  -c TME_OBJECT_ID \
	  -c SLOT_NUMBER \
          -c BOARD_EISA_PCI_ID \
	  -c BOARD_NAME \
    	  -c BOARD_REVISION \
          -c RECORD_TIME \
          -w "order by TME_OBJECT_LABEL" \
"$query_lib" "HP SLOT INFORMATION"

echo "Creating query HP IDE INFORMATION in $query_lib..." 
wcrtquery -d "HP IDE Device Information" -r invdh_1 -v HPIDEDEV \
          -c COMPUTER_SYS_ID \
	  -c TME_OBJECT_LABEL \
	  -c TME_OBJECT_ID \
	  -c CONTROLLER_DRIVE \
  	  -c NAME \
  	  -c FIRMWARE_REV \
   	  -c DISK_SIZE \
   	  -c SERIAL_NUMBER \
  	  -c RECORD_TIME \
	  -w "order by TME_OBJECT_LABEL" \
"$query_lib" "HP IDE INFORMATION"

echo "Creating query HP DRIVE ARRAY INFORMATION in $query_lib..." 
wcrtquery -d "HP Drive Array Information" -r invdh_1 -v HPDRVARRY \
          -c COMPUTER_SYS_ID \
	  -c TME_OBJECT_LABEL \
	  -c TME_OBJECT_ID \
	  -c MODEL \
  	  -c SLOT_PORT_BAY \
  	  -c FIRMWARE_REV \
   	  -c DRIVE_SIZE \
   	  -c HOT_PLUGGABLE \
	  -w "order by TME_OBJECT_LABEL" \
"$query_lib" "HP DRIVE ARRAY INFORMATION"

echo "Creating query HP SCSI INFORMATION in $query_lib..." 
wcrtquery -d "HP SCSI Device Information" -r invdh_1 -v HPSCSI \
          -c COMPUTER_SYS_ID \
	  -c TME_OBJECT_LABEL \
	  -c TME_OBJECT_ID \
	  -c CNTLR_SLOT_SCSI_ID \
  	  -c NAME \
  	  -c FIRMWARE_REV \
   	  -c DISK_SIZE \
   	  -c HOT_PLUGGABLE \
  	  -c RECORD_TIME \
	  -w "order by TME_OBJECT_LABEL" \
"$query_lib" "HP SCSI INFORMATION"

echo "Creating query HP FCA INFORMATION in $query_lib..." 
wcrtquery -d "HP Fibre Channel Array Information" -r invdh_1 -v HPFCA \
          -c COMPUTER_SYS_ID \
	  -c TME_OBJECT_LABEL \
	  -c TME_OBJECT_ID \
  	  -c MODEL \
	  -c STORAGE_BOX_INDEX \
	  -c DRIVE_INDEX \
   	  -c DRIVE_SIZE \
   	  -c FIRMWARE_REV \
  	  -c RECORD_TIME \
	  -w "order by TME_OBJECT_LABEL" \
"$query_lib" "HP FCA INFORMATION"

exit 0
