#!/bin/sh
#
# File:		PLUSInstallAfter_MN.sh
#
# Product:	Tivoli Module
# Description:	Shell Script
# Author:		Module Generator
#
# Generated:	
#
# (C) COPYRIGHT Tivoli Systems, Inc., 1997
# All Rights Reserved
# Licensed Material - Property of Tivoli Systems, Inc.
#

#
#	The standard directory and the /Plus override script
#
ETC=/etc/Tivoli
SCRIPT=PLUSsetup_env.sh


#-----------------------------------------------------------------------
# Move the icons into collections to unclutter the icon view.
# Note, the names of components are hard coded.  If you change them
# in builder, change them here as well.
#
move_an_icon()
{
	if [ $# -ne 2 ]; then
		return
	fi
	
	# Turn off abort if errors occur.
	set +e

	CHECKICON=""
	CHECKICON="`wls TivoliPlus/"$MEDIUM_PRODNAME" | grep -i "$1" 2> /dev/null`"

	if [ ! -z "$CHECKICON" ]; then
		# Icon was present so move it.
		wmv TivoliPlus/"$MEDIUM_PRODNAME"/"$1" TivoliPlus/"$MEDIUM_PRODNAME"/"$2"
		CHECKICON=""
	fi

	# Turn back on abort if errors occur.
	set -e
}


#
#	If this is NT, then etc is in a different location
#
if [ x\"$OS\" = x\"Windows_NT\" ] ; then
     ETC=$SystemRoot/system32/drivers/etc/Tivoli
fi

#
#	Look for our override script, if not there, then use the
#		standard one.
#
if [ ! -f $ETC/$SCRIPT ]; then
	SCRIPT=setup_env.sh
fi

. $ETC/$SCRIPT

#
#	Set up some popular environment variables.
#
OSERV=`objcall 0.0.0 get_oserv`
export OSERV
INST_DIR=`objcall $OSERV query install_dir`
INST_DIR=`echo $INST_DIR | tr "\\\\\\\\" "/"`
export INST_DIR
REGION=`objcall $OSERV query whoami | awk '{print $1}'`
LIBRARY=`wlookup Library`

#
#	Get the region name to avoid collisions
#
IRO=`wlookup InterRegion`
IRONAME=`idlattr -t -g $IRO name string`
IRONAME=`eval echo $IRONAME`

DEFSEN=\"TivoliSentryDefaults#$IRONAME\"
MNOID=`objcall 0.0.0 get_host_location`
eval MNNAME=`idlattr -t -g $MNOID label string`
export MNNAME
PLUSDIR=$INST_DIR/generic_unix/TME/PLUS
LINKDIR=$PLUSDIR/LINK
PRODDIR=$PLUSDIR/IM2
PATH=$LINKDIR:$PRODDIR:$PATH
export PATH

cd $PRODDIR

. ./PLUSproduct-info.sh

#
#	This setting controls the task library creation behavior
#
USE_TLL=true; export USE_TLL

#
#	Use the module-level TaskRoles setting to set up a default ROLE for tasks
#
DEFAULT_TASKROLES=super; export DEFAULT_TASKROLES

#
#	Debugging code: by creating a directory called .plusdebug in
#		the appropriate TEMP directory, the output of scripts is
#		redirected to a file in TEMP by the same name as the script.
#
TEMP=/tmp
if [ x"$OS" = x"Windows_NT" ]; then
	TEMP=$DBDIR/tmp
else
	TEMP=/tmp
fi

DEBUGDIR=$TEMP/.plusdebug

#SCRIPTNAME=`echo $0 | tr "\\\\\\\\" "/"`
#SCRIPTNAME=`basename $SCRIPTNAME`
SCRIPTNAME=PLUSInstallAfter_MN.sh

[ -d "$DEBUGDIR" ] && exec > $DEBUGDIR/$SCRIPTNAME 2>&1 && DEBUG=true && set -xv
[ -f "$DEBUGDIR" ] && DEBUG=true && set -xv

chmod +x $LINKDIR/Link.install $LINKDIR/Link.init $LINKDIR/Link.cfg $LINKDIR/w* $LINKDIR/cfgappicon $LINKDIR/faux* $LINKDIR/*.sh

## do install
. $LINKDIR/PLUSinstall_MN.sh

###########################################################################
#
#  at this point the plus module has been installed.
#  insert any code to run after installation here.
#

CONFIG_TASK_COLL="Insight Administration Tasks"
move_an_icon "Setup TEC Event Server" "$CONFIG_TASK_COLL"


#
# Save the DB_after files if $DEBUGDIR exists
#

set +e
if [ -d "$DEBUGDIR" ]; then
	cp $TEMP/IM_DB_after.* $DEBUGDIR/. 2> /dev/null
fi
set -e

exit 0

