#!/bin/sh
# $Id: $
#
# Component:	TivoliPlus Generic Installation Script.
#
# $Source: $
# $Revision: $
#
# Description:  
#		
#
# Author:	Fran Costanzo
#		Tivoli Systems, Inc.
#
# (C) COPYRIGHT Tivoli Systems, Inc. 1996-2000
# Unpublished Work
# All Rights Reserved
# Licensed Material - Property of Tivoli Systems, Inc.
#

#
#	Setup Tivoli environment variables and call script
#	to set up product specific stuff.
#

#
# make sure this script runs in the C locale, but outmsg funcs will look at USER_LANG
#
SAVE_LANG=$LANG
if [ "$LANG" != C ]; then
  USER_LANG=$LANG; export USER_LANG
  LANG=C; export LANG
fi

#
#	Set up environment (similar to old /etc/Tivoli/setup_env.sh)
#
OSERV=`objcall 0.0.0 get_oserv`; export OSERV
INST_DIR=`objcall $OSERV query install_dir | tr "\\\\\\\\" "/"`; export INST_DIR
INTERP=`objcall $OSERV query interp`; export INTERP
BINDIR=$INST_DIR/$INTERP; export BINDIR
PLUSDIR=$INST_DIR/generic_unix/TME/PLUS
LINKDIR=$PLUSDIR/LINK; export LINKDIR
DBDIR=`objcall $OSERV query db_dir | tr "\\\\\\\\" "/"`; export DBDIR
TEMP=/tmp; export TEMP
if [ x"$OS" = x"Windows_NT" ]; then
	TEMP=$DBDIR/tmp
fi
if [ ! -d $TEMP ]; then
	$LINKDIR/mkdir.sh $TEMP
fi
PATH=$LINKDIR:$PATH; export PATH


#
#	get all the common functions loaded
#
. $LINKDIR/PLUScommon-install.sh

check_apps_installed

if $TEC_INSTALLED; then
	TEC_SENTRY_INFORMATIONAL_CLAUSE="-T HARMLESS EventServer"
	TEC_SENTRY_RESET_CLAUSE="-T HARMLESS EventServer"
	TEC_SENTRY_NORMAL_CLAUSE="-T HARMLESS EventServer"
	TEC_SENTRY_FATAL_CLAUSE="-T FATAL EventServer"
	TEC_SENTRY_CRITICAL_CLAUSE="-T CRITICAL EventServer"
	TEC_SENTRY_SEVERE_CLAUSE="-T MINOR EventServer"
	TEC_SENTRY_MINOR_CLAUSE="-T MINOR EventServer"
	TEC_SENTRY_WARNING_CLAUSE="-T WARNING EventServer"
	TEC_SENTRY_HARMLESS_CLAUSE="-T HARMLESS EventServer"
fi

cd $PRODDIR
. ./PLUSproduct-info.sh

if [ "$WINSTRUCTED" = true ]; then
	log_failure `outmsg LinkInstallCat 117 "Informational script %1\\$s/PLUSproduct-info.sh was produced by winstruct and cannot be used for this install process." "$PRODDIR"`
	exit 1
fi
WINSTRUCTED=false; export WINSTRUCTED

#
#	Debugging code: by creating a directory called .plusdebug in
#		the appropriate TEMP directory, the output of scripts is
#		redirected to a file in TEMP by the same name as the script.
#
DEBUGDIR=$TEMP/.plusdebug
if [ -d "$DEBUGDIR" -o -f "$DEBUGDIR" -o "$DEBUG" = true ]; then
  DEBUG=true
else
  DEBUG=false
fi
## just make it true always...
DEBUG=true
export DEBUG

#
# Set shell flags for trace, abort install if error
#
if $DEBUG; then set -xv; fi
set -e

#
# Start processing info here
#
common_init || exit 1

log_start_install

#
# Create application launch icons
#
create_app_launch || exit 1

#
#	set install options
#
set_install_options || exit 1

#
# Determine to which subscription list, if any, this host should be added
#
add_host_to_subscription_lists || exit 1

#
# If TEC is installed, then create the events and load rule bases
#
if $TEC_INSTALLED ; then
	#
	# Create hidden tasks
	#
	create_tec_hidden_tasks || exit 1

	#
	# Install TEC config task
	#
	create_tec_config_tasks || exit 1
else
	errmsg LinkInstallCat 27 "Tivoli Enterprise Console NOT installed!"
fi

#
# Run the configuration task, if it exists
#
if [ -f $PRODDIR/PLUSconfig.sh ]; then
	chmod +x $PRODDIR/PLUSconfig.sh
	$PRODDIR/PLUSconfig.sh
fi

touch $DBDIR/${SHORT_prodname}plus-installed

log_end_install

#
# Save the log files if $DEBUGDIR exists
#
if [ -d "$DEBUGDIR" ]; then
	cp $TEMP/${SHORT_PRODNAME}* $DEBUGDIR/.
fi

# restore user's locale
LANG=$SAVE_LANG

###return 0  # (can't return from function)
