#!/bin/sh
PATH=/usr/bin:/bin:/usr/ucb:$PATH
export PATH

THIS_CMD=`echo $0 | tr "\\\\\\\\" "/"`; THIS_CMD=`basename $THIS_CMD`
USAGE=`wbindmsg LinkCmdCat 28 "Usage: %1\\$s path" "$THIS_CMD" 2> /dev/null`
if [ ! "$USAGE" ]; then
	USAGE="Usage: $THIS_CMD path"
fi


if [ $# -ne 1 ] ; then
	echo "$USAGE"
	exit 1
fi

DESIRED_DIR=$1
CURRENT_DIR=
prefix=false
INCREMENTAL=`echo $1 | sed -e 's/\// /g'`
for next_dir in $INCREMENTAL
do
	drive=`echo $next_dir | grep :`
    if [ "x${drive}" !=  "x" ]
    then
     	CURRENT_DIR=${drive}/
        prefix=true
        next_dir=""
        shift
   	elif [ $prefix = true ]
    then 
		CURRENT_DIR=$CURRENT_DIR${next_dir}
        prefix=false
    else
	        CURRENT_DIR=$CURRENT_DIR/${next_dir}
	fi

	if [ ! -d "$CURRENT_DIR" ] ; then
		mkdir $CURRENT_DIR
		if [ ! -d "$CURRENT_DIR" ] ; then
			break
		fi
	fi
done	

if [ ! -d $DESIRED_DIR ] ; then
	#Failed
	exit 10
else
	#Succeeded	
	exit 0
fi
