#!/bin/sh
# $Id: $
#
# Component:	/Plus utility script
#
# Description:  
#
# Author:	<generated>
#
# (C) COPYRIGHT Tivoli Systems, Inc. 1996-2000
# Unpublished Work
# All Rights Reserved
# Licensed Material - Property of Tivoli Systems, Inc.
#


#
#	Set up environment (similar to old /etc/Tivoli/setup_env.sh)
#
OSERV=`objcall 0.0.0 get_oserv`; export OSERV
INST_DIR=`objcall $OSERV query install_dir | tr "\\\\\\\\" "/"`; export INST_DIR
INTERP=`objcall $OSERV query interp`; export INTERP
BINDIR=$INST_DIR/$INTERP; export BINDIR
PLUSDIR=$INST_DIR/generic_unix/TME/PLUS
LINKDIR=$PLUSDIR/LINK; export LINKDIR
DBDIR=`objcall $OSERV query db_dir | tr "\\\\\\\\" "/"`; export DBDIR
TEMP=/tmp; export TEMP
if [ x"$OS" = x"Windows_NT" ]; then
	TEMP=$DBDIR/tmp
fi
if [ ! -d $TEMP ]; then
	$LINKDIR/mkdir.sh $TEMP
fi
PATH=$LINKDIR:$PATH; export PATH


#
#	The standard directory and the /Plus override script
#
ETC=/etc/Tivoli
SCRIPT=PLUSsetup_env.sh

#
#	If this is NT, then etc is in a different location
#
if [ x\"$OS\" = x\"Windows_NT\" ] ; then
     ETC=$SystemRoot/system32/drivers/etc/Tivoli
fi

#
#	Look for our override script
#
if [ -f $ETC/$SCRIPT ]; then
  . $ETC/$SCRIPT
fi


#
#	Set up some other popular environment variables.
#
REGION=`objcall $OSERV query whoami | awk '{print $1}'`
LIBRARY=`wlookup Library`

#
#	Get the region name to avoid collisions
#
IRO=`wlookup InterRegion`
IRONAME=`idlattr -t -g $IRO name string`
IRONAME=`eval echo $IRONAME`

DEFSEN=\"TivoliSentryDefaults#$IRONAME\"

MNOID=`objcall 0.0.0 get_host_location`
eval MNNAME=`idlattr -t -g $MNOID label string`
export MNNAME

#
#	Debugging code: by creating a directory called .plusdebug in
#		the appropriate TEMP directory, the output of scripts is
#		redirected to a file in TEMP by the same name as the script.
#
DEBUGDIR=$TEMP/.plusdebug

SCRIPTNAME=`echo $0 | tr "\\\\\\\\" "/"`
SCRIPTNAME=`basename $`

[ -d "$DEBUGDIR" ] && exec > $DEBUGDIR/$SCRIPTNAME 2>&1 && set -xv
[ -f "$DEBUGDIR" -o "$DEBUG" = true ] && set -xv

ODNUM=`odadmin | grep Dispatcher | awk '{print $3}'`
if [ $ODNUM -ne 1 ]; then
	exit 0
else
	exit 1
fi
