DROP TABLE H_HP_CPU 
go

CREATE TABLE H_HP_CPU (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	CPU_NUMBER			INTEGER NOT NULL,
	CPU_TYPE			VARCHAR(128) NULL,
	CPU_SPEED			INTEGER NULL,
	L2_CACHE			VARCHAR(10) NULL,
	L3_CACHE			VARCHAR(10) NULL,
	CPU_CORE_INDEX		INTEGER NULL,
	CPU_CORE_COUNT		INTEGER NULL,
	RECORD_ACTION        CHAR(6)      NULL,
      PRFL_ACTION          VARCHAR(20)  NULL,
	RECORD_TIME          DATETIME     )
go

DROP TABLE H_HP_EISA_PCI_SLOTS
go
 
CREATE TABLE H_HP_EISA_PCI_SLOTS (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	SLOT_NUMBER			VARCHAR(8) NOT NULL ,
	BOARD_EISA_PCI_ID		VARCHAR(8) NULL ,
	BOARD_NAME			VARCHAR(128) NULL ,
	RECORD_ACTION        CHAR(6)      NULL,
      PRFL_ACTION          VARCHAR(20)  NULL,
	RECORD_TIME          DATETIME    )
go


DROP TABLE H_HP_SYSTEM
go
 
CREATE TABLE H_HP_SYSTEM (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	SYSTEM_NAME			VARCHAR(128) NULL ,
	FLASH_ROM			VARCHAR(3) NULL ,
	SYSTEM_PARTITION		VARCHAR(9) NULL ,
	SYSTEM_ROM_REV		VARCHAR(40) NULL ,
	SERIAL_NUMBER		VARCHAR(18) NULL ,
	PART_NUMBER			VARCHAR(18) NULL ,
	ASSET_TAG			VARCHAR(17) NULL ,
	TOTAL_SYS_MEMORY		VARCHAR(12) NULL ,
	HOT_PLUG_PCI		VARCHAR(3) NULL ,
	RECORD_ACTION        CHAR(6)      NULL,
      PRFL_ACTION          VARCHAR(20)  NULL,
	RECORD_TIME          DATETIME     )
go

DROP TABLE H_HP_MEMORY_MODULES
go
 
CREATE TABLE H_HP_MEMORY_MODULES (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	BOARD_MODULE_NUM		VARCHAR(8) NOT NULL ,
	MODULE_SIZE			VARCHAR(8) NULL ,
	MODULE_TYPE			VARCHAR(12) NULL ,
	MODULE_SPEED		VARCHAR(8) NULL ,
	MEMORY_ERROR_CHK_TYPE	VARCHAR(12) NULL ,
	MEMORY_TECHNOLOGY_TYPE	VARCHAR(12) NULL ,
	MODULE_PART_NUMBER	VARCHAR(32) NULL ,
	MODULE_SERIAL_NUMBER	VARCHAR(32) NULL ,
	MODULE_MANUFACTURE_ID	VARCHAR(10) NULL ,
	MODULE_MANUFACTURE_DATE	VARCHAR(10) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
      PRFL_ACTION          VARCHAR(20)  NULL,
	RECORD_TIME          DATETIME     )
go

DROP TABLE H_HP_IDE_DEVICES
go
 
CREATE TABLE H_HP_IDE_DEVICES (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	CONTROLLER_DRIVE		VARCHAR(10) NOT NULL ,
	NAME				VARCHAR(41) NULL ,
	TYPE				VARCHAR(21) NULL ,
	FIRMWARE_REV		VARCHAR(9) NULL ,
	DISK_SIZE			VARCHAR(12) NULL ,
	SERIAL_NUMBER		VARCHAR(21) NULL ,
	RECORD_ACTION        CHAR(6)      NULL,
      PRFL_ACTION          VARCHAR(20)  NULL,
	RECORD_TIME          DATETIME     )
go

DROP TABLE H_HP_SCSI_DEVICES
go
 
CREATE TABLE H_HP_SCSI_DEVICES (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	CNTLR_SLOT_SCSI_ID	VARCHAR(10) NOT NULL ,
	NAME				VARCHAR(26) NULL ,
	TYPE				VARCHAR(21) NULL ,
	FIRMWARE_REV		VARCHAR(5) NULL ,
	BUS_WIDTH			VARCHAR(7) NULL ,
	DISK_SIZE			VARCHAR(10) NULL ,
	HOT_PLUGGABLE		VARCHAR(8) NULL ,
	SERIAL_NUMBER		VARCHAR(40) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
      PRFL_ACTION          VARCHAR(20)  NULL,
	RECORD_TIME          DATETIME     )
go

DROP TABLE H_HP_VIDEO_MONITOR
go
 
CREATE TABLE H_HP_VIDEO_MONITOR (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	DESCRIPTION			VARCHAR(128) NULL ,
	NAME				VARCHAR(128) NULL ,
	SERIAL_NUMBER		VARCHAR(48) NULL ,
	MAX_HORIZONTAL_PIXELS	INTEGER NULL ,
	MAX_VERTICAL_PIXELS	INTEGER NULL ,
	EDID_VERSION		VARCHAR(5) NULL ,
	VERT_HORZ_FREQ_RANGE	VARCHAR(24) NULL ,
	FAULT_MANAGEMENT_SUPPORT	VARCHAR(3) NULL ,
	MANUFACTURE			VARCHAR(64) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
      PRFL_ACTION          VARCHAR(20)  NULL,
	RECORD_TIME          DATETIME     )
go

DROP TABLE H_HP_HEALTH_SUBSYSTEM
go
 
CREATE TABLE H_HP_HEALTH_SUBSYSTEM (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	ASR_STATUS			VARCHAR(14) NULL ,
	ASR_REBOOT_TO		VARCHAR(18) NULL ,
	PAGER_STATUS		VARCHAR(14) NULL ,
	PAGER_NUMBER		VARCHAR(64) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
      PRFL_ACTION          VARCHAR(20)  NULL,
	RECORD_TIME          DATETIME     )
go

DROP TABLE H_HP_DRIVE_ARRAY_CONTROLLER
go
 
CREATE TABLE H_HP_DRIVE_ARRAY_CONTROLLER (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	MODEL				VARCHAR(48) NULL ,
	FIRMWARE_REV       	VARCHAR(5) NULL ,
	SLOT				INTEGER NOT NULL,
	RECORD_ACTION        CHAR(6)      NULL,
      PRFL_ACTION          VARCHAR(20)  NULL,
	RECORD_TIME          DATETIME     )
go

DROP TABLE H_HP_DA_LOGICAL
go
 
CREATE TABLE H_HP_DA_LOGICAL (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	LOGICAL_DRIVE_INDEX	INTEGER NOT NULL ,
	DRIVE_SIZE			VARCHAR(10) NULL ,
	CONTROLLER_SLOT		INTEGER NULL ,
	AVAILABLE_SPARES		VARCHAR(40) NULL,
	PHYSICAL_DRIVES		VARCHAR(6) NULL,
	FAULT_TOLERANCE		VARCHAR(5) NULL ,
	RECORD_ACTION        CHAR(6)      NULL,
      PRFL_ACTION          VARCHAR(20)  NULL,
	RECORD_TIME          DATETIME     )
go


DROP TABLE H_HP_DA_PHYSICAL
go
 
CREATE TABLE H_HP_DA_PHYSICAL (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	SLOT_PORT_BAY		VARCHAR(10) NOT NULL ,
	MODEL				VARCHAR(41) NULL ,
	FIRMWARE_REV 		VARCHAR(9) NULL ,
	DRIVE_SIZE			VARCHAR(10) NULL ,
	HOT_PLUGGABLE		VARCHAR(8) NULL ,
	SERIAL_NUMBER		VARCHAR(41) NULL ,
	DRIVE_SPEED			VARCHAR(8) NULL,
	DRIVE_TYPE			VARCHAR(8) NULL,
	SATA_VERSION		VARCHAR(8) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
      PRFL_ACTION          VARCHAR(20)  NULL,
	RECORD_TIME          DATETIME     )
go

DROP TABLE H_HP_ATA_DISK 
go

CREATE TABLE H_HP_ATA_DISK (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	DISK_INDEX			INTEGER NOT NULL,
	DISK_SIZE			VARCHAR(15) NULL,
	CONTROLLER_SLOT		INTEGER NULL,
	DISK_MODEL			VARCHAR(41) NULL,
	DISK_FIRMWARE		VARCHAR(9) NULL,
	DISK_SERIAL_NUMBER	VARCHAR(21) NULL,
	DISK_TYPE			VARCHAR(5) NULL,
	SATA_VERSION		VARCHAR(10) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
      PRFL_ACTION          VARCHAR(20)  NULL,
	RECORD_TIME          DATETIME     )
go

DROP TABLE H_HP_SAS_HBA 
go

CREATE TABLE H_HP_SAS_HBA (
     	COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	CONTROLLER_SLOT		INTEGER NOT NULL,
	MODEL				VARCHAR(50) NULL,
	FIRMWARE			VARCHAR(17) NULL,
	SERIAL_NUMBER		VARCHAR(81) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
      PRFL_ACTION          VARCHAR(20)  NULL,
	RECORD_TIME          DATETIME     )
go

DROP TABLE H_HP_SAS_LOG_DRV 
go

CREATE TABLE H_HP_SAS_LOG_DRV (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	LOGICAL_DRIVE_INDEX	INTEGER NOT NULL,
	HBA_INDEX			INTEGER NULL,
	DRIVE_SIZE			VARCHAR(15) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
      PRFL_ACTION          VARCHAR(20)  NULL,
	RECORD_TIME          DATETIME     )
go

DROP TABLE H_HP_SAS_PHY_DRV 
go

CREATE TABLE H_HP_SAS_PHY_DRV (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	PHYSICAL_DRIVE_INDEX	INTEGER NOT NULL,
	HBA_INDEX			INTEGER NULL,
	MODEL				VARCHAR(41) NULL,
	DRIVE_SIZE			VARCHAR(15) NULL,
	DRIVE_SPEED			VARCHAR(10) NULL,
	DRIVE_FIRMWARE		VARCHAR(9) NULL,
	DRIVE_TYPE			VARCHAR(10) NULL,
	SERIAL_NUMBER		VARCHAR(41) NULL,
	HOT_PLUGGABLE		VARCHAR(10) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
      PRFL_ACTION          VARCHAR(20)  NULL,
	RECORD_TIME          DATETIME     )
go

DROP TABLE H_HP_STORAGE_SYSTEM
go
 
CREATE TABLE H_HP_STORAGE_SYSTEM (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	STORAGE_INDEX		INTEGER NOT NULL ,
	MODEL				VARCHAR(17) NULL ,
	CONTROLLER_SLOT		INTEGER NULL ,
	SCSI_BUS_INDEX		INTEGER NULL ,
	FIRMWARE_REV		VARCHAR(8) NULL ,
	CONNECT_TYPE		VARCHAR(8) NULL,
	VENDOR			VARCHAR(9) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
      PRFL_ACTION          VARCHAR(20)  NULL,
	RECORD_TIME          DATETIME     )
go


DROP TABLE H_HP_SOFTWARE_VERSIONS
go
 
CREATE TABLE H_HP_SOFTWARE_VERSIONS (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	NAME				VARCHAR(127) NOT NULL ,
	DESCRIPTION			VARCHAR(127) NULL ,
	VERSION			VARCHAR(50) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
      PRFL_ACTION          VARCHAR(20)  NULL,
	RECORD_TIME          DATETIME     )
go

DROP TABLE H_HP_RIB_INFO
go
 
CREATE TABLE H_HP_RIB_INFO (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	SERIAL_NUMBER		VARCHAR(24) NULL ,
	FIRMWARE_REV		VARCHAR(24) NULL ,
	VIDEO_STATUS		VARCHAR(24) NULL ,
	KEYBOARD_STATUS		VARCHAR(24) NULL ,
	ALERT_STATUS		VARCHAR(24) NULL ,
	BATTERY_STATUS		VARCHAR(24) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
      PRFL_ACTION          VARCHAR(20)  NULL,
	RECORD_TIME          DATETIME     )
go


DROP TABLE H_HP_CLUSTER_SUBSYSTEM
go
 
CREATE TABLE H_HP_CLUSTER_SUBSYSTEM (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	NODE_NAME			VARCHAR(24) NULL ,
	NODE_INDEX			INTEGER NULL ,
	CLUSTER_NAME		VARCHAR(64) NULL ,
	CLUSTER_IP_ADDR		VARCHAR(64) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
      PRFL_ACTION          VARCHAR(20)  NULL,
	RECORD_TIME          DATETIME     )
go


DROP TABLE H_HP_CLUSTER_INTERCONNECT
go
 
CREATE TABLE H_HP_CLUSTER_INTERCONNECT (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	INTERCONN_PHYSICAL_ID	VARCHAR(64) NULL  ,
	INTERCONN_TRANSPORT	VARCHAR(64) NULL ,
	INTERCONN_ADDRESS		VARCHAR(64) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
      PRFL_ACTION          VARCHAR(20)  NULL,
	RECORD_TIME          DATETIME     )
go


DROP TABLE H_HP_FCA_CONTROLLER
go
 
CREATE TABLE H_HP_FCA_CONTROLLER (
      COMPUTER_SYS_ID      	VARCHAR(64) NOT NULL,
	MODEL				VARCHAR(64) NULL ,
	FIRMWARE_REV		VARCHAR(5) NULL ,
	SERIAL_NUMBER		VARCHAR(32) NULL ,
	SLOT_INDEX			INTEGER NOT NULL,
	RECORD_ACTION        CHAR(6)      NULL,
      PRFL_ACTION          VARCHAR(20)  NULL,
	RECORD_TIME          DATETIME     )
go


DROP TABLE H_HP_FCA_HOST_CONTROLLER
go
 
CREATE TABLE H_HP_FCA_HOST_CONTROLLER (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	MODEL				VARCHAR(72) NULL ,
	SLOT_INDEX			INTEGER NOT NULL ,
	WORLD_WIDE_NAME		VARCHAR(17) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
      PRFL_ACTION          VARCHAR(20)  NULL,
	RECORD_TIME          DATETIME     )
go


DROP TABLE H_HP_FCA_LOGICAL_DRIVES
go
 
CREATE TABLE H_HP_FCA_LOGICAL_DRIVES (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	STORAGE_BOX_INDEX		INTEGER NOT NULL ,
	LOGICAL_DRIVE_INDEX	INTEGER NOT NULL ,
	FAULT_TOLERANCE		VARCHAR(24) NULL ,
	LOGICAL_DRIVE_SIZE	VARCHAR(10) NULL ,
	PHYSICAL_DRIVE_IDS	VARCHAR(10) NULL ,
	ACCELERATOR_STATUS	VARCHAR(16) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
      PRFL_ACTION          VARCHAR(20)  NULL,
	RECORD_TIME          DATETIME     )
go


DROP TABLE H_HP_FCA_PHYSICAL_DRIVES
go
 
CREATE TABLE H_HP_FCA_PHYSICAL_DRIVES (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	STORAGE_BOX_INDEX		INTEGER NOT NULL ,
	DRIVE_INDEX			INTEGER NOT NULL ,
	MODEL				VARCHAR(41) NULL ,
	DRIVE_SIZE			VARCHAR(10) NULL ,
	FIRMWARE_REV		VARCHAR(9) NULL ,
	SERIAL_NUMBER		VARCHAR(41) NULL,
	DRIVE_SPEED			INTEGER NULL,
	DRIVE_TYPE			INTEGER NULL,
	SATA_VERSION		INTEGER NULL,
	RECORD_ACTION        CHAR(6)      NULL,
      PRFL_ACTION          VARCHAR(20)  NULL,
	RECORD_TIME          DATETIME     )
go


DROP TABLE H_HP_PORTABLE_BATTERIES
go
 
CREATE TABLE H_HP_PORTABLE_BATTERIES (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	BATTERY_INDEX		INTEGER NULL ,
	MANUFACTURER		VARCHAR(80) NULL ,
	BATTERY_DATE		VARCHAR(10) NULL ,
	SERIAL_NUMBER		VARCHAR(16) NULL ,
	ASSET_TAG			VARCHAR(16) NULL ,
	CHEMISTRY			VARCHAR(80) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
      PRFL_ACTION          VARCHAR(20)  NULL,
	RECORD_TIME          DATETIME     )
go


DROP TABLE H_HP_DOCKING_STATION
go
 
CREATE TABLE H_HP_DOCKING_STATION (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	DOCK_STATUS			VARCHAR(8) NULL ,
	MODEL_NAME			VARCHAR(128) NULL ,
	SERIAL_NUMBER		VARCHAR(16) NULL ,
	ASSET_TAG			VARCHAR(16) NULL ,
	ROM_REVISION		VARCHAR(10) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
      PRFL_ACTION          VARCHAR(20)  NULL,
	RECORD_TIME          DATETIME     )
go


DROP TABLE H_HP_PORTABLE_PC_CARD_SLOTS
go
 
CREATE TABLE H_HP_PORTABLE_PC_CARD_SLOTS (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	PC_CARD_INDEX		INTEGER NULL ,
	SLOT_LOCATION		VARCHAR(40) NULL ,
	CARD_PRESENCE		VARCHAR(3) NULL ,
	CARD_STATUS			VARCHAR(80) NULL ,
	MANUFACTURER_NAME		VARCHAR(80) NULL ,
	DEVICE_NAME			VARCHAR(80) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
      PRFL_ACTION          VARCHAR(20)  NULL,
	RECORD_TIME             DATETIME     )
go


