DROP TABLE H_HP_CPU;

CREATE TABLE H_HP_CPU (
      COMPUTER_SYS_ID      	VARCHAR2(64)  NOT NULL,
	CPU_NUMBER			INTEGER NOT NULL,
	CPU_TYPE			VARCHAR2(128) NULL,
	CPU_SPEED			INTEGER NULL,
	L2_CACHE			VARCHAR2(10) NULL,
	L3_CACHE			VARCHAR2(10) NULL,
	CPU_CORE_INDEX		INTEGER NULL,
	CPU_CORE_COUNT		INTEGER NULL,
	RECORD_ACTION        CHAR(6)      NULL,
      PRFL_ACTION          VARCHAR2(20)  NULL,
	RECORD_TIME          DATE     );


DROP TABLE H_HP_EISA_PCI_SLOTS;

CREATE TABLE H_HP_EISA_PCI_SLOTS (
      COMPUTER_SYS_ID      	VARCHAR2(64)  NOT NULL,
	SLOT_NUMBER			VARCHAR2(8) NOT NULL ,
	BOARD_EISA_PCI_ID		VARCHAR2(8) NULL ,
	BOARD_NAME			VARCHAR2(128) NULL ,
	RECORD_ACTION        CHAR(6)      NULL,
      PRFL_ACTION          VARCHAR2(20)  NULL,
	RECORD_TIME          DATE      );


DROP TABLE H_HP_SYSTEM;

CREATE TABLE H_HP_SYSTEM (
      COMPUTER_SYS_ID      	VARCHAR2(64)  NOT NULL,
	SYSTEM_NAME			VARCHAR2(128) NULL ,
	FLASH_ROM			VARCHAR2(3) NULL ,
	SYSTEM_PARTITION		VARCHAR2(9) NULL ,
	SYSTEM_ROM_REV		VARCHAR2(40) NULL ,
	SERIAL_NUMBER		VARCHAR2(17) NULL ,
	PART_NUMBER			VARCHAR2(18) NULL,
	ASSET_TAG			VARCHAR2(17) NULL ,
	TOTAL_SYS_MEMORY		VARCHAR2(12) NULL ,
	HOT_PLUG_PCI		VARCHAR2(3) NULL ,
	RECORD_ACTION        CHAR(6)      NULL,
      PRFL_ACTION          VARCHAR2(20)  NULL,
	RECORD_TIME          DATE      );


DROP TABLE H_HP_MEMORY_MODULES;

CREATE TABLE H_HP_MEMORY_MODULES (
      COMPUTER_SYS_ID      	VARCHAR2(64)  NOT NULL,
	BOARD_MODULE_NUM		VARCHAR2(8) NOT NULL ,
	MODULE_SIZE			VARCHAR2(8) NULL ,
	MODULE_TYPE			VARCHAR2(12) NULL ,
	MODULE_SPEED		VARCHAR2(8) NULL ,
	MEMORY_ERROR_CHK_TYPE	VARCHAR2(12) NULL ,
	MEMORY_TECHNOLOGY_TYPE	VARCHAR2(12) NULL ,
	MODULE_PART_NUMBER	VARCHAR2(32) NULL ,
	MODULE_SERIAL_NUMBER	VARCHAR2(32) NULL ,
	MODULE_MANUFACTURE_ID	VARCHAR2(10) NULL ,
	MODULE_MANUFACTURE_DATE	VARCHAR2(10) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
        PRFL_ACTION          VARCHAR2(20)  NULL,
	RECORD_TIME          DATE      );

DROP TABLE H_HP_IDE_DEVICES;
 
CREATE TABLE H_HP_IDE_DEVICES (
      COMPUTER_SYS_ID      	VARCHAR2(64)  NOT NULL,
	CONTROLLER_DRIVE		VARCHAR2(10) NOT NULL ,
	NAME				VARCHAR2(41) NULL ,
	TYPE				VARCHAR2(21) NULL ,
	FIRMWARE_REV		VARCHAR2(9) NULL ,
	DISK_SIZE			VARCHAR2(12) NULL ,
	SERIAL_NUMBER		VARCHAR2(21) NULL ,
	RECORD_ACTION        CHAR(6)      NULL,
        PRFL_ACTION          VARCHAR2(20)  NULL,
	RECORD_TIME          DATE      );

DROP TABLE H_HP_SCSI_DEVICES;
 
CREATE TABLE H_HP_SCSI_DEVICES (
      COMPUTER_SYS_ID      	VARCHAR2(64)  NOT NULL,
	CNTLR_SLOT_SCSI_ID	VARCHAR2(10) NOT NULL ,
	NAME				VARCHAR2(26) NULL ,
	TYPE				VARCHAR2(21) NULL ,
	FIRMWARE_REV		VARCHAR2(5) NULL ,
	BUS_WIDTH			VARCHAR2(7) NULL ,
	DISK_SIZE			VARCHAR2(10) NULL ,
	HOT_PLUGGABLE		VARCHAR2(8) NULL ,
	SERIAL_NUMBER		VARCHAR2(40) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
        PRFL_ACTION          VARCHAR2(20)  NULL,
	RECORD_TIME          DATE      );

DROP TABLE H_HP_VIDEO_MONITOR;
 
CREATE TABLE H_HP_VIDEO_MONITOR (
      COMPUTER_SYS_ID      	VARCHAR2(64)  NOT NULL,
	DESCRIPTION			VARCHAR2(128) NULL ,
	NAME				VARCHAR2(128) NULL ,
	SERIAL_NUMBER		VARCHAR2(48) NULL ,
	MAX_HORIZONTAL_PIXELS	INTEGER NULL ,
	MAX_VERTICAL_PIXELS	INTEGER NULL ,
	EDID_VERSION		VARCHAR2(5) NULL ,
	VERT_HORZ_FREQ_RANGE	VARCHAR2(24) NULL ,
	FAULT_MANAGEMENT_SUPPORT	VARCHAR2(3) NULL ,
	MANUFACTURE			VARCHAR2(64) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
        PRFL_ACTION          VARCHAR2(20)  NULL,
	RECORD_TIME          DATE      );

DROP TABLE H_HP_HEALTH_SUBSYSTEM;

CREATE TABLE H_HP_HEALTH_SUBSYSTEM (
      COMPUTER_SYS_ID      	VARCHAR2(64)  NOT NULL,
	ASR_STATUS			VARCHAR2(14) NULL ,
	ASR_REBOOT_TO		VARCHAR2(18) NULL ,
	PAGER_STATUS		VARCHAR2(14) NULL ,
	PAGER_NUMBER		VARCHAR2(64) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
        PRFL_ACTION          VARCHAR2(20)  NULL,
	RECORD_TIME          DATE      );

DROP TABLE H_HP_DRIVE_ARRAY_CONTROLLER;

CREATE TABLE H_HP_DRIVE_ARRAY_CONTROLLER (
      COMPUTER_SYS_ID      	VARCHAR2(64)  NOT NULL,
	MODEL				VARCHAR2(48) NULL ,
	FIRMWARE_REV       	VARCHAR2(5) NULL ,
	SLOT				INTEGER NOT NULL,
	RECORD_ACTION        CHAR(6)      NULL,
        PRFL_ACTION          VARCHAR2(20)  NULL,
	RECORD_TIME          DATE      );

DROP TABLE H_HP_DA_LOGICAL;
 
CREATE TABLE H_HP_DA_LOGICAL (
      COMPUTER_SYS_ID      	VARCHAR2(64)  NOT NULL,
	LOGICAL_DRIVE_INDEX	INTEGER NOT NULL ,
	DRIVE_SIZE			VARCHAR2(10) NULL ,
	CONTROLLER_SLOT		INTEGER NULL ,
	AVAILABLE_SPARES		VARCHAR2(40) NULL,
	PHYSICAL_DRIVES		VARCHAR2(6) NULL,
	FAULT_TOLERANCE		VARCHAR2(5) NULL ,
	RECORD_ACTION        CHAR(6)      NULL,
        PRFL_ACTION          VARCHAR2(20)  NULL,
	RECORD_TIME          DATE      );


DROP TABLE H_HP_DA_PHYSICAL;
 
CREATE TABLE H_HP_DA_PHYSICAL (
      COMPUTER_SYS_ID      	VARCHAR2(64)  NOT NULL,
	SLOT_PORT_BAY		VARCHAR2(10) NOT NULL ,
	MODEL				VARCHAR2(41) NULL ,
	FIRMWARE_REV 		VARCHAR2(9) NULL ,
	DRIVE_SIZE			VARCHAR2(10) NULL ,
	HOT_PLUGGABLE		VARCHAR2(8) NULL ,
	SERIAL_NUMBER		VARCHAR2(41) NULL ,
	DRIVE_SPEED			VARCHAR2(8) NULL,
	DRIVE_TYPE			VARCHAR2(8) NULL,
	SATA_VERSION		VARCHAR2(8) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
        PRFL_ACTION          VARCHAR2(20)  NULL,
	RECORD_TIME          DATE      );

DROP TABLE H_HP_ATA_DISK; 

CREATE TABLE H_HP_ATA_DISK (
      COMPUTER_SYS_ID      	VARCHAR2(64)  NOT NULL,
	DISK_INDEX			INTEGER NOT NULL,
	DISK_SIZE			VARCHAR2(15) NULL,
	CONTROLLER_SLOT		INTEGER NULL,
	DISK_MODEL			VARCHAR2(41) NULL,
	DISK_FIRMWARE		VARCHAR2(9) NULL,
	DISK_SERIAL_NUMBER	VARCHAR2(21) NULL,
	DISK_TYPE			VARCHAR2(5) NULL,
	SATA_VERSION		VARCHAR2(10) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
      PRFL_ACTION          VARCHAR2(20)  NULL,
	RECORD_TIME          DATE     );

DROP TABLE H_HP_SAS_HBA; 

CREATE TABLE H_HP_SAS_HBA (
     	COMPUTER_SYS_ID      	VARCHAR2(64)  NOT NULL,
	CONTROLLER_SLOT		INTEGER NOT NULL,
	MODEL				VARCHAR2(50) NULL,
	FIRMWARE			VARCHAR2(17) NULL,
	SERIAL_NUMBER		VARCHAR2(81) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
      PRFL_ACTION          VARCHAR2(20)  NULL,
	RECORD_TIME          DATE     );

DROP TABLE H_HP_SAS_LOG_DRV; 

CREATE TABLE H_HP_SAS_LOG_DRV (
      COMPUTER_SYS_ID      	VARCHAR2(64)  NOT NULL,
	LOGICAL_DRIVE_INDEX	INTEGER NOT NULL,
	HBA_INDEX			INTEGER NULL,
	DRIVE_SIZE			VARCHAR2(15) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
      PRFL_ACTION          VARCHAR2(20)  NULL,
	RECORD_TIME          DATE     );

DROP TABLE H_HP_SAS_PHY_DRV; 

CREATE TABLE H_HP_SAS_PHY_DRV (
      COMPUTER_SYS_ID      	VARCHAR2(64)  NOT NULL,
	PHYSICAL_DRIVE_INDEX		INTEGER NOT NULL,
	HBA_INDEX			INTEGER NULL,
	MODEL				VARCHAR2(41) NULL,
	DRIVE_SIZE			VARCHAR2(15) NULL,
	DRIVE_SPEED			VARCHAR2(10) NULL,
	DRIVE_FIRMWARE		VARCHAR2(9) NULL,
	DRIVE_TYPE			VARCHAR2(10) NULL,
	SERIAL_NUMBER		VARCHAR2(41) NULL,
	HOT_PLUGGABLE		VARCHAR2(10) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
      PRFL_ACTION          VARCHAR2(20)  NULL,
	RECORD_TIME          DATE     );


DROP TABLE H_HP_STORAGE_SYSTEM;
 
CREATE TABLE H_HP_STORAGE_SYSTEM (
      COMPUTER_SYS_ID      	VARCHAR2(64)  NOT NULL,
	STORAGE_INDEX		INTEGER NOT NULL ,
	MODEL				VARCHAR2(17) NULL ,
	CONTROLLER_SLOT		INTEGER NULL ,
	SCSI_BUS_INDEX		INTEGER NULL ,
	FIRMWARE_REV		VARCHAR2(8) NULL ,
	CONNECT_TYPE		VARCHAR2(8) NULL,
	VENDOR			VARCHAR2(9) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
        PRFL_ACTION          VARCHAR2(20)  NULL,
	RECORD_TIME          DATE      );


DROP TABLE H_HP_SOFTWARE_VERSIONS;
 
CREATE TABLE H_HP_SOFTWARE_VERSIONS (
      COMPUTER_SYS_ID      	VARCHAR2(64)  NOT NULL,
	NAME				VARCHAR2(127) NOT NULL ,
	DESCRIPTION			VARCHAR2(127) NULL ,
	VERSION			VARCHAR2(50) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
        PRFL_ACTION          VARCHAR2(20)  NULL,
	RECORD_TIME          DATE      );



DROP TABLE H_HP_RIB_INFO;
 
CREATE TABLE H_HP_RIB_INFO (
      COMPUTER_SYS_ID      	VARCHAR2(64)  NOT NULL,
	SERIAL_NUMBER		VARCHAR2(24) NULL ,
	FIRMWARE_REV		VARCHAR2(24) NULL ,
	VIDEO_STATUS		VARCHAR2(24) NULL ,
	KEYBOARD_STATUS		VARCHAR2(24) NULL ,
	ALERT_STATUS		VARCHAR2(24) NULL ,
	BATTERY_STATUS		VARCHAR2(24) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
        PRFL_ACTION          VARCHAR2(20)  NULL,
	RECORD_TIME          DATE      );



DROP TABLE H_HP_CLUSTER_SUBSYSTEM;
 
CREATE TABLE H_HP_CLUSTER_SUBSYSTEM (
      COMPUTER_SYS_ID      	VARCHAR2(64)  NOT NULL,
	NODE_NAME			VARCHAR2(24) NULL ,
	NODE_INDEX			INTEGER NULL ,
	CLUSTER_NAME		VARCHAR2(64) NULL ,
	CLUSTER_IP_ADDR		VARCHAR2(64) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
        PRFL_ACTION          VARCHAR2(20)  NULL,
	RECORD_TIME          DATE      );



DROP TABLE H_HP_CLUSTER_INTERCONNECT;
 
CREATE TABLE H_HP_CLUSTER_INTERCONNECT (
      COMPUTER_SYS_ID      	VARCHAR2(64)  NOT NULL,
	INTERCONN_PHYSICAL_ID	VARCHAR2(64) NULL  ,
	INTERCONN_TRANSPORT	VARCHAR2(64) NULL ,
	INTERCONN_ADDRESS		VARCHAR2(64) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
        PRFL_ACTION          VARCHAR2(20)  NULL,
	RECORD_TIME          DATE      );


DROP TABLE H_HP_FCA_CONTROLLER;
 
CREATE TABLE H_HP_FCA_CONTROLLER (
      COMPUTER_SYS_ID      	VARCHAR2(64) NOT NULL,
	MODEL				VARCHAR2(64) NULL ,
	FIRMWARE_REV		VARCHAR2(5) NULL ,
	SERIAL_NUMBER		VARCHAR2(32) NULL ,
	SLOT_INDEX			INTEGER NOT NULL,
	RECORD_ACTION        CHAR(6)      NULL,
        PRFL_ACTION          VARCHAR2(20)  NULL,
	RECORD_TIME          DATE      );


DROP TABLE H_HP_FCA_HOST_CONTROLLER;
 
CREATE TABLE H_HP_FCA_HOST_CONTROLLER (
      COMPUTER_SYS_ID      	VARCHAR2(64)  NOT NULL,
	MODEL				VARCHAR2(72) NULL ,
	SLOT_INDEX			INTEGER NOT NULL ,
	WORLD_WIDE_NAME		VARCHAR2(17) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
        PRFL_ACTION          VARCHAR2(20)  NULL,
	RECORD_TIME          DATE      );


DROP TABLE H_HP_FCA_LOGICAL_DRIVES;
 
CREATE TABLE H_HP_FCA_LOGICAL_DRIVES (
      COMPUTER_SYS_ID      	VARCHAR2(64)  NOT NULL,
	STORAGE_BOX_INDEX		INTEGER NOT NULL ,
	LOGICAL_DRIVE_INDEX	INTEGER NOT NULL ,
	FAULT_TOLERANCE		VARCHAR2(24) NULL ,
	LOGICAL_DRIVE_SIZE	VARCHAR2(10) NULL ,
	PHYSICAL_DRIVE_IDS	VARCHAR2(10) NULL ,
	ACCELERATOR_STATUS	VARCHAR2(16) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
        PRFL_ACTION          VARCHAR2(20)  NULL,
	RECORD_TIME          DATE      );


DROP TABLE H_HP_FCA_PHYSICAL_DRIVES;
 
CREATE TABLE H_HP_FCA_PHYSICAL_DRIVES (
      COMPUTER_SYS_ID      	VARCHAR2(64)  NOT NULL,
	STORAGE_BOX_INDEX		INTEGER NOT NULL ,
	DRIVE_INDEX			INTEGER NOT NULL ,
	MODEL				VARCHAR2(41) NULL ,
	DRIVE_SIZE			VARCHAR2(10) NULL ,
	FIRMWARE_REV		VARCHAR2(9) NULL ,
	SERIAL_NUMBER		VARCHAR2(41) NULL,
	DRIVE_SPEED			VARCHAR2(8) NULL,
	DRIVE_TYPE			VARCHAR2(8) NULL,
	SATA_VERSION		VARCHAR2(8) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
        PRFL_ACTION          VARCHAR2(20)  NULL,
	RECORD_TIME          DATE      );


DROP TABLE H_HP_PORTABLE_BATTERIES;
 
CREATE TABLE H_HP_PORTABLE_BATTERIES (
      COMPUTER_SYS_ID      	VARCHAR2(64)  NOT NULL,
	BATTERY_INDEX		INTEGER NULL ,
	MANUFACTURER		VARCHAR2(80) NULL ,
	BATTERY_DATE		VARCHAR2(10) NULL ,
	SERIAL_NUMBER		VARCHAR2(16) NULL ,
	ASSET_TAG			VARCHAR2(16) NULL ,
	CHEMISTRY			VARCHAR2(80) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
        PRFL_ACTION          VARCHAR2(20)  NULL,
	RECORD_TIME          DATE      );


DROP TABLE H_HP_DOCKING_STATION;
 
CREATE TABLE H_HP_DOCKING_STATION (
      COMPUTER_SYS_ID      	VARCHAR2(64)  NOT NULL,
	DOCK_STATUS			VARCHAR2(8) NULL ,
	MODEL_NAME			VARCHAR2(128) NULL ,
	SERIAL_NUMBER		VARCHAR2(16) NULL ,
	ASSET_TAG			VARCHAR2(16) NULL ,
	ROM_REVISION		VARCHAR2(10) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
        PRFL_ACTION          VARCHAR2(20)  NULL,
	RECORD_TIME          DATE      );


DROP TABLE H_HP_PORTABLE_PC_CARD_SLOTS;
 
CREATE TABLE H_HP_PORTABLE_PC_CARD_SLOTS (
      COMPUTER_SYS_ID      	VARCHAR2(64)  NOT NULL,
	PC_CARD_INDEX		INTEGER NULL ,
	SLOT_LOCATION		VARCHAR2(40) NULL ,
	CARD_PRESENCE		VARCHAR2(3) NULL ,
	CARD_STATUS			VARCHAR2(80) NULL ,
	MANUFACTURER_NAME		VARCHAR2(80) NULL ,
	DEVICE_NAME			VARCHAR2(80) NULL,
	RECORD_ACTION        CHAR(6)      NULL,
        PRFL_ACTION          VARCHAR2(20)  NULL,
	RECORD_TIME             DATE      );

commit;
