#!/bin/sh 
#  This simple Bourne shell script creates a query library
#  containing the  HP Inventory queries. It must be run by 
#  an administrator with proper TME authorization in the 
#  appropriately configured TMR where the library must reside. 
#  The following queries are created within the specified 
#  query library (default is H_HP_QUERIES):
#			HP Inventory
#			HP ROM Information
#			HP Software Versions
# 
#  ./hptiv_queries.sh <PolicyRegionName> [QueryLibraryName]
#

if [ $# -lt 1 ] ; then
        echo "Usage: $0 <PolicyRegionName> [QueryLibraryName]"
        exit 1
fi

if [ $# -eq 2 ] ; then
	query_lib="$2"
else
	query_lib='H_HP_QUERIES'
fi

echo "Creating query library $query_lib in $1..." 
wcrtqlib "$1" "$query_lib"

echo "Creating query HP INVENTORY in $query_lib..." 
wcrtquery -d "Historical HP Inventory Information" -r invdh_1 -v H_HPINVDATA \
          -c TME_OBJECT_LABEL \
	  -c TME_OBJECT_ID \
	  -c COMPUTER_SYS_ID \
	  -c COMPUTER_SCANTIME \
          -c IP_ADDR \
	  -c IP_HOSTNAME \
	  -c OS_NAME \
	  -c OS_MAJOR_VERS \
	  -c OS_MINOR_VERS \
          -c CPU_TYPE \
          -c CPU_SPEED \
          -c SYSTEM_NAME \
          -c SYSTEM_ROM_REV \
          -c FLASH_ROM \
          -c SERIAL_NUMBER \
          -c TOTAL_SYS_MEMORY \
          -c ASSET_TAG \
          -w "order by TME_OBJECT_LABEL" \
"$query_lib" "H_HP_INVENTORY"

echo "Creating query HP SOFTWARE VERSIONS in $query_lib..." 
wcrtquery -d "Historical HP Software Versions" -r invdh_1 -v H_HPSWVER \
          -c TME_OBJECT_LABEL \
	  -c TME_OBJECT_ID \
	  -c COMPUTER_SYS_ID \
	  -c COMPUTER_SCANTIME \
          -c SYSTEM_NAME \
	  -c SYSTEM_ROM_REV \
          -c FLASH_ROM \
          -c NAME \
          -c DESCRIPTION \
          -c VERSION \
	  -c RECORD_TIME \
	  -w "order by TME_OBJECT_LABEL" \
"$query_lib" "H_HP_SOFTWARE_VERSIONS"

echo "Creating query HP CPU INFORMATION in $query_lib..." 
wcrtquery -d "Historical HP CPU Information" -r invdh_1 -v H_HPCPU \
          -c COMPUTER_SYS_ID \
	    -c TME_OBJECT_LABEL \
	  -c TME_OBJECT_ID \
	    -c CPU_TYPE \
          -c CPU_NUMBER \
	    -c CPU_SPEED \
	    -c L2_CACHE \
	    -c L3_CACHE \
          -c RECORD_TIME \
          -w "order by TME_OBJECT_LABEL" \
"$query_lib" "H_HP_CPU_INFORMATION"

echo "Creating query HP SLOT INFORMATION in $query_lib..." 
wcrtquery -d "Historical HP Slot Information" -r invdh_1 -v H_HPSLOTS \
          -c COMPUTER_SYS_ID \
	  -c TME_OBJECT_LABEL \
	  -c TME_OBJECT_ID \
	  -c SLOT_NUMBER \
          -c BOARD_EISA_PCI_ID \
	  -c BOARD_NAME \
          -c RECORD_TIME \
          -w "order by TME_OBJECT_LABEL" \
"$query_lib" "H_HP_SLOT_INFORMATION"

echo "Creating query HP IDE INFORMATION in $query_lib..." 
wcrtquery -d "Historical HP IDE Device Information" -r invdh_1 -v H_HPIDEDEV \
          -c COMPUTER_SYS_ID \
	  -c TME_OBJECT_LABEL \
	  -c TME_OBJECT_ID \
	  -c CONTROLLER_DRIVE \
  	  -c NAME \
  	  -c FIRMWARE_REV \
   	  -c DISK_SIZE \
   	  -c SERIAL_NUMBER \
  	  -c RECORD_TIME \
	  -w "order by TME_OBJECT_LABEL" \
"$query_lib" "H_HP_IDE_INFORMATION"

echo "Creating query HP DRIVE ARRAY INFORMATION in $query_lib..." 
wcrtquery -d "Historical HP Drive Array Information" -r invdh_1 -v H_HPDRVARRY \
          -c COMPUTER_SYS_ID \
	  -c TME_OBJECT_LABEL \
	  -c TME_OBJECT_ID \
	  -c MODEL \
  	  -c SLOT_PORT_BAY \
  	  -c FIRMWARE_REV \
   	  -c DRIVE_SIZE \
   	  -c HOT_PLUGGABLE \
	  -w "order by TME_OBJECT_LABEL" \
"$query_lib" "H_HP_DRIVE_ARRAY_INFORMATION"

echo "Creating query HP SAS INFORMATION in $query_lib..." 
wcrtquery -d "Historical HP SAS Information" -r invdh_1 -v H_HPSASDRV \
          -c COMPUTER_SYS_ID \
	  -c TME_OBJECT_LABEL \
	  -c TME_OBJECT_ID \
	  -c MODEL \
  	  -c HBA_INDEX \
   	  -c DRIVE_SIZE \
   	  -c DRIVE_SPEED \
  	  -c DRIVE_FIRMWARE \
   	  -c DRIVE_TYPE \
   	  -c HOT_PLUGGABLE \
	  -w "order by TME_OBJECT_LABEL" \
"$query_lib" "H_HP_SAS_INFORMATION"

echo "Creating query HP ATA DISK INFORMATION in $query_lib..." 
wcrtquery -d "Historical HP ATA Disk Information" -r invdh_1 -v H_HPATADISK \
          -c COMPUTER_SYS_ID \
	  -c TME_OBJECT_LABEL \
	  -c TME_OBJECT_ID \
	  -c DISK_INDEX \
	  -c DISK_SIZE \
	  -c CONTROLLER_SLOT \
	  -c DISK_MODEL \
	  -c DISK_FIRMWARE \
	  -c DISK_TYPE \
	  -c SATA_VERSION \
 	  -w "order by TME_OBJECT_LABEL" \
"$query_lib" "H_HP_ATA_DISK_INFORMATION"

echo "Creating query HP SCSI INFORMATION in $query_lib..." 
wcrtquery -d "Historical HP SCSI Device Information" -r invdh_1 -v H_HPSCSI \
          -c COMPUTER_SYS_ID \
	  -c TME_OBJECT_LABEL \
	  -c TME_OBJECT_ID \
	  -c CNTLR_SLOT_SCSI_ID \
  	  -c NAME \
  	  -c FIRMWARE_REV \
   	  -c DISK_SIZE \
   	  -c HOT_PLUGGABLE \
  	  -c RECORD_TIME \
	  -w "order by TME_OBJECT_LABEL" \
"$query_lib" "H_HP_SCSI_INFORMATION"

echo "Creating query HP FCA INFORMATION in $query_lib..." 
wcrtquery -d "Historical HP Fibre Channel Array Information" -r invdh_1 -v H_HPFCA \
          -c COMPUTER_SYS_ID \
	  -c TME_OBJECT_LABEL \
	  -c TME_OBJECT_ID \
  	  -c MODEL \
	  -c STORAGE_BOX_INDEX \
	  -c DRIVE_INDEX \
   	  -c DRIVE_SIZE \
   	  -c FIRMWARE_REV \
  	  -c RECORD_TIME \
	  -w "order by TME_OBJECT_LABEL" \
"$query_lib" "H_HP_FCA_INFORMATION"

exit 0
