
ALTER TABLE HP_CPU DROP CONSTRAINT HPCPU_FK
ALTER TABLE HP_EISA_PCI_SLOTS DROP CONSTRAINT HPEISAPCISLOTS_FK
ALTER TABLE HP_SYSTEM DROP CONSTRAINT HPSYSTEM_FK
ALTER TABLE HP_MEMORY_MODULES DROP CONSTRAINT HPMEMORYMODULES_FK
ALTER TABLE HP_IDE_DEVICES DROP CONSTRAINT HPIDEDEVICES_FK
ALTER TABLE HP_SCSI_DEVICES DROP CONSTRAINT HPSCSIDEVICES_FK
ALTER TABLE HP_VIDEO_MONITOR DROP CONSTRAINT HPVIDEOMONITOR_FK 
ALTER TABLE HP_HEALTH_SUBSYSTEM DROP CONSTRAINT HPHEALTHSUBSYSTEM_FK
ALTER TABLE HP_DRIVE_ARRAY_CONTROLLER DROP CONSTRAINT HPDRIVEARRAYCONTROLLER_FK
ALTER TABLE HP_DA_LOGICAL DROP CONSTRAINT HPDALOGICAL_FK
ALTER TABLE HP_DA_PHYSICAL DROP CONSTRAINT HPDAPHYSICAL_FK
ALTER TABLE HP_ATA_DISK DROP CONSTRAINT HPATADISK_FK
ALTER TABLE HP_SAS_HBA DROP CONSTRAINT HPSASHBA_FK
ALTER TABLE HP_SAS_LOG_DRV DROP CONSTRAINT HPSASLOGDRV_FK
ALTER TABLE HP_SAS_PHY_DRV DROP CONSTRAINT HPSASPHYDRV_FK
ALTER TABLE HP_STORAGE_SYSTEM DROP CONSTRAINT HPSTORAGESYSTEM_FK
ALTER TABLE HP_SOFTWARE_VERSIONS DROP CONSTRAINT HPSOFTWAREVERSIONS_FK
ALTER TABLE HP_RIB_INFO DROP CONSTRAINT HPRIBINFO_FK
ALTER TABLE HP_CLUSTER_SUBSYSTEM DROP CONSTRAINT HPCLUSTERSUBSYSTEM_FK
ALTER TABLE HP_FCA_CONTROLLER DROP CONSTRAINT HPFCACONTROLLER_FK
ALTER TABLE HP_CLUSTER_INTERCONNECT DROP CONSTRAINT HPCLUSTERINTERCONNECT_FK
ALTER TABLE HP_FCA_HOST_CONTROLLER DROP CONSTRAINT HPFCAHOSTCONTROLLER_FK
ALTER TABLE HP_FCA_LOGICAL_DRIVES DROP CONSTRAINT HPFCALOGICALDRIVES_FK
ALTER TABLE HP_FCA_PHYSICAL_DRIVES DROP CONSTRAINT HPFCAPHYSICALDRIVES_FK
ALTER TABLE HP_PORTABLE_BATTERIES DROP CONSTRAINT HPPORTABLEBATTERIES_FK
ALTER TABLE HP_DOCKING_STATION DROP CONSTRAINT HPDOCKINGSTATION_FK
ALTER TABLE HP_PORTABLE_PC_CARD_SLOTS DROP CONSTRAINT HPPORTABLEPCCARDSLOTS_FK
go

DROP TABLE HP_CPU 
go

CREATE TABLE HP_CPU (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	CPU_NUMBER			INTEGER NOT NULL,
	CPU_TYPE			VARCHAR(128) NULL,
	CPU_SPEED			INTEGER NULL,
	L2_CACHE			VARCHAR(10) NULL,
	L3_CACHE			VARCHAR(10) NULL,
	CPU_CORE_INDEX		INTEGER NULL,
	CPU_CORE_COUNT		INTEGER NULL,
	RECORD_TIME          DATETIME     DEFAULT GETDATE(),
CONSTRAINT HPCPU_PK PRIMARY KEY(COMPUTER_SYS_ID, CPU_NUMBER),
CONSTRAINT HPCPU_FK FOREIGN KEY(COMPUTER_SYS_ID)
REFERENCES COMPUTER(COMPUTER_SYS_ID))
go

DROP TRIGGER HPCPU_TR
go

CREATE TRIGGER HPCPU_TR ON HP_CPU
FOR UPDATE AS
BEGIN
       UPDATE HP_CPU SET RECORD_TIME = GETDATE()
       WHERE COMPUTER_SYS_ID = (SELECT COMPUTER_SYS_ID FROM INSERTED)
       AND CPU_NUMBER = (SELECT CPU_NUMBER FROM INSERTED)
END
go

DROP TABLE HP_EISA_PCI_SLOTS
go
 
CREATE TABLE HP_EISA_PCI_SLOTS (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	SLOT_NUMBER			VARCHAR(8) NOT NULL ,
	BOARD_EISA_PCI_ID		VARCHAR(8) NULL ,
	BOARD_NAME			VARCHAR(128) NULL ,
	RECORD_TIME          DATETIME     DEFAULT GETDATE(),
CONSTRAINT HPEISAPCISLOTS_PK PRIMARY KEY(COMPUTER_SYS_ID, SLOT_NUMBER),
CONSTRAINT HPEISAPCISLOTS_FK FOREIGN KEY(COMPUTER_SYS_ID)
REFERENCES COMPUTER(COMPUTER_SYS_ID))
go

DROP TRIGGER HPEISAPCISLOTS_TR
go
CREATE TRIGGER HPEISAPCISLOTS_TR ON HP_EISA_PCI_SLOTS
FOR UPDATE AS
BEGIN
       UPDATE HP_EISA_PCI_SLOTS SET RECORD_TIME = GETDATE()
       WHERE COMPUTER_SYS_ID = (SELECT COMPUTER_SYS_ID FROM INSERTED)
       AND SLOT_NUMBER = (SELECT SLOT_NUMBER FROM INSERTED)
END
go

DROP TABLE HP_SYSTEM
go
 
CREATE TABLE HP_SYSTEM (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	SYSTEM_NAME			VARCHAR(128) NULL ,
	FLASH_ROM			VARCHAR(3) NULL ,
	SYSTEM_PARTITION		VARCHAR(9) NULL ,
	SYSTEM_ROM_REV		VARCHAR(40) NULL ,
	SERIAL_NUMBER		VARCHAR(18) NULL ,
	PART_NUMBER			VARCHAR(18) NULL ,
	ASSET_TAG			VARCHAR(17) NULL ,
	TOTAL_SYS_MEMORY		VARCHAR(12) NULL ,
	HOT_PLUG_PCI		VARCHAR(3) NULL ,
	RECORD_TIME          DATETIME     DEFAULT GETDATE(),
CONSTRAINT HPSYSTEM_PK PRIMARY KEY(COMPUTER_SYS_ID),
CONSTRAINT HPSYSTEM_FK FOREIGN KEY(COMPUTER_SYS_ID)
REFERENCES COMPUTER(COMPUTER_SYS_ID))
go

DROP TRIGGER HPSYSTEM_TR
go
CREATE TRIGGER HPSYSTEM_TR ON HP_SYSTEM
FOR UPDATE AS
BEGIN
       UPDATE HP_SYSTEM SET RECORD_TIME = GETDATE()
       WHERE COMPUTER_SYS_ID = (SELECT COMPUTER_SYS_ID FROM INSERTED)       
END
go

DROP TABLE HP_MEMORY_MODULES
go
 
CREATE TABLE HP_MEMORY_MODULES (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	BOARD_MODULE_NUM		VARCHAR(8) NOT NULL ,
	MODULE_SIZE			VARCHAR(8) NULL ,
	MODULE_TYPE			VARCHAR(12) NULL ,
	MODULE_SPEED		VARCHAR(8) NULL ,
	MEMORY_ERROR_CHK_TYPE	VARCHAR(12) NULL ,
	MEMORY_TECHNOLOGY_TYPE	VARCHAR(12) NULL ,
	MODULE_PART_NUMBER	VARCHAR(32) NULL ,
	MODULE_SERIAL_NUMBER	VARCHAR(32) NULL ,
	MODULE_MANUFACTURE_ID	VARCHAR(10) NULL ,
	MODULE_MANUFACTURE_DATE	VARCHAR(10) NULL,
	RECORD_TIME          DATETIME     DEFAULT GETDATE(),
CONSTRAINT HPMEMORYMODULES_PK PRIMARY KEY(COMPUTER_SYS_ID, BOARD_MODULE_NUM),
CONSTRAINT HPMEMORYMODULES_FK FOREIGN KEY(COMPUTER_SYS_ID)
REFERENCES COMPUTER(COMPUTER_SYS_ID))
go

DROP TRIGGER HPMEMORYMODULES_TR
go
CREATE TRIGGER HPMEMORYMODULES_TR ON HP_MEMORY_MODULES
FOR UPDATE AS
BEGIN
       UPDATE HP_MEMORY_MODULES SET RECORD_TIME = GETDATE()
       WHERE COMPUTER_SYS_ID = (SELECT COMPUTER_SYS_ID FROM INSERTED)
       AND BOARD_MODULE_NUM = (SELECT BOARD_MODULE_NUM FROM INSERTED)
END
go


DROP TABLE HP_IDE_DEVICES
go
 
CREATE TABLE HP_IDE_DEVICES (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	CONTROLLER_DRIVE		VARCHAR(10) NOT NULL ,
	NAME				VARCHAR(41) NULL ,
	TYPE				VARCHAR(21) NULL ,
	FIRMWARE_REV		VARCHAR(9) NULL ,
	DISK_SIZE			VARCHAR(12) NULL ,
	SERIAL_NUMBER		VARCHAR(21) NULL ,
	RECORD_TIME          DATETIME     DEFAULT GETDATE(),
CONSTRAINT HPIDEDEVICES_PK PRIMARY KEY(COMPUTER_SYS_ID, CONTROLLER_DRIVE),
CONSTRAINT HPIDEDEVICES_FK FOREIGN KEY(COMPUTER_SYS_ID)
REFERENCES COMPUTER(COMPUTER_SYS_ID))
go

DROP TRIGGER HPIDEDEVICES_TR
go
CREATE TRIGGER HPIDEDEVICES_TR ON HP_IDE_DEVICES
FOR UPDATE AS
BEGIN
       UPDATE HP_IDE_DEVICES SET RECORD_TIME = GETDATE()
       WHERE COMPUTER_SYS_ID = (SELECT COMPUTER_SYS_ID FROM INSERTED)
       AND CONTROLLER_DRIVE = (SELECT CONTROLLER_DRIVE FROM INSERTED)
END
go

DROP TABLE HP_SCSI_DEVICES
go
 
CREATE TABLE HP_SCSI_DEVICES (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	CNTLR_SLOT_SCSI_ID	VARCHAR(10) NOT NULL ,
	NAME				VARCHAR(26) NULL ,
	TYPE				VARCHAR(21) NULL ,
	FIRMWARE_REV		VARCHAR(5) NULL ,
	BUS_WIDTH			VARCHAR(7) NULL ,
	DISK_SIZE			VARCHAR(10) NULL ,
	HOT_PLUGGABLE		VARCHAR(8) NULL ,
	SERIAL_NUMBER		VARCHAR(40) NULL,
	RECORD_TIME          DATETIME     DEFAULT GETDATE(),
CONSTRAINT HPSCSIDEVICES_PK PRIMARY KEY(COMPUTER_SYS_ID, CNTLR_SLOT_SCSI_ID),
CONSTRAINT HPSCSIDEVICES_FK FOREIGN KEY(COMPUTER_SYS_ID)
REFERENCES COMPUTER(COMPUTER_SYS_ID))
go

DROP TRIGGER HPSCSIDEVICES_TR
go
CREATE TRIGGER HPSCSIDEVICES_TR ON HP_SCSI_DEVICES
FOR UPDATE AS
BEGIN
       UPDATE HP_SCSI_DEVICES SET RECORD_TIME = GETDATE()
       WHERE COMPUTER_SYS_ID = (SELECT COMPUTER_SYS_ID FROM INSERTED)
       AND CNTLR_SLOT_SCSI_ID = (SELECT CNTLR_SLOT_SCSI_ID FROM INSERTED)
END
go

DROP TABLE HP_VIDEO_MONITOR
go
 
CREATE TABLE HP_VIDEO_MONITOR (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	DESCRIPTION			VARCHAR(128) NULL ,
	NAME				VARCHAR(128) NULL ,
	SERIAL_NUMBER		VARCHAR(48) NULL ,
	MAX_HORIZONTAL_PIXELS	INTEGER NULL ,
	MAX_VERTICAL_PIXELS	INTEGER NULL ,
	EDID_VERSION		VARCHAR(5) NULL ,
	VERT_HORZ_FREQ_RANGE	VARCHAR(24) NULL ,
	FAULT_MANAGEMENT_SUPPORT	VARCHAR(3) NULL ,
	MANUFACTURE			VARCHAR(64) NULL,
	RECORD_TIME          DATETIME     DEFAULT GETDATE(),
CONSTRAINT HPVIDEOMONITOR_PK PRIMARY KEY(COMPUTER_SYS_ID),
CONSTRAINT HPVIDEOMONITOR_FK FOREIGN KEY(COMPUTER_SYS_ID)
REFERENCES COMPUTER(COMPUTER_SYS_ID))
go

DROP TRIGGER HPVIDEOMONITOR_TR
go
CREATE TRIGGER HPVIDEOMONITOR_TR ON HP_VIDEO_MONITOR
FOR UPDATE AS
BEGIN
       UPDATE HP_VIDEO_MONITOR SET RECORD_TIME = GETDATE()
       WHERE COMPUTER_SYS_ID = (SELECT COMPUTER_SYS_ID FROM INSERTED)
END
go

DROP TABLE HP_HEALTH_SUBSYSTEM
go
 
CREATE TABLE HP_HEALTH_SUBSYSTEM (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	ASR_STATUS			VARCHAR(14) NULL ,
	ASR_REBOOT_TO		VARCHAR(18) NULL ,
	PAGER_STATUS		VARCHAR(14) NULL ,
	PAGER_NUMBER		VARCHAR(64) NULL,
	RECORD_TIME          DATETIME     DEFAULT GETDATE(),
CONSTRAINT HPHEALTHSUBSYSTEM_PK PRIMARY KEY(COMPUTER_SYS_ID),
CONSTRAINT HPHEALTHSUBSYSTEM_FK FOREIGN KEY(COMPUTER_SYS_ID)
REFERENCES COMPUTER(COMPUTER_SYS_ID))
go

DROP TRIGGER HPHEALTHSUBSYSTEM_TR
go
CREATE TRIGGER HPHEALTHSUBSYSTEM_TR ON HP_HEALTH_SUBSYSTEM
FOR UPDATE AS
BEGIN
       UPDATE HP_HEALTH_SUBSYSTEM SET RECORD_TIME = GETDATE()
       WHERE COMPUTER_SYS_ID = (SELECT COMPUTER_SYS_ID FROM INSERTED)
END
go

DROP TABLE HP_DRIVE_ARRAY_CONTROLLER
go
 
CREATE TABLE HP_DRIVE_ARRAY_CONTROLLER (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	MODEL				VARCHAR(48) NULL ,
	FIRMWARE_REV       	VARCHAR(5) NULL ,
	SLOT				INTEGER NOT NULL,
	RECORD_TIME          DATETIME     DEFAULT GETDATE(),
CONSTRAINT HPDRIVEARRAYCONTROLLER_PK PRIMARY KEY(COMPUTER_SYS_ID, SLOT),
CONSTRAINT HPDRIVEARRAYCONTROLLER_FK FOREIGN KEY(COMPUTER_SYS_ID)
REFERENCES COMPUTER(COMPUTER_SYS_ID))
go

DROP TRIGGER HPDRIVEARRAYCONTROLLER_TR
go
CREATE TRIGGER HPDRIVEARRAYCONTROLLER_TR ON HP_DRIVE_ARRAY_CONTROLLER
FOR UPDATE AS
BEGIN
       UPDATE HP_DRIVE_ARRAY_CONTROLLER SET RECORD_TIME = GETDATE()
       WHERE COMPUTER_SYS_ID = (SELECT COMPUTER_SYS_ID FROM INSERTED)
       AND SLOT = (SELECT SLOT FROM INSERTED)
END
go

DROP TABLE HP_DA_LOGICAL
go
 
CREATE TABLE HP_DA_LOGICAL (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	LOGICAL_DRIVE_INDEX	INTEGER NOT NULL ,
	DRIVE_SIZE			VARCHAR(10) NULL ,
	CONTROLLER_SLOT		INTEGER NULL ,
	AVAILABLE_SPARES		VARCHAR(40) NULL,
	PHYSICAL_DRIVES		VARCHAR(6) NULL,
	FAULT_TOLERANCE		VARCHAR(5) NULL ,
	RECORD_TIME          DATETIME     DEFAULT GETDATE(),
CONSTRAINT HPDALOGICAL_PK PRIMARY KEY(COMPUTER_SYS_ID, LOGICAL_DRIVE_INDEX),
CONSTRAINT HPDALOGICAL_FK FOREIGN KEY(COMPUTER_SYS_ID)
REFERENCES COMPUTER(COMPUTER_SYS_ID))
go

DROP TRIGGER HPDALOGICAL_TR
go
CREATE TRIGGER HPDALOGICAL_TR ON HP_DA_LOGICAL
FOR UPDATE AS
BEGIN
       UPDATE HP_DA_LOGICAL SET RECORD_TIME = GETDATE()
       WHERE COMPUTER_SYS_ID = (SELECT COMPUTER_SYS_ID FROM INSERTED)
       AND LOGICAL_DRIVE_INDEX = (SELECT LOGICAL_DRIVE_INDEX FROM INSERTED)
END
go

DROP TABLE HP_DA_PHYSICAL
go
 
CREATE TABLE HP_DA_PHYSICAL (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	SLOT_PORT_BAY		VARCHAR(10) NOT NULL ,
	MODEL				VARCHAR(41) NULL ,
	FIRMWARE_REV 		VARCHAR(9) NULL ,
	DRIVE_SIZE			VARCHAR(10) NULL ,
	HOT_PLUGGABLE		VARCHAR(8) NULL ,
	SERIAL_NUMBER		VARCHAR(41) NULL ,
	DRIVE_SPEED			VARCHAR(8) NULL,
	DRIVE_TYPE			VARCHAR(8) NULL,
	SATA_VERSION		VARCHAR(8) NULL,
	RECORD_TIME          DATETIME     DEFAULT GETDATE(),
CONSTRAINT HPDAPHYSICAL_PK PRIMARY KEY(COMPUTER_SYS_ID, SLOT_PORT_BAY),
CONSTRAINT HPDAPHYSICAL_FK FOREIGN KEY(COMPUTER_SYS_ID)
REFERENCES COMPUTER(COMPUTER_SYS_ID))
go

DROP TRIGGER HPDAPHYSICAL_TR
go
CREATE TRIGGER HPDAPHYSICAL_TR ON HP_DA_PHYSICAL
FOR UPDATE AS
BEGIN
       UPDATE HP_DA_PHYSICAL SET RECORD_TIME = GETDATE()
       WHERE COMPUTER_SYS_ID = (SELECT COMPUTER_SYS_ID FROM INSERTED)
       AND SLOT_PORT_BAY = (SELECT SLOT_PORT_BAY FROM INSERTED)
END
go

DROP TABLE HP_ATA_DISK 
go

CREATE TABLE HP_ATA_DISK (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	DISK_INDEX			INTEGER NOT NULL,
	DISK_SIZE			VARCHAR(15) NULL,
	CONTROLLER_SLOT		INTEGER NULL,
	DISK_MODEL			VARCHAR(41) NULL,
	DISK_FIRMWARE		VARCHAR(9) NULL,
	DISK_SERIAL_NUMBER	VARCHAR(21) NULL,
	DISK_TYPE			VARCHAR(5) NULL,
	SATA_VERSION		VARCHAR(10) NULL,
	RECORD_TIME          DATETIME     DEFAULT GETDATE(),
CONSTRAINT HPATADISK_PK PRIMARY KEY(COMPUTER_SYS_ID, DISK_INDEX),
CONSTRAINT HPATADISK_FK FOREIGN KEY(COMPUTER_SYS_ID)
REFERENCES COMPUTER(COMPUTER_SYS_ID))
go

DROP TRIGGER HPATADISK_TR
go

CREATE TRIGGER HPATADISK_TR ON HP_ATA_DISK
FOR UPDATE AS
BEGIN
       UPDATE HP_ATA_DISK SET RECORD_TIME = GETDATE()
       WHERE COMPUTER_SYS_ID = (SELECT COMPUTER_SYS_ID FROM INSERTED)
       AND DISK_INDEX = (SELECT DISK_INDEX FROM INSERTED)
END
go

DROP TABLE HP_SAS_HBA 
go

CREATE TABLE HP_SAS_HBA (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	CONTROLLER_SLOT		INTEGER NOT NULL,
	MODEL				VARCHAR(50) NULL,
	FIRMWARE			VARCHAR(17) NULL,
	SERIAL_NUMBER		VARCHAR(81) NULL,
	RECORD_TIME          DATETIME     DEFAULT GETDATE(),
CONSTRAINT HPSASHBA_PK PRIMARY KEY(COMPUTER_SYS_ID, CONTROLLER_SLOT),
CONSTRAINT HPSASHBA_FK FOREIGN KEY(COMPUTER_SYS_ID)
REFERENCES COMPUTER(COMPUTER_SYS_ID))
go

DROP TRIGGER HPSASHBA_TR
go

CREATE TRIGGER HPSASHBA_TR ON HP_SAS_HBA
FOR UPDATE AS
BEGIN
       UPDATE HP_SAS_HBA SET RECORD_TIME = GETDATE()
       WHERE COMPUTER_SYS_ID = (SELECT COMPUTER_SYS_ID FROM INSERTED)
       AND CONTROLLER_SLOT = (SELECT CONTROLLER_SLOT FROM INSERTED)
END
go

DROP TABLE HP_SAS_LOG_DRV 
go

CREATE TABLE HP_SAS_LOG_DRV (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	LOGICAL_DRIVE_INDEX	INTEGER NOT NULL,
	HBA_INDEX			INTEGER NULL,
	DRIVE_SIZE			VARCHAR(15) NULL,
	RECORD_TIME          DATETIME     DEFAULT GETDATE(),
CONSTRAINT HPSASLOGDRV_PK PRIMARY KEY(COMPUTER_SYS_ID, LOGICAL_DRIVE_INDEX),
CONSTRAINT HPSASLOGDRV_FK FOREIGN KEY(COMPUTER_SYS_ID)
REFERENCES COMPUTER(COMPUTER_SYS_ID))
go

DROP TRIGGER HPSASLOGDRV_TR
go

CREATE TRIGGER HPSASLOGDRV_TR ON HP_SAS_LOG_DRV
FOR UPDATE AS
BEGIN
       UPDATE HP_SAS_LOG_DRV SET RECORD_TIME = GETDATE()
       WHERE COMPUTER_SYS_ID = (SELECT COMPUTER_SYS_ID FROM INSERTED)
       AND LOGICAL_DRIVE_INDEX = (SELECT LOGICAL_DRIVE_INDEX FROM INSERTED)
END
go

DROP TABLE HP_SAS_PHY_DRV 
go

CREATE TABLE HP_SAS_PHY_DRV (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	PHYSICAL_DRIVE_INDEX	INTEGER NOT NULL,
	HBA_INDEX			INTEGER NULL,
	MODEL				VARCHAR(41) NULL,
	DRIVE_SIZE			VARCHAR(15) NULL,
	DRIVE_SPEED			VARCHAR(10) NULL,
	DRIVE_FIRMWARE		VARCHAR(9) NULL,
	DRIVE_TYPE			VARCHAR(10) NULL,
	SERIAL_NUMBER		VARCHAR(41) NULL,
	HOT_PLUGGABLE		VARCHAR(10) NULL,
	RECORD_TIME          DATETIME     DEFAULT GETDATE(),
CONSTRAINT HPSASPHYDRV_PK PRIMARY KEY(COMPUTER_SYS_ID, PHYSICAL_DRIVE_INDEX),
CONSTRAINT HPSASPHYDRV_FK FOREIGN KEY(COMPUTER_SYS_ID)
REFERENCES COMPUTER(COMPUTER_SYS_ID))
go

DROP TRIGGER HPSASPHYDRV_TR
go

CREATE TRIGGER HPSASPHYDRV_TR ON HP_SAS_PHY_DRV
FOR UPDATE AS
BEGIN
       UPDATE HP_SAS_PHY_DRV SET RECORD_TIME = GETDATE()
       WHERE COMPUTER_SYS_ID = (SELECT COMPUTER_SYS_ID FROM INSERTED)
       AND PHYSICAL_DRIVE_INDEX = (SELECT PHYSICAL_DRIVE_INDEX FROM INSERTED)
END
go

DROP TABLE HP_STORAGE_SYSTEM
go
 
CREATE TABLE HP_STORAGE_SYSTEM (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	STORAGE_INDEX		INTEGER NOT NULL ,
	MODEL				VARCHAR(17) NULL ,
	CONTROLLER_SLOT		INTEGER NULL ,
	SCSI_BUS_INDEX		INTEGER NULL ,
	FIRMWARE_REV		VARCHAR(8) NULL ,
	CONNECT_TYPE		VARCHAR(8) NULL,
	VENDOR			VARCHAR(9) NULL,
	RECORD_TIME          DATETIME     DEFAULT GETDATE(),
CONSTRAINT HPSTORAGESYSTEM_PK PRIMARY KEY(COMPUTER_SYS_ID, STORAGE_INDEX),
CONSTRAINT HPSTORAGESYSTEM_FK FOREIGN KEY(COMPUTER_SYS_ID)
REFERENCES COMPUTER(COMPUTER_SYS_ID))
go

DROP TRIGGER HPSTORAGESYSTEM_TR
go
CREATE TRIGGER HPSTORAGESYSTEM_TR ON HP_STORAGE_SYSTEM
FOR UPDATE AS
BEGIN
       UPDATE HP_STORAGE_SYSTEM SET RECORD_TIME = GETDATE()
       WHERE COMPUTER_SYS_ID = (SELECT COMPUTER_SYS_ID FROM INSERTED)
       AND STORAGE_INDEX = (SELECT STORAGE_INDEX FROM INSERTED)
END
go

DROP TABLE HP_SOFTWARE_VERSIONS
go
 
CREATE TABLE HP_SOFTWARE_VERSIONS (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	NAME				VARCHAR(127) NOT NULL ,
	DESCRIPTION			VARCHAR(127) NULL ,
	VERSION			VARCHAR(50) NULL,
	RECORD_TIME          DATETIME     DEFAULT GETDATE(),
CONSTRAINT HPSOFTWAREVERSIONS_PK PRIMARY KEY(COMPUTER_SYS_ID, NAME),
CONSTRAINT HPSOFTWAREVERSIONS_FK FOREIGN KEY(COMPUTER_SYS_ID)
REFERENCES COMPUTER(COMPUTER_SYS_ID))
go

DROP TRIGGER HPSOFTWAREVERSIONS_TR
go
CREATE TRIGGER HPSOFTWAREVERSIONS_TR ON HP_SOFTWARE_VERSIONS
FOR UPDATE AS
BEGIN
       UPDATE HP_SOFTWARE_VERSIONS SET RECORD_TIME = GETDATE()
       WHERE COMPUTER_SYS_ID = (SELECT COMPUTER_SYS_ID FROM INSERTED)
       AND NAME = (SELECT NAME FROM INSERTED)
END
go

DROP TABLE HP_RIB_INFO
go
 
CREATE TABLE HP_RIB_INFO (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	SERIAL_NUMBER		VARCHAR(24) NULL ,
	FIRMWARE_REV		VARCHAR(24) NULL ,
	VIDEO_STATUS		VARCHAR(24) NULL ,
	KEYBOARD_STATUS		VARCHAR(24) NULL ,
	ALERT_STATUS		VARCHAR(24) NULL ,
	BATTERY_STATUS		VARCHAR(24) NULL,
	RECORD_TIME          DATETIME     DEFAULT GETDATE(),
CONSTRAINT HPRIBINFO_PK PRIMARY KEY(COMPUTER_SYS_ID),
CONSTRAINT HPRIBINFO_FK FOREIGN KEY(COMPUTER_SYS_ID)
REFERENCES COMPUTER(COMPUTER_SYS_ID))
go

DROP TRIGGER HPRIBINFO_TR
go
CREATE TRIGGER HPRIBINFO_TR ON HP_RIB_INFO
FOR UPDATE AS
BEGIN
       UPDATE HP_RIB_INFO SET RECORD_TIME = GETDATE()
       WHERE COMPUTER_SYS_ID = (SELECT COMPUTER_SYS_ID FROM INSERTED)
END
go

DROP TABLE HP_CLUSTER_SUBSYSTEM
go
 
CREATE TABLE HP_CLUSTER_SUBSYSTEM (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	NODE_NAME			VARCHAR(24) NULL ,
	NODE_INDEX			INTEGER NULL ,
	CLUSTER_NAME		VARCHAR(64) NULL ,
	CLUSTER_IP_ADDR		VARCHAR(64) NULL,
	RECORD_TIME          DATETIME     DEFAULT GETDATE(),
CONSTRAINT HPCLUSTERSUBSYSTEM_PK PRIMARY KEY(COMPUTER_SYS_ID),
CONSTRAINT HPCLUSTERSUBSYSTEM_FK FOREIGN KEY(COMPUTER_SYS_ID)
REFERENCES COMPUTER(COMPUTER_SYS_ID))
go

DROP TRIGGER HPCLUSTERSUBSYSTEM_TR
go
CREATE TRIGGER HPCLUSTERSUBSYSTEM_TR ON HP_CLUSTER_SUBSYSTEM
FOR UPDATE AS
BEGIN
       UPDATE HP_CLUSTER_SUBSYSTEM SET RECORD_TIME = GETDATE()
       WHERE COMPUTER_SYS_ID = (SELECT COMPUTER_SYS_ID FROM INSERTED)
END
go

DROP TABLE HP_CLUSTER_INTERCONNECT
go
 
CREATE TABLE HP_CLUSTER_INTERCONNECT (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	INTERCONN_PHYSICAL_ID	VARCHAR(64) NULL  ,
	INTERCONN_TRANSPORT	VARCHAR(64) NULL ,
	INTERCONN_ADDRESS		VARCHAR(64) NULL,
	RECORD_TIME          DATETIME     DEFAULT GETDATE(),
CONSTRAINT HPCLUSTERINTERCONNECT_PK PRIMARY KEY(COMPUTER_SYS_ID),
CONSTRAINT HPCLUSTERINTERCONNECT_FK FOREIGN KEY(COMPUTER_SYS_ID)
REFERENCES COMPUTER(COMPUTER_SYS_ID))
go

DROP TRIGGER HPCLUSTERINTERCONNECT_TR
go
CREATE TRIGGER HPCLUSTERINTERCONNECT_TR ON HP_CLUSTER_INTERCONNECT
FOR UPDATE AS
BEGIN
       UPDATE HP_CLUSTER_INTERCONNECT SET RECORD_TIME = GETDATE()
       WHERE COMPUTER_SYS_ID = (SELECT COMPUTER_SYS_ID FROM INSERTED)
END
go

DROP TABLE HP_FCA_CONTROLLER
go
 
CREATE TABLE HP_FCA_CONTROLLER (
      COMPUTER_SYS_ID      	VARCHAR(64) NOT NULL,
	MODEL				VARCHAR(64) NULL ,
	FIRMWARE_REV		VARCHAR(5) NULL ,
	SERIAL_NUMBER		VARCHAR(32) NULL ,
	SLOT_INDEX			INTEGER NOT NULL,
	RECORD_TIME          DATETIME     DEFAULT GETDATE(),
CONSTRAINT HPFCACONTROLLER_PK PRIMARY KEY(COMPUTER_SYS_ID, SLOT_INDEX),
CONSTRAINT HPFCACONTROLLER_FK FOREIGN KEY(COMPUTER_SYS_ID)
REFERENCES COMPUTER(COMPUTER_SYS_ID))
go

DROP TRIGGER HPFCACONTROLLER_TR
go
CREATE TRIGGER HPFCACONTROLLER_TR ON HP_FCA_CONTROLLER
FOR UPDATE AS
BEGIN
       UPDATE HP_FCA_CONTROLLER SET RECORD_TIME = GETDATE()
       WHERE COMPUTER_SYS_ID = (SELECT COMPUTER_SYS_ID FROM INSERTED)
       AND SLOT_INDEX = (SELECT SLOT_INDEX FROM INSERTED)
END
go

DROP TABLE HP_FCA_HOST_CONTROLLER
go
 
CREATE TABLE HP_FCA_HOST_CONTROLLER (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	MODEL				VARCHAR(72) NULL ,
	SLOT_INDEX			INTEGER NOT NULL ,
	WORLD_WIDE_NAME		VARCHAR(17) NULL,
	RECORD_TIME          DATETIME     DEFAULT GETDATE(),
CONSTRAINT HPFCAHOSTCONTROLLER_PK PRIMARY KEY(COMPUTER_SYS_ID, SLOT_INDEX),
CONSTRAINT HPFCAHOSTCONTROLLER_FK FOREIGN KEY(COMPUTER_SYS_ID)
REFERENCES COMPUTER(COMPUTER_SYS_ID))
go

DROP TRIGGER HPFCAHOSTCONTROLLER_TR
go
CREATE TRIGGER HPFCAHOSTCONTROLLER_TR ON HP_FCA_HOST_CONTROLLER
FOR UPDATE AS
BEGIN
       UPDATE HP_FCA_HOST_CONTROLLER SET RECORD_TIME = GETDATE()
       WHERE COMPUTER_SYS_ID = (SELECT COMPUTER_SYS_ID FROM INSERTED)
       AND SLOT_INDEX = (SELECT SLOT_INDEX FROM INSERTED)
END
go

DROP TABLE HP_FCA_LOGICAL_DRIVES
go
 
CREATE TABLE HP_FCA_LOGICAL_DRIVES (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	STORAGE_BOX_INDEX		INTEGER NOT NULL ,
	LOGICAL_DRIVE_INDEX	INTEGER NOT NULL ,
	FAULT_TOLERANCE		VARCHAR(24) NULL ,
	LOGICAL_DRIVE_SIZE	VARCHAR(10) NULL ,
	PHYSICAL_DRIVE_IDS	VARCHAR(10) NULL ,
	ACCELERATOR_STATUS	VARCHAR(16) NULL,
	RECORD_TIME          DATETIME     DEFAULT GETDATE(), 
CONSTRAINT HPFCALOGICALDRIVES_PK PRIMARY KEY(COMPUTER_SYS_ID, STORAGE_BOX_INDEX, LOGICAL_DRIVE_INDEX),
CONSTRAINT HPFCALOGICALDRIVES_FK FOREIGN KEY(COMPUTER_SYS_ID)
REFERENCES COMPUTER(COMPUTER_SYS_ID))
go

DROP TRIGGER HPFCALOGICALDRIVES_TR
go
CREATE TRIGGER HPFCALOGICALDRIVES_TR ON HP_FCA_LOGICAL_DRIVES
FOR UPDATE AS
BEGIN
       UPDATE HP_FCA_LOGICAL_DRIVES SET RECORD_TIME = GETDATE()
       WHERE COMPUTER_SYS_ID = (SELECT COMPUTER_SYS_ID FROM INSERTED)
       AND STORAGE_BOX_INDEX = (SELECT STORAGE_BOX_INDEX FROM INSERTED)
	 AND LOGICAL_DRIVE_INDEX = (SELECT LOGICAL_DRIVE_INDEX FROM INSERTED)
END
go

DROP TABLE HP_FCA_PHYSICAL_DRIVES
go
 
CREATE TABLE HP_FCA_PHYSICAL_DRIVES (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	STORAGE_BOX_INDEX		INTEGER NOT NULL ,
	DRIVE_INDEX			INTEGER NOT NULL ,
	MODEL				VARCHAR(41) NULL ,
	DRIVE_SIZE			VARCHAR(10) NULL ,
	FIRMWARE_REV		VARCHAR(9) NULL ,
	SERIAL_NUMBER		VARCHAR(41) NULL,
	DRIVE_SPEED			VARCHAR(8) NULL,
	DRIVE_TYPE			VARCHAR(8) NULL,
	SATA_VERSION		VARCHAR(8) NULL,
	RECORD_TIME          DATETIME     DEFAULT GETDATE(),
CONSTRAINT HPFCAPHYSICALDRIVES_PK PRIMARY KEY(COMPUTER_SYS_ID, STORAGE_BOX_INDEX, DRIVE_INDEX),
CONSTRAINT HPFCAPHYSICALDRIVES_FK FOREIGN KEY(COMPUTER_SYS_ID)
REFERENCES COMPUTER(COMPUTER_SYS_ID))
go

DROP TRIGGER HPFCAPHYSICALDRIVES_TR
go
CREATE TRIGGER HPFCAPHYSICALDRIVES_TR ON HP_FCA_PHYSICAL_DRIVES
FOR UPDATE AS
BEGIN
       UPDATE HP_FCA_PHYSICAL_DRIVES SET RECORD_TIME = GETDATE()
       WHERE COMPUTER_SYS_ID = (SELECT COMPUTER_SYS_ID FROM INSERTED)
       AND STORAGE_BOX_INDEX = (SELECT STORAGE_BOX_INDEX FROM INSERTED)
	 AND DRIVE_INDEX = (SELECT DRIVE_INDEX FROM INSERTED)
END
go

DROP TABLE HP_PORTABLE_BATTERIES
go
 
CREATE TABLE HP_PORTABLE_BATTERIES (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	BATTERY_INDEX		INTEGER NULL ,
	MANUFACTURER		VARCHAR(80) NULL ,
	BATTERY_DATE		VARCHAR(10) NULL ,
	SERIAL_NUMBER		VARCHAR(16) NULL ,
	ASSET_TAG			VARCHAR(16) NULL ,
	CHEMISTRY			VARCHAR(80) NULL,
	RECORD_TIME          DATETIME     DEFAULT GETDATE(),
CONSTRAINT HPPORTABLEBATTERIES_PK PRIMARY KEY(COMPUTER_SYS_ID),
CONSTRAINT HPPORTABLEBATTERIES_FK FOREIGN KEY(COMPUTER_SYS_ID)
REFERENCES COMPUTER(COMPUTER_SYS_ID))
go

DROP TRIGGER HPPORTABLEBATTERIES_TR
go
CREATE TRIGGER HPPORTABLEBATTERIES_TR ON HP_PORTABLE_BATTERIES
FOR UPDATE AS
BEGIN
       UPDATE HP_PORTABLE_BATTERIES SET RECORD_TIME = GETDATE()
       WHERE COMPUTER_SYS_ID = (SELECT COMPUTER_SYS_ID FROM INSERTED)
END
go

DROP TABLE HP_DOCKING_STATION
go
 
CREATE TABLE HP_DOCKING_STATION (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	DOCK_STATUS			VARCHAR(8) NULL ,
	MODEL_NAME			VARCHAR(128) NULL ,
	SERIAL_NUMBER		VARCHAR(16) NULL ,
	ASSET_TAG			VARCHAR(16) NULL ,
	ROM_REVISION		VARCHAR(10) NULL,
	RECORD_TIME          DATETIME     DEFAULT GETDATE(),
CONSTRAINT HPDOCKINGSTATION_PK PRIMARY KEY(COMPUTER_SYS_ID),
CONSTRAINT HPDOCKINGSTATION_FK FOREIGN KEY(COMPUTER_SYS_ID)
REFERENCES COMPUTER(COMPUTER_SYS_ID))
go

DROP TRIGGER HPDOCKINGSTATION_TR
go
CREATE TRIGGER HPDOCKINGSTATION_TR ON HP_DOCKING_STATION
FOR UPDATE AS
BEGIN
       UPDATE HP_DOCKING_STATION SET RECORD_TIME = GETDATE()
       WHERE COMPUTER_SYS_ID = (SELECT COMPUTER_SYS_ID FROM INSERTED)
END
go

DROP TABLE HP_PORTABLE_PC_CARD_SLOTS
go
 
CREATE TABLE HP_PORTABLE_PC_CARD_SLOTS (
      COMPUTER_SYS_ID      	VARCHAR(64)  NOT NULL,
	PC_CARD_INDEX		INTEGER NULL ,
	SLOT_LOCATION		VARCHAR(40) NULL ,
	CARD_PRESENCE		VARCHAR(3) NULL ,
	CARD_STATUS			VARCHAR(80) NULL ,
	MANUFACTURER_NAME		VARCHAR(80) NULL ,
	DEVICE_NAME			VARCHAR(80) NULL,
	RECORD_TIME             DATETIME     DEFAULT GETDATE(),
CONSTRAINT HPPORTABLEPCCARDSLOTS_PK PRIMARY KEY(COMPUTER_SYS_ID),
CONSTRAINT HPPORTABLEPCCARDSLOTS_FK FOREIGN KEY(COMPUTER_SYS_ID)
REFERENCES COMPUTER(COMPUTER_SYS_ID))
go

DROP TRIGGER HPPORTABLEPCCARDSLOTS_TR
go
CREATE TRIGGER HPPORTABLEPCCARDSLOTS_TR ON HP_PORTABLE_PC_CARD_SLOTS
FOR UPDATE AS
BEGIN
       UPDATE HP_PORTABLE_PC_CARD_SLOTS SET RECORD_TIME = GETDATE()
       WHERE COMPUTER_SYS_ID = (SELECT COMPUTER_SYS_ID FROM INSERTED)
END
go

delete from INVENTORY_TABLES where TABLE_NAME = 'HP_CPU'
go
delete from INVENTORY_TABLES where TABLE_NAME = 'HP_EISA_PCI_SLOTS'
go
delete from INVENTORY_TABLES where TABLE_NAME = 'HP_SYSTEM'
go
delete from INVENTORY_TABLES where TABLE_NAME = 'HP_MEMORY_MODULES'
go
delete from INVENTORY_TABLES where TABLE_NAME = 'HP_IDE_DEVICES'
go
delete from INVENTORY_TABLES where TABLE_NAME = 'HP_SCSI_DEVICES'
go
delete from INVENTORY_TABLES where TABLE_NAME = 'HP_VIDEO_MONITOR'
go
delete from INVENTORY_TABLES where TABLE_NAME = 'HP_HEALTH_SUBSYSTEM'
go
delete from INVENTORY_TABLES where TABLE_NAME = 'HP_DRIVE_ARRAY_CONTROLLER'
go
delete from INVENTORY_TABLES where TABLE_NAME = 'HP_DA_LOGICAL'
go
delete from INVENTORY_TABLES where TABLE_NAME = 'HP_DA_PHYSICAL'
go
delete from INVENTORY_TABLES where TABLE_NAME = 'HP_ATA_DISK'
go
delete from INVENTORY_TABLES where TABLE_NAME = 'HP_SAS_HBA'
go
delete from INVENTORY_TABLES where TABLE_NAME = 'HP_SAS_LOG_DRV'
go
delete from INVENTORY_TABLES where TABLE_NAME = 'HP_SAS_PHY_DRV'
go
delete from INVENTORY_TABLES where TABLE_NAME = 'HP_STORAGE_SYSTEM'
go
delete from INVENTORY_TABLES where TABLE_NAME = 'HP_SOFTWARE_VERSIONS'
go
delete from INVENTORY_TABLES where TABLE_NAME = 'HP_RIB_INFO'
go
delete from INVENTORY_TABLES where TABLE_NAME = 'HP_CLUSTER_SUBSYSTEM'
go
delete from INVENTORY_TABLES where TABLE_NAME = 'HP_FCA_CONTROLLER'
go
delete from INVENTORY_TABLES where TABLE_NAME = 'HP_CLUSTER_INTERCONNECT'
go
delete from INVENTORY_TABLES where TABLE_NAME = 'HP_FCA_HOST_CONTROLLER'
go
delete from INVENTORY_TABLES where TABLE_NAME = 'HP_FCA_LOGICAL_DRIVES'
go
delete from INVENTORY_TABLES where TABLE_NAME = 'HP_FCA_PHYSICAL_DRIVES'
go
delete from INVENTORY_TABLES where TABLE_NAME = 'HP_PORTABLE_BATTERIES'
go
delete from INVENTORY_TABLES where TABLE_NAME = 'HP_DOCKING_STATION'
go
delete from INVENTORY_TABLES where TABLE_NAME = 'HP_PORTABLE_PC_CARD_SLOTS'
go

insert into INVENTORY_TABLES (TABLE_NAME) values ('HP_CPU')
insert into INVENTORY_TABLES (TABLE_NAME) values ('HP_EISA_PCI_SLOTS')
insert into INVENTORY_TABLES (TABLE_NAME) values ('HP_SYSTEM')
insert into INVENTORY_TABLES (TABLE_NAME) values ('HP_MEMORY_MODULES')
insert into INVENTORY_TABLES (TABLE_NAME) values ('HP_IDE_DEVICES')
insert into INVENTORY_TABLES (TABLE_NAME) values ('HP_SCSI_DEVICES')
insert into INVENTORY_TABLES (TABLE_NAME) values ('HP_VIDEO_MONITOR')
insert into INVENTORY_TABLES (TABLE_NAME) values ('HP_HEALTH_SUBSYSTEM')
insert into INVENTORY_TABLES (TABLE_NAME) values ('HP_DRIVE_ARRAY_CONTROLLER')
insert into INVENTORY_TABLES (TABLE_NAME) values ('HP_DA_LOGICAL')
insert into INVENTORY_TABLES (TABLE_NAME) values ('HP_DA_PHYSICAL')
insert into INVENTORY_TABLES (TABLE_NAME) values ('HP_ATA_DISK')
insert into INVENTORY_TABLES (TABLE_NAME) values ('HP_SAS_HBA')
insert into INVENTORY_TABLES (TABLE_NAME) values ('HP_SAS_LOG_DRV')
insert into INVENTORY_TABLES (TABLE_NAME) values ('HP_SAS_PHY_DRV')
insert into INVENTORY_TABLES (TABLE_NAME) values ('HP_STORAGE_SYSTEM')
insert into INVENTORY_TABLES (TABLE_NAME) values ('HP_SOFTWARE_VERSIONS')
insert into INVENTORY_TABLES (TABLE_NAME) values ('HP_RIB_INFO')
insert into INVENTORY_TABLES (TABLE_NAME) values ('HP_CLUSTER_SUBSYSTEM')
insert into INVENTORY_TABLES (TABLE_NAME) values ('HP_FCA_CONTROLLER')
insert into INVENTORY_TABLES (TABLE_NAME) values ('HP_CLUSTER_INTERCONNECT')
insert into INVENTORY_TABLES (TABLE_NAME) values ('HP_FCA_HOST_CONTROLLER')
insert into INVENTORY_TABLES (TABLE_NAME) values ('HP_FCA_LOGICAL_DRIVES')
insert into INVENTORY_TABLES (TABLE_NAME) values ('HP_FCA_PHYSICAL_DRIVES')
insert into INVENTORY_TABLES (TABLE_NAME) values ('HP_PORTABLE_BATTERIES')
insert into INVENTORY_TABLES (TABLE_NAME) values ('HP_DOCKING_STATION')
insert into INVENTORY_TABLES (TABLE_NAME) values ('HP_PORTABLE_PC_CARD_SLOTS')
go

