@echo off
REM !/bin/sh
REM /* ****************************************************************************
REM /*
REM /*                  Insight Integration for OpenView NNM
REM /*
REM /*      Copyright 1996,2003 Hewlett-Packard Development Company, L.P.
REM /*
REM /*      Hewlett-Packard Company shall not be liable for technical or
REM /*      editorial errors or omissions contained herein. The information in
REM /*      this document is provided "as is" without warranty of any kind and
REM /*      is subject to change without notice. The warranties for HP products
REM /*      are set forth in the express limited warranty statements
REM /*      accompanying such products. Nothing herein should be construed as
REM /*      constituting an additional warranty.
REM /*
REM /*      Confidential computer software. Valid license from HP required for
REM /*      possession, use or copying. Consistent with FAR 12.211 and 12.212,
REM /*      Commercial Computer Software, Computer Software Documentation, and
REM /*      Technical Data for Commercial Items are licensed to the U.S.
REM /*      Government under vendor's standard commercial license.
REM /*
REM /* **************************************************************************
REM /*                                                                        
REM /* PROPRIETARY NOTE:                                                      
REM /*     This document contains information confidential and proprietary to 
REM /*     Hewlett-Packard and shall not be reproduced or transferred to other
REM /*     documents or disclosed to others or used for any purpose other than 
REM /*     that for which it was obtained without the expressed written consent
REM /*     of Hewlett-Packard Company.
REM /*                                                                        
REM /* **************************************************************************
REM /*
REM 
REM  *                                  cpqchkreg       - Presence of Registration File Check 
REM  *                                  cpqchkconf      - Syntax check for cpqconfig.dat 
REM  *                                  cpqchktconf     - Syntax check for cpqtrapd.conf 
REM  *                                  cpqchkstr       - Syntax check for cpqval2str.info 
REM  *                               and cpqval2str.trap
REM  *                          

set LANG=C

set FLAG=1

set CPQ_CONF=%OV_CONF%\%LANG%\cpq


REM =========================================================================
REM  cpqchkreg - Check for the presence of all necessary registration files.
REM  ---------
REM  Output:
REM     On success
REM             "Essential registration files for necessary present"
REM     On failure
REM             "Following registration files for necessary not found."
REM                                             <file 1>
REM                                             <file 2>
REM =========================================================================
@echo off
echo "Checking for the presence of necessary registration files...."
echo -
@echo off
if not exist cpqchkreg.bat echo "Error: Missing executable cpqchkreg.bat"
@echo off
if not exist cpqchkreg.bat echo "Check for presence of registration files failed"
@echo off
if exist cpqchkreg.bat call cpqchkreg.bat
@echo off

REM =========================================================================
REM  cpqchkconf - Checks for syntax of cpqconfig.dat
REM  ----------
REM  Output:
REM     On not finding the executable
REM             "Error: Missing executable cpqchkconf"
REM     On not finding the file
REM             "Error: Missing configuration file cpqconfig.dat."
REM     On encountering any syntax error 
REM             "Error: cpqconfig.dat <line no>"
REM     On success
REM             "cpqconfig.dat passed syntax check"
REM =========================================================================
@echo off
echo "Validating Syntax of cpqconfig.dat...."
echo -
@echo off
if not exist cpqchkconf.exe echo "Error: Missing executable cpqchkconf.exe"
@echo off
if not exist cpqchkconf.exe echo "cpqconfig.dat Syntax  Check failed"
@echo off
if exist cpqchkconf.exe cpqchkconf.exe
@echo off
REM =========================================================================
REM  cpqchktconf - Checks for syntax of cpqtrapd.conf
REM  -----------
REM  Output:
REM     On not finding the executable
REM             "Error: Missing executable cpqchktconf"
REM     On not finding the file
REM             "Error: Missing configuration file cpqtrapd.conf."
REM     On encountering any syntax error 
REM             "Error: cpqtrapd.conf <line no>"
REM     On success
REM             "cpqtrapd.conf passed syntax check"
REM =========================================================================
@echo off
echo "Validating Syntax of cpqtrapd.conf...."
echo -
@echo off
if not exist cpqchktconf.exe echo "Error: Missing executable cpqchktconf.exe"
@echo off
if not exist cpqchktconf.exe echo "cpqtrapd.conf Syntax  Check failed"
@echo off
if exist cpqchktconf.exe cpqchktconf.exe 
@echo off
REM ======================================================================== 
REM  cpqchkstr - Checks for syntax of cpqval2str.info and cpqval2str.trap
REM  ---------
REM  Output:
REM     On not finding the executable
REM             "Error: Missing executable cpqchkstr
REM     On not finding the file
REM             "Error: Missing configuration file cpqval2str.info and cpqval2str.trap"
REM     On encountering any syntax error
REM             "Error: cpqval2str.info/cpqval2str.trap  <line no>"
REM     On success
REM             "cpqval2str.info/cpqval2str.trap passed syntax check"
REM =========================================================================
@echo off
echo "Validating Syntax of cpqval2str.trap"
echo -
@echo off
if not exist cpqchkstr.exe echo "Error: Missing executable cpqchkstr.exe"
@echo off
if exist cpqchkstr.exe cpqchkstr.exe
@echo off
