#!/bin/sh

if [ "`id -nu`" != "root" ]; then
        echo
        echo "ERROR: This script must be executed as the 'root' superuser."
        exit 1
fi

if [ -f ProLiant_p-GbE2_Interconnect_Switch_Doc*.rpm ]; then
        echo
        echo "ProLiant p-Class GbE2 Interconnect Switch Documentation Installation, version 2.1.0"
        echo ================================================================================
        echo

        echo "Press N (Enter) to skip documentation install.  Press (Enter) to continue."

        read x
        if [ "$x" != "n" -a "$x" != "N" ]; then
                rpm -U --force ProLiant_p-GbE2_Interconnect_Switch_Doc*.rpm
                rpm -qa | grep ProLiant_p-GbE2_Interconnect_Switch_Doc > /dev/null
                if [ $? = 0 ]; then
                        echo
                        echo Installation to /usr/local/ProLiant/Interconnect_Switch/Documentation/p-GbE2/version2.1.0 complete.
                        echo
                else
                        echo
                        echo "ERROR: The following packages were not installed succesfully:"
                        echo
                        echo     ProLiant_p-GbE2_Interconnect_Switch_Doc*.rpm
                        echo
                fi
        fi
fi

echo
echo "ProLiant p-Class GbE2 Interconnect Switch Utilities Installation, version 2.1.0"
echo ================================================================================
echo
echo "Press N (Enter) to exit installation.  Press (Enter) to continue."

read x
if [ "$x" = "n" -o "$x" = "N" ]; then
        exit 1
fi

rpm -U --force ProLiant_p-GbE2_Interconnect_Switch_Utilities*.rpm
rpm -qa | grep p-GbE2_Interconnect_Switch_Utilities > /dev/null
if [ $? = 0 ]; then
        echo
        echo Installation to /usr/local/ProLiant/Interconnect_Switch/Utilities/p-GbE2/version2.1.0 complete.
        echo
        exit 0
else
        echo
        echo "ERROR: The following packages were not installed succesfully:"
        echo
        echo     ProLiant_p-GbE2_Interconnect_Switch_Utilities*.rpm
        echo
        exit 1
fi
