// $RCSfile: CHPSTOR.TPL $ $Revision: 1.5 $
// (C) Copyright 2003 Hewlett-Packard Development Company, L.P.
// end of script hiding --->

<!cpqIdeControllerEntry>
<!cpqScsiCntlrEntry>
<!cpqDaCntlrEntry>
<!cpqSsChassisEntry>
<!cpqSsRaidSystemEntry>
<!cpqFcTapeCntlrEntry>
<!cpqFcaHostCntlrEntry>
<!cpqSsScsiAttachmentEntry>
<!cpqFcaCntlrEntry>

function IsDuplicate(index, list, count)
{
   var n;
   for (n = 0; n < count; n++)
      if (list[n] == index)  return true;
   return false;
}
function pathCondition(status)
{
   var condition = 1;
   if (status == 2) condition = 2;
   else if (status == 5) condition = 3;
   else if (status == 3 || status == 4) condition = 4;
   return condition;
}
function ideCntrlName(idx)
{
   var index = parseInt(idx, 10) + 1;
   var name = cpqIdeControllerEntry[idx].cpqIdeControllerModel;
   if (cpqIdeControllerEntry[idx].cpqIdeControllerSlot > 0)
      name += " in Slot " + cpqIdeControllerEntry[idx].cpqIdeControllerSlot;
   else if (cpqIdeControllerEntry[idx].cpqIdeControllerSlot == 0)
      name += " on System Board";
   else // No slot number
      name += " (" + index + ")";
   return name;
}
function scsiCntrlName(idx)
{
   var name = "SCSI Controller ";
   name += (cpqScsiCntlrEntry[idx].cpqScsiCntlrSlot == 0 ? "on System Board" :
               "in Slot " + cpqScsiCntlrEntry[idx].cpqScsiCntlrSlot);
   name += " Port " + cpqScsiCntlrEntry[idx].cpqScsiCntlrBusIndex;
   return name;
}
daModel = new Array;
daModel[1]="Unknown";
daModel[2]="IDA";
daModel[3]="IDA Expansion";
daModel[4]="IDA-2";
daModel[5]="SMART";
daModel[6]="SMART-2/E";
daModel[7]="SMART-2/P";
daModel[8]="SMART-2SL";
daModel[9]="SMART-3100ES";
daModel[10]="SMART-3200";
daModel[11]="SMART-2DH";
daModel[12]="SMART-221";
daModel[13]="Smart Array 4250ES";
daModel[14]="Smart Array 4200";
daModel[15]="Integrated Smart Array";
daModel[16]="Smart Array 431";
daModel[17]="Smart Array 5300";
daModel[18]="RAID LC2";
daModel[19]="Smart Array 5i";
daModel[20]="Smart Array 532";
daModel[21]="Smart Array 5312";
daModel[22]="Smart Array 641";
daModel[23]="Smart Array 642";
daModel[24]="Smart Array 6400";

function daCntrlModel(idx)
{
   var model = "Unknown";
   if (idx > 0 && idx < daModel.length)
      model = daModel[idx];
   return model;
}
function daCntrlName(idx)
{
   var name = daCntrlModel(cpqDaCntlrEntry[idx].cpqDaCntlrModel) + " Controller ";
   if (cpqDaCntlrEntry[idx].cpqDaCntlrHwLocation != "")
          name += "at "+ cpqDaCntlrEntry[idx].cpqDaCntlrHwLocation;
   else if (cpqDaCntlrEntry[idx].cpqDaCntlrSlot == 0)
      name += "on System Board";
   else
      name += "in Slot " + cpqDaCntlrEntry[idx].cpqDaCntlrSlot;

   with(cpqDaCntlrEntry[idx])
   {
      if (typeof(cpqDaCntlrCurrentRole) != "undefined")
      {
         if (cpqDaCntlrCurrentRole == 3 && cpqDaCntlrPartnerSlot != -1)
         {
            if (cpqDaCntlrPartnerSlot == 0)
               name += "/on System Board";
            else if (cpqDaCntlrSlot == 0)
               name += "/Slot " + cpqDaCntlrPartnerSlot;
            else
               name += "/" + cpqDaCntlrPartnerSlot;
         }
         if ((cpqDaCntlrCurrentRole == 3 || cpqDaCntlrCurrentRole == 4) &&
              cpqDaCntlrPartnerSlot == -1)
         {
            if (cpqDaCntlrRedundancyType == 3)
               name += "/Other Server";
            else
               name += "/Unknown";
         }
      }
   }
   return name;
}
function fcStSysName(idx)
{
   var i = parseInt(idx) + 1;
   var name = "Storage System ";
   if (idx >= 0 && idx < cpqSsChassisEntry.length)
      name += cpqSsChassisEntry[idx].cpqSsChassisName + " (" + i + ")";
   return name;
}
function fcTapeCntrlName(idx)
{
   var name = "Unknown";
   if (idx >= 0 && idx < cpqFcTapeCntlrEntry.length)
   {
      if (cpqFcTapeCntlrEntry[idx].cpqFcTapeCntlrType == 2)
         name = "FC Tape Controller";
      else if (cpqFcTapeCntlrEntry[idx].cpqFcTapeCntlrType == 3)
         name = "Modular Data Router";
      name +=" (" + cpqFcTapeCntlrEntry[idx].cpqFcTapeCntlrWWN + ")";
   }
   return name;
}

if (typeof(cpqIdeControllerEntry) != "undefined")
{
   for (i = 0; i < cpqIdeControllerEntry.length; i++)
   {
      idePage = "/WEBAGENT/SUBFRAME.TPL?currentSubmenu=/WEBAGENT/CQMGSTOR/MS-IDMNU.TPL&";
      idePage += "index="+cpqIdeControllerEntry[i].cpqIdeControllerIndex;
      AddDataEntry("SNMP Webagent", "Home::Storage::"+ideCntrlName(i),
         cpqIdeControllerEntry[i].cpqIdeControllerOverallCondition, idePage, "0");
   }
}
if (typeof(cpqScsiCntlrEntry) != "undefined")
{
   for (i = 0; i < cpqScsiCntlrEntry.length; i++)
   {
      scsipage = "/WEBAGENT/SUBFRAME.TPL?currentSubmenu=/WEBAGENT/CQMGSTOR/MS-SCMNU.TPL&";
      scsipage += "index="+cpqScsiCntlrEntry[i].cpqScsiCntlrIndex + "&bus="+cpqScsiCntlrEntry[i].cpqScsiCntlrBusIndex;
      AddDataEntry("SNMP Webagent", "Home::Storage::" + scsiCntrlName(i),
         cpqScsiCntlrEntry[i].cpqScsiCntlrCondition, scsipage, "0");
   }
}
if (typeof(cpqDaCntlrEntry) != "undefined")
{
   for (i = 0; i < cpqDaCntlrEntry.length; i++)
   {
      if (typeof(cpqDaCntlrEntry[i].cpqDaCntlrCurrentRole) != "undefined")
      {
         if (cpqDaCntlrEntry[i].cpqDaCntlrCurrentRole == 4)
            continue;   // don't display backups!
      }
      daPage = "/WEBAGENT/SUBFRAME.TPL?currentSubmenu=/WEBAGENT/CQMGSTOR/MS-DAMNU.TPL&";
      daPage += "index="+cpqDaCntlrEntry[i].cpqDaCntlrIndex;
      AddDataEntry("SNMP Webagent", "Home::Storage::" + daCntrlName(i),
         cpqDaCntlrEntry[i].cpqDaCntlrCondition, daPage, "0");
   }
}
if (typeof(cpqSsChassisEntry) != "undefined")
{
   for (i = 0; i < cpqSsChassisEntry.length; i++)
   {
      fcPage = "/WEBAGENT/SUBFRAME.TPL?currentSubmenu=/WEBAGENT/CQMGSTOR/MS-FCMNU.TPL&";
      fcPage += "index="+i;
      AddDataEntry("SNMP Webagent", "Home::Storage::" + fcStSysName(i),
         cpqSsChassisEntry[i].cpqSsChassisOverallCondition, fcPage, "0");
   }
}
if ( typeof(cpqSsRaidSystemEntry) != "undefined")
{
   if (cpqSsRaidSystemEntry.length > 0)
   {
      raidCond = 1;
      for (i = 0; i < cpqSsRaidSystemEntry.length; i++)
      {
         if (raidCond < cpqSsRaidSystemEntry[i].cpqSsRaidSystemCondition) raidCond = cpqSsRaidSystemEntry[i].cpqSsRaidSystemCondition;
      }
      AddDataEntry("SNMP Webagent", "Home::Storage::RA-8000 RAID Array Storage Systems", raidCond, "/WEBAGENT/CQMGSTOR/MS-RAIDS.TPL", "0");
   }
}
if (typeof(cpqFcTapeCntlrEntry) != "undefined")
{
   for (i = 0; i < cpqFcTapeCntlrEntry.length; i++)
   {
      fctapePage = "/WEBAGENT/SUBFRAME.TPL?currentSubmenu=/WEBAGENT/CQMGSTOR/MS-FTMNU.TPL&";
      fctapePage += "index="+i+ "&cntlrIndex="+cpqFcTapeCntlrEntry[i].cpqFcTapeCntlrIndex;
      AddDataEntry("SNMP Webagent", "Home::Storage::" + fcTapeCntrlName(i),
         cpqFcTapeCntlrEntry[i].cpqFcTapeCntlrOverallCondition, fctapePage, "0");
   }
}
// External Storage Connections
fcaHostCond = 0;

if (typeof(cpqFcaHostCntlrEntry) != "undefined")
{
   for (i = 0; i < cpqFcaHostCntlrEntry.length; i++)
   {
      if (fcaHostCond < cpqFcaHostCntlrEntry[i].cpqFcaHostCntlrCondition)
         fcaHostCond = cpqFcaHostCntlrEntry[i].cpqFcaHostCntlrCondition;
   }
}
listCount = 0;
fcaCntlCond = 0;
boxList = new Array();

if (typeof(cpqSsScsiAttachmentEntry) != "undefined" &&
    typeof(cpqFcaCntlrEntry) != "undefined")
{
   for (i = 0; i < cpqSsScsiAttachmentEntry.length; i++)
   {
      idx = cpqSsScsiAttachmentEntry[i].cpqSsScsiAttachmentChassisIndex;

      if (!IsDuplicate(idx, boxList, listCount))
      {
         boxList[listCount] = idx;
         listCount++;
         boxCond = 0;
         for (j = 0; j < cpqFcaCntlrEntry.length; j++)
         {
            if (cpqFcaCntlrEntry[j].cpqFcaCntlrBoxIndex == idx)
            {
               pathCond = pathCondition(cpqFcaCntlrEntry[j].cpqFcaCntlrStatus);
               if (boxCond == 0)
                  boxCond = pathCond;
               else if (boxCond == 1 && pathCond != 1)
                  boxCond = pathCond;
               else if ((boxCond == 2 && pathCond != 2) ||
                        (boxCond == 4 && pathCond != 4))
                  boxCond = 3;
            }
         }
         if (boxCond > fcaCntlCond) fcaCntlCond = boxCond;
      }
   }
}
if (fcaHostCond > 0 || fcaCntlCond > 0)
{
   cond = fcaHostCond;
   if (fcaCntlCond > fcaHostCond) cond = fcaCntlCond;
   AddDataEntry("SNMP Webagent", "Home::Storage::External Storage Connections", cond, "/WEBAGENT/CQMGSTOR/MS-FCCNT.TPL", "0");
}
