<html>
<!-- $RCSfile: MS-FCCTL.TPL $ $Revision: 1.18 $ -->
<!-- (C) Copyright 2003 Hewlett-Packard Development Company, L.P. -->
<head>
<title>Fibre Channel Controller Information</title>

<script language="JavaScript">
   writeAccess = (2 & <!cpqFcaCntlrBlinkTime.access>) != 0;
   if (writeAccess) noAutoRefresh = 1;
</script>

<!#/COMMON/PAGETAGS.TPL>

<script language="JavaScript">
contextHelp = true;

<!cpqSsChassisEntry>
<!cpqFcaCntlrEntry>
<!cpqFcaAccelEntry>

<!#/COMMON/COND.JS>
<!#/COMMON/STDITEMS.JS>
<!#/COMMON/TABLES.JS>
<!#/COMMON/PARSEARG.JS>
<!#/COMMON/DISPBASE.JS>
<!#FCAENUMS.JS>
<!#MS-FCCMN.JS>

postfix["cpqFcaAccelWriteCache"]  = "MB";
postfix["cpqFcaAccelReadCache"]   = "MB";
postfix["cpqFcaAccelTotalMemory"] = "MB";

function getIndex(form, boxIndex, ioSlot)
{
   form.INDEX.value = parseInt(boxIndex) + "." + parseInt(ioSlot);
   return true;
}
</script>
</head>
<script language="JavaScript">

writeBodyHead();

idx = findArg("index"); // the fc controller index passed in to the page

if (idx == -1)
{
   parseArgs(tryPrevPage());
   idx = findArg("index");
}
if (idx == -1 || idx >= cpqFcaCntlrEntry.length)
{
   reportMissingArgs();
}
else
{
   thisCntlr = cpqFcaCntlrEntry[idx];

   for (boxIndex = 0; boxIndex < cpqSsChassisEntry.length; boxIndex++)
   {
      if (thisCntlr.cpqFcaCntlrBoxIndex == cpqSsChassisEntry[boxIndex].cpqSsChassisIndex )
         break;
   }
   cntlrCondition = new cpqCondition(thisCntlr.cpqFcaCntlrCondition);

   writePageHead(fcChassisName(boxIndex), "/WEBAGENT/IMAGES/MASSHDR.GIF", "Fibre Channel Controller");

   duplexed = false;
   if (typeof(cpqFcaCntlrEntry[idx].cpqFcaCntlrCurrentRole != "undefined") &&
       cpqFcaCntlrEntry[idx].cpqFcaCntlrCurrentRole != null &&
       cpqFcaCntlrEntry[idx].cpqFcaCntlrCurrentRole != "")
   {
      duplexed = true;
   }
   writeTableLabel(cntlrCondition.image() + fcCntlrName(idx));
   writeTableHead();

   writeSingleTableRowInDoubleTable(
      "Model:", displayItem("cpqFcaCntlrModel", thisCntlr.cpqFcaCntlrModel));

   if (duplexed)
   {
      writeDoubleTableRow(
         "Controller Status:", displayItem("cpqFcaCntlrStatus", thisCntlr.cpqFcaCntlrStatus),
         "Redundancy Mode:",   displayItem("cpqFcaCntlrRedundancyType", thisCntlr.cpqFcaCntlrRedundancyType));
      writeDoubleTableRow(
         "Current Role:",     displayItem("cpqFcaCntlrCurrentRole", thisCntlr.cpqFcaCntlrCurrentRole),
         "Redundancy Error:", displayItem("cpqFcaCntlrRedundancyError", thisCntlr.cpqFcaCntlrRedundancyError));
   }
   writeDoubleTableRow(
      "Firmware Version:", displayItem("cpqFcaCntlrFWRev", thisCntlr.cpqFcaCntlrFWRev),
      "World Wide Port Name:",  displayItem("cpqFcaCntlrWorldWideName", thisCntlr.cpqFcaCntlrWorldWideName));
   writeDoubleTableRow(
      "Serial Number:",    displayItem("cpqFcaCntlrSerialNumber", thisCntlr.cpqFcaCntlrSerialNumber),
      "World Wide Node Name:",  displayItem("cpqFcaCntlrWorldWideNodeName", thisCntlr.cpqFcaCntlrWorldWideNodeName));
   writeDoubleTableRow(
      "Product Revision:",      displayItem("cpqFcaCntlrProductRev", thisCntlr.cpqFcaCntlrProductRev),
      "", "");
   writeTableTail();

   // Write accelerator table
   accelIndex = -1;
   thisAccelCondition = new cpqCondition(1);

   for (i = 0; i < cpqFcaAccelEntry.length; i++)
   {
      if (cpqFcaAccelEntry[i].cpqFcaAccelBoxIndex  == thisCntlr.cpqFcaCntlrBoxIndex &&
          cpqFcaAccelEntry[i].cpqFcaAccelBoxIoSlot == thisCntlr.cpqFcaCntlrBoxIoSlot)
      {
         accelIndex = i;
         break;
      }
   }
   document.write("<br>");
   if (accelIndex >= 0 && accelIndex < cpqFcaAccelEntry.length)
   {
      thisAccel = cpqFcaAccelEntry[accelIndex];
      thisAccelCondition.set(thisAccel.cpqFcaAccelCondition);

      writeTableLabel(thisAccelCondition.imageSmall()+"Accelerator", "Accelerator");
      writeTableHead();
      writeDoubleTableRow(
        "Status:",         displayItem("cpqFcaAccelStatus", thisAccel.cpqFcaAccelStatus),
        "Battery Status:", displayItem("cpqFcaAccelBatteryStatus", thisAccel.cpqFcaAccelBatteryStatus));
      writeDoubleTableRow(
        "Serial Number:", displayItem("cpqFcaAccelSerialNumber", thisAccel.cpqFcaAccelSerialNumber),
        "Read Errors:",   displayItem("cpqFcaAccelReadErrs", thisAccel.cpqFcaAccelReadErrs));
      writeDoubleTableRow(
        "Total Memory:", displayItem("cpqFcaAccelTotalMemory", thisAccel.cpqFcaAccelTotalMemory),
        "Write Errors:", displayItem("cpqFcaAccelWriteErrs", thisAccel.cpqFcaAccelWriteErrs));
      writeDoubleTableRow(
        "Read Cache:",   displayItem("cpqFcaAccelReadCache", thisAccel.cpqFcaAccelReadCache),
        "Error Code:",   displayItem("cpqFcaAccelErrCode", thisAccel.cpqFcaAccelErrCode));
      writeDoubleTableRow(
        "Write Cache:",  displayItem("cpqFcaAccelWriteCache", thisAccel.cpqFcaAccelWriteCache),
        "Bad Data:",     displayItem("cpqFcaAccelBadData", thisAccel.cpqFcaAccelBadData));
      writeTableTail();
   }

   if (thisCntlr.cpqFcaCntlrBlinkTime != "" && thisCntlr.cpqFcaCntlrBlinkTime < 4294967295)
   {
      document.write("<br>");
      writeTableLabel("Identify Drives");
      writeTableHead();
      if (thisCntlr.cpqFcaCntlrBlinkTime > 1)
         imgStr = "<img src='/WEBAGENT/CQMGSTOR/ENG/DRVBLINK.GIF' width='72' height='42' border='0'>";
      else
         imgStr = "<img src='/WEBAGENT/CQMGSTOR/ENG/DRIVE.GIF' width='72' height='42' border='0'>";

      if (thisCntlr.cpqFcaCntlrCurrentRole == 4)  // Backup
      {
         document.write("<tr><td align='center' width='30%'>" + imgStr + "</td>",
            "<td><small><font face='Arial'>Select the active controller to identify the drives ",
            "attached to this backup controller. Select <I>Help</I> for further information.",
            "</font></small></td></tr>");
      }
      else if (writeAccess)
      {
         if (thisCntlr.cpqFcaCntlrBlinkTime > 1)
            document.write("<tr><form action='MS-FCCTL.TPL' method='POST' target='_self' ",
              "onSubmit='return getIndex(this, thisCntlr.cpqFcaCntlrBoxIndex, thisCntlr.cpqFcaCntlrBoxIoSlot);'>",
              "<input type='hidden' name='TABLESET' value='1'><input type='hidden' name='INDEX' value=''>",
              "<input type='hidden' name='cpqFcaCntlrBlinkTime' value='1'><td align='center' width='50%'>",
              "<img src='/WEBAGENT/CQMGSTOR/ENG/DRVBLINK.GIF' width='72' height='42' border='0'></td>",
              "<td align='center'><input type='submit' value='Stop'></td></form></tr>");
         else  // Not blinking
            document.write("<tr><form action='MS-FCCTL.TPL' method='POST' target='_self' ",
              "onSubmit='return getIndex(this, thisCntlr.cpqFcaCntlrBoxIndex, thisCntlr.cpqFcaCntlrBoxIoSlot);'>",
              "<td align='center' width='50%'><input type='hidden' name='TABLESET' value='1'>",
              "<input type='hidden' name='INDEX' value=''><small><font face='Arial'>Blink Drive Lights </font></small>",
              "<select name='cpqFcaCntlrBlinkTime'>",
              "<option value='600'>1 minute<option value='1200'>2 minutes<option value='1800'>3 minutes",
              "<option value='2400'>4 minutes<option value='3000' selected>5 minutes<option value='6000'>10 minutes",
              "<option value='12000'>20 minutes<option value='18000'>30 minutes<option value='24000'>40 minutes",
              "<option value='30000'>50 minutes<option value='36000'>1 hour</select></td>",
              "<td align='center'><input type='submit' value='Start'></td>",
              "</form></tr>");
      }
      else  // Read only
      {
         document.write("<tr><td align='center' width='30%'>" + imgStr + "</td>",
            "<td><small><font face='Arial'>Only an administrator or an operator can blink the drive lights ",
            "to identify the drive. Select <I>Help</I> for further information.</font></small></td></tr>");
      }
      writeTableTail();
   }
}
writeBodyTail();
</script>
</html>

