<html>
<!-- $RCSfile: MS-FCSS.TPL $ $Revision: 1.22 $ -->
<!-- (C) Copyright 2003 Hewlett-Packard Development Company, L.P. -->
<head>
<title>Fibre Channel Storage System Informaiton</title>

<!#/COMMON/PAGETAGS.TPL>

<script language="JavaScript">
contextHelp = true;

<!cpqSsChassisEntry>
<!cpqSsIoSlotEntry>
<!cpqSsBackplaneEntry>
<!cpqSsPowerSupplyEntry>
<!cpqSsTempSensorEntry>
<!cpqSsFanModuleEntry>

<!#/COMMON/COND.JS>
<!#/COMMON/STDITEMS.JS>
<!#/COMMON/TABLES.JS>
<!#/COMMON/PARSEARG.JS>
<!#/COMMON/DISPBASE.JS>
<!#SSENUMS.JS>
<!#FCAENUMS.JS>
<!#MS-FCCMN.JS>

postfix["cpqSsTempSensorCurrentValue"] = "C";
postfix["cpqSsTempSensorLimitValue"] = "C";
</script>
</head>
<script language="JavaScript">

writeBodyHead();

idx = findArg("index");

if (idx == -1)
{
   parseArgs(tryPrevPage());
   idx = findArg("index");
}
if (idx == -1 || idx >= cpqSsChassisEntry.length)
{
   reportMissingArgs();
}
else
{
   thisChassis = cpqSsChassisEntry[idx];
   thisChassisIndex = thisChassis.cpqSsChassisIndex;
   slotControllers = new Array;

   for (i = 0; i < cpqSsIoSlotEntry.length; i++)
   {
      if (cpqSsIoSlotEntry[i].cpqSsIoSlotChassisIndex == thisChassisIndex)
         slotControllers[cpqSsIoSlotEntry[i].cpqSsIoSlotIndex] = displayItem(
            "cpqSsIoSlotControllerType", cpqSsIoSlotEntry[i].cpqSsIoSlotControllerType);
   }
   powerCondition = new cpqCondition(thisChassis.cpqSsChassisPowerSupplyCondition);
   tempCondition = new cpqCondition(thisChassis.cpqSsChassisTemperatureCondition);
   fanCondition = new cpqCondition(thisChassis.cpqSsChassisFanCondition);
   chassisCond = storageSysCondition(idx);
   writePageHead("Storage System Information", "/WEBAGENT/IMAGES/MASSHDR.GIF", "Storage System Information");
   writeTableLabel(chassisCond.image() + fcChassisName(idx));
   writeTableHead();
   writeSingleTableRowInDoubleTable(
      "Model:", displayItem("cpqSsChassisModel", thisChassis.cpqSsChassisModel));
   writeSingleTableRowInDoubleTable(
      "Name:",  displayItem("cpqSsChassisName", thisChassis.cpqSsChassisName));
   writeDoubleTableRow(
      "Connection:", displayItem("cpqSsChassisConnectionType", thisChassis.cpqSsChassisConnectionType),
      "IO Slot 1:", (null!=slotControllers[1] ? slotControllers[1]: "Not Installed"));
   writeDoubleTableRow(
      "Serial Number:", displayItem("cpqSsChassisSerialNumber", thisChassis.cpqSsChassisSerialNumber),
      "IO Slot 2:", (null!=slotControllers[2] ? slotControllers[2]: "Not Installed"));
   if (thisChassis.cpqSsChassisModel > 2)
      writeSingleTableRowInDoubleTable(
         "IO Module Type:", displayItem("cpqSsChassisScsiIoModuleType", thisChassis.cpqSsChassisScsiIoModuleType));
   if (thisChassis.cpqSsChassisModel == 4)
      writeSingleTableRowInDoubleTable(
         "RSO Status:", displayItem("cpqSsChassisRsoStatus", thisChassis.cpqSsChassisRsoStatus));
   writeTableTail();
   document.write("<br>");

   if (thisChassis.cpqSsChassisModel > 2)
   {
      backCond = new cpqCondition(1);
      for (i = 0; i < cpqSsBackplaneEntry.length; i++)
      {
         if (cpqSsBackplaneEntry[i].cpqSsBackplaneChassisIndex == thisChassisIndex)
         {
            ssName = displayItem("cpqSsBackplanePlacement", cpqSsBackplaneEntry[i].cpqSsBackplanePlacement);
            ssName += " Storage System Bus " + cpqSsBackplaneEntry[i].cpqSsBackplaneIndex;
            backCond.set(cpqSsBackplaneEntry[i].cpqSsBackplaneCondition);
            writeTableLabel(backCond.imageSmall() + ssName, "Backplane Information");
            writeTableHead();
            writeDoubleTableRow(
               "Vendor:", displayItem("cpqSsBackplaneVendor", cpqSsBackplaneEntry[i].cpqSsBackplaneVendor),
               "Model:", displayItem("cpqSsBackplaneModel", cpqSsBackplaneEntry[i].cpqSsBackplaneModel));
            writeDoubleTableRow(
               "Firmware Revision:", displayItem("cpqSsBackplaneFWRev", cpqSsBackplaneEntry[i].cpqSsBackplaneFWRev),
               "Board Revision:", displayItem("cpqSsBackplaneBoardRevision", cpqSsBackplaneEntry[i].cpqSsBackplaneBoardRevision));
            writeDoubleTableRow(
               "Serial Number:", displayItem("cpqSsBackplaneSerialNumber", cpqSsBackplaneEntry[i].cpqSsBackplaneSerialNumber),
               "Version:", displayItem("cpqSsBackplaneVersion", cpqSsBackplaneEntry[i].cpqSsBackplaneVersion));
            writeDoubleTableRow(
               "Drive Bays:", displayItem("cpqSsBackplaneDriveBays", cpqSsBackplaneEntry[i].cpqSsBackplaneDriveBays),
               "Duplex Option:", displayItem("cpqSsBackplaneDuplexOption", cpqSsBackplaneEntry[i].cpqSsBackplaneDuplexOption));

            // Don't display Temp, Fan, & Power status if not provided
            if (cpqSsBackplaneEntry[i].cpqSsBackplaneTempStatus == 6)
            {
               writeDoubleTableRow(
                  "Placement:", displayItem("cpqSsBackplanePlacement", cpqSsBackplaneEntry[i].cpqSsBackplanePlacement),
                  "","");
            } else {
               writeDoubleTableRow(
                  "Placement:", displayItem("cpqSsBackplanePlacement", cpqSsBackplaneEntry[i].cpqSsBackplanePlacement),
                  "Temperature Status:", displayItem("cpqSsBackplaneTempStatus", cpqSsBackplaneEntry[i].cpqSsBackplaneTempStatus));
               writeDoubleTableRow(
                  "Power Supply Status:", displayItem("cpqSsBackplaneFtpsStatus", cpqSsBackplaneEntry[i].cpqSsBackplaneFtpsStatus),
                  "Fan Status:", displayItem("cpqSsBackplaneFanStatus", cpqSsBackplaneEntry[i].cpqSsBackplaneFanStatus));
            }
            writeTableTail();
            document.write("<br>");
         }
      }
   }
   else // RA4xxx
   {
      writeTableLabel("Backplane Information");
      writeTableHead();
      writeColumnTableHeaderRow("Firmware Revision", "Drive Bays", "Duplex");

      for (i = 0; i < cpqSsBackplaneEntry.length; i++)
      {
         if (cpqSsBackplaneEntry[i].cpqSsBackplaneChassisIndex == thisChassisIndex)
         {
            writeColumnTableDataRow(
               displayItem("cpqSsBackplaneFWRev",        cpqSsBackplaneEntry[i].cpqSsBackplaneFWRev),
               displayItem("cpqSsBackplaneDriveBays",    cpqSsBackplaneEntry[i].cpqSsBackplaneDriveBays),
               displayItem("cpqSsBackplaneDuplexOption", cpqSsBackplaneEntry[i].cpqSsBackplaneDuplexOption));
         }
      }
      writeTableTail();
      document.write("<br>");

      writeTableLabel("Asset Information");
      writeTableHead();
      writeColumnTableHeaderRow("Board", "Serial Number", "Board Revision");
      writeColumnTableDataRow("System Board",
         displayItem("cpqSsChassisSystemBoardSerNum", thisChassis.cpqSsChassisSystemBoardSerNum),
         displayItem("cpqSsChassisSystemBoardRev",    thisChassis.cpqSsChassisSystemBoardRev));
      writeColumnTableDataRow("Power Board",
         displayItem("cpqSsChassisPowerBoardSerNum", thisChassis.cpqSsChassisPowerBoardSerNum),
         displayItem("cpqSsChassisPowerBoardRev",    thisChassis.cpqSsChassisPowerBoardRev));
      writeColumnTableDataRow("SCSI Board",
         displayItem("cpqSsChassisScsiBoardSerNum", thisChassis.cpqSsChassisScsiBoardSerNum),
         displayItem("cpqSsChassisScsiBoardRev",    thisChassis.cpqSsChassisScsiBoardRev));
      writeTableTail();
      document.write("<br>");

      writeTableLabel(powerCondition.imageSmall()+"Power Supply Information", "Power Supply Information");
      writeTableHead();
      writeColumnTableHeaderRow("Location", "Status", "UPS State", "Serial Number", "Board Revision", "Firmware Revision");

      for (i = 0; i < cpqSsPowerSupplyEntry.length; i++)
      {
         if (cpqSsPowerSupplyEntry[i].cpqSsPowerSupplyChassisIndex == thisChassisIndex)
         {
            thisPS = cpqSsPowerSupplyEntry[i];
            powerCondition.state = 1;
            powerCondition.update(thisPS.cpqSsPowerSupplyCondition);
            writeColumnTableDataRow(
               powerCondition.imageSmall() + "Power Bay " + (thisPS.cpqSsPowerSupplyBay-1) ,
               displayItem("cpqSsPowerSupplyStatus",           thisPS.cpqSsPowerSupplyStatus ),
               displayItem("cpqSsPowerSupplyUpsStatus",        thisPS.cpqSsPowerSupplyUpsStatus),
               displayItem("cpqSsPowerSupplySerialNumber",     thisPS.cpqSsPowerSupplySerialNumber),
               displayItem("cpqSsPowerSupplyBoardRevision",    thisPS.cpqSsPowerSupplyBoardRevision),
               displayItem("cpqSsPowerSupplyFirmwareRevision", thisPS.cpqSsPowerSupplyFirmwareRevision));
         }
      }
      writeTableTail();
      document.write("<br>");

      writeTableLabel(tempCondition.imageSmall() + "Temperature Information", "Temperature Information");
      writeTableHead();
      writeColumnTableHeaderRow("Location", "Status", "Current Value", "Limit Value");

      for (i = 0; i < cpqSsTempSensorEntry.length; i++)
      {
         if (cpqSsTempSensorEntry[i].cpqSsTempSensorChassisIndex == thisChassisIndex)
         {
            thisTemp = cpqSsTempSensorEntry[i];
            tempCondition.state = 1;
            tempCondition.update(thisTemp.cpqSsTempSensorCondition);
            writeColumnTableDataRow(
               tempCondition.imageSmall() + displayItem("cpqSsTempSensorLocation", thisTemp.cpqSsTempSensorLocation),
               displayItem("cpqSsTempSensorStatus", thisTemp.cpqSsTempSensorStatus),
               displayItem("cpqSsTempSensorCurrentValue", thisTemp.cpqSsTempSensorCurrentValue),
               displayItem("cpqSsTempSensorLimitValue", thisTemp.cpqSsTempSensorLimitValue));
         }
      }
      writeTableTail();
      document.write("<br>");

      writeTableLabel(fanCondition.imageSmall() + "Fan Information", "Fan Information");
      writeTableHead();
      writeColumnTableHeaderRow("Location", "Status", "Serial Number", "Board Revision");

      for (i = 0; i < cpqSsFanModuleEntry.length; i++)
      {
         if (cpqSsFanModuleEntry[i].cpqSsFanModuleChassisIndex == thisChassisIndex)
         {
            thisFan = cpqSsFanModuleEntry[i];
            fanCondition.state = 1;
            fanCondition.update(thisFan.cpqSsFanModuleCondition);
            writeColumnTableDataRow(
               fanCondition.imageSmall() + displayItem("cpqSsFanModuleLocation", thisFan.cpqSsFanModuleLocation),
               displayItem("cpqSsFanModuleStatus",        thisFan.cpqSsFanModuleStatus),
               displayItem("cpqSsFanModuleSerialNumber",  thisFan.cpqSsFanModuleSerialNumber),
               displayItem("cpqSsFanModuleBoardRevision", thisFan.cpqSsFanModuleBoardRevision));
         }
      }
      writeTableTail();
   }
}
writeBodyTail();
</script>
</html>

