#ifndef _HPPROTO_H
#define _HPPROTO_H

#include "hptypes.h"

#define cmhp_modname	"cmhp"

/* Interface to the HAM Module */
#define	HAM_HOT_ADD	"ham_hot_add"
typedef ULONG (*ham_interface_t)(ULONG64, ULONG64, UCHAR);

/* cmhp.c */

/* atomic counters */
void cmph_inc_inj_err_count(ULONG mrm);
void cmph_dec_inj_err_count(ULONG mrm);
ULONG cmph_read_inj_err_count(ULONG mrm);

/* Memory Access */
PVOID cmhpMapPhysUnCache(ULONG ulPhysAddr, ULONG ulLength);
PVOID cmhpMapPhysCache(ULONG ulPhysAddr, ULONG ulLength);
VOID  cmhpUnMapPhys(PVOID VirtAddr, ULONG size);

void *cmhp_get_free_DMA_page(void);
ULONG cmhp_copy_from_user(PVOID dest, PVOID src, ULONG size);
ULONG cmhp_copy_to_user(PVOID dest, PVOID src, ULONG size);
PVOID cmhpMalloc(ULONG ulSize);
PVOID cmhpAtomicMalloc(ULONG ulSize);
VOID cmhpFree(PVOID pVAddr, ULONG ulSize);
ULONG cmhpGetPageSize(VOID);


/* locks */
VOID cmhp_intr_lock(ULONG);
VOID cmhp_intr_unlock(ULONG);
VOID cmhp_var_lock(VOID);
VOID cmhp_var_unlock(VOID);
VOID cmhp_event_lock(VOID);
VOID cmhp_event_unlock(VOID);

VOID cmhp_ham_load(VOID);
VOID cmhp_ham_unload(VOID);

VOID cmhp_event_mutex_up(VOID);
VOID cmhp_event_mutex_down(VOID);


extern ULONG 	cmhp_rebuild_rate;
extern BOOLEAN 	cmhp_hotadd_enabled;

/*  PCI Access  */
/* Device ID for the Memory Controller */
#if !defined(PCI_VENDOR_ID_COMPAQ)
#define PCI_VENDOR_ID_COMPAQ 0xe11
#endif
#define PCI_DEVICE_ID_COMPAQ_MEMCNTL	0xb200
/* Device ID for the brigdes*/
#define SERVERWORKS_VENDOR_ID 0x1166
#define SERVERWORKS_CIOB30_DEVICE_ID 0x0010

typedef struct _PCISTRUCTLIST *PPCISTRUCTLIST;
typedef struct _PCISTRUCTLIST
{
   PPCISTRUCTLIST pNext;
   PVOID sysdata;              // scratch pad pointer
   ULONG ulMemAddr;            // Base Addr
   ULONG ulSize;               
   UCHAR ucIrq;          
   UCHAR ucBusNumber;
   UCHAR ucDeviceNumber;
   UCHAR ucFunctionNumber;
}PCISTRUCTLIST;

PPCISTRUCTLIST cmhpFindPCIDevice(ULONG ulVendorID, ULONG ulDeviceID);
BOOLEAN FreeDeviceData(PPCISTRUCTLIST);
VOID cmhpPciWriteConfigWord(PVOID dev, ULONG addr, WORD val);

/* ISR */
VOID cmhpRegisterIRQ(ULONG irq, PVOID arg);
VOID cmhpUnRegisterIRQ(ULONG irq, PVOID arg);
VOID cmhpStartDFP(VOID);

/* Delay */
ULONG cmhpUsecWait(ULONG microsecs);

VOID lock_module(VOID);
VOID unlock_module(VOID);

ULONG cmhpGetCurrentTimeInSec(VOID);

/* print */
void cmhpPrint(ULONG ulSev, PCHAR str, ...);
/* Severity levels */
#define CMHP_INFO     1
#define CMHP_WARNING  2
#define CMHP_ERR      3
#define CMHP_DBG      4

#endif /* _HPPROTO_H */

VOID cmhpLoadImlHandler(VOID);
