#ifndef _UNIXPROTO_H
#define _UNIXPROTO_H

#include "hptypes.h"

#define CMHP_INVAL -1
#define CMHP_NOMEM -2
#define CMHP_FAULT -3
#define CMHP_EAGAIN -4
#define CMHP_EIO    -5

/* cmhp_ioctl.c */
ULONG cmhp_ioctl(ULONG cmd, ULONG arg);

/* vendor/cmhp_hw.c */
LONG  cmhp_function_init(VOID);
VOID  cmhp_function_exit(VOID);
VOID  cmhp_change_top_memory_base(USHORT);
VOID  cmhp_interrupt(ULONG irq);
VOID  cmhp_interrupt_bh(ULONG);
ULONG cmhp_get_rebuild_rate(void);

/* cmhp_event.c */
VOID cmhp_precess_next_event(VOID);
int cmhp_init_events(int init_flag);


/* cmhp_iohlth.c */
LONG cmhp_get_iohlth_info(PVOID arg);

/* cmhp_hotadd.c */
LONG cmhp_hot_add(ULONG64 start, ULONG64 size, UCHAR flags);
#define MEM_READ      0x1
#define MEM_WRITE      0x2
#define MEM_DEFAULT      (MEM_READ|MEM_WRITE)
#define MEM_ATTRIB_MASK   (MEM_READ|MEM_WRITE)

/* unixmiscfuncs.c  */
ULONG   unixMemCpy(PUCHAR dest, PUCHAR src, ULONG size);
PUCHAR  unixStrCpy(PUCHAR s1, PUCHAR s2);
ULONG   unixStrLen (PUCHAR s1);
PUCHAR  unixStrCat (PUCHAR s1, PUCHAR s2);
ULONG   unixStrnCmp (PUCHAR s1, PUCHAR s2, ULONG n);
PVOID   unixMemSet (PUCHAR p, UCHAR v, ULONG n);
PVOID   unixMemZero(PVOID s, ULONG n);
// use these defines for unixMapPhysToVirt 
//#define MEM_ATTRIB_CACHE   1
//#define MEM_ATTRIB_UNCACHE 2
PVOID unixMapPhysToVirt(ULONG PhysAddr, ULONG len, ULONG type);
VOID  unixUnMapVirt(PVOID VirtAddr, ULONG len);
ULONG unixMicroDelay(ULONG microsecs);
ULONG unixGetTimeSec(VOID);


/****************  DEFINES ****************************/
#ifndef max
#define max(a,b)	((a) > (b) ? (a) : (b))
#endif /* max */

#define cmhp_thread_name   "cmhpd"


#endif /* _UNIXPROTO_H */
