/***************************************************************************
*         Copyright 2002 Compaq Information Technologies Group, L.P.       *
****************************************************************************
*
*  @doc
*
*  @module  casmw_linux.h
*  Version: 1.0
*
*  Function: Provide basic support for the hp ProLiant Advance Server
*            Management ASIC.
*
*  @doc
****************************************************************************
*
*  @doc
*
*  Change Log:
*
*       Date    Who   Description
*
*****************************************************************************/
#ifndef INC_CASMW_LINUX_H
#define INC_CASMW_LINUX_H


#ifndef __KERNEL__
#  define __KERNEL__
#endif

#ifndef MODULE
#  define MODULE
#endif

#ifdef INC_OS_HEADERS
#include <linux/config.h>


#ifdef CONFIG_SMP
#define __SMP__
#endif


#ifndef CONFIG_X86_LOCAL_APIC
#  define CONFIG_X86_LOCAL_APIC 1
#endif

#ifndef __MODULE_KERNEL_i686
#define __MODULE_KERNEL_i686
#endif

#ifndef OS_SYMBOL
#define OS_SYMBOL 1
#endif

#if OS_SYMBOL==1

#include <linux/autoconf.h>
#if defined(CONFIG_MODVERSIONS) && !defined(MODVERSIONS)
#	define MODVERSIONS
#endif

#ifdef MODVERSIONS
#	include <linux/modversions.h>
#endif

#endif

#include <linux/module.h>
#include <asm/io.h>
#include <linux/notifier.h>
#include <asm/uaccess.h>
#include <linux/kernel.h> /* printk() */

#endif


//*************************************************************************
//  Constants
//*************************************************************************



//************************************************************************
//	typdefs
//************************************************************************

//************************************************************************
//	globals
//************************************************************************


//************************************************************************
//	funcs
//************************************************************************



//*************************************************************************
//  Defines and typedefs
//*************************************************************************

#pragma pack(1)

typedef struct _desctableptr_s {
  WORD limit;
  DWORD base;		
} desctableptr_s;


typedef struct _gatedesc_s {
  WORD offset_low;
  WORD selector;
  UCHAR pad;			/* |000|XXXXX| ig & trpg, |XXXXXXXX| task g */
  UCHAR p_dpl_type;		/* |P|DL|0|TYPE| */
  WORD offset_high;
} gatedesc_s;

#pragma pack()
#define CASM_MAX_TOID       6            /* Maximum number of timers     */
#define CASM_MAX_ADDR       16           /* Max number of phys addresses */

//
// @struct UNIXADDR | Used to track Unix Address Allocations
//
typedef struct _CASMADDR {
   ULONG               phys_addr;
   ULONG               mem_len;
   PVOID               virt_addr;
   ULONG               mem_blk_num;     /* RESMGR Block Number           */
   ULONG               use_count;       /* Tracks Usage                  */
} CASMADDR, *PCASMADDR;


typedef struct _OSDATA {
    spinlock_t        rom_lock;         /* controls access to ROM calls   */
    spinlock_t        q_lock;           /* controls access to pInstance   */
    spinlock_t        iic_lock;         /* controls access to IIC         */
    ULONG             rom_pl;           /* rom_lock Flags                 */
    ULONG             q_pl;             /* Saved Flags                    */
    ULONG             iic_pl;           /* IIC lock privilege level     */
    wait_queue_head_t task_wq;          /* User Tasks waits on this       */
    wait_queue_head_t mca_wq;           /* MCA  Tasks waits on this       */
    wait_queue_head_t iic_wq;           /* IIC  Tasks waits on this       */
    desctableptr_s    idt_base;         /* Used for NMI and MCA Hndlrs    */
    gatedesc_s        *idt_table;
    struct timer_list timers[CASM_MAX_TOID];
    CASMADDR          paddrs[CASM_MAX_ADDR];   
} OSDATA, *POSDATA;



//*************************************************************************
//  Function prototypes
//*************************************************************************



//*************************************************************************
// Special Interrupt handling code
//*************************************************************************

struct pt_regs;



#ifdef DEBUG
#define DBG(fmt, args...) printk(fmt, ##args);
#else
#define DBG(fmt, args...) 
#endif

#endif 
