############################################################################
# copyright 2002 Compaq Information Technologies Group, L.P. 
############################################################################

# Setup some variables.
PKGNAM=cpqhealth
THIS_VERSION=`uname -r`

VERS=$1       #package version
REL=$2        #package release

usage()
{
   echo "USAGE: $1:custom_health [VERSION] [RELEASE]"
   echo "Where VERSION and RELEASE are optional"
}

#Verify command Syntax
if [ $# -ne 2 ]
then
   VERS=`cat cpqasm/PKG_VERSION | sed 's/-CUSTOM/CUSTOM/' `
   REL=1
fi

#this is where we will build this RPM
RPMTOP=/tmp/cpqrpm
TOPDIR="%_topdir  ${RPMTOP}"
BUILDNAME="%_build_name_fmt  %%{ARCH}/%%{NAME}-%%{VERSION}-%%{RELEASE}.%%{ARCH}.rpm"

#make sure ~/.rpmmacro file reflexs this
#also setup up the correct naming convention
if [ ! -f ~/.rpmmacros ]
then
   echo ${TOPDIR} >>~/.rpmmacros
   echo ${BUILDNAME} >>~/.rpmmacros
else
    #So the .rpmmacro file is already there 
    #lets make sure it says what we want it to
    awk -v x="${TOPDIR}" -v y="${BUILDNAME}" \
    '{ 
       if($0 ~ /%_topdir/)              \
          {printf("%s\n", x)}           \
       else if($0 ~ /%_build_name_fmt/) \
          {printf("%s\n", y)}           \
       else                             \
          {printf("%s\n", $0)}          \
    }' ~/.rpmmacros >~/tmprpmmacros
   mv ~/tmprpmmacros ~/.rpmmacros
fi

#If this directory is not present make it
[ -d ${RPMTOP}/BUILD ]   || mkdir -p ${RPMTOP}/BUILD
[ -d ${RPMTOP}/RPMS ]    || mkdir -p ${RPMTOP}/RPMS
[ -d ${RPMTOP}/SOURCES ] || mkdir -p ${RPMTOP}/SOURCES
[ -d ${RPMTOP}/SPECS ]   || mkdir -p ${RPMTOP}/SPECS
[ -d ${RPMTOP}/SPRMS ]   || mkdir -p ${RPMTOP}/SRPMS

#clean those directories
rm -rf ${RPMTOP}/BUILD/${PKGNAM}

SPECFILE=${RPMTOP}/SPECS/${PKGNAM}-${VERS}-${REL}.spec

# Build the source tarball
SRCTARBAL=${RPMTOP}/SOURCES/${PKGNAM}-${VERS}-${REL}.tar.gz
cd ..
tar czf ${SRCTARBAL} ${PKGNAM}
cd ${PKGNAM}

# Copy the hp RPM logo to the SOURCES directory
cp hprpm.xpm ${RPMTOP}/SOURCES

#SET RPM_BUILD_ROOT so sh does not keep messing it up
RPM_BUILD_ROOT="$""RPM_BUILD_ROOT"

# Set The Driver base directory for the system that this lands on
DRV_BASE=/lib/modules/Compaq/cpqhealth

echo "Building Custom SPEC file . . ."

cat << EOF >$SPECFILE
Summary     	: hp ProLiant Health Driver for IA32 Linux
Name				: ${PKGNAM}
Version			: ${VERS} 
Release			: ${REL}
Group				: System Environment/Kernel
Source			: ${SRCTARBAL}
Copyright		: 2002 Compaq Information Technologies Group, L.P.
Vendor			: Hewlett-Packard Company
Packager    	: Hewlett-Packard Company
URL         	: http://www.hp.com/linux
BuildRoot   	: /var/tmp/%{name}
Icon				: hprpm.xpm
AutoReqProv		: no
PreReq			: /bin/sh, /bin/bash

%description
This is a custom version of the hp ProLiant Health Device Driver.  The hp ProLiant Health Device Driver package provides extended capabilities to ProLiant Servers.  These capabilities include monitoring of temperature thresholds, fan, processor and memory failures.  Should a parameter be out of normal operating conditions, the Linux operating system will be automatically shutdown.  This updated package also provides the capability of other device drivers to be able to log to the hp ProLiant Integrated Management Log (IML).  The ProLiant Advanced Server Management Driver is the interface to the ProLiant Advanced Server Management (ASM) ASIC.  This driver will work with both the ProLiant ASM (0x0E11A0F0) and the ProLiant iLO Advanced Server Management (0x0E11B203) ASICs.  The hp ProLiant Event Logging Device Driver provides an interface so other drivers (such as the hp ProLiant storage array device drivers) can log events to the hp ProLiant Integrated Management Log (IML).


%prep
# %setup -n %{name}
%setup -n cpqhealth

%build
PKG_VER=%{version}\-%{release}
echo "\$PKG_VER" > PKG_VERSION
make -f cpqhealth.mk OS_MODEL=LINUX EFS_VER="\$PKG_VER" all

%pre
if [ -d /opt/compaq/cpqhealth ]; then
	echo "This custom release of cpqhealth cannot be upgraded."
	echo "Please remove the installed 'cpqhealth' RPM before upgrading"
	echo "to this release. Use 'rpm -e cpqhealth' to remove."
	exit 1
fi

if [ -f /etc/rc.d/init.d/cpqhealth ]; then
	echo "This custom release of cpqhealth cannot be upgraded."
	echo "Please remove the installed 'cpqhealth' RPM before upgrading"
	echo "to this release. Use 'rpm -e cpqhealth' to remove."
	exit 1
fi

if [ -f /opt/compaq/cpqhealth/cpqasm/up/cpqasm.o ]; then
	echo "This custom release of cpqhealth cannot be upgraded."
	echo "Please remove the installed 'cpqhealth' RPM before upgrading"
	echo "to this release. Use 'rpm -e cpqhealth' to remove."
	exit 1
fi

BUSY=\`lsmod |fgrep cpqhealth\`
if [ ${#BUSY} -ne 0 ]; then
	echo "This custom release of cpqhealth cannot be upgraded."
	echo "Please remove the installed 'cpqhealth' RPM before upgrading"
	echo "to this release. Use 'rpm -e cpqhealth' to remove."
	exit 1
fi

#
# We have to clean up from previous releases which did not
# remove all the instances of the driver.  This causes problems
# when other drivers such as the RIB driver loads.
#

for OS_VER in \`ls -d /lib/modules/* \`; do
	#Now wipe all occurences of cpqhealth and cpqrom in the current directory.
	if [ -f $OS_VER/misc/cpqhealth.o ]; then
		rm -f $OS_VER/misc/cpqhealth.o
	fi
	if [ -f $OS_VER/misc/cpqrom.o ]; then
		rm -f $OS_VER/misc/cpqrom.o
	fi
	if [ -f $OS_VER/kernel/drivers/char/cpqhealth.o ]; then
		rm -f $OS_VER/kernel/drivers/char/cpqhealth.o
	fi
	if [ -f $OS_VER/kernel/drivers/char/cpqrom.o ]; then
		rm -f $OS_VER/kernel/drivers/char/cpqrom.o
	fi
done;

CPQASM=\`lsmod |fgrep cpqasm\`
if [ ${#CPQASM} -ne 0 ]; then
	CMA=\`ls /etc/init.d | fgrep cma\`
	if [ ${#CMA} -ne 0 ]; then
		for i in $CMA
		do
			/etc/init.d/$i stop
		done
	fi
	/etc/init.d/cpqasm stop
	sleep 2
	/sbin/rmmod cpqasm 
fi

CPQASM=\`lsmod |fgrep cpqevt\`
if [ ${#CPQASM} -ne 0 ]; then
	sleep 2
	/sbin/rmmod cpqevt
fi


CPQASM=\`lsmod |fgrep cpqasm\`
if [ ${#CPQASM} -ne 0 ]; then
   echo "WARNING!  Not able to stop the cpqasm device driver!"
	echo "          The CIM agents may not be terminated."
   exit 1
fi


#
# RPM Upgrade may be in process.  We need to clean up a bit
#
if [ -f /sbin/cpqimlview ]; then
	echo "Starting cpqhealth package Upgrade. . ."
   rm -f /lib/modules/Compaq/drivers/up/cpqasm.o
   rm -f /lib/modules/Compaq/drivers/smp/cpqasm.o
   rm -f /lib/modules/Compaq/drivers/ent/cpqasm.o
   rm -f /opt/compaq/cpqhealth/cpqasm/casmw_linux.o
   rm -f /sbin/cpqimlview
   rm -f /sbin/cpqimlview.tcl
   rm -f /sbin/imlbe
   rm -f /sbin/hpimlview
   rm -f /usr/share/pixmaps/compred.xbm
   rm -f /usr/share/pixmaps/hplogo.xbm
   rm -f /usr/share/pixmaps/m_blue.gif
   rm -f /usr/share/pixmaps/m_fail.gif
   rm -f /usr/share/pixmaps/m_green.gif
   rm -f /usr/share/pixmaps/m_red.gif
   rm -f /usr/share/pixmaps/m_yellow.gif
   rm -f /etc/rc.d/rc3.d/S10cpqasm
   rm -f /etc/rc.d/rc3.d/K10cpqasm
   rm -f /etc/rc.d/rc5.d/S10cpqasm
   rm -f /etc/rc.d/rc5.d/K10cpqasm
   rm -f /dev/casr
   rm -f /dev/cecc
   rm -f /dev/ccsm
   rm -f /dev/cmca
   rm -f /dev/cside
   rm -f /dev/cevt
   rm -f /dev/cpci
   rm -f /dev/cdt
   rm -f /dev/cpqw
   rm -f /dev/crom
   rm -f /dev/cwell
   rm -f /dev/cpqevt
   rm -rf /dev/cpqhealth
   rm -f /lib/modules/Compaq/drivers/up/cpqevt.o
   rm -f /lib/modules/Compaq/drivers/smp/cpqevt.o
   rm -f /lib/modules/Compaq/drivers/ent/cpqevt.o
   rm -f /opt/compaq/cpqhealth/cpqevt/cpqevtw_linux.o

#
# For RPM upgrades, we delete all driver binaries to insure
# we rebuild correctly on errata kernels.
#
	DRIVERS=\`find /opt/compaq/cpqhealth/cpqasm/* -name cpqasm.o\`

	for THIS_DRIVER in $DRIVERS
	do
		if [ -f $THIS_DRIVER ]
		then
			rm $THIS_DRIVER
		fi
	done

	DRIVERS=\`find /opt/compaq/cpqhealth/cpqevt/* -name cpqevt.o\`

	for THIS_DRIVER in $DRIVERS
	do
		if [ -f $THIS_DRIVER ]
		then
			rm $THIS_DRIVER
		fi
	done

fi


%install
if [ $RPM_BUILD_ROOT != "/" ]; then
	rm -rf $RPM_BUILD_ROOT
fi


THIS_VERSION=`uname -r`

#
# Create the Directory Structure in the build area
#
mkdir -p $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqasm
mkdir -p $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqasm/${THIS_VERSION}
mkdir -p $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqevt
mkdir -p $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqevt/${THIS_VERSION}
mkdir -p $RPM_BUILD_ROOT/usr/share/man/man8
mkdir -p $RPM_BUILD_ROOT/usr/share/man/man4
mkdir -p $RPM_BUILD_ROOT/usr/share/pixmaps
mkdir -p $RPM_BUILD_ROOT/sbin
mkdir -p $RPM_BUILD_ROOT/etc/init.d/
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/rc0.d/
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/rc1.d/
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/rc2.d/
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/rc3.d/
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/rc4.d/
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/rc5.d/
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/rc6.d/

#
# Copy the files from the "Make" area to the "Build" staging area.
#
cp -a /usr/share/man/man8/cpqimlview.8.gz  $RPM_BUILD_ROOT/usr/share/man/man8/cpqimlview.8.gz
cp -a /sbin/bootcfg  $RPM_BUILD_ROOT/sbin/bootcfg
cp -a /usr/share/man/man4/cpqhealth.4.gz  $RPM_BUILD_ROOT/usr/share/man/man4/cpqhealth.4.gz
cp -a cpqasm/cpqasm.o  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqasm/${THIS_VERSION}/cpqasm.o
cp -a cpqevt/cpqevt.o  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqevt/${THIS_VERSION}/cpqevt.o

cp -a hprpm.xpm  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/hprpm.xpm
cp -a cpqhealth.license  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqhealth.license
cp -a custom_cpqhealth.sh  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/custom_cpqhealth.sh
cp -a custom_cpqhealth_install.sh  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/custom_cpqhealth_install.sh
cp -a cpqhealth.mk  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqhealth.mk
cp -a cpqasm/cpqasm.mk  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqasm/cpqasm.mk
cp -a cpqasm/cpqasm_mknod.sh  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqasm/cpqasm_mknod.sh
cp -a cpqasm/S10cpqasm  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqasm/S10cpqasm
cp -a cpqasm/retry_cpqasm.sh  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqasm/retry_cpqasm.sh
cp -a cpqasm/cpqimlview  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqasm/cpqimlview
cp -a cpqasm/cpqimlview.tcl  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqasm/cpqimlview.tcl
cp -a cpqasm/iml.msg.tcl  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqasm/iml.msg.tcl
cp -a cpqasm/hplogo.xbm  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqasm/hplogo.xbm
cp -a cpqasm/m_blue.gif  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqasm/m_blue.gif
cp -a cpqasm/m_fail.gif  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqasm/m_fail.gif
cp -a cpqasm/m_green.gif  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqasm/m_green.gif
cp -a cpqasm/m_red.gif  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqasm/m_red.gif
cp -a cpqasm/m_yellow.gif  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqasm/m_yellow.gif
cp -a cpqasm/convert.h  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqasm/convert.h
cp -a cpqasm/unixincl.h  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqasm/unixincl.h
cp -a cpqasm/casm_common.o  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqasm/casm_common.o
cp -a cpqasm/casmc.h  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqasm/casmc.h
cp -a cpqasm/oswrap.h  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqasm/oswrap.h
cp -a cpqasm/casmw_linux.c  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqasm/casmw_linux.c
cp -a cpqasm/casmw_linux.h  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqasm/casmw_linux.h
cp -a cpqasm/casmd  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqasm/casmd
cp -a cpqevt/cevtd  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqevt/cevtd
cp -a cpqasm/imlbe  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqasm/imlbe
cp -a cpqasm/hpimlview  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqasm/hpimlview
cp -a utils.d/hpuid  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/hpuid
cp -a utils.d/hpuid_example.sh  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/hpuid_example.sh
cp -a PKG_VERSION  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqasm/PKG_VERSION

cp -a cpqevt/cpqevt.mk  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqevt/cpqevt.mk
cp -a cpqevt/retry_cpqevt.sh  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqevt/retry_cpqevt.sh
cp -a cpqevt/convert.h  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqevt/convert.h
cp -a cpqevt/unixincl.h  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqevt/unixincl.h
cp -a cpqevt/cpqevt_common.o  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqevt/cpqevt_common.o
cp -a cpqevt/cpqevtc.h  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqevt/cpqevtc.h
cp -a cpqevt/oswrap.h  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqevt/oswrap.h
cp -a cpqevt/cpqevtw_linux.c  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqevt/cpqevtw_linux.c
cp -a cpqevt/cpqevtw_linux.h  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqevt/cpqevtw_linux.h
cp -a cpqevt/cpqevtq.h  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqevt/cpqevtq.h
cp -a PKG_VERSION  $RPM_BUILD_ROOT/opt/compaq/cpqhealth/cpqevt/PKG_VERSION


#
# Now we create our links in the build staging area
#
ln -s /opt/compaq/cpqhealth/cpqasm/cpqimlview $RPM_BUILD_ROOT/sbin/cpqimlview
ln -s /opt/compaq/cpqhealth/cpqasm/cpqimlview.tcl $RPM_BUILD_ROOT/sbin/cpqimlview.tcl
ln -s /opt/compaq/cpqhealth/cpqasm/imlbe $RPM_BUILD_ROOT/sbin/imlbe
ln -s /opt/compaq/cpqhealth/cpqasm/hpimlview $RPM_BUILD_ROOT/sbin/hpimlview
ln -s /opt/compaq/cpqhealth/hpuid $RPM_BUILD_ROOT/sbin/hpuid
ln -s /opt/compaq/cpqhealth/cpqasm/hplogo.xbm $RPM_BUILD_ROOT/usr/share/pixmaps/hplogo.xbm
ln -s /opt/compaq/cpqhealth/cpqasm/m_blue.gif $RPM_BUILD_ROOT/usr/share/pixmaps/m_blue.gif
ln -s /opt/compaq/cpqhealth/cpqasm/m_fail.gif $RPM_BUILD_ROOT/usr/share/pixmaps/m_fail.gif
ln -s /opt/compaq/cpqhealth/cpqasm/m_green.gif $RPM_BUILD_ROOT/usr/share/pixmaps/m_green.gif
ln -s /opt/compaq/cpqhealth/cpqasm/m_red.gif $RPM_BUILD_ROOT/usr/share/pixmaps/m_red.gif
ln -s /opt/compaq/cpqhealth/cpqasm/m_yellow.gif $RPM_BUILD_ROOT/usr/share/pixmaps/m_yellow.gif
ln -s /opt/compaq/cpqhealth/cpqasm/S10cpqasm $RPM_BUILD_ROOT/etc/init.d/cpqasm
ln -s /opt/compaq/cpqhealth/cpqasm/S10cpqasm $RPM_BUILD_ROOT/etc/rc.d/rc3.d/S10cpqasm
ln -s /opt/compaq/cpqhealth/cpqasm/S10cpqasm $RPM_BUILD_ROOT/etc/rc.d/rc3.d/K10cpqasm
ln -s /opt/compaq/cpqhealth/cpqasm/S10cpqasm $RPM_BUILD_ROOT/etc/rc.d/rc5.d/S10cpqasm
ln -s /opt/compaq/cpqhealth/cpqasm/S10cpqasm $RPM_BUILD_ROOT/etc/rc.d/rc5.d/K10cpqasm
ln -s /opt/compaq/cpqhealth/cpqasm/S10cpqasm $RPM_BUILD_ROOT/etc/rc.d/rc0.d/K10cpqasm
ln -s /opt/compaq/cpqhealth/cpqasm/S10cpqasm $RPM_BUILD_ROOT/etc/rc.d/rc1.d/K10cpqasm
ln -s /opt/compaq/cpqhealth/cpqasm/S10cpqasm $RPM_BUILD_ROOT/etc/rc.d/rc2.d/K10cpqasm
ln -s /opt/compaq/cpqhealth/cpqasm/S10cpqasm $RPM_BUILD_ROOT/etc/rc.d/rc4.d/K10cpqasm
ln -s /opt/compaq/cpqhealth/cpqasm/S10cpqasm $RPM_BUILD_ROOT/etc/rc.d/rc6.d/K10cpqasm



%post
sync
#
# We might be upgrading which in that case, we really do
# not want to do this.
#
if [ \$1 -eq 2 ]; then
	echo "Completing cpqhealth package Upgrade. . ."
	CPQASM=\`lsmod |fgrep cpqasm\`
	if [ ${#CPQASM} -ne 0 ]; then
		CMA=\`ls /etc/init.d | fgrep cma\`
		if [ ${#CMA} -ne 0 ]; then
			for i in $CMA
			do
				/etc/init.d/$i stop
			done
		fi
		/etc/init.d/cpqasm stop
		sleep 3
		/sbin/rmmod cpqasm 
	fi

	CPQASM=\`lsmod |fgrep cpqevt\`
	if [ ${#CPQASM} -ne 0 ]; then
		/sbin/rmmod cpqevt
	fi

fi

#
# Display EULA for Source Modules
#
echo -e "\n"
echo "Please read the Licence Agreement for this software at"
echo -e "\n"
echo "         /opt/compaq/cpqhealth/cpqhealth.license"
echo -e "\n"
echo "By Not removing this package, you are accepting the terms"
echo "of the \"License for Compaq Value Added Software\"."
echo -e "\n"


#
# Launch the software
#
/etc/init.d/cpqasm start

if [ \$? -eq 0 ]; then
   sleep 3
   echo -e "\n"
   echo "This custom cpqhealth RPM has installed successfully."
	touch /var/lock/subsys/cpqasm
else
   echo "This custom cpqhealth RPM installation failed!"
   echo "See /opt/compaq/cpqhealth/cpqhealth_boot.log for details."
   exit 1
fi


%preun
sync
#
# We might be upgrading which in that case, we really do
# not want to do this.
#
if [ \$1 -ne 0 ]; then
   exit 0
fi

CPQASM=\`lsmod |fgrep cpqasm\`
if [ ${#CPQASM} -ne 0 ]; then
	echo "The cpqasm driver is being stopped . . ."
	/opt/compaq/cpqhealth/cpqasm/casmd -t
	sleep 2
	/sbin/rmmod cpqasm
fi

echo "The cpqasm driver is being removed . . ."
rm -f /dev/casm
rm -f /dev/casr
rm -f /dev/cecc
rm -f /dev/ccsm
rm -f /dev/cmca
rm -f /dev/cside
rm -f /dev/cevt
rm -f /dev/cpci
rm -f /dev/cdt
rm -f /dev/cpqw
rm -f /dev/crom
rm -f /dev/cwell
rm -rf /dev/cpqhealth

sync
CPQASM=\`lsmod |fgrep cpqevt\`
if [ ${#CPQASM} -ne 0 ]; then
	echo "The cpqevt driver is being stopped . . ."
	/opt/compaq/cpqhealth/cpqevt/cevtd -t
	sleep 2
	/sbin/rmmod cpqevt
	sleep 2
	rm -f /dev/cpqevt
fi

echo "The cpqevt driver is being removed . . ."

echo "The cpqhealth is being removed . . ."
rm -f /opt/compaq/cpqhealth/*.log



%postun
sync
#
# We might be upgrading which in that case, we really do
# not want to do this.
#
if [ \$1 -ne 0 ]; then
   echo "Post cpqhealth package Upgrade. . ."
   exit 0
fi

rm -rf /tmp/cpqrpm
rm -rf /opt/compaq/cpqhealth
echo "The cpqhealth package has been removed from this system"
rm -f /var/lock/subsys/cpqasm
echo -e "\n"


%clean
rm -fR $RPM_BUILD_ROOT

%files 
%defattr(755,root,root)
/opt/compaq/cpqhealth
/usr/share/man/man4/cpqhealth.4.gz
/usr/share/man/man8/cpqimlview.8.gz
/sbin/bootcfg
/sbin/cpqimlview
/sbin/cpqimlview.tcl
/sbin/imlbe
/sbin/hpimlview
/sbin/hpuid
/usr/share/pixmaps/hplogo.xbm
/usr/share/pixmaps/m_blue.gif
/usr/share/pixmaps/m_fail.gif
/usr/share/pixmaps/m_green.gif
/usr/share/pixmaps/m_red.gif
/usr/share/pixmaps/m_yellow.gif
/etc/init.d/cpqasm
/etc/rc.d/rc3.d/S10cpqasm
/etc/rc.d/rc3.d/K10cpqasm
/etc/rc.d/rc5.d/S10cpqasm
/etc/rc.d/rc5.d/K10cpqasm
/etc/rc.d/rc0.d/K10cpqasm
/etc/rc.d/rc1.d/K10cpqasm
/etc/rc.d/rc2.d/K10cpqasm
/etc/rc.d/rc4.d/K10cpqasm
/etc/rc.d/rc6.d/K10cpqasm

EOF

echo "Making RPM from ${SPECFILE} . . ."
rpm -ba  ${SPECFILE}

echo "Moving ${RPMTOP}/RPMS/i386/${PKGNAM}-${VERS}-${REL}*.rpm to /opt/compaq/cpqhealth"
cp ${RPMTOP}/RPMS/i386/${PKGNAM}-${VERS}-${REL}*.rpm /opt/compaq/cpqhealth/.

echo "Moving ${RPMTOP}/SRPMS/${PKGNAM}-${VERS}-${REL}*.rpm to /opt/compaq/cpqhealth"
cp ${RPMTOP}/SRPMS/${PKGNAM}-${VERS}-${REL}*.rpm /opt/compaq/cpqhealth/.
