/*++

Copyright (c) 2000,2001 Compaq Computer Corporation

Module Name:

    CpqCiKnt.h

Abstract:

    This module contains the NT-dependent constructs for a ring-0 NT 
    driver that provides kernel mode services to an application in 
    user space.

Author:

    Tom.Bonola@compaq.com   Mar-2000

Environment:

    Kernel mode

Revision History:

--*/

#ifndef _CPQCIxxh
#define _CPQCIxxh

typedef struct _CPQCIDRVOSMEMHANDLE {
	unsigned long PhysicalAddress;
	void *VirtualAddress;
	unsigned long MemorySize;
	unsigned long Attributes;
} *CPQCIDRVOSMEMHANDLE;

typedef struct _CPQCIEXTENSIONHEADER{
    CPQCIOBJECTTYPE ObjectType;
    CPQCICHAR       ObjectName[CPQCI_OBJECT_NAME_LENGTH];
    struct _CPQCIADAPTEREXTENSION *AdapterExtension;
} CPQCIEXTENSIONHEADER;

typedef struct _CPQCIADAPTEREXTENSION {
    CPQCIEXTENSIONHEADER 		Header;
    struct _CPQCIADAPTEROBJECT*		Adapter;
    struct _CPQCICONNECTIONEXTENSION *	ConnectionList; // list of OS-created connection extensions.
    struct semaphore 			ChannelSem[2];
#if LINUX_VERSION_CODE >= 0x020300
    wait_queue_head_t 			RecvSignal[CPQCI_MAX_CHANNELS];
#else
    struct wait_queue*			RecvSignal[CPQCI_MAX_CHANNELS];
#endif
    int irq;
} CPQCIADAPTEREXTENSION;

typedef struct _CPQCICONNECTIONEXTENSION {
    CPQCIEXTENSIONHEADER Header;
    CPQCICONNECTION      Connection;
    CPQCICHANNEL         Channel;
    unsigned long paddr;
    struct _CPQCICONNECTIONEXTENSION *Next;
} CPQCICONNECTIONEXTENSION;

//Shamelessly stolen from cpqrid driver.
#pragma pack(1)
typedef struct {
	char	name[50];       /*Name of the module*/
	char	revision_number[6];
	struct {
	    ulong
	    day:5,
	    month:4,
	    year:23;
	} revision_date;                /*Date of most recent update of module*/
	char 	purpose[255];   /*Purpose of module*/
} module_info_type;
#pragma pack()
//Prototypes for memory mapping
static void* vma_private_data(struct vm_area_struct *vma);
static void cpqci_vma_open(struct vm_area_struct *vma);
static void cpqci_vma_close(struct vm_area_struct *vma);
#if LINUX_VERSION_CODE > 0x020300
static struct page* cpqci_vma_nopage_regular(struct vm_area_struct *vma, unsigned long address, int write);
static struct page* cpqci_vma_nopage_high(struct vm_area_struct *vma, unsigned long address, int write);
#else
static unsigned long cpqci_vma_nopage_regular(struct vm_area_struct *vma, unsigned long address, int write);
static unsigned long cpqci_vma_nopage_high(struct vm_area_struct *vma, unsigned long address, int write);
#endif
#endif // _CPQCIxxh
