#ifndef _CPQCITYP
#define _CPQCITYP

/******************************************************************************
    Derive private types for bit wise awareness.
******************************************************************************/


#define i_t     long    // Native access type.
#define i8_t    char
#define i16_t   short
#define i32_t   int

//  Derived from above.
typedef unsigned i_t   u_t;
typedef volatile i_t   vi_t;
typedef volatile u_t   vu_t;

typedef unsigned i8_t  u8_t;
typedef volatile i8_t  vi8_t;
typedef volatile u8_t  vu8_t;

typedef unsigned i16_t u16_t;
typedef volatile i16_t vi16_t;
typedef volatile u16_t vu16_t;

typedef unsigned i32_t u32_t;
typedef volatile i32_t vi32_t;
typedef volatile u32_t vu32_t;


typedef u8_t CPQCICHAR;
typedef u_t  CPQCICHANNEL;
typedef u_t CPQCICHANNELS;
typedef u_t CPQCICONNECTION;
typedef u_t CPQCICONNECTIONS;
typedef u_t CPQCIENTRIES;
typedef u_t CPQCISIZE;
typedef u_t CPQCITIMEOUT;
typedef u_t CPQCIPHYSICAL;
typedef u_t CPQCISIGNATURE;

typedef union { u_t uint; u8_t *ptr; u8_t  _pad[8];            } CPQCITYPEQUAD;

typedef void * CPQCICONTEXT;
typedef void * CPQCIDRVOSHANDLE;
typedef void * CPQCIVIRTUAL;

typedef void CPQCIVOID;

#define CPQCI_MAX_CHANNELS                  	32
#define CPQCI_OBJECT_NAME_LENGTH   		64
#define CPQCI_KEY_SIZE				128 

#define CPQCI_BASE_NORMALPRIORITY_CHANNEL    0
#define CPQCI_BASE_HIGHPRIORITY_CHANNEL     20
#define CPQCI_BASE_CRITICALPRIORITY_CHANNEL 24

#define CPQCI_REG_MMIOREGBAR   0x14    // 32b

#define CPQCI_SIGNATURE            0xB2040E11

#define CPQCI_INVALID_CHANNEL    ((CPQCICHANNEL)(-1))
#define CPQCI_INVALID_CONNECTION ((CPQCICONNECTION)(-1))

typedef enum _CPQCIBOOL {
    CpqCiFalse,
    CpqCiTrue
} CPQCIBOOL;

typedef enum _CPQCIOBJECTTYPE {
    CpqCiAdapter,
    CpqCiConnection
} CPQCIOBJECTTYPE;

typedef enum _CPQCIPRIORITY {
    CpqCiNormalPriority     = 0,
    CpqCiHighPriority       = 1,
    CpqCiCriticalPriority_0 = CPQCI_BASE_CRITICALPRIORITY_CHANNEL,
    CpqCiCriticalPriority_1,
    CpqCiCriticalPriority_2,
    CpqCiCriticalPriority_3,
    CpqCiCriticalPriority_4,
    CpqCiCriticalPriority_5,
    CpqCiCriticalPriority_6,
    CpqCiCriticalPriority_7
} CPQCIPRIORITY;

typedef enum _CPQCISTATUS {
    CpqCiSuccess,                      // 0x00,  0
    CpqCiErrNoDriver,                  // 0x01,  1
    CpqCiErrNoDevice,                  // 0x02,  2
    CpqCiErrNoMemory,                  // 0x03,  3
    CpqCiErrBadConnection,             // 0x04,  4
    CpqCiErrBadDescriptorCount,        // 0x05,  5
    CpqCiErrBadDescriptorSize,         // 0x06,  6
    CpqCiErrMapRegisters,              // 0x07,  7
    CpqCiErrMapDoorbells,              // 0x08,  8
    CpqCiErrMapDeviceram,              // 0x09,  9
    CpqCiErrNoDeviceMemory,            // 0x0A, 10
    CpqCiErrBadPriority,               // 0x0B, 11
    CpqCiErrNoMoreChannels,            // 0x0C, 12
    CpqCiErrNoMoreConnections,         // 0x0D, 13
    CpqCiErrNoMoreChannelMemory,       // 0x0E, 14
    CpqCiErrUnableToMapHostRam,        // 0x0F, 15
    CpqCiErrUnableToMapSendRam,        // 0x10, 16
    CpqCiErrUnableToMapRecvRam,        // 0x11, 17
    CpqCiErrUnableToMapDoorbell,       // 0x12, 18
    CpqCiErrBadObjectType,             // 0x13, 19
    CpqCiErrFifoFull,                  // 0x14, 20
    CpqCiErrFifoEmpty,                 // 0x15, 21
    CpqCiErrPartialTransfer,           // 0x16, 22
    CpqCiErrChannelStillInuse,         // 0x17, 23
    CpqCiErrAccessDenied,              // 0x18, 24
    CpqCiErrChannelDeleted,            // 0x19, 25
    CpqCiErrNoKeySpecified,            // 0x1A, 26
    CpqCiErrInvalidAdapter,            // 0x1B, 27
    CpqCiErrNoPendingChannels,         // 0x1C, 28
    CpqCiErrUnableToCreateSignal,      // 0x1D, 29
    CpqCiErrUnableToObtainSignal,      // 0x1E, 30
    CpqCiErrNotImplemented,            // 0x1F, 31
    CpqCiErrNoMoreWaiters,             // 0x20, 32
    CpqCiErrUnableToWait,              // 0x21, 33
    CpqCiErrTimeout,                   // 0x22, 34
    CpqCiErrInterface,                 // 0x23, 35
    CpqCiErrChannelNotResponding,      // 0x24, 36
    CpqCiErrBadCallingContext,         // 0x25, 37
    CpqCiErrChannelDisconnected,       // 0x26, 38
    CpqCiErrBadParameter,              // 0x27, 39
    CpqCiErrMax                        // 0x28, 40
} CPQCISTATUS;

typedef enum _CPQCIMODE {
    CpqCiKernelMode,
    CpqCiUserMode
} CPQCIMODE;

typedef enum _CPQCICACHETYPE {
    CpqCiUncached,
    CpqCiCached
} CPQCICACHETYPE;

struct _CPQCIADAPTEROBJECT;

#endif
