/*++

Copyright (c) 2000,2001 Compaq Computer Corporation

Module Name:

    CpqCiUlx.h

Abstract:

    This module contains the NT-dependent constructs for a usermode NT 
    application that uses the CpqCiSend/CpqCiRecv routines.  This
    module is also shared between the usermode application and kernel
    mode driver.

Author:

    Tom.Bonola@compaq.com   Mar-2000

Environment:

    Kernel mode

Revision History:

--*/

#ifndef _CPQCIUxxh
#define _CPQCIUxxh

//
//  CPQCI to NT constant used for specifying an infinite wait.
//
#define CPQCIWAITFOREVER UINT_MAX

//
//  Driver object base name.
//
#define CPQCI_DEVICE_NAME  "CpqCiDrv"


typedef struct _CPQCIDRVHANDLEPARMS {
    CPQCICHAR       ObjectName[CPQCI_OBJECT_NAME_LENGTH];
    CPQCIPRIORITY   Priority;
    CPQCIENTRIES    SendPackets;
    CPQCISIZE       SendPacketSize;
    CPQCIENTRIES    RecvPackets;
    CPQCISIZE       RecvPacketSize;
    CPQCIBOOL       KeyPresent;
    u8_t	    Key[CPQCI_KEY_SIZE];
    u8_t	    Ccb[CPQCI_KEY_SIZE];
    CPQCISTATUS     Error;
    CPQCITIMEOUT    TimeOut;
    int             Oshandle;
} CPQCIDRVHANDLEPARMS;

//
//  Driver IO Control Functions.
//
#define CPQCI_MINOR	170
#define CPQCI_IOCTL_BASE 'C'

#define CPQCI_IOCTL_CREATE_CHANNEL\
    _IOWR(CPQCI_IOCTL_BASE, 0, CPQCIDRVHANDLEPARMS)

#define CPQCI_IOCTL_OPEN_CHANNEL\
    _IOWR(CPQCI_IOCTL_BASE, 1, CPQCIDRVHANDLEPARMS)

#define CPQCI_IOCTL_REGISTER_WAITER\
    _IOWR(CPQCI_IOCTL_BASE, 2, unsigned long)

#define CPQCI_IOCTL_GET_INFO\
    _IOWR(CPQCI_IOCTL_BASE, 3, module_info_type)

#endif // _CPQCIUxxh
