/***************************************************************************
* Copyright (c) 1998-2002 Compaq Information Technologies Group, L.P. 
* ALL RIGHTS RESERVED.
****************************************************************************
*
*  @doc
*
*  @module  cridw_linux.h
*  Version: 1.0
*
*  Function: Provide basic support for the hp Advance Server
*            Management ASIC.
*
*  @doc
****************************************************************************
*
*  @doc
*
*  Change Log:
*
*       Date    Who   Description
*
*****************************************************************************/
#ifndef INC_CRIDW_LINUX_H
#define INC_CRIDW_LINUX_H

#ifdef MULTI_DIST
#include "linux/multi_dist.h"
#else
#include "linux/dist.h"
#endif

//Typedefs
int pci_get_slot(struct pci_dev* pdev, u8 * slot);
int crid_read_print_crid(char *Buf, char **start, off_t off, int count, int *eof, void *data, PCRIDDATA pInstance);

//*************************************************************************
//  Defines and typedefs
//*************************************************************************

#define MAX_CRID_TOID		6            /* Maximum number of timers */
#define MAX_CRID_LOCK		5            /* Maximum number of locks	 */



//
// @struct UNIXADDR | Used to track Unix Address Allocations
//


typedef struct _CRIDLOCK {
    spinlock_t        lock;         
    int	 	      start;
    int		      end;
    char	      *file;
    ULONG	      flags;
} CRIDLOCK, *PCRIDLOCK;

typedef struct _CRIDTIMER {
    struct timer_list	entry;
    void		(*pFunction)(void*);
    void*		pArg;
    ULONG  		used;
} CRIDTIMER, *PCRIDTIMER;


typedef struct _OSDATA {
    CRIDLOCK	      	crid_lock[MAX_CRID_LOCK];
    wait_queue_head_t 	slot_wq[MAX_SEQ_NUM];
    wait_queue_head_t 	get_pkt_wq;
    CRIDTIMER		timer[MAX_CRID_TOID];
} OSDATA, *POSDATA;


#endif 
