Summary     	: hp Lights-Out Drivers and Agents
Name        	: hprsm
Version     	: 6.30.0
Release     	: custom
Group       	: System Environment/Kernel
Source		: hprsm-6.30.0.tar.gz	
Copyright   	: commercial 
Packager    	: Hewlett-Packard 
Vendor		: Hewlett-Packard 
URL         	: http://www.hp.com/linux
BuildRoot   	: /var/tmp/%{name}
AutoReqProv	: no
PreReq		: /bin/sh, /bin/bash
Requires	: hpasm 

%description

The HP Lights-Out Drivers and Agents for Linux combines the drivers for the hp ProLiant Remote Insight Board, hp ProLiant Integrated Lights Out Management, and the RILO and rack agents.

The hp ProLiant Remote Insight Board Driver ensures data flow between the hp ProLiant Integrated Management Log and the Remote Insight Board. It also routes SNMP packets out of the integrated Network Interface Card so that no additional network connection has to be burdened with management traffic. The Remote Insight Board will work without this driver, however, some functionality will not be available.

The ProLiant Integrated Lights Out Management Driver (cpqci.o) is a replacement to the ProLiant Remote Insight Board Driver (cpqrib.o) that enables Remote Manageability. 

hp Server Agents for Linux provide a full spectrum of management data including RILO information for hp Servers. This information is available using the 
hp Insight Manager Console, the hp Web Agent, or other management
applications using SNMP.

The ProLiant Rack Infrastructure Interface Service enables IPMI communication through the integrated Lights Out Management Component.

%prep
%setup -n hprsm.rpm

%build

%pre
if [ "$1" = "2" ]; then
   /etc/init.d/hprsm stop
   sh /opt/compaq/hprsm/hprsm end 
fi

if [ ! -d /var/spool/compaq/server/registry ]; then
   mkdir -p /var/spool/compaq/server/registry
   chmod 700 /var/spool/compaq
   chmod 700 /var/spool/compaq/server
   chmod 700 /var/spool/compaq/server/registry
fi

%install
if [ $RPM_BUILD_ROOT != "/" ]; then
	rm -rf $RPM_BUILD_ROOT
fi
mkdir -p $RPM_BUILD_ROOT
cp -a dev $RPM_BUILD_ROOT
cp -a opt $RPM_BUILD_ROOT
cp -a usr $RPM_BUILD_ROOT
cp -a etc $RPM_BUILD_ROOT
cp -a sbin $RPM_BUILD_ROOT

%post
#Conditionally copy some files around
sh /opt/compaq/hprsm/addon/condcopy /opt/compaq/hprsm/addon/condcopy.txt
#Change file permissions
chmod go-rwx /opt/compaq
chmod go-rwx /opt/compaq/server
chmod go-rwx /opt/compaq/server/bin
chmod go-rwx /opt/compaq/server/etc
chmod go-rwx /var/spool/compaq

sync
sh /opt/compaq/hprsm/hprsm init verbose
if [ $? -eq 0 ]; then
        echo -e "\n"
        echo "The hprsm RPM has installed successfully."
	echo
	echo    "==================================================================="
	echo    "NOTE: For the proper configurations of snmpd and agents, you MUST"
	echo    "      follow the \"Post-Installation Configurations\" instructions"
	echo    "      in the \"hpasm package README.\""
	echo    "==================================================================="
	echo
else
        echo "The hprsm RPM installation failed!"
fi
    
%preun
if [ "$1" = "0" ]; then
   sync
   /etc/init.d/hprsm stop
   sh /opt/compaq/hprsm/hprsm end 

   BUSY=`lsmod |egrep "cpqrid [ ]*[0-9][0-9]* [ ]*[1-9][0-9]*"`
   if [ ${#BUSY} -ne 0 ]; then
        echo "cpqrid driver is busy and can not be removed."
        exit 1
   fi 
   BUSY=`lsmod |egrep "cpqci [ ]*[0-9][0-9]* [ ]*[1-9][0-9]*"`
   if [ ${#BUSY} -ne 0 ]; then
        echo "cpqci driver is busy and can not be removed."
        exit 1
   fi 
   
   for OS_VER in `ls -d /lib/modules/*`; do
        #Now wipe all occurences of cpqrid and cpqci in the current directory.
        if [ -f $OS_VER/misc/cpqrid.o ]; then
                rm -f $OS_VER/misc/cpqrid.o
        fi
        if [ -f $OS_VER/kernel/drivers/char/cpqrid.o ]; then
                rm -f $OS_VER/kernel/drivers/char/cpqrid.o
        fi
        if [ -f $OS_VER/misc/cpqci.o ]; then
                rm -f $OS_VER/misc/cpqci.o
        fi
        if [ -f $OS_VER/kernel/drivers/char/cpqci.o ]; then
                rm -f $OS_VER/kernel/drivers/char/cpqci.o
        fi
   done;

   #remove the conditionally copied files
   sh /opt/compaq/hprsm/addon/condrem /opt/compaq/hprsm/addon/condcopy.txt
fi

%postun
if [ "$1" = "0" ]; then
  rmdir /opt/compaq/server/bin 2>/dev/null
  rmdir /opt/compaq/server/etc 2>/dev/null
  rmdir /opt/compaq/server 2>/dev/null
  rmdir /opt/compaq 2>/dev/null
  rmdir /opt 2>/dev/null

  rm -rf /opt/compaq/cpqrid
  rm -rf /opt/compaq/cpqci
  rm -rf /opt/compaq/hprsm

  # Remove /opt/compaq/server/etc/cimsvrobjects.conf from /opt/compaq/cmaobjects.conf
  CONFFILE=/opt/compaq/cmaobjects.conf
  OBJSFILE="/opt/compaq/server/etc/cmasvrbjects.conf"
  if [ ! -f "$OBJSFILE" ]; then
    if [ -f "$CONFFILE" ]; then
      #check if the entry is already there
      grep $OBJSFILE $CONFFILE >/dev/null
      if [ "$?" = 0 ]; then
        grep -v "$OBJSFILE" $CONFFILE >$CONFFILE.$$
        cp $CONFFILE.$$ $CONFFILE
        rm -f $CONFFILE.$$
      fi
    fi
  fi
fi


%clean
rm -fR $RPM_BUILD_ROOT

%files 
%defattr(755,root,root)
/opt/compaq/cpqrid/cpcpqrid
/opt/compaq/cpqci/cpcpqci
/opt/compaq/hprsm/hprsm
/opt/compaq/hprsm/addon/condcopy
/opt/compaq/hprsm/addon/condrem
/opt/compaq/server/cpserver
/opt/compaq/server/setuphelper
%defattr(755,root,root)
/sbin/cpqriisd
/sbin/cpqblru
%defattr(755,root,root)
/etc/init.d/hprsm
%defattr(644,root,root)
/opt/compaq/cpqrid/custom/cpqrid.o
/opt/compaq/cpqci/driver/cpqci.o
/opt/compaq/cpqci/driver/up/kernel.txt
/opt/compaq/cpqci/driver/smp/kernel.txt
/opt/compaq/cpqci/driver/ent/kernel.txt
/opt/compaq/hprsm/pciFindDev.o
/opt/compaq/hprsm/addon/condcopy.txt
%defattr(644,root,root)
/opt/compaq/hprsm/addon/libcpqci.so
/opt/compaq/hprsm/addon/libcpqci.so.1
/opt/compaq/hprsm/addon/libcpqci.so.1.0
/usr/lib/libcpqci-static.a
/usr/lib/libcpqipmb.so
/usr/lib/libcpqipmb.so.1
/usr/lib/libcpqipmb.so.1.0
%defattr(644,root,root)
/usr/share/man/man4/cpqrid.4.gz
/usr/share/man/man4/cpqci.4.gz
/usr/share/man/man4/cpqriisd.4.gz
/usr/share/man/man4/cpqblru.4.gz
/usr/share/man/man4/hprsm.4.gz
%defattr(644,root,root)
/dev/crid
/dev/cpqhealth/crid
/dev/cpqci
%defattr(-,root,root)
/opt/compaq/hprsm/etc/cmad
/opt/compaq/server/bin/cmasm2d
/opt/compaq/server/bin/cmarackd
/opt/compaq/server/etc/cmasm2d
/opt/compaq/server/etc/cmarackd
/opt/compaq/hprsm/etc/cpqbssa.txt
/opt/compaq/hprsm/etc/cmasvrobjects.conf
