#ifndef MODULE
#define MODULE
#endif
#ifndef NULL
#define NULL ((void*)0)
#endif
#ifndef __KERNEL__
#define __KERNEL__
#endif

#include <linux/autoconf.h>
#include <linux/pci.h>
#include <linux/module.h>

unsigned int vend_id, dev_id;
unsigned short sub_vend_id= 0xffff, sub_dev_id=0xffff;
MODULE_PARM (vend_id, "i");
MODULE_PARM (dev_id, "i");
MODULE_PARM (sub_vend_id, "h");
MODULE_PARM (sub_dev_id, "h");

int init_module(void)
{
	struct pci_dev *pCookie = NULL;

	pCookie = pci_find_device(vend_id, dev_id, pCookie);
	if (pCookie != NULL) {
		if(sub_vend_id != 0xffff) {
			if (pCookie->subsystem_vendor != sub_vend_id) return -1;
		}
		if(sub_dev_id != 0xffff) {
			if (pCookie->subsystem_device != sub_dev_id) return -1;
		}
		return 0;
	}
	return -1;
}

void cleanup_module(void)
{
	//shouldn't have to do anything here
}
