#!/bin/bash

uname -r | grep BOOT || /sbin/depmod -a > /dev/null 2>&1 || true

if [ -f /etc/redhat-release ] ; then
mkdir /usr/src/mypci
cat <<END > /usr/src/mypci/pci.updates
# updates for the system pci.ids file
#
# IMPORTANT!  Entries in this list must be sorted as they
#             would appear in the system pci.ids file.  Entries
#             are sorted by ven, dev, subven, subdev
#             (numerical order).
#
14e4  Broadcom Corporation
	1644  NetXtreme BCM5700 Gigabit Ethernet
		1014 0277  Broadcom Vigil B5700 1000Base-T
		1028 00d1  Broadcom BCM5700
		1028 0106  Broadcom BCM5700
		1028 0109  Broadcom BCM5700 1000Base-T
		1028 010a  Broadcom BCM5700 1000BaseTX
		10b7 1000  3C996-T 1000Base-T
		10b7 1001  3C996B-T 1000Base-T
		10b7 1002  3C996C-T 1000Base-T
		10b7 1003  3C997-T 1000Base-T Dual Port
		10b7 1004  3C996-SX 1000Base-SX
		10b7 1005  3C997-SX 1000Base-SX Dual Port
		10b7 1008  3C942 Gigabit LOM (31X31)
		14e4 0002  NetXtreme 1000Base-SX
		14e4 0003  NetXtreme 1000Base-SX
		14e4 0004  NetXtreme 1000Base-T
		14e4 1028  NetXtreme 1000BaseTX
		14e4 1644  BCM5700 1000Base-T
	1645  NetXtreme BCM5701 Gigabit Ethernet
		0e11 007c  NC7770 Gigabit Server Adapter (PCI-X, 10/100/1000-T)
		0e11 007d  NC6770 Gigabit Server Adapter (PCI-X, 1000-SX)
		0e11 0085  NC7780 Gigabit Server Adapter (embedded, WOL)
		0e11 0099  NC7780 Gigabit Server Adapter (embedded, WOL)
		0e11 009a  NC7770 Gigabit Server Adapter (PCI-X, 10/100/1000-T)
		0e11 00c1  NC6770 Gigabit Server Adapter (PCI-X, 1000-SX)
		1028 0121  Broadcom BCM5701 1000Base-T
		103c 128a  HP 1000Base-T (PCI) [A7061A]
		103c 128b  HP 1000Base-SX (PCI) [A7073A]
		103c 12a4  HP Core Lan 1000Base-T
		103c 12c1  HP IOX Core Lan 1000Base-T [A7109AX]
		10a9 8010  SGI IO9 Gigabit Ethernet (Copper)
		10a9 8011  SGI Gigabit Ethernet (Copper)
		10a9 8012  SGI Gigabit Ethernet (Fiber)
		10b7 1004  3C996-SX 1000Base-SX
		10b7 1006  3C996B-T 1000Base-T
		10b7 1007  3C1000-T 1000Base-T
		10b7 1008  3C940-BR01 1000Base-T
		14e4 0001  BCM5701 1000Base-T
		14e4 0005  BCM5701 1000Base-T
		14e4 0006  BCM5701 1000Base-T
		14e4 0007  BCM5701 1000Base-SX
		14e4 0008  BCM5701 1000Base-T
		14e4 8008  BCM5701 1000Base-T
	1646  NetXtreme BCM5702 Gigabit Ethernet
		0e11 00bb  NC7760 1000BaseTX
		1028 0126  Broadcom BCM5702 1000BaseTX
		14e4 8009  BCM5702 1000BaseTX
	1647  NetXtreme BCM5703 Gigabit Ethernet
		0e11 0099  NC7780 1000BaseTX
		0e11 009a  NC7770 1000BaseTX
		10a9 8010  SGI IO9 Gigabit Ethernet (Copper)
		14e4 0009  BCM5703 1000BaseTX
		14e4 000a  BCM5703 1000BaseSX
		14e4 000b  BCM5703 1000BaseTX
		14e4 8009  BCM5703 1000BaseTX
		14e4 800a  BCM5703 1000BaseTX
	1648  NetXtreme BCM5704 Gigabit Ethernet
		0e11 00cf  NC7772 Gigabit Server Adapter (PCI-X, 10,100,1000-T)
		0e11 00d0  NC7782 Gigabit Server Adapter (PCI-X, 10,100,1000-T)
		0e11 00d1  NC7783 Gigabit Server Adapter (PCI-X, 10,100,1000-T)
		10b7 2000  3C998-T Dual Port 10/100/1000 PCI-X
		10b7 3000  3C999-T Quad Port 10/100/1000 PCI-X
		1166 1648  NetXtreme CIOB-E 1000Base-T
	164d  NetXtreme BCM5702FE Gigabit Ethernet
	1653  NetXtreme BCM5705 Gigabit Ethernet
		0e11 00e3  NC7761 Gigabit Server Adapter
	1654  NetXtreme BCM5705_2 Gigabit Ethernet
		0e11 00e3  NC7761 Gigabit Server Adapter
		103c 3100  NC1020 HP ProLiant Gigabit Server Adapter 32 PCI
	1659  NetXtreme BCM5721 Gigabit Ethernet PCI Express
	165d  NetXtreme BCM5705M Gigabit Ethernet
	165e  NetXtreme BCM5705M_2 Gigabit Ethernet
	1600  NetXtreme BCM5752 1000Base-T PCI Express$
	1601  NetXtreme BCM5752M 1000Base-T PCI Express$
	166e  570x 10/100 Integrated Controller
	1677  NetXtreme BCM5751 Gigabit Ethernet PCI Express
		1028 0179  Optiplex GX280
	167d  NetXtreme BCM5751M Gigabit Ethernet PCI Express
	167e  NetXtreme BCM5751F Fast Ethernet PCI Express
	1696  NetXtreme BCM5782 Gigabit Ethernet
		103c 12bc  HP d530 CMT (DG746A)
		14e4 000d  NetXtreme BCM5782 1000Base-T
	169c  NetXtreme BCM5788 Gigabit Ethernet
	169d  NetLink BCM5789 Gigabit Ethernet PCI Express
	16a6  NetXtreme BCM5702X Gigabit Ethernet
		0e11 00bb  NC7760 Gigabit Server Adapter (PCI-X, 10/100/1000-T)
		1028 0126  BCM5702 1000Base-T
		14e4 000c  BCM5702 1000Base-T
		14e4 8009  BCM5702 1000Base-T
	16a7  NetXtreme BCM5703X Gigabit Ethernet
		0e11 00ca  NC7771 Gigabit Server Adapter (PCI-X, 10,100,1000-T)
		0e11 00cb  NC7781 Gigabit Server Adapter (PCI-X, 10,100,1000-T)
		14e4 0009  NetXtreme BCM5703 1000Base-T
		14e4 000a  NetXtreme BCM5703 1000Base-SX
		14e4 000b  NetXtreme BCM5703 1000Base-T
		14e4 800a  NetXtreme BCM5703 1000Base-T
	16a8  NetXtreme BCM5704S Gigabit Ethernet
		10b7 2001  3C998-SX Dual Port 1000-SX PCI-X
	16aa  NetXtreme II BCM5706S Gigabit Ethernet
	16c6  NetXtreme BCM5702A3 Gigabit Ethernet
		10b7 1100  3C1000B-T 10/100/1000 PCI
		14e4 000c  BCM5702 1000Base-T
		14e4 8009  BCM5702 1000Base-T
	16c7  NetXtreme BCM5703 Gigabit Ethernet
		0e11 00ca  NC7771 Gigabit Server Adapter (PCI-X, 10,100,1000-T)
		0e11 00cb  NC7781 Gigabit Server Adapter (PCI-X, 10,100,1000-T)
		103c 12c3  HP Combo FC/GigE-SX [A9782A]
		103c 12ca  HP Combo FC/GigE-T [A9784A]
		14e4 0009  NetXtreme BCM5703 1000Base-T
		14e4 000a  NetXtreme BCM5703 1000Base-SX
	16dd  NetLink BCM5781 Gigabit Ethernet PCI Express
	16f7  NetXtreme BCM5753 Gigabit Ethernet PCI Express
	16fd  NetXtreme BCM5753M Gigabit Ethernet PCI Express
	16fe  NetXtreme BCM5753F Fast Ethernet PCI Express
	170d  NetXtreme BCM5901 100Base-TX
		1014 0545  ThinkPad R40e (2684-HVG) builtin ethernet controller
	170e  NetXtreme BCM5901 100Base-TX

END

# Find the correct PCI files
pci_ids_file=
pci_table_file=
if [ -f /usr/share/hwdata/pci.ids ]; then
        pci_ids_file="/usr/share/hwdata/pci.ids"
elif [ -f /usr/share/pci.ids ]; then
        pci_ids_file="/usr/share/pci.ids"
else
        echo "Could not locate pci.ids." >&2
        echo "No PCI updates performed." >&2
fi

if [ -f /usr/share/hwdata/pcitable ]; then
        pci_table_file="/usr/share/hwdata/pcitable"
elif [ -f /usr/share/kudzu/pcitable ]; then
        pci_table_file="/usr/share/kudzu/pcitable"
else
        echo "Could not locate pcitable." >&2
        echo "No PCI updates performed." >&2
fi

if [ "$pci_ids_file" = "" ] || [ "$pci_table_file" = "" ]; then
        # Exit without performing updates.
        return 0
fi

#Yes, this really needs bash
bash -s $pci_ids_file \
        $pci_table_file \
        /usr/src/mypci/pci.updates \
        /usr/src/mypci/pci.ids.new \
        /usr/src/mypci/pcitable.new \
        bcm5700 \
<<"END"

#! /bin/bash
# $1 = system pci.ids file to update
# $2 = system pcitable file to update
# $3 = file with new entries in pci.ids file format
# $4 = pci.ids output file
# $5 = pcitable output file
# $6 = driver name for use in pcitable file

exec 3<$1
exec 4<$2
exec 5<$3
exec 6>$4
exec 7>$5
driver=$6
IFS=

# pattern matching strings
ID="[[:xdigit:]][[:xdigit:]][[:xdigit:]][[:xdigit:]]"
VEN="${ID}*"
DEV="	${ID}*"
SUB="	${ID}*"
TABLE_DEV="0x${ID}	0x${ID}	\"*"
TABLE_SUB="0x${ID}	0x${ID}	0x${ID}	0x${ID}	\"*"

line=
table_line=
ids_in=
table_in=
vendor=
device=
subdev=
subdev=
ven_str=
dev_str=
sub_str=

# force a sub-shell to fork with a new stdin
# this is needed if the shell is reading these instructions from stdin
while true
do
        # get the first line of each data file to jump start things
        exec 0<&3
        read -r ids_in
        exec 0<&4
        read -r table_in

        # outer loop reads lines from the updates file
        exec 0<&5
        while read -r line
        do
                # vendor entry
                if [[ $line == $VEN ]]
                then
                        vendor=0x${line:0:4}
                        ven_str=${line#${line:0:6}}
                        # add entry to pci.ids
                        exec 0<&3
                        exec 1>&6
                        while [[ $ids_in != $VEN ||
                                 0x${ids_in:0:4} < $vendor ]]
                        do
                                echo "$ids_in"
                                read -r ids_in
                        done
                        echo "$line"
                        if [[ 0x${ids_in:0:4} == $vendor ]]
                        then
                                read -r ids_in
                        fi

                # device entry
                elif [[ $line == $DEV ]]
                then
                        device=0x${line:1:4}
                        dev_str=${line#${line:0:7}}
                        table_line="$vendor     $device \"$driver\"     \"$ven_str|$dev_str\""
                        # add entry to pci.ids
                        exec 0<&3
                        exec 1>&6
                        while [[ $ids_in != $DEV ||
                                 0x${ids_in:1:4} < $device ]]
                        do
                                if [[ $ids_in == $VEN ]]
                                then
                                        break
                                fi
                                echo "$ids_in"
                                read -r ids_in
                       done
                        echo "$line"
                        if [[ 0x${ids_in:1:4} == $device ]]
                        then
                                read -r ids_in
                        fi
                        # add entry to pcitable
                        exec 0<&4
                        exec 1>&7
                        while [[ $table_in != $TABLE_DEV ||
                                 ${table_in:0:6} < $vendor ||
                                 ( ${table_in:0:6} == $vendor &&
                                   ${table_in:7:6} < $device ) ]]
                        do
                                echo "$table_in"
                                read -r table_in
                        done
                        echo "$table_line"
                        if [[ ${table_in:0:6} == $vendor &&
                              ${table_in:7:6} == $device ]]
                        then
                                read -r table_in
                        fi

                # subsystem entry
                elif [[ $line == $SUB ]]
                then
                        subven=0x${line:2:4}
                        subdev=0x${line:7:4}
                        sub_str=${line#${line:0:13}}
                        table_line="$vendor     $device $subven $subdev \"$driver\"     \"$ven_str|$sub_str\""
                        # add entry to pci.ids
                        exec 0<&3
                        exec 1>&6
                        while [[ $ids_in != $SUB ||
                                 0x${ids_in:2:4} < $subven ||
                                 ( 0x${ids_in:2:4} == $subven &&
                                  0x${ids_in:7:4} < $subdev ) ]]
                        do
                                if [[ $ids_in == $VEN ||
                                      $ids_in == $DEV ]]
                                then
                                        break
                                fi
                                if [[ ! (${ids_in:2:4} == "1014" &&
                                         ${ids_in:7:4} == "052C") ]]
                                then
                                        echo "$ids_in"
                                fi
                                read -r ids_in
                        done
                        echo "$line"
                        if [[ 0x${ids_in:2:4} == $subven  &&
                              0x${ids_in:7:4} == $subdev ]]
                        then
                                read -r ids_in
                        fi
                        # add entry to pcitable
                        exec 0<&4
                        exec 1>&7
                        while [[ $table_in != $TABLE_SUB ||
                                 ${table_in:14:6} < $subven ||
                                 ( ${table_in:14:6} == $subven &&
                                   ${table_in:21:6} < $subdev ) ]]
                        do
                                if [[ $table_in == $TABLE_DEV ]]
                                then
                                        break
                                fi
                                if [[ ! (${table_in:14:6} == "0x1014" &&
                                         ${table_in:21:6} == "0x052C") ]]
                                then
                                        echo "$table_in"
                                fi
                                read -r table_in
                        done
                        echo "$table_line"
                        if [[ ${table_in:14:6} == $subven &&
                              ${table_in:21:6} == $subdev ]]
                        then
                                read -r table_in
                        fi
                fi

                exec 0<&5
        done

        # print the remainder of the original files
        exec 0<&3
        exec 1>&6
        echo "$ids_in"
        while read -r ids_in
        do
                echo "$ids_in"
        done

        exec 0>&4
        exec 1>&7
        echo "$table_in"
        while read -r table_in
        do
                echo "$table_in"
        done

        break
done <&5

exec 3<&-
exec 4<&-
exec 5<&-
exec 6>&-
exec 7>&-

END

# Use the variables from above again.
/bin/cp -f /usr/src/mypci/pci.ids.new  $pci_ids_file
/bin/cp -f /usr/src/mypci/pcitable.new $pci_table_file

rm -rf /usr/src/mypci

fi
echo "done"
exit 0
