/*name and version number:@(#)linuxif.h	1.13*/
/*date of get: 		  11/24/03 14:46:49*/
/*date of delta:	  02/20/01 19:05:19*/
/****************************************************************
File :  linuxif.h
Description :
	Contains the interface functions for Linux

Copyright (C) 1999, 2000, 2001 Lucent Technologies Inc.
Copyright (C) 2001, 2002, 2003 Agere Systems Inc. All rights reserved.

****************************************************************/

#define LT_COUNTRY_ID	0x19

#define LT_SERIAL_PORT_DEFNS			        \
	/* UART CLK   PORT IRQ     FLAGS         */	\
	{ 0, BASE_BAUD, 0x000, 0, 0 },	/* ttyS0 */	\
	{ 0, BASE_BAUD, 0x000, 0, 0 },	/* ttyS1 */	\
	{ 0, BASE_BAUD, 0x000, 0, 0 },	/* ttyS2 */	\
	{ 0, BASE_BAUD, 0x000, 0, 0 },	/* ttyS3 */     \
	{ 0, BASE_BAUD, 0x000, 0, 0 }, 	/* ttyS4 */	\
	{ 0, BASE_BAUD, 0x000, 0, 0 },	/* ttyS5 */	\
	{ 0, BASE_BAUD, 0x000, 0, 0 },	/* ttyS6 */	\
	{ 0, BASE_BAUD, 0x000, 0, 0 },	/* ttyS7 */	\
	{ 0, BASE_BAUD, 0x000, 0, 0 },	/* ttyS8 */	\
	{ 0, BASE_BAUD, 0x000, 0, 0 },	/* ttyS9 */	\
	{ 0, BASE_BAUD, 0x000, 0, 0 },	/* ttyS10 */	\
	{ 0, BASE_BAUD, 0x000, 0, 0 },	/* ttyS11 */	\
	{ 0, BASE_BAUD, 0x000, 0, 0 },	/* ttyS12 */	\
	{ 0, BASE_BAUD, 0x000, 0, 0 },	/* ttyS13 */	\
	{ 0, BASE_BAUD, 0x000, 0, ASYNC_BOOT_AUTOCONF|ASYNC_SKIP_TEST },	/* ttyS14 */	


#ifdef PORT_MAX
#undef PORT_MAX
#endif

#define PORT_LTMODEM 15
#define PORT_MAX     15
#define TRUE 1
#define FALSE 0

typedef unsigned char byte ;
typedef unsigned short word ;
typedef unsigned long dword ;
typedef int BOOL;

struct ltmodem_ops
{
	int (*detect_modem)(void *pltmodem_res);
	int (*init_modem)(void);
	int (*PortOpen)(void);
	int (*PortClose)(void);
	int (*read_vuart_register)(int offset);
	int (*write_vuart_register)(int offset, int value);
	int (*app_ioctl_handler)(unsigned int cmd, unsigned long arg);
	byte(*dsp_isr)(void);
};

struct ltmodem_res
{
	word BaseAddress;
	byte Irq;
};

struct lt_pci_dev_info
{
	unsigned short	irq;
	unsigned short	vendor;
	unsigned short	device;
	unsigned short	subsystem_vendor;
	unsigned short	subsystem_device;
	unsigned short	devfn;
	unsigned char	bus_num;
	unsigned long 	Base_Address[6];
};	

extern int GetLtModemInterface(void *mdmdata);
extern int SetLtModemInterface(int state);
#define IOCTL_MODEM_APP_1	_IOR(62,41,char *)
#define IOCTL_MODEM_APP_2	_IOR(62,42,char *)
#define IOCTL_MODEM_APP_3	_IOR(62,43,char *)
#define IOCTL_MODEM_APP_4	_IOR(62,44,char *)
#define IOCTL_MODEM_APP_5	_IOR(62,45,char *)
#define IOCTL_MODEM_APP_6	_IOR(62,46,char *)
#define IOCTL_MODEM_APP_7	_IOR(62,47,char *)
#define IOCTL_MODEM_APP_8	_IOR(62,48,char *)
