/*name and version number:@(#)ltmodem.c	1.22*/
/*date of get: 		  11/24/03 14:46:49*/
/*date of delta:	  11/04/02 17:42:36*/
/****************************************************************
 * File :  ltmodem.c
 *
 * Copyright (C) 1999, 2000, 2001 Lucent Technologies Inc.
 * Copyright (C) 2001, 2002, 2003 Agere Systems Inc. All rights reserved.
 *
 * Description :
 * 	Contains the interface functions for Linux
 *
 *  Revision History
 *
 *  Initials           Date     Change
 *  Soumyendu Sarkar   11/03    SMP support included
 *
 ***************************************************************/
#include <linux/autoconf.h>
#if defined(CONFIG_MODVERSIONS) && !defined(MODVERSIONS)
#   define MODVERSIONS
#endif

#define EXPORT_SYMTAB 1
#ifdef MODVERSIONS
#include <linux/modversions.h>
#endif
#include <linux/config.h>
#include <linux/module.h>

#include <linux/sched.h>   // in order to get jiffies
#include <linux/param.h>   // in order to get HZ
#include <linux/pci.h>     // pci functions
#include <linux/interrupt.h> // in_interrupt macro
#include <linux/time.h>
#include <asm/io.h>
#include "linuxif.h"
#ifndef NO_EEPROM
#include <linux/ptrace.h>
#include <asm/uaccess.h>
#include <asm/signal.h>
#define __KERNEL_SYSCALLS__
#include <linux/unistd.h>
#include <linux/wait.h>
#include <linux/smp.h>
#endif
static char *modem_name = "Lucent Modem Controller driver";
static char *modem_version = "8.30";
#ifndef NO_EEPROM
static char *envp[] = {"HOME=/", "TERM=linux", "PATH=/usr/bin:/bin", NULL};
static int errno;
extern int g_pid;
extern int call_func_state;
struct wait_queue * mdm_wait;
extern int call_func (unsigned int func);
#endif
extern int eeprom_flag;
 
static struct pci_dev *dev = NULL;
struct timer_list timerList;
int (*lt_rs_interrupt)(void);

void lt_pcibios_read_config_word ( byte bus, byte id1, byte id2, word *result )
{
	pcibios_read_config_word ( bus, id1, id2, result );
}

void lt_pcibios_read_config_byte ( byte bus, byte id1, byte id2, byte *result )	
{
	pcibios_read_config_byte ( bus, id1, id2, result );
}

void lt_pcibios_read_config_dword ( byte bus, byte id1, byte id2, unsigned int *result )
{
	pcibios_read_config_dword ( bus, id1, id2, result );
}

int lt_pcibios_write_config_word (byte bus, byte dev_fn, byte where, unsigned short val)
{
	pcibios_write_config_word (bus, dev_fn, where, val);
}

byte Get_PCI_INTERRUPT_LINE ( void )
{
	return PCI_INTERRUPT_LINE;
}

byte Get_PCI_BASE_ADDRESS_1 ( void )
{
	return PCI_BASE_ADDRESS_1;
}

byte Get_PCI_BASE_ADDRESS_2 ( void )
{
	return PCI_BASE_ADDRESS_2;
}

dword Get_PCI_BASE_ADDRESS_IO_MASK ( void )
{
	return PCI_BASE_ADDRESS_IO_MASK;
}

byte Get_PCI_BASE_ADDRESS_SPACE_IO ( void )
{
	return PCI_BASE_ADDRESS_SPACE_IO;
}

BOOL lt_pci_present ( void )
{
	return pci_present ();
}

BOOL lt_pci_find_device ( struct lt_pci_dev_info *lt_dev, unsigned int id, unsigned int num )
{
 	int iter;
 	dev = pci_find_device ( id, num, dev );
	if ((dev) && (dev->irq))
	{
		lt_dev->irq = dev->irq;
		lt_dev->vendor = dev->vendor;
		lt_dev->device = dev->device;
		lt_dev->devfn = dev->devfn;
		lt_dev->bus_num = dev->bus->number;
#ifdef LT_KER_24
		lt_dev->subsystem_vendor = dev->subsystem_vendor;
		lt_dev->subsystem_device = dev->subsystem_device;
		for(iter=0; iter<=5; iter++)
		{
			if (dev->resource[iter].start)
				lt_dev->Base_Address[iter] = (dev->resource[iter].start | (dev->resource[iter].flags & 1));
			else
				lt_dev->Base_Address[iter] = 0;
		}
#else		
		pcibios_read_config_word(lt_dev->bus_num, lt_dev->devfn, PCI_SUBSYSTEM_VENDOR_ID, &lt_dev->subsystem_vendor);
		pcibios_read_config_word(lt_dev->bus_num, lt_dev->devfn, PCI_SUBSYSTEM_ID, &lt_dev->subsystem_device);
		for(iter=0; iter<=5; iter++)
			lt_dev->Base_Address[iter] = dev->base_address[iter];
#endif
		return TRUE;
	}
	return FALSE;
}

byte GetIrqFromDev ( void )
{
	return (byte)dev->irq;
}

byte GetBusNumberFromDev ( void )
{
	return (byte)dev->bus->number ;
}

byte GetDevfnFromDev ( void )
{
	return (byte)dev->devfn;
}

word GetDeviceFromDev ( void )
{
	return dev->device;
}

word GetVendorFromDev ( void )
{
	return dev->vendor;
}

dword GetBase_addressFromDev ( int num )
{
#ifdef LT_KER_24
	return (dev->resource[num].start | (dev->resource[num].flags & 1));
#else
	return dev->base_address[num];
#endif
}

void lt_add_timer( void (*timerfunction)(unsigned long) )
{
	timerList.expires = jiffies+1;
	timerList.function = timerfunction;
	timerList.data = 0;
	add_timer(&timerList);
}

dword VMODEM_Get_System_Time (void)
{
	struct timeval time;
	do_gettimeofday( &time);
	return((time.tv_usec/1000)+(time.tv_sec*1000));
}

void lt_init_timer ( void  )
{
	init_timer(&timerList);
}

byte inp (word addr )
{
  return inb(addr);
}

void outp (word addr, byte value )
{
    outb(value, addr);
}

word inpw(word addr)
{
	return inw(addr);
}

void outpw(word addr, word value)
{
	return outw(value, addr);
}

dword inpd(word addr)
{
	return inl(addr);
}

void outpd(word addr, dword value)
{
	return outl(value, addr);
}

/****************************************************************
Routine : dp_regread
    i/o routines to talk to the hardware - called from background
*****************************************************************/
byte dp_regread ( byte reg )
{
	unsigned long flags;
  byte ret;
  if (smp_num_cpus > 1)
  {
    save_flags(flags);
    cli();
  }
	ret = dp_regread_nonint (reg);
  if (smp_num_cpus > 1)
  {
  	restore_flags(flags);
    sti();
  }
  return ret;
}

/****************************************************************
Routine : dp_regwrite
    i/o routines to talk to the hardware - called from background
*****************************************************************/
void dp_regwrite ( byte reg, byte value )
{
	unsigned long flags;
  if (smp_num_cpus > 1)
  {
    save_flags(flags);
    cli();
  }
  dp_regwrite_nonint ( reg, value ) ;
  if (smp_num_cpus > 1)
  {
  	restore_flags(flags);
    sti();
  }
}

/****************************************************************
Routine : x_sprintf
*****************************************************************/
int x_sprintf(char * buf, const char * fmt, ...)
{
	va_list args;
	int i;
	
	va_start(args, fmt);
	i=vsprintf(buf,fmt,args);
	va_end(args);
	return (i);
}

/****************************************************************
Routine : linux_debug_message
*****************************************************************/
void linux_debug_message ( byte *msg )
{
	printk("<1>ltmodem: %s\n",msg);
}

byte modemPortOpen ( void )
{
	extern byte vxdPortOpen ( void ) ;
#ifndef NO_EEPROM
	if (call_func_state == 0)
	{
		call_func_state = 1;
		call_func(1);
	}
#endif
	return( vxdPortOpen() );
}

byte modemPortClose ( void )
{
	extern void vxdPortClose ( void ) ;
#ifndef NO_EEPROM
	if (call_func_state == 1)
	{
		call_func_state = 0;
		call_func(9);
	}
#endif
	vxdPortClose();
#ifdef LT_KER_24
	SetLtModemInterface(0);
#endif
}

static int GetLtModemInterface(void *mdmdata)
{
	struct ltmodem_ops *lucent_modem_ops;
	extern int lucent_detect_modem ( void *pltmodem_res );
	extern void lucent_init_modem ( void ) ;
	extern int read_vuart_port( int offset);
	extern void write_vuart_port( int offset, int value);
	extern int app_ioctl_handler ( unsigned int cmd, unsigned long arg );
	extern byte dp_dsp_isr ( void );
	
	lucent_modem_ops = (struct ltmodem_ops *)mdmdata;
	lucent_modem_ops->detect_modem = lucent_detect_modem;
	lucent_modem_ops->init_modem = lucent_init_modem;
	lucent_modem_ops->PortOpen = modemPortOpen;
	lucent_modem_ops->PortClose = modemPortClose;
	lucent_modem_ops->read_vuart_register = read_vuart_port;
	lucent_modem_ops->write_vuart_register = write_vuart_port;
	lucent_modem_ops->app_ioctl_handler = app_ioctl_handler;
	lucent_modem_ops->dsp_isr = dp_dsp_isr;
}
EXPORT_SYMBOL(GetLtModemInterface);

static int SetLtModemInterface(int state)
{
	if (state == 1)
#ifdef LT_KER_24
		lt_rs_interrupt = (int (*)(void))inter_module_get("lt_rs_interrupt");
#else
		lt_rs_interrupt = (int (*)(void))get_module_symbol("ltserial","lt_rs_interrupt");
#endif
	else
	{
#ifdef LT_KER_24
		inter_module_put("lt_rs_interrupt");
#endif
		lt_rs_interrupt = NULL;
	}
	if (lt_rs_interrupt == NULL)
		return (-1);
	return (0);
}
EXPORT_SYMBOL(SetLtModemInterface);

#ifdef MODULE
int init_module(void)
{
 	extern byte eeprom[];
 	printk(KERN_INFO "Loading %s version %s\n", modem_name, modem_version);
#ifndef NO_EEPROM
	eeprom_flag = 1;
	call_func_state = 0;
#else
	eeprom_flag = 0;
	eeprom[0] = LT_COUNTRY_ID;	// set the country ID for the Lucent modem
#endif
 	return 0;
}
void cleanup_module(void)
{
	printk(KERN_INFO "Unloading %s: version %s\n", modem_name, modem_version);
}
MODULE_DESCRIPTION("Lucent Modem Controller driver");
#endif

#ifndef NO_EEPROM
void lin_kill(void)
{
	if (g_pid)
	{
		kill_proc(g_pid, SIGKILL,9);
		g_pid = 0;
	}
}

void lin_wake_up(void)
{
	wake_up(&mdm_wait);
}

void lin_interruptible_sleep_on( void )
{
	interruptible_sleep_on(&mdm_wait);
}
int lin_signal_pending( void )
{
	signal_pending(current);
	if(current->sigpending == 1)
		return 1;
	else
		return 0;
}

int function_1 (int (*fn)(void *), char *a)
{
	int i;
	int pid;

	pid = kernel_thread(fn, a, 0);
	return pid;
}

static int function_2 (char *p)
{
	char *argStr;
	char* argv[] = {"",NULL};
	int err;
	int pid;

		set_fs(KERNEL_DS);
		if((pid = execve(p, argv, envp)) < 0)
		{
         		err = errno;
			return err;
		}
	return 0;
}
#else
void lin_kill(void) {}
void lin_wake_up(void) {}
void lin_interruptible_sleep_on( void ) {}
int lin_signal_pending( void ) {}
int function_1 (int (*fn)(void *), char *a) {}
int function_2 (char *p) {}
#endif
