
var oShell = new ActiveXObject('Wscript.Shell');
var oFS = new ActiveXObject('Scripting.FileSystemObject');
var ForReading = 1;
var ForWriting = 2;

//	User downloads zip file from web
//	User unzips to a directory
//	User executes in the directory Mib71Update

// Use the WScript object to output message
//function Msg(sString)
function Msg(sString)
{
    WScript.Echo(sString);
}


function ErrMsg(sFncName, err)
{
    Msg(sFncName + '- Error: ' + err.number + ' ' + err.description);
}

function IsValidKey(sKey)
{
    var bRetVal = false;
    try
    {
        //	 no such key -2147024894 Invalid root in registry key "HKEY_LOCAL_MACHINE\SOFTWARE\Compaq\Insight Manager XE\3.22\".
        oShell.RegRead(sKey);
        bRetVal = true;
    }
    catch(err)
    {
        Msg(err.number + ' ' + err.description);
    }
    return bRetVal;
}


//
// FindFiles
//
function FindFiles(sFolder,sExt,nRecurse)
{
    var FileList = new Array();
    try
    {
    	var f = oFS.GetFolder(sFolder);
	    var fc = new Enumerator(f.files);
	    for (; !fc.atEnd(); fc.moveNext())
	    {
	        if (sExt == oFS.GetExtensionName(fc.item().Path))
	        {
		        FileList.push(fc.item().Name);
            }
	    }
	    if (nRecurse-- > 0)
	    {
	        // recurse into subdirectories
	        fc = new Enumerator(f.SubFolders);
	        for (; !fc.atEnd(); fc.moveNext())
	        {
		        FileList += FindFiles(fc.item(), sExtnRecurse);
	        }
	    }
    }
    catch (err)
    {
	    ErrMsg('FindFiles ', err);
    }
    return FileList;
}

//
// MakeDir
//
function MakeDir( sDest )
{
    if( oFS.FolderExists( sDest ) )
    {
        return true;
    }

    oFS.CreateFolder( sDest );
    return oFS.FolderExists( sDest );
}

//
// CopyFiles
//
function CopyFiles(sSrcFiles, sDest)
{
    var bRetVal = false;
    try
    {
	    oFS.Copyfile( sSrcFiles, sDest );
	    bRetVal = true;
    }
    catch (err)
    {
	    ErrMsg('CopyFiles ', err);
    }
    return bRetVal;
}

//
// ServiceRunning
//
function ServiceRunning( sServiceName )
{
    return true;
    var bRetVal = false;
    try
    {
	    var sTempFile = oFS.GetTempName();
	    oShell.Run('cmd /c net start > ' + sTempFile,0,true);
	    oFile = oFS.OpenTextFile(sTempFile,ForReading);
	    var sResults = oFile.ReadAll();
	    oFile.Close();
	    oFS.DeleteFile(sTempFile);
	    if (-1 != sResults.indexOf(sServiceName))
	    {
	        bRetVal = true;
	    }
    }
    catch(err)
    {
    	ErrMsg('ServiceRunning ', err);
    }
    return bRetVal;
}

//
// PerformNimCmd
//
function PerformNimCmd(sCmd, sRunDir)
{
    var sCmdArgs = 'cmd /c ' + sRunDir.charAt(0) + ': && cd ' + sRunDir + ' && ' + sCmd;
    var oExec = oShell.Exec(sCmdArgs);
    var oStdOut = oExec.StdOut;
    while( !oStdOut.AtEndOfStream )
    {
        WScript.Echo(oStdOut.ReadLine());
    }
    var oStdErr = oExec.StdErr;
    while( !oStdErr.AtEndOfStream )
    {
        WScript.Echo(oStdErr.ReadLine());
    }
}

//
// UpdateNimbusMibs
//
function UpdateNimbusMibs( sSrcDir, sDestDir )
{
    var bRetVal = false;
    try
    {
        if (sDestDir.length)
	    {
	        CopyFiles( sSrcDir + '\\*.mib', sDestDir + '\\mibs\\');
	        CopyFiles(sSrcDir + '\\*.cfg',sDestDir + '\\mibs\\');
	        var CfgFiles = FindFiles(sSrcDir,'cfg',0);
	        for (var i =0; i < CfgFiles.length; i++)
	        {
                PerformNimCmd('mxmib -a ' + CfgFiles[i], sDestDir);
	        }
	        bRetVal = true;
        }
	    else
        {
	        Msg('Systems Insight Manager: No Mib update, no cfg\'s to import ');
        }
    }
    catch (err)
    {
	    ErrMsg('Systems Insight Manager ', err);
    }
    return bRetVal;
}

//
// HandleNimbus
//
function HandleNimbus()
{
    var sServiceName = 'HP Systems Insight Manager';
    try
    {
        var sRootDir = oShell.RegRead('HKEY_LOCAL_MACHINE\\SOFTWARE\\Hewlett-Packard\\Systems Insight Manager\\Settings\\InstallPath');
        if( sRootDir != null )
        {
            if (ServiceRunning(sServiceName)  )
	      {
	          UpdateNimbusMibs(oShell.CurrentDirectory, sRootDir);
                Msg('System Insight Manger Mib update completed');
            }
            else
            {
                 Msg('Systems Insight Manager: No Mib update, System Insight Manger service not running');
           }
        }
        else
        {
            Msg('Systems Insight Manager: No Mib update, System Insight Manger is not installed');
        }
    }
    catch(err)
    {
        ErrMsg('Systems Insight Manager ', err);
        Msg('Systems Insight Manager: No Mib update, System Insight Manger service not running');
    }
}

HandleNimbus();
