@echo off
cls

rem makedisk batch file
rem minimum requirements DOS 6.22 or NT 3.51 or Windows 95 or newer

rem Check available environment space
set env_chk=0123456789abcdef
if %env_chk% == 0123456789abcdef goto preprocess
goto env_bad

:preprocess
set env_chk=
if "%4" == "copy" set gui=copy
if NOT "%_silent%" == "" goto env_ok
set _silent=TRUE
if "%3" == "silent" %0 %1 %2
if "%3" == "SILENT" %0 %1 %2
if "%2" == "silent" %0 %1 %3
if "%2" == "SILENT" %0 %1 %3
if "%1" == "silent" %0 %2 %3
if "%1" == "SILENT" %0 %2 %3
set _silent=FALSE

:env_ok
rem Check that OS (%1) and destination (%2) are supplied and valid
set dest=
if NOT "%gui%" == "" goto gui_dest
if "%2" == "" set dest=A:
if "%2" == "A:" set dest=A:
if "%2" == "a:" set dest=A:
if "%2" == "A:\" set dest=A:
if "%2" == "a:\" set dest=A:
if "%2" == "B:" set dest=B:
if "%2" == "b:" set dest=B:
if "%2" == "B:\" set dest=B:
if "%2" == "b:\" set dest=B:
if "%dest%" == "" goto setdest
set _mdisk_floppy=TRUE
goto dest_ok

:gui_dest
if %2 == "" set dest=A:
if %2 == "A:" set dest=A:
if %2 == "a:" set dest=A:
if %2 == "A:\" set dest=A:
if %2 == "a:\" set dest=A:
if %2 == "B:" set dest=B:
if %2 == "b:" set dest=B:
if %2 == "B:\" set dest=B:
if %2 == "b:\" set dest=B:
if "%dest%" == "" goto setdest
set _mdisk_floppy=TRUE
goto dest_ok

:setdest
set dest=%2
set _mdisk_floppy=FALSE
goto dest_ok

:dest_ok
if not exist ..\VERFILE.TIC goto wrongdir
if "%1" == "xp32fe" goto valid
if "%1" == "XP32FE" goto valid
if "%1" == "XP32GIG" goto valid
if "%1" == "xp32gig" goto valid
if "%1" == "w2kfe" goto valid
if "%1" == "W2KFE" goto valid
if "%1" == "w2kgig" goto valid
if "%1" == "W2KGIG" goto valid
goto invalid

:invalid
if NOT "%gui%" == "" goto end
echo !!! COMMAND LINE PARAMETERS ARE NOT CORRECT !!!
goto usage

:valid
if NOT "%gui%" == "" goto gui_valid
if "%dest%" == "A:" goto floppy
if "%dest%" == "B:" goto floppy
goto nofloppy

:gui_valid
if %dest% == "A:" goto floppy
if %dest% == "B:" goto floppy
goto nofloppy

:nofloppy
set mode=nofloppy
cls
echo The destination you specified (%dest%) does not
echo appear to be a diskette. If you are trying to create a diskette,
echo press Control-C and answer Y. Then enter this command again, being sure
echo enter the drive letter without a trailing backslash (A: or B:).
echo.
echo If you do want the files copied to %dest%,
if "%_silent%" == "FALSE" pause
goto cont_1

:floppy
set mode=floppy
if NOT "%gui%" == "" goto cont_1 
cls
if exist %dest%\*.* echo !! THIS DISKETTE DOES NOT APPEAR TO BE FORMATTED !!
echo.
echo Please be sure that the disk in %dest% is 1.44 meg, formatted non-bootable and
echo has no pre-existing files. To format the diskette, press Control-C
echo and answer Y, then enter the command FORMAT %dest%. Otherwise,
if "%_silent%" == "FALSE" pause
goto cont_1

:cont_1
if not exist ..\verfile.tic goto wrongdir
if "%1" == "xp32fe" goto XP32_FE
if "%1" == "XP32FE" goto XP32_FE
if "%1" == "XP32GIG" goto XP32_Gig
if "%1" == "xp32gig" goto XP32_Gig
if "%1" == "w2kfe" goto W2K_FE
if "%1" == "W2KFE" goto W2K_FE
if "%1" == "w2kgig" goto W2K_Gig
if "%1" == "W2KGIG" goto W2K_Gig
goto usage

:XP32_FE

cls
echo.
echo Copying files to %dest%
echo.

copy ..\verfile.tic %dest%
if not exist %dest%\verfile.tic goto NOCOPY

copy /v ..\PRO100\WS03XP2K\*.* %dest%
echo.
echo Base driver files have been copied to diskette. 
echo Advanced Networking Features must be installed from
echo a CD-ROM drive, or over the network after a connection
echo to your network file service is established.
echo.
if NOT "%gui%" == "" set gui=done
if "%_mdisk_floppy%" == "FALSE" goto end
echo PLEASE LABEL YOUR DISKETTE
echo Intel(R) PRO LAN Adapter Configuration and
echo Microsoft Windows Server 2003 32 and
echo Microsoft Windows XP 32 10/100 Drivers (Release # from your CD)
echo.
goto end

:W2K_FE

cls
echo.
echo Copying files to %dest%
echo.

copy ..\verfile.tic %dest%
if not exist %dest%\verfile.tic goto NOCOPY

rem 10/100 specific files (IA 32)
copy /v ..\PRO100\WS03XP2K\*.* %dest%
echo.
echo Base driver files have been copied to diskette. 
echo Advanced Networking Features must be installed from
echo a CD-ROM drive, or over the network after a connection
echo to your network file service is established.
echo.
if NOT "%gui%" == "" set gui=done
if "%_mdisk_floppy%" == "FALSE" goto end
echo PLEASE LABEL YOUR DISKETTE
echo Intel(R) PRO LAN Adapter Configuration and
echo Microsoft Windows 2000 10/100 Drivers (Release # from your CD)
echo.
goto end

:XP32_Gig

cls
echo.
echo Copying files to %dest%
echo.

copy ..\verfile.tic %dest%
if not exist %dest%\verfile.tic goto NOCOPY

rem Gigabit specific files (IA 32)
copy /v ..\PRO1000\WS03XP2K\*.* %dest%
echo.
echo Base driver files have been copied to diskette. 
echo Advanced Networking Features must be installed from
echo a CD-ROM drive, or over the network after a connection
echo to your network file service is established.
echo.
if NOT "%gui%" == "" set gui=done
if "%_mdisk_floppy%" == "FALSE" goto end
echo Intel(R) PRO LAN Adapter Configuration and
echo Microsoft Windows Server 2003 32 and
echo Microsoft Windows XP 32 Gigabit Drivers (Release # from your CD)
echo.
goto end

:W2K_Gig

cls
echo.
echo Copying files to %dest%
echo.

copy ..\verfile.tic %dest%
if not exist %dest%\verfile.tic goto NOCOPY

copy /v ..\PRO1000\WS03XP2K\*.* %dest%
echo.
echo Base driver files have been copied to diskette. 
echo Advanced Networking Features must be installed from
echo a CD-ROM drive, or over the network after a connection
echo to your network file service is established.
echo.
if NOT "%gui%" == "" set gui=done
if "%_mdisk_floppy%" == "FALSE" goto end
echo PLEASE LABEL YOUR DISKETTE
echo Intel(R) PRO LAN Adapter Configuration and
echo Microsoft Windows 2000 Gigabit Drivers (Release # from your CD)
echo.
goto end

:NOCOPY
if NOT "%gui%" == "" set gui=nocopy
if NOT "%gui%" == "" goto end
cls
echo.
echo Can not copy to %dest%.
echo Please check your syntax and try again.
goto usage

:usage
echo.
echo Usage rules:
echo MAKEDISK [operating system] [destination (optional)] [silent (optional)]
echo.
echo where [operating system] is the OS family you are creating the diskette for
echo XP32FE   = Microsoft Windows Server 2003/XP 10/100 based solutions
echo XP32GIG  = Microsoft Windows Server 2003/XP Gigabit based solutions
echo W2KFE    = Microsoft Windows 2000 10/100 based solutions
echo W2KGIG   = Microsoft Windows 2000 Gigabit based solutions
echo.
echo and where [destination] is the drive letter and path (such as A:)
echo and where [silent] = run in silent mode (does not pause for user input)
echo Do not add a trailing backslash (\) to the destination path.
echo [destination] (will be A: if none specified) is expected to be formatted media.
echo This utility MUST be run from the \MAKEDISK directory.
echo.
pause 
echo EXAMPLE:

echo To create a Windows XP install diskette for 10/100 drivers in A:, from the
echo MAKEDISK directory run:
echo    MAKE2KXP XP32FE 
echo.
pause
goto END

:env_bad
set env_chk=
cls
echo ERROR: Your computer does not have sufficient environment space to
echo run this batch file. Please increase the available environment space
echo and run this batch file again. To increase the avaiable environment
echo space, please do the following;
echo.
echo                                  DOS
echo If you are running DOS, edit the CONFIG.SYS file and find the statement
echo COMMAND=C:\(PATH)\COMMAND.COM /e:(number)
echo where (path) is the directory path to your COMMAND.COM file and (number)
echo is a numerical value. Increase the numerical value by at least 32.
echo If this line does not exist, add the following line;
echo COMMAND=C:\COMMAND.COM /E:512
echo Reboot the computer before running this batch file again.
echo.
echo                        Windows 2000 and Windows NT
echo Click Start, then Run, then enter "CMD /E:4096" (without the quotes) to
echo open a DOS window, and then re-run this batch file in that window.
echo.
echo                    Windows 95, Windows 98 and Windows ME
echo Click Start, then Run, then enter "COMMAND /E:4096" (without the quotes) to
echo open a DOS window, and then re-run this batch file in that window.
goto end

:WRONGDIR
if NOT "%gui%" == "" set gui=wrongdir
if NOT "%gui%" == "" goto end
cls
echo You must run this utility from the \MAKEDISK directory.
goto usage

:END
set dest=
set mode=
set _silent=
set _mdisk_floppy=
if "%gui%" == "" goto CLI_EXIT

REM FINISH_ALL
if NOT "%gui%" == "done" goto GUI_INSERTSECOND
echo 0 > %TEMP%\makediskoutput.txt
cls
exit 0

:GUI_INSERTSECOND
if NOT "%gui%" == "insertsecond" goto GUI_INSERTSECOND
echo 1 > %TEMP%\makediskoutput.txt
cls
exit 1

:GUI_NOCOPY
if NOT "%gui%" == "nocopy" goto GUI_WRONGDIR
echo 2 > %TEMP%\makediskoutput.txt
cls
exit 2

:GUI_WRONGDIR
if NOT "%gui%" == "wrongdir" goto GUI_GENFAILURE
echo 4 > %TEMP%\makediskoutput.txt
cls
exit 4

:GUI_GENFAILURE
echo 9 > %TEMP%\makediskoutput.txt
cls
exit 9

:CLI_EXIT
