#!/bin/bash
#
# Name: remove_qla2x00.sh
# Copyright: (C)2003 Hewlett-Packard
#
# Description: This script removes any qla2x00, qla2200,
#              or qla2300 module from the specified ramdisk
#
# Modification History
#
# Name		Date	 Description
#
# Chad Dupuis   03/04/03 Initial Development
# Chad Dupuis   06/03/03 Updates for IA64

# cleans up file in /tmp

clean_up () {
 mount $RAMDISKMNT 1>/dev/null 2>/dev/null
 rmdir $RAMDISKMNT
 rm -f $TMPRAMDISK
 rm -f $MYIMAGE
}

MYIMAGE=/tmp/myimage
RAMDISKMNT=/tmp/ramdisk
TMPRAMDISK=/tmp/myramdisk2
BOOTDIR=/boot/efi/efi/redhat

# check number of args

if [ $# -ne 1 ]
then
 echo "Usage: remove_qla2x00 <initrd file>"
 exit 1
else
 INITRD=/boot/efi/efi/redhat/$1
fi

# check that the file being specified exists

ls $INITRD 1>/dev/null 2>/dev/null

if [ $? -ne 0 ]
then
 echo "$INITRD doesn't exist!"
 exit 1
fi

# uncompress the ramdisk image

cd /tmp
echo "Uncompressing initrd."

cat $INITRD | gunzip > $MYIMAGE

if [ $? -ne 0 ]
then
 echo ""
 echo "Could not uncompress $INITRD"
 clean_up
 exit 1
fi

# mount ramdisk image

echo "Mounting initrd."

if [ ! -d $RAMDISKMNT ]
then
 mkdir $RAMDISKMNT
fi

LOOPDEVS=`ls /dev/loop*`

MOUNTED=0

for i in $LOOPDEVS
do
 mount $MYIMAGE $RAMDISKMNT -t ext2 -o loop=$i
 
 if [ $? -eq 0 ]
 then
  MOUNTED=1
  break
 fi
done

if [ $MOUNTED -ne 1 ]
then
 echo ""
 echo "Could not mount $MYIMAGE"
 clean_up
 exit 1
fi

# Remove any qla2x00i.o, qla2200.o, or qla2300.o files

echo "Removing any qla2x00, qla2200, or qla2300 modules from initrd."

rm -f $RAMDISKMNT/lib/qla2x00.o 1>/dev/null 2>/dev/null
rm -f $RAMDISKMNT/lib/qla2200.o 1>/dev/null 2>/dev/null
rm -f $RAMDISKMNT/lib/qla2300.o 1>/dev/null 2>/dev/null

# create new linuxrc file without any references to
# qla2200 or qla2300

cp $RAMDISKMNT/linuxrc /tmp/linuxrc
cat /tmp/linuxrc | grep -v qla2x00 > /tmp/linuxrc.tmp
cat /tmp/linuxrc.tmp | grep -v qla2200 > /tmp/linuxrc.tmp2
cat /tmp/linuxrc.tmp2 | grep -v qla2300 > /tmp/linuxrc.tmp3
mv -f linuxrc.tmp3 $RAMDISKMNT/linuxrc
chmod 755 $RAMDISKMNT/linuxrc
rm -f /tmp/linuxrc
rm -f /tmp/linuxrc.tmp
rm -f /tmp/linuxrc.tmp2

# Umount ramdisk image

echo "Umounting initrd."

umount $RAMDISKMNT

if [ $? -ne 0 ]
then
 echo ""
 echo "Could not umount $RAMDISKMNT"
 clean_up
 exit 1
fi

# Compress ramdisk image

echo "Compressing initrd."

cat $MYIMAGE | gzip > $TMPRAMDISK 

if [ $? -ne 0 ]
then
 echo ""
 echo "Could not compress $MYIMAGE"
 clean_up
 exit 1
fi

# move new initrd image into place
cp $INITRD $INITRD.old 1>/dev/null 2>/dev/null
mv -f $TMPRAMDISK $INITRD 1>/dev/null 2>/dev/null
chmod 755 $INITRD

clean_up
exit 0
