%define name bcm5700
%define version 7.3.5a

Summary: Broadcom Gigabit ethernet driver
Name: %{name}
Version: %{version}
Release: 1
Vendor: Broadcom Corporation
Copyright: GPL
Group: System Environment/Base
Source: bcm5700-%{version}.tgz
BuildRoot: /var/tmp/%{name}-buildroot

%description
This package contains Broadcom's Gigabit ethernet driver.

%prep
%setup -c -b 0

%build
make

%install
BCM_KVER=`uname -r | cut -c1-3 | sed 's/2\.[56]/2\.6/'`

if [ "$BCM_KVER" = "2.6" ]
then
BCM_DRV=bcm5700.ko
else
BCM_DRV=bcm5700.o
fi

echo "%defattr(-,root,root)" > $RPM_BUILD_DIR/file.list.%{name}
if [ -d /lib/modules/`uname -r`/kernel/3rdparty/bcm5700 ]
then
mkdir -p $RPM_BUILD_ROOT/lib/modules/`uname -r`/kernel/3rdparty/bcm5700
echo "/lib/modules/`uname -r`/kernel/3rdparty/bcm5700/$BCM_DRV" >> $RPM_BUILD_DIR/file.list.%{name}
elif [ -d /lib/modules/`uname -r`/kernel/drivers/addon/bcm5700 ]
then
mkdir -p $RPM_BUILD_ROOT/lib/modules/`uname -r`/kernel/drivers/addon/bcm5700
echo "/lib/modules/`uname -r`/kernel/drivers/addon/bcm5700/$BCM_DRV" >> $RPM_BUILD_DIR/file.list.%{name}
elif [ -d /lib/modules/`uname -r`/kernel/drivers/net/bcm ]
then
mkdir -p $RPM_BUILD_ROOT/lib/modules/`uname -r`/kernel/drivers/net/bcm
echo "/lib/modules/`uname -r`/kernel/drivers/net/bcm/$BCM_DRV" >> $RPM_BUILD_DIR/file.list.%{name}
elif [ -d /lib/modules/`uname -r`/kernel ]
then
mkdir -p $RPM_BUILD_ROOT/lib/modules/`uname -r`/kernel/drivers/net
echo "/lib/modules/`uname -r`/kernel/drivers/net/$BCM_DRV" >> $RPM_BUILD_DIR/file.list.%{name}
else
mkdir -p $RPM_BUILD_ROOT/lib/modules/`uname -r`/net
echo "/lib/modules/`uname -r`/net/$BCM_DRV" >> $RPM_BUILD_DIR/file.list.%{name}
fi
if [ -d /usr/share/man ]
then
mkdir -p $RPM_BUILD_ROOT/usr/share/man/man4
echo "/usr/share/man/man4/bcm5700.4.*" >> $RPM_BUILD_DIR/file.list.%{name}
elif [ -d /usr/man ]
then
mkdir -p $RPM_BUILD_ROOT/usr/man/man4
echo "/usr/man/man4/bcm5700.4.*" >> $RPM_BUILD_DIR/file.list.%{name}
fi
make install PREFIX=$RPM_BUILD_ROOT

%post
depmod -a > /dev/null 2> /dev/null
exit 0

%postun
depmod -a > /dev/null 2> /dev/null
exit 0

%clean
rm -rf $RPM_BUILD_ROOT $RPM_BUILD_DIR/file.list.%{name}

%files -f ../file.list.%{name}
%doc LICENSE README.TXT DISTRIB.TXT RELEASE.TXT

%changelog
