<html>
<!-- RCSfile: MS-DALOG.TPL Revision: 1.18  -->
<!-- (C) Copyright 2003 Hewlett-Packard Development Company, L.P. -->
<head>
<title>Drive Array Logical Drive Information</title>

<script language="JavaScript">
   writeAccess = (2 & <!cpqDaLogDrvBlinkTime.access>) != 0;
   if (writeAccess) noAutoRefresh = 1;
</script>

<!#/COMMON/PAGETAGS.TPL>

<script language="JavaScript">
contextHelp = true;

<!cpqDaCntlrEntry>
<!cpqDaLogDrvEntry>
<!cpqDaSpareEntry>
<!cpqDaPhyDrvEntry>
<!cpqDaLogDrvPerfEntry>
<!cpqDaLogDrvPhyDrvIDs.raw>
<!cpqDaLogDrvAvailSpares.raw>

<!#/COMMON/COND.JS>
<!#/COMMON/STDITEMS.JS>
<!#/COMMON/TABLES.JS>
<!#/COMMON/PARSEARG.JS>
<!#/COMMON/DISPBASE.JS>
<!#DAENUMS.JS>
<!#MS-DACMN.JS>

postfix["cpqDaLogDrvPerfTotalIO"] = "/sec";
postfix["cpqDaLogDrvPerfReads"] = "/sec";
postfix["cpqDaLogDrvPerfWrites"] = "/sec";
postfix["cpqDaLogDrvPerfSectorsRead"] = "/sec";
postfix["cpqDaLogDrvPerfSectorsWritten"] = "/sec";
postfix["cpqDaLogDrvSize"] = "MB";
postfix["cpqDaLogDrvStripeSize"] = "KB";

function getIndex(form, ctlIndex, drvIndex)
{
   form.INDEX.value = parseInt(ctlIndex) + "." + parseInt(drvIndex);
   return true;
}
function getReplacedDrive(idx, ctlIndex)
{
   var i, drive = "N/A";
   if (idx != "" && idx >= 0)
   {
      for (i = 0; i < cpqDaPhyDrvEntry.length; i++)
         if (cpqDaPhyDrvEntry[i].cpqDaPhyDrvCntlrIndex == ctlIndex &&
             cpqDaPhyDrvEntry[i].cpqDaPhyDrvIndex == idx)
         {
            drive = makeLink("CQMGSTOR/MS-DAPHY.TPL?index=" + i, phyDrvName(i), "_self");
            break;
         }
   }
   return drive;
}
</script>
</head>
<script language="JavaScript">

writeBodyHead();

idx = findArg("index");

if (idx == -1)
{
   parseArgs(tryPrevPage());
   idx = findArg("index");
}
if (idx == -1 || idx >= cpqDaLogDrvEntry.length)
{
   reportMissingArgs();
}
else
{
   thisDrv  = cpqDaLogDrvEntry[idx];
   driveIdx = thisDrv.cpqDaLogDrvIndex;
   cntlrIdx = thisDrv.cpqDaLogDrvCntlrIndex;
   thisPerf = null;

   for (i = 0; i < cpqDaLogDrvPerfEntry.length; i++)
   {
      if (cpqDaLogDrvPerfEntry[i].cpqDaLogDrvPerfCntlrIndex == cntlrIdx &&
          cpqDaLogDrvPerfEntry[i].cpqDaLogDrvPerfIndex == driveIdx)
      {
         thisPerf = cpqDaLogDrvPerfEntry[i];
         break;
      }
   }
   for (i = 0; i < cpqDaCntlrEntry.length; i++)
   {
      if (cpqDaCntlrEntry[i].cpqDaCntlrIndex == cntlrIdx)
      {
         cntlrName = daCntlrBoardName(i);
         thisCntlr = cpqDaCntlrEntry[i];
         break;
      }
   }
   driveCondition = new cpqCondition(thisDrv.cpqDaLogDrvCondition);
   writePageHead(cntlrName, "/WEBAGENT/IMAGES/MASSHDR.GIF", "Logical Drive");

   if (thisPerf == null)
   {
      totalIo = "N/A";
      reads = "N/A";
      writes = "N/A";
      sectorsRead = "N/A";
      sectorsWritten = "N/A";
   } else {
      totalIo = displayItem("cpqDaLogDrvPerfTotalIO", thisPerf.cpqDaLogDrvPerfTotalIO);
      reads = displayItem("cpqDaLogDrvPerfReads", thisPerf.cpqDaLogDrvPerfReads);
      writes = displayItem("cpqDaLogDrvPerfWrites", thisPerf.cpqDaLogDrvPerfWrites);
      sectorsRead = displayItem("cpqDaLogDrvPerfSectorsRead", thisPerf.cpqDaLogDrvPerfSectorsRead);
      sectorsWritten = displayItem("cpqDaLogDrvPerfSectorsWritten", thisPerf.cpqDaLogDrvPerfSectorsWritten);
   }
   writeTableLabel(driveCondition.image() + logDrvName(idx));
   writeTableHead();
   writeDoubleTableRow("Status:", displayItem("cpqDaLogDrvStatus", thisDrv.cpqDaLogDrvStatus),
                       "Total:", totalIo);
   writeDoubleTableRow("Fault Tolerance:", displayItem("cpqDaLogDrvFaultTol", thisDrv.cpqDaLogDrvFaultTol),
                       "Reads:", reads);
   writeDoubleTableRow("Capacity:", daDriveCapacity("cpqDaLogDrvSize", thisDrv.cpqDaLogDrvSize),
                       "Writes:", writes);
   writeDoubleTableRow("Accelerator:", displayItem("cpqDaLogDrvHasAccel", thisDrv.cpqDaLogDrvHasAccel),
                       "Sectors Read:", sectorsRead);
   writeDoubleTableRow("Stripe Size:", displayItem("cpqDaLogDrvStripeSize", thisDrv.cpqDaLogDrvStripeSize),
                       "Sectors Written:", sectorsWritten);

   if (thisDrv.cpqDaLogDrvStatus == 12)  operation = "Expand";
   else  operation = "Rebuild";

   if (typeof(thisDrv.cpqDaLogDrvPercentRebuild != "undefined") &&
       thisDrv.cpqDaLogDrvPercentRebuild != "")
   {
      rebuildCaption = "Percent " + operation + " Complete:";
      rebuildData = percentGraph(thisDrv.cpqDaLogDrvPercentRebuild);
   } else {
      rebuildCaption = operation + " Blocks Left:";
      rebuildData = displayItem("cpqDaLogDrvRebuildBlks", thisDrv.cpqDaLogDrvRebuildBlks);
   }
   if (thisDrv.cpqDaLogDrvStatus != 7)
      writeDoubleTableRow(rebuildCaption, rebuildData, "", "");
   else
      writeDoubleTableRow(rebuildCaption, rebuildData,
         "Rebuilding Drive:", getReplacedDrive(thisDrv.cpqDaLogDrvRebuildingPhyDrv, cntlrIdx));
   writeTableTail();
   document.write("<br>");

   if (thisDrv.cpqDaLogDrvBlinkTime != "" && thisDrv.cpqDaLogDrvBlinkTime < 4294967295)
   {
      writeTableLabel("Identify Drive");
      writeTableHead();
      if (writeAccess)
      {
         if (thisDrv.cpqDaLogDrvBlinkTime > 1)
            document.write("<tr><form action='MS-DALOG.TPL' method='POST' target='_self' ",
              "onSubmit='return getIndex(this, thisDrv.cpqDaLogDrvCntlrIndex, thisDrv.cpqDaLogDrvIndex);'>",
              "<input type='hidden' name='TABLESET' value='1'><input type='hidden' name='INDEX' value=''>",
              "<input type='hidden' name='cpqDaLogDrvBlinkTime' value='1'><td align='center' width='50%'>",
              "<img src='/WEBAGENT/CQMGSTOR/ENG/DRVBLINK.GIF' width='72' height='42' border='0'></td>",
              "<td align='center'><input type='submit' value='Stop'></td></form></tr>");
         else  // Not blinking
            document.write("<tr><form action='MS-DALOG.TPL' method='POST' target='_self' ",
              "onSubmit='return getIndex(this, thisDrv.cpqDaLogDrvCntlrIndex, thisDrv.cpqDaLogDrvIndex);'>",
              "<td align='center' width='50%'><input type='hidden' name='TABLESET' value='1'>",
              "<input type='hidden' name='INDEX' value=''><small><font face='Arial'>Blink Drive Lights </font></small>",
              "<select name='cpqDaLogDrvBlinkTime'>",
              "<option value='600'>1 minute<option value='1200'>2 minutes<option value='1800'>3 minutes",
              "<option value='2400'>4 minutes<option value='3000' selected>5 minutes<option value='6000'>10 minutes",
              "<option value='12000'>20 minutes<option value='18000'>30 minutes<option value='24000'>40 minutes",
              "<option value='30000'>50 minutes<option value='36000'>1 hour</select></td>",
              "<td align='center'><input type='submit' value='Start'></td>",
              "</form></tr>");
      }
      else  // Read only
      {
        if (thisDrv.cpqDaLogDrvBlinkTime > 1)
            imgStr = "<img src='/WEBAGENT/CQMGSTOR/ENG/DRVBLINK.GIF' width='72' height='42' border='0'>";
         else
            imgStr = "<img src='/WEBAGENT/CQMGSTOR/ENG/DRIVE.GIF' width='72' height='42' border='0'>";

         document.write("<tr><td align='center' width='30%'>" + imgStr + "</td>",
            "<td><small><font face='Arial'>Only an administrator or an operator can blink the drive lights ",
            "to identify the drive. Select <I>Help</I> for further information.</font></small></td></tr>");
      }
      writeTableTail();
      document.write("<br>");
   }
   writeTableLabel("Physical Drives");
   writeTableHead();
   rawData = cpqDaLogDrvPhyDrvIDs[idx];
   phyDrvCondition = new cpqCondition(1);
   phyDrvCount = 0;

   for (i = 0; i < rawData.length; i++)
   {
      for (j = 0; j < cpqDaPhyDrvEntry.length; j++)
      {
         if (cpqDaPhyDrvEntry[j].cpqDaPhyDrvCntlrIndex == thisCntlr.cpqDaCntlrIndex &&
             cpqDaPhyDrvEntry[j].cpqDaPhyDrvIndex == rawData[i])
         {
            phyDrvCondition.set(cpqDaPhyDrvEntry[j].cpqDaPhyDrvCondition);
            document.write("<tr><td>");
            phyLink = "CQMGSTOR/MS-DAPHY.TPL?index=" + j;
            writeStatusNameTable(makeLink(phyLink, phyDrvCondition.imageSmall(), "_self"),
                                 makeLink(phyLink, phyDrvName(j), "_self"));
            document.write("</td></tr>");
            phyDrvCount++;
            break;
         }
      }
   }
   if (phyDrvCount == 0) writeOneItemTableRow("None");
   writeTableTail();
   document.write("<br>");

   writeTableLabel("Spare Drives");
   writeTableHead();
   rawData = cpqDaLogDrvAvailSpares[idx];
   phyDrvCondition = new cpqCondition(1);
   phyDrvCount = 0;

   for (i = 0; i < rawData.length; i++)
   {
      for (j = 0; j < cpqDaPhyDrvEntry.length; j++)
      {
         if (cpqDaPhyDrvEntry[j].cpqDaPhyDrvCntlrIndex == thisCntlr.cpqDaCntlrIndex &&
             cpqDaPhyDrvEntry[j].cpqDaPhyDrvIndex == rawData[i])
         {
            phyDrvCondition.set(cpqDaPhyDrvEntry[j].cpqDaPhyDrvCondition);
            document.write("<tr><td>");
            phyLink = "CQMGSTOR/MS-DAPHY.TPL?index=" + j;
            writeStatusNameTable(makeLink(phyLink, phyDrvCondition.imageSmall(), "_self"),
                                 makeLink(phyLink, phyDrvName(j), "_self"));
            document.write("</td></tr>");
            phyDrvCount++;
            break;
         }
      }
   }
   if (phyDrvCount == 0) writeOneItemTableRow("None");
   writeTableTail();
}
writeBodyTail();
</script>
</html>