<html>
<!-- RCSfile: MS-DTAPE.TPL Revision: 1.19  -->
<!-- (C) Copyright 2003 Hewlett-Packard Development Company, L.P. -->
<head>
<title>Drive Array Tape Drive Information</title>

<!#/COMMON/PAGETAGS.TPL>

<script language="JavaScript">
contextHelp = true;

<!cpqDaTapeLibraryEntry>
<!cpqDaTapeDrvEntry>
<!cpqDaTapeCountersEntry>

<!#/COMMON/COND.JS>
<!#/COMMON/STDITEMS.JS>
<!#/COMMON/TABLES.JS>
<!#/COMMON/PARSEARG.JS>
<!#/COMMON/DISPBASE.JS>
<!#DAENUMS.JS>
<!#MS-DACMN.JS>
</script>
</head>
<script language="JavaScript">

writeBodyHead();

drive = findArg("index");

if (drive == -1)
{
   parseArgs(tryPrevPage());
   drive = findArg("index");
}
for (index = 0; index < cpqDaTapeDrvEntry.length; index++)
{
   if (drive == cpqDaTapeDrvEntry[index].length)
      break;
}
if (drive == cpqDaTapeDrvEntry.length)
{
   reportMissingArgs();
}
else
{
   writePageHead("Tape Drive Information", "/WEBAGENT/IMAGES/MASSHDR.GIF");
   tapeCondition = new cpqCondition(cpqDaTapeDrvEntry[drive].cpqDaTapeDrvCondition);
   writeTableLabel(tapeCondition.image() + daTapeDriveName(drive));
   writeTableHead();
   writeDoubleTableRow(
      "Status:", displayItem("cpqDaTapeDrvStatus", cpqDaTapeDrvEntry[drive].cpqDaTapeDrvStatus),
      "Model:",  displayItem("cpqDaTapeDrvModel",  cpqDaTapeDrvEntry[drive].cpqDaTapeDrvName));
   writeDoubleTableRow(
      "Firmware Revision:", displayItem("cpqDaTapeDrvFwRev", cpqDaTapeDrvEntry[drive].cpqDaTapeDrvFwRev),
      "Serial Number:",     displayItem("cpqDaTapeDrvSerialNumber", cpqDaTapeDrvEntry[drive].cpqDaTapeDrvSerialNumber));
   writeDoubleTableRow(
      "Current Width:", displayItem("cpqDaTapeDrvCurrentWidth", cpqDaTapeDrvEntry[drive].cpqDaTapeDrvCurrentWidth),
      "Current Speed:", displayItem("cpqDaTapeDrvCurrentSpeed", cpqDaTapeDrvEntry[drive].cpqDaTapeDrvCurrentSpeed));
   if (cpqDaTapeDrvEntry[drive].cpqDaTapeDrvHotPlug == 2)
      writeDoubleTableRow(
         "Magazine Size:", displayItem("cpqDaTapeDrvMagSize", cpqDaTapeDrvEntry[drive].cpqDaTapeDrvMagSize),
         "Placement:",     displayItem("cpqDaTapeDrvPlacement", cpqDaTapeDrvEntry[drive].cpqDaTapeDrvPlacement) + hotPlugGraphic());
   else writeDoubleTableRow(
      "Magazine Size:", displayItem("cpqDaTapeDrvMagSize", cpqDaTapeDrvEntry[drive].cpqDaTapeDrvMagSize),
      "Placement:",     displayItem("cpqDaTapeDrvPlacement", cpqDaTapeDrvEntry[drive].cpqDaTapeDrvPlacement));

   writeDoubleTableRow(
      "Library Drive:", displayItem("cpqDaTapeDrvLibraryDrive", cpqDaTapeDrvEntry[drive].cpqDaTapeDrvLibraryDrive),
      "","");
   writeTableTail();

   document.write("<br>");
   writeTableLabel("Tape Drive Error Counts");
   writeTableHead();
   writeDoubleTableRow(
      "Tape Errors:", displayItem("cpqDaTapeCountersTotalErrors", cpqDaTapeCountersEntry[drive].cpqDaTapeCountersTotalErrors),
      "Re-Reads:",    displayItem("cpqDaTapeCountersReReads", cpqDaTapeCountersEntry[drive].cpqDaTapeCountersReReads));
   writeDoubleTableRow(
      "Uncorrectable:", displayItem("cpqDaTapeCountersTotalUncorrectable", cpqDaTapeCountersEntry[drive].cpqDaTapeCountersTotalUncorrectable),
      "Re-Writes:",     displayItem("cpqDaTapeCountersReWrites", cpqDaTapeCountersEntry[drive].cpqDaTapeCountersReWrites));
   writeDoubleTableRow(
      "Total bytes:", displayItem("cpqDaTapeCountersTotalBytes", cpqDaTapeCountersEntry[drive].cpqDaTapeCountersTotalBytes),
      "", "");
   writeTableTail();

   document.write("<br>");
   writeTableLabel("Tape Drive Maintenance");
   writeTableHead();
   writeSingleTableRow(
      "Tape Drive Heads Need Cleaning:", displayItem("cpqDaTapeDrvCleanReq", cpqDaTapeDrvEntry[drive].cpqDaTapeDrvCleanReq));
   writeSingleTableRow(
      "Cleaning Tape Needs Replacement:", displayItem("cpqDaTapeDrvCleanTapeRepl", cpqDaTapeDrvEntry[drive].cpqDaTapeDrvCleanTapeRepl));
   writeSingleTableRow(
      "Cleaning Tape Number Cleanings Done:", displayItem("cpqDaTapeDrvCleanTapeCount", cpqDaTapeDrvEntry[drive].cpqDaTapeDrvCleanTapeCount));
   writeTableTail();
}
writeBodyTail();
</script>
</html>

