<html>
<!-- RCSfile: MS-FCLOG.TPL Revision: 1.25  -->
<!-- (C) Copyright 2003 Hewlett-Packard Development Company, L.P. -->
<head>
<title>Fibre Channel Logical Drive Information</title>

<script language="JavaScript">
   writeAccess = (2 & <!cpqFcaLogDrvBlinkTime.access>) != 0;
   if (writeAccess) noAutoRefresh = 1;
</script>

<!#/COMMON/PAGETAGS.TPL>

<script language="JavaScript">
contextHelp = true;

<!cpqSsChassisEntry>
<!cpqFcaLogDrvEntry>
<!cpqFcaLogDrvPhyDrvIDs.raw>
<!cpqFcaLogDrvAvailSpares.raw>
<!cpqFcaPhyDrvEntry>
<!cpqFcaSpareEntry>
<!cpqExtArrRsrcVolEntry>
<!cpqExtArrSnapshotEntry>
<!cpqExtArrSnapshotDateTime.raw>

<!#/COMMON/COND.JS>
<!#/COMMON/STDITEMS.JS>
<!#/COMMON/TABLES.JS>
<!#/COMMON/PARSEARG.JS>
<!#/COMMON/DISPBASE.JS>
<!#SSENUMS.JS>
<!#FCAENUMS.JS>
<!#MS-FCCMN.JS>

postfix["cpqFcaLogDrvSize"] = "MB";
postfix["cpqFcaLogDrvStripeSize"] = "KB";
postfix["cpqExtArrSnapshotUsedSpace"] = "MB";
postfix["cpqExtArrRsrcVolTotalSpace"] = "MB";
postfix["cpqExtArrRsrcVolFreeNewSpace"] = "MB";
postfix["cpqExtArrRsrcVolFreeActiveSpace"] = "MB";

function getIndex(form, boxIndex, drvIndex)
{
   form.INDEX.value = parseInt(boxIndex) + "." + parseInt(drvIndex);
   return true;
}
function getReplacedDrive(idx, ctlIndex)
{
   var i, drive = "N/A";
   if (idx != "" && idx >= 0)
   {
      for (i = 0; i < cpqFcaPhyDrvEntry.length; i++)
         if (cpqFcaPhyDrvEntry[i].cpqFcaPhyDrvCntlrIndex == ctlIndex &&
             cpqFcaPhyDrvEntry[i].cpqFcaPhyDrvIndex == idx)
         {
            drive = makeLink("CQMGSTOR/MS-FCPHY.TPL?index=" + i, fcPhyDrvName(i), "_self");
            break;
         }
   }
   return drive;
}
function displayDateTime(str)
{
   var dateTime = "";
   var year = 256 * str[0] + str[1];
   if (year == 0) dateTime = "N/A";
   else
   {
      dateTime += str[2] + "/";  // month
      dateTime += str[3] + "/";  // day
      dateTime += year + "  ";
      dateTime += str[4] + ":";  // hour
      if (10 > str[5])           // minutes
         dateTime += "0" + str[5] + ":";
      else
         dateTime += str[5] + ":";
      if (10 > str[6])           // seconds
         dateTime += "0" + str[6];
      else
         dateTime += str[6];
   }
   return dateTime;
}
</script>
</head>
<script language="JavaScript">

writeBodyHead();

idx = findArg("index");

if (idx == -1)
{
   parseArgs(tryPrevPage());
   idx = findArg("index");
}
if (idx == -1 || idx >= cpqFcaLogDrvEntry.length)
{
   reportMissingArgs();
}
else
{
   thisDrv = cpqFcaLogDrvEntry[idx];
   cntlrIdx = thisDrv.cpqFcaLogDrvCntlrIndex;
   boxIdx = thisDrv.cpqFcaLogDrvBoxIndex;

   for (i = 0; i < cpqSsChassisEntry.length; i++)
   {
       if (cpqSsChassisEntry[i].cpqSsChassisIndex == boxIdx)
       {
          boxIdx = i;
          break;
       }
   }
   writePageHead(fcChassisName(boxIdx), "/WEBAGENT/IMAGES/MASSHDR.GIF", "Logical Drive Information");

   driveCondition = new cpqCondition(thisDrv.cpqFcaLogDrvCondition);
   writeTableLabel(driveCondition.image() + fcLogDrvName(idx));
   writeTableHead();
   writeDoubleTableRow(
      "Status:", displayItem("cpqFcaLogDrvStatus", thisDrv.cpqFcaLogDrvStatus), "","");
   writeDoubleTableRow(
      "Fault Tolerance:", displayItem("cpqFcaLogDrvFaultTol", thisDrv.cpqFcaLogDrvFaultTol),
      "Capacity:", fcDriveCapacity("cpqFcaLogDrvSize", thisDrv.cpqFcaLogDrvSize));

   writeDoubleTableRow(
      "Accelerator:", displayItem("cpqFcaLogDrvHasAccel", thisDrv.cpqFcaLogDrvHasAccel),
      "Stripe Size:", displayItem("cpqFcaLogDrvStripeSize", thisDrv.cpqFcaLogDrvStripeSize));

   if (thisDrv.cpqFcaLogDrvStatus == 12) caption = "Percent Expand Complete:";
   else caption = "Percent Rebuild Complete:";

   if (thisDrv.cpqFcaLogDrvStatus != 7)
      writeDoubleTableRow(caption, percentGraph(thisDrv.cpqFcaLogDrvPercentRebuild), "","");
   else
      writeDoubleTableRow(caption, percentGraph(thisDrv.cpqFcaLogDrvPercentRebuild),
         "Rebuilding Drive:", getReplacedDrive(thisDrv.cpqFcaLogDrvRebuildingPhyDrv, cntlrIdx));
   writeTableTail();
   document.write("<br>");

   if (thisDrv.cpqFcaLogDrvBlinkTime != "" && thisDrv.cpqFcaLogDrvBlinkTime < 4294967295)
   {
      writeTableLabel("Identify Drive");
      writeTableHead();
      if (writeAccess)
      {
         if (thisDrv.cpqFcaLogDrvBlinkTime > 1)
            document.write("<tr><form action='MS-FCLOG.TPL' method='POST' target='_self' ",
              "onSubmit='return getIndex(this, thisDrv.cpqFcaLogDrvBoxIndex, thisDrv.cpqFcaLogDrvIndex);'>",
              "<input type='hidden' name='TABLESET' value='1'><input type='hidden' name='INDEX' value=''>",
              "<input type='hidden' name='cpqFcaLogDrvBlinkTime' value='1'><td align='center' width='50%'>",
              "<img src='/WEBAGENT/CQMGSTOR/ENG/DRVBLINK.GIF' width='72' height='42' border='0'></td>",
              "<td align='center'><input type='submit' value='Stop'></td></form></tr>");
         else  // Not blinking
            document.write("<tr><form action='MS-FCLOG.TPL' method='POST' target='_self' ",
              "onSubmit='return getIndex(this, thisDrv.cpqFcaLogDrvBoxIndex, thisDrv.cpqFcaLogDrvIndex);'>",
              "<td align='center' width='50%'><input type='hidden' name='TABLESET' value='1'>",
              "<input type='hidden' name='INDEX' value=''><small><font face='Arial'>Blink Drive Lights </font></small>",
              "<select name='cpqFcaLogDrvBlinkTime'>",
              "<option value='600'>1 minute<option value='1200'>2 minutes<option value='1800'>3 minutes",
              "<option value='2400'>4 minutes<option value='3000' selected>5 minutes<option value='6000'>10 minutes",
              "<option value='12000'>20 minutes<option value='18000'>30 minutes<option value='24000'>40 minutes",
              "<option value='30000'>50 minutes<option value='36000'>1 hour</select></td>",
              "<td align='center'><input type='submit' value='Start'></td>",
              "</form></tr>");
      }
      else  // Read only
      {
         if (thisDrv.cpqFcaLogDrvBlinkTime > 1)
            imgStr = "<img src='/WEBAGENT/CQMGSTOR/ENG/DRVBLINK.GIF' width='72' height='42' border='0'>";
         else
            imgStr = "<img src='/WEBAGENT/CQMGSTOR/ENG/DRIVE.GIF' width='72' height='42' border='0'>";

         document.write("<tr><td align='center' width='30%'>" + imgStr + "</td>",
            "<td><small><font face='Arial'>Only an administrator or an operator can blink the drive lights ",
            "to identify the drive. Select <I>Help</I> for further information.</font></small></td></tr>");
      }
      writeTableTail();
      document.write("<br>");
   }
   writeTableLabel("Physical Drives");
   writeTableHead();
   rawData = cpqFcaLogDrvPhyDrvIDs[idx];

   for (i = 0; i < rawData.length; i++)
   {
      for (j = 0; j < cpqFcaPhyDrvEntry.length; j++)
      {
         if (cpqFcaPhyDrvEntry[j].cpqFcaPhyDrvBoxIndex == thisDrv.cpqFcaLogDrvBoxIndex &&
             cpqFcaPhyDrvEntry[j].cpqFcaPhyDrvIndex == rawData[i])
         {
            driveCondition.set(cpqFcaPhyDrvEntry[j].cpqFcaPhyDrvCondition);
            document.write("<tr><td>");
            phyLink = "CQMGSTOR/MS-FCPHY.TPL?index=" + j;
            writeStatusNameTable(makeLink(phyLink, driveCondition.imageSmall(), "_self"),
                                 makeLink(phyLink, fcPhyDrvName( j ), "_self"));
            document.write("</td></tr>");
            break;
         }
      }
   }
   writeTableTail();
   document.write("<br>");

   writeTableLabel("Spare Drives");
   writeTableHead();
   rawData = cpqFcaLogDrvAvailSpares[idx];
   phyDrvCount = 0;

   for (i = 0; i < rawData.length; i++)
   {
      for (j = 0; j < cpqFcaPhyDrvEntry.length; j++)
      {
         if (cpqFcaPhyDrvEntry[j].cpqFcaPhyDrvBoxIndex == thisDrv.cpqFcaLogDrvBoxIndex &&
             cpqFcaPhyDrvEntry[j].cpqFcaPhyDrvIndex == rawData[i])
         {
            driveCondition.set(cpqFcaPhyDrvEntry[ j ].cpqFcaPhyDrvCondition);
            document.write("<tr><td>");
            phyLink = "CQMGSTOR/MS-FCPHY.TPL?index=" + j;
            writeStatusNameTable(makeLink(phyLink, driveCondition.imageSmall(), "_self"),
                                 makeLink(phyLink, fcPhyDrvName(j), "_self"));
            document.write("</td></tr>");
            phyDrvCount++;
            break;
         }
      }
   }
   if (phyDrvCount == 0)
   {
      writeOneItemTableRow("None");
   }
   writeTableTail();
   document.write("<br>");

   // Is this a resource logical drive
   if (thisDrv.cpqFcaLogDrvSnapshotSourceDrvIndex != "" &&
       thisDrv.cpqFcaLogDrvSnapshotSourceDrvIndex != -1)
   {
      writeTableLabel("Associated Source Logical Drive");
      writeTableHead();
      for (i = 0; i < cpqFcaLogDrvEntry.length; i++)
      {
         if (cpqFcaLogDrvEntry[i].cpqFcaLogDrvBoxIndex == thisDrv.cpqFcaLogDrvBoxIndex &&
             cpqFcaLogDrvEntry[i].cpqFcaLogDrvIndex == thisDrv.cpqFcaLogDrvSnapshotSourceDrvIndex)
         {
            driveCondition.set(cpqFcaLogDrvEntry[i].cpqFcaLogDrvCondition);
            logLink = "CQMGSTOR/MS-FCLOG.TPL?index=" + i;
            document.write("<tr><td>");
            writeStatusNameTable(makeLink(logLink, driveCondition.imageSmall(), "_self"),
                                 makeLink(logLink, fcLogDrvName(i), "_self"));
            document.write("</td></tr>");
            break;
         }
      }
      writeTableTail();
      document.write("<br>");

      // Snapshot Resource Volume Information
      if (typeof(cpqExtArrRsrcVolEntry) != "undefined")
      {
         for (i = 0; i < cpqExtArrRsrcVolEntry.length; i++)
         {
            if (cpqExtArrRsrcVolEntry[i].cpqExtArrRsrcVolBoxIndex == thisDrv.cpqFcaLogDrvBoxIndex &&
                cpqExtArrRsrcVolEntry[i].cpqExtArrRsrcVolIndex == thisDrv.cpqFcaLogDrvIndex)
            {
               writeTableLabel("Snapshot Resource Volume Information");
               writeTableHead();
               writeDoubleTableRow(
                  "Status:", displayItem("cpqExtArrRsrcVolStatus", cpqExtArrRsrcVolEntry[i].cpqExtArrRsrcVolStatus),
                  "Total Space:", displayItem("cpqExtArrRsrcVolTotalSpace", cpqExtArrRsrcVolEntry[i].cpqExtArrRsrcVolTotalSpace));
               writeDoubleTableRow(
                  "Snapshot Creation:", displayItem("cpqExtArrRsrcVolAllowCreation", cpqExtArrRsrcVolEntry[i].cpqExtArrRsrcVolAllowCreation),
                  "Growth Space:", displayItem("cpqExtArrRsrcVolFreeActiveSpace", cpqExtArrRsrcVolEntry[i].cpqExtArrRsrcVolFreeActiveSpace));
               writeDoubleTableRow(
                  "Disabled Instances:", displayItem("cpqExtArrRsrcVolDisabledInstances", cpqExtArrRsrcVolEntry[i].cpqExtArrRsrcVolDisabledInstances),
                  "Creation Space:", displayItem("cpqExtArrRsrcVolFreeNewSpace", cpqExtArrRsrcVolEntry[i].cpqExtArrRsrcVolFreeNewSpace));
               writeTableTail();
               document.write("<br>");
               break;
            }
         }
      }
      // Snapshot Resource Volume Information
      if (typeof(cpqExtArrSnapshotEntry) != "undefined")
      {
         writeTableLabel("Snapshot Information");
         writeTableHead();
         if (cpqExtArrSnapshotEntry.length == 0)
            writeOneItemTableRow("None");
         else
            writeColumnTableHeaderRow("Instance", "Space Used", "Date Time", "Mounted", "Access");
         for (i = 0; i < cpqExtArrSnapshotEntry.length; i++)
         {
            if (cpqExtArrSnapshotEntry[i].cpqExtArrSnapshotBoxIndex == thisDrv.cpqFcaLogDrvBoxIndex &&
                cpqExtArrSnapshotEntry[i].cpqExtArrSnapshotRsrcVolIndex == thisDrv.cpqFcaLogDrvIndex)
            {
               thisSnap = cpqExtArrSnapshotEntry[i];
               writeColumnTableDataRow(thisSnap.cpqExtArrSnapshotInstance,
                  displayItem("cpqExtArrSnapshotUsedSpace", thisSnap.cpqExtArrSnapshotUsedSpace),
                  displayDateTime(cpqExtArrSnapshotDateTime[i]),
                  displayItem("cpqExtArrSnapshotMounted", thisSnap.cpqExtArrSnapshotMounted),
                  displayItem("cpqExtArrSnapshotAccess", thisSnap.cpqExtArrSnapshotAccess));
            }
         }
         writeTableTail();
      }
   }
   // Is this a source logical drive
   else if (thisDrv.cpqFcaLogDrvSnapshotResourceDrvIndex != "" &&
            thisDrv.cpqFcaLogDrvSnapshotResourceDrvIndex != -1)
   {
      writeTableLabel("Associated Snapshot Resource Volume");
      writeTableHead();
      for (i = 0; i < cpqFcaLogDrvEntry.length; i++)
      {
         if (cpqFcaLogDrvEntry[i].cpqFcaLogDrvBoxIndex == thisDrv.cpqFcaLogDrvBoxIndex &&
             cpqFcaLogDrvEntry[i].cpqFcaLogDrvIndex == thisDrv.cpqFcaLogDrvSnapshotResourceDrvIndex)
         {
            driveCondition.set(cpqFcaLogDrvEntry[i].cpqFcaLogDrvCondition);
            logLink = "CQMGSTOR/MS-FCLOG.TPL?index=" + i;
            document.write("<tr><td>");
            writeStatusNameTable(makeLink(logLink, driveCondition.imageSmall(), "_self"),
                                 makeLink(logLink, fcLogDrvName(i), "_self"));
            document.write("</td></tr>");
            break;
         }
      }
      writeTableTail();
   }
}
writeBodyTail();
</script>
</html>