<?php

//This file contains cimom implementation used for group configuration

function GetChildNodeValue($eltProp)
{
   $nlChildren =  $eltProp->child_nodes();
   for ($i = 0; $i< count($nlChildren); $i++)
   {
      $eltChild =  $nlChildren[$i];
      $snodeName = $eltChild->node_name();
      if("VALUE" == $snodeName)
      {
         $nodeTxtVal = $eltChild->first_child();
         if ($nodeTxtVal != NULL)
	 {
	    $sVal = $nodeTxtVal->node_value();
         }  
         break;
      }
   }
   
   return $sVal;
}


//-------------------------------------------------------------------------- 
function Validate($inValue)
{
  
  //print "inValue:$inValue";
  if((!strcasecmp("Disabled", $inValue)) or (!strcasecmp("FALSE", $inValue)))
  {
     $outValue = 0;
  }   
  elseif((!strcasecmp("Enabled", $inValue)) or (!strcasecmp("TRUE", $inValue)))
  {
     $outValue = 1;
  }  
  elseif(!strcasecmp("", $inValue))
  {
     $outValue = "empty";
  }
  else
  {
     $outValue = $inValue;
  }   
  //print "outValue:$outValue";   
  return $outValue;

}     


//--------------------------------------------------------------------------
function ApendsettingsPair($sName,$sVal)
{
    global $agentSettings;
    global $modInstStr;
    
    foreach ($agentSettings as $key => $val) 
    {
       //print "sName-->$sName, key--->$key, val--->$val\n\n";
       if($key == $sName)
       {
          $sValOut = Validate($sVal);
          //echo "sVal = $sValOut";
          //don't include the "" string as tag value
          if($sValOut !== "empty")  //0 != "empty" return false so have to use "!==" here
          {
             $modInstStr .= $val.'='.$sValOut.'&';
          }
          break;
       }
    }   
}


//--------------------------------------------------------------------------
function ModifyAgentProperties($instance)
{
    global $modInstStr;
    $nlProps = $instance->get_elements_by_tagname("PROPERTY");
    $numnlProps =count($nlProps);
    //print ("ModifyAgentProperties nlProps count=".$numnlProps);
    
    for ($nProp = 0; $nProp < $numnlProps; $nProp++)
    {
       $eltProp = $nlProps[$nProp];
       $sName = $eltProp->get_attribute ("NAME");
       $sVal = GetChildNodeValue($eltProp);
       //print ("sName:".$sName."sVal:".$sVal);
    
       if ("services" == $sName)
       {
       
		  $svSvcs = explode(', ',$sVal);
		  $dwSvcFlags = 0;
		  $status.="";
         
 		  foreach ($svSvcs as $sval)
		 {
			 if (!strncasecmp("phy", $sval, 3)) 
			 {
	     		$status.="phy,";
					$dwSvcFlags |= SVC_PHYSICAL;
			 }
			 elseif (!strncasecmp("dat", $sval, 3)) 
				 {
	     		$status.="dat,";
					$dwSvcFlags |= SVC_DATALINK;
			 }
			 elseif (!strncasecmp("int", $sval, 3)) 
				 {
	     		$status.="inc,";
					$dwSvcFlags |= SVC_INTERNET;
			 }
			 elseif (!strncasecmp("end", $sval, 3)) 
				 {
				$status.="end,";
					$dwSvcFlags |= SVC_ENDTOEND;
			 }
			 elseif (!strncasecmp("app", $sval, 3)) 
				 {
				$status.="app,";
					$dwSvcFlags |= SVC_APPLICATION;
			 }
		  }
				
		  //echo "service status=$status\n";
		  $sVal = $dwSvcFlags;
			  $sTag = SNMP_SERVICE_TAG;
		  $modInstStr .= $sTag.'='.$sVal.'&';
          
       }
       else
       {
          ApendsettingsPair($sName,$sVal);
          
       }

    } //for $nProp
    
}


//--------------------------------------------------------------------------
function ModifySecurityProperties($instance)
{
    global $modInstStr;
    $communityStrFalg = 0;
    $sTagCommStr = VALID_COMMUNITIES_TAG;
    $sTagCommStrRight = COMMUNITY_RIGHTS_TAG;
    
    $nlProps = $instance->get_elements_by_tagname("PROPERTY");
    $numnlProps =count($nlProps);
    //print ("ModifySecurityProperties nlProps count=".$numnlProps);
    
    for ($nProp = 0; $nProp <$numnlProps; $nProp++)
    {
       $eltProp = $nlProps[$nProp];
       $sName = $eltProp->get_attribute ("NAME");
       $sVal = GetChildNodeValue($eltProp);
       //print "sName--->$sName, sVal-->$sVal   ";

       if ("send_auth_trap" == $sName
           or "accept_specific_hosts" == $sName)
       {
          ApendsettingsPair($sName,$sVal);
       }
       elseif ("accepted_hosts" == $sName)
       {
          $sTag = ACCEPTED_HOSTS_TAG;
          $sVal = str_replace(",", GROUP_CONFIG_DELIM_STR, $sVal);  
          $modInstStr .= $sTag.'='.$sVal.'&';
       }
       else
       {
          $communityStrFalg = 1;
          static $commStr="";
          static $commStrRights="";
          
          $commStr .= $sName.GROUP_CONFIG_DELIM_STR;
          $commStrRights .= $sVal.GROUP_CONFIG_DELIM_STR;
       }
    }//for
  
    if( $communityStrFalg == 1 && $commStr !== "")
        $modInstStr .= $sTagCommStr.'='.$commStr.'&'.$sTagCommStrRight.'='.$commStrRights.'&';
    
}


//--------------------------------------------------------------------------
function ModifyTrapProperties($instance)
{
    global $traps;
    $nlProps = $instance->get_elements_by_tagname("PROPERTY");
    
    $numnlProps =count($nlProps);
    //print ("ModifyTrapProperties nlProps count=".$numnlProps);
    for ($nProp = 0; $nProp < $numnlProps; $nProp++)
    {
       $eltProp = $nlProps[$nProp];
       $sName = $eltProp->get_attribute ("NAME");
       $sVal = GetChildNodeValue($eltProp);
       //print "sName--->$sName, sVal-->$sVal   ";
               
       $sVal = str_replace(",", ";", $sVal);  //use ";" as delimiter for destination host names
       $traps["trapcommstr"] .= $sName.GROUP_CONFIG_DELIM_STR;
       $traps["trapdest"] .= $sVal.GROUP_CONFIG_DELIM_STR;
	   //echo "trapcomstr:".$traps["trapcommstr"];
	   return $traps;
       
    }//for
}


//--------------------------------------------------------------------------
function ModifyThresholdProperties($instance)
{
    global $modInstStr;
    
    $nlProps = $instance->get_elements_by_tagname("PROPERTY");
    $numnlProps =count($nlProps);
    //print ("ModifyThresholdProperties nlProps count=".$numnlProps);
    for ($nProp = 0; $nProp < $numnlProps; $nProp++)
    {
       $eltProp = $nlProps[$nProp];
       $sName = $eltProp->get_attribute ("NAME");
       $sVal = GetChildNodeValue($eltProp);
       ApendsettingsPair($sName,$sVal);
    }//for
}


//--------------------------------------------------------------------------
function DoEnumerateInstances($reqxml)
{

	global $cfgexe;
	global $webapp;
	
    
	$snmpxmlFile = '';  //default local directory
	if( isset( $_SERVER["HTTP_HPSMH_SESSIONDIR"]))
	    $snmpxmlFile = $_SERVER["HTTP_HPSMH_SESSIONDIR"].'/snmpcfg.xml';
    
	$snmpxmlFile= str_replace("/", "\\\\", $snmpxmlFile);
	
	$command = "GETGRP ".$snmpxmlFile;
	$tmp= "command line:".$cfgexe." ".$command;

	if ($GLOBALS[debug])
	 	fputs($reqxml->fp, "$tmp\n" );

	$rc = exec($cfgexe.' '.$command, $returnXML, $retval);
	
	if ($GLOBALS[debug])
	{
		for ($i = 0; $i<count($returnXML); $i++)
		{ 
			fwrite($reqxml->fp, "result from exec(GETGRP):");
			fwrite($reqxml->fp, $returnXML[$i]);
			fwrite($reqxml->fp, "\n");
		}
	}
    
	//$xmldoc = domxml_open_mem(file_get_contents($snmpxmlFile));
	$xmldoc = domxml_open_file($snmpxmlFile);

	//now delete the temp xml file
	unlink($snmpxmlFile);  
    
	if($xmldoc) 
	{
		if ($GLOBALS[debug])
			fputs($reqxml->fp, "Success opening snmpxmlfile.\n");

		$real_path_xsl = realpath ("./snmpcfg.xsl");
		$xsldoc = domxml_xslt_stylesheet_file($real_path_xsl );
		$result =  $xsldoc->process($xmldoc);
		$output = $xsldoc->result_dump_mem($result);  

		//get rid of the <?xml...> header before sending it back, otherwise won't work
		$content = strstr($output, '>');
		$xmlcontent = strstr($content, '<');
		print $xmlcontent;  //as enumerateInstance response

	}
	else
	{
		fputs($reqxml->fp, "Open ".$snmpxmlFile." file failed.\n");
		SendResponseXML($reqxml, CIM_ERR_FAILED, "Error occured in handling EnumerateInstace request");
	}

}


//--------------------------------------------------------------------------
function DoModifyInstance( $reqxml )
{
   $errCode = 0;
   $badkeys = "";
   global $modInstStr;
   global $cfgexe;
   
   
   $numMethod = count($reqxml->nlMethod);
   if ($GLOBALS[debug])
       fputs($reqxml->fp,"DoModifyInstance numMethod=".$numMethod."\n");

   
   for ($iMethod = 0; $iMethod<$numMethod; $iMethod++)
   {
	   //$node = $reqxml->nlMethod[$iMethod]; syntax error, so split this statement to two in below
	   $tmpMethod = $reqxml->nlMethod;
	   $node = $tmpMethod[$iMethod];
	   $listInstances = $node->get_elements_by_tagname("INSTANCE");
        
	   for ($iInst = 0; $iInst<count($listInstances); $iInst++)
	   {
		  $instance = $listInstances[$iInst];
		  //print ("The element[$iInst] is: ".$instance->get_content());
		  $sClassName = $instance->get_attribute("CLASSNAME");
		  //print ("sClassname -->".$sClassName);
		  if( "Cpq_SNMPAgentSettings" ==  $sClassName ||
			  "Cpq_CompaqAgentSettings" == $sClassName)
		  {
			 ModifyAgentProperties( $instance);
		  }
		  elseif ("Cpq_SNMPSecuritySettings" == $sClassName) 
		  {
			 ModifySecurityProperties($instance);
		  }
		  elseif ("Cpq_SNMPTrapSettings" == $sClassName) 
		  {
			 $traps = ModifyTrapProperties($instance);
		  }
		  elseif ("Cpq_WINOSThresholdSettings" == $sClassName) 
		  {
			 ModifyThresholdProperties($instance);
		  }

	   } //for Instance

	}//for Method


	// use if( $traps["trapcommstr"] !== "") does not work
	if(strcasecmp("", $traps["trapcommstr"]))
	{
	   $modInstStr .= TRAP_COMMUNITIES_TAG.'='.$traps["trapcommstr"].'&'.TRAP_DESTINATION_TAG.'='.$traps["trapdest"].'&';
	}

	//get rid of the last '&'
	$modInstStr = substr($modInstStr,0,strlen($modInstStr)-1);
	
	//replace the space into hex number
	$modInstStr = str_replace(" ", "%20", $modInstStr);

	//since '&' and ',' is invalid char for values, so it is safe here to assume that '&' is the delimiter to be escaped
	$modInstStr = str_replace("&", "%26", $modInstStr);

	$command = "SET ".$modInstStr;
	$tmp = "command line:".$cfgexe." ".$command;

	if($GLOBALS[debug])
  		fputs($reqxml->fp, "$tmp\n");

	$rc = exec($cfgexe.' '.$command, $returnXML, $retval);

	if ($GLOBALS[debug])
	{
		for ($i = 0; $i<count($returnXML); $i++)
		{ 
			fwrite($reqxml->fp, "result from exec(SET):");
			fwrite($reqxml->fp, $returnXML[$i]);
			fwrite($reqxml->fp, "\n");
		}
	}

	SendResponseXML($reqxml, $errCode, $badkeys);

} //end of DoModifyInstance()



//--------------------------------------------------------------------------
function DoApplyToAll($reqxml)
{
?>

<CIM CIMVERSION="2.0" DTDVERSION="2.0">

   <MESSAGE ID="<?php echo $reqxml->parsedval('messageid')+10; ?>" PROTOCOLVERSION="1.0">
      <SIMPLERSP>
         <IMETHODRESPONSE NAME="ApplyToAll" />
      </SIMPLERSP>
   </MESSAGE>
</CIM>


<?php
}   // end DoApplyToAll


?>
