// RCSfile: MS-DACMN.JS Revision: 1.19 $

function boxName(idx)
{
   var name = "";
   var box = cpqSsDrvBoxEntry[idx];

   if (box.cpqSsBoxPlacement == 2)
   {
      name = "Internal ";
   }
   else if (box.cpqSsBoxPlacement == 3)
   {
      name = "External ";
   }
   name += "Storage System on Port " + box.cpqSsBoxBusIndex;
   return name;
}
function storageSysName(idx, port)
{
   var i = parseInt(idx) + 1;
   var name = "Storage System ";
   name += cpqSsChassisEntry[idx].cpqSsChassisName;
   name += " on Port " + port;
   return name;
}
function logDrvName(idx)
{
   var drive = cpqDaLogDrvEntry[idx];
   var name = "Logical Drive " + drive.cpqDaLogDrvIndex;

   if (drive.cpqDaLogDrvFaultTol == 2)
   {
      name += " - No Fault Tolerance";
   }
   else if (drive.cpqDaLogDrvFaultTol > 2)
   {
      name += " - " + displayItem("cpqDaLogDrvFaultTol", drive.cpqDaLogDrvFaultTol);
   }
   return name;
}
function phyDrvName(idx)
{
   var i;
   var drive = cpqDaPhyDrvEntry[idx];
   var size = parseInt(drive.cpqDaPhyDrvSize, 10);
   var name = "Port " + drive.cpqDaPhyDrvBusNumber + " Drive " + drive.cpqDaPhyDrvBay;

   if (!isNaN(size) && size > 0)
   {
      name += "  " + drive.cpqDaPhyDrvSize + " MB";
   }
   if (drive.cpqDaPhyDrvConfigurationStatus == 3)
   {
      name += " - Unconfigured";
   }
   else
   {
      for (i = 0; i < cpqDaSpareEntry.length; i++)
      {
         if (cpqDaSpareEntry[i].cpqDaSpareCntlrIndex == drive.cpqDaPhyDrvCntlrIndex &&
             cpqDaSpareEntry[i].cpqDaSparePhyDrvIndex == drive.cpqDaPhyDrvIndex)
         {
            name += " - Spare";
         }
      }
   }
   return name;
}
function daCntlrBoardName(idx)
{
   var rc = displayItem("cpqDaCntlrModel", cpqDaCntlrEntry[idx].cpqDaCntlrModel) + " Controller ";

   if (cpqDaCntlrEntry[idx].cpqDaCntlrHwLocation != "")
   {
      if (cpqDaCntlrEntry[idx].cpqDaCntlrHwLocation == "Slot 0")
         rc += "on System Board";
      else
         rc += "in "+ cpqDaCntlrEntry[idx].cpqDaCntlrHwLocation;
   }
   else if (cpqDaCntlrEntry[idx].cpqDaCntlrSlot == 0)
   {
      rc += "on System Board";
   }
   else
   {
      rc += "in Slot " + cpqDaCntlrEntry[idx].cpqDaCntlrSlot;
   }
   return rc;
}
function daCntlrName(idx)
{
   var name = daCntlrBoardName(idx);

   with(cpqDaCntlrEntry[idx])
   {
      if (typeof(cpqDaCntlrCurrentRole) != "undefined")
      {
         if (cpqDaCntlrCurrentRole == 3 && cpqDaCntlrPartnerSlot != -1)
         {
            if (cpqDaCntlrPartnerSlot == 0)
               name += "/on System Board";
            else if (cpqDaCntlrSlot == 0)
               name += "/Slot " + cpqDaCntlrPartnerSlot;
            else
               name += "/" + cpqDaCntlrPartnerSlot;
         }
         if ((cpqDaCntlrCurrentRole == 3 || cpqDaCntlrCurrentRole == 4) &&
              cpqDaCntlrPartnerSlot == -1)
         {
            if (cpqDaCntlrRedundancyType == 3)
               name += "/Other Server";
            else
               name += "/Unknown";
         }
      }
   }
   return name;
}
function compileDaCondition()
{
   this.state = 1;  // reset to unknown
   this.update(cpqDaCntlrEntry[this.index].cpqDaCntlrCondition);
}
function daTapeDriveIndex(cntlr, bus, id)
{
   for (idx = 0; idx < cpqDaTapeDrvEntry.length; idx++)
   {
      if (cpqDaTapeDrvEntry[idx].cpqDaTapeDrvCntlrIndex == cntlr &&
          cpqDaTapeDrvEntry[idx].cpqDaTapeDrvBusIndex == bus &&
          cpqDaTapeDrvEntry[idx].cpqDaTapeDrvScsiIdIndex == id)
         break;
   }
   return idx;
}
function daTapeDriveName(i)
{
   var name = "";
   if (i < cpqDaTapeDrvEntry.length)
   {
      name  = cpqDaTapeDrvEntry[i].cpqDaTapeDrvName +
            " - Bus " + cpqDaTapeDrvEntry[i].cpqDaTapeDrvBusIndex +
            " Drive " + cpqDaTapeDrvEntry[i].cpqDaTapeDrvScsiIdIndex;
   }
   return name;
}
function daTapeLibraryName(i)
{
   var name = cpqDaTapeLibraryEntry[i].cpqDaTapeLibraryModel +
        " - Bus " + cpqDaTapeLibraryEntry[i].cpqDaTapeLibraryScsiBus +
        " Device " + cpqDaTapeLibraryEntry[i].cpqDaTapeLibraryScsiTarget;
   return name;
}
function hotPlugGraphic()
{
   return ("<img src='/WEBAGENT/CQMGSTOR/ENG/HOTPLUG.JPG' align='middle' width='11' height='15' hspace='3' border='0'> ");
}
function daDriveCapacity(item, size)
{
   var rc = parseInt(size, 10);

   if (isNaN(rc) || rc <= 0)
   {
      rc = "N/A";
   } else {
      rc = displayItem(item, size);
   }
   return rc;
}
