<html>
<!-- RCSfile: MS-DTLIB.TPL Revision: 1.11  -->
<!-- (C) Copyright 2003 Hewlett-Packard Development Company, L.P. -->
<head>
<title>Drive Array Tape Library Information</title>

<!#/COMMON/PAGETAGS.TPL>

<script language="JavaScript">
contextHelp = true;

<!cpqDaCntlrEntry>
<!cpqDaTapeLibraryEntry>
<!cpqDaTapeLibraryDriveList2.raw>
<!cpqDaTapeDrvEntry>

<!#/COMMON/COND.JS>
<!#/COMMON/STDITEMS.JS>
<!#/COMMON/TABLES.JS>
<!#/COMMON/PARSEARG.JS>
<!#/COMMON/DISPBASE.JS>
<!#/COMMON/NUMCNVRT.JS>
<!#DAENUMS.JS>
<!#MS-DACMN.JS>

function makeDriveLink(linkHref, linkText, target)
{
   return("<a href=\"" + linkHref + "\" target=\"" + target
      + "\">" + linkText + "</a>");
}
</script>
</head>
<script language="JavaScript">

writeBodyHead();

libIndex = findArg("libindex");

if (libIndex == -1)
{
   parseArgs(tryPrevPage());
   libIndex = findArg("libindex");
}
for (index = 0; index < cpqDaTapeLibraryEntry.length; index++)
{
   if (libIndex == cpqDaTapeLibraryEntry[index].length)
      break;
}
if (libIndex == cpqDaTapeLibraryEntry.length)
{
   reportMissingArgs();
}
else
{
   writePageHead("Tape Storage System Information", "/WEBAGENT/IMAGES/MASSHDR.GIF");
   cond = new cpqCondition(1);
   cond.set(cpqDaTapeLibraryEntry[libIndex].cpqDaTapeLibraryCondition);
   writeTableLabel(cond.image() + daTapeLibraryName(libIndex), "Information");
   writeTableHead();
   writeDoubleTableRow(
      "Status:", displayItem("cpqDaTapeLibraryStatus", cpqDaTapeLibraryEntry[libIndex].cpqDaTapeLibraryStatus),
      "Model:",  displayItem("cpqDaTapeLibraryName",   cpqDaTapeLibraryEntry[libIndex].cpqDaTapeLibraryModel));
   writeDoubleTableRow(
      "Serial Number:", displayItem("cpqDaTapeLibrarySerialNumber", cpqDaTapeLibraryEntry[libIndex].cpqDaTapeLibrarySerialNumber),
      "Firmware Rev:",  displayItem("cpqDaTapeLibraryFWRev",        cpqDaTapeLibraryEntry[libIndex].cpqDaTapeLibraryFWRev));
   writeDoubleTableRow(
      "Current Width:", displayItem("cpqDaTapeLibraryCurrentWidth", cpqDaTapeLibraryEntry[libIndex].cpqDaTapeLibraryCurrentWidth),
      "Current Speed:", displayItem("cpqDaTapeLibraryCurrentSpeed", cpqDaTapeLibraryEntry[libIndex].cpqDaTapeLibraryCurrentSpeed));
   writeDoubleTableRow(
      "Door Status:",   displayItem("cpqDaTapeLibraryDoorStatus", cpqDaTapeLibraryEntry[libIndex].cpqDaTapeLibraryDoorStatus),
      "Service Hours:", displayItem("cpqDaTapeLibraryStatHours",  cpqDaTapeLibraryEntry[libIndex].cpqDaTapeLibraryStatHours));
   writeDoubleTableRow(
      "Total Moves:",      displayItem("cpqDaTapeLibraryStatMoves", cpqDaTapeLibraryEntry[libIndex].cpqDaTapeLibraryStatMoves),
      "Last Known Error:", displayItem("cpqDaTapeLibraryLastError", hexfromdec(cpqDaTapeLibraryEntry[libIndex].cpqDaTapeLibraryLastError) +"h"));
   writeTableTail();

   document.write("<br>");
   writeTableLabel("Associated Tape Drives");
   writeTableHead();
   driveCount = 0;
   driveCond = new cpqCondition(1);

   if (cpqDaTapeLibraryEntry[libIndex].cpqDaTapeLibraryDriveList2 != "")
   {
      driveList = cpqDaTapeLibraryDriveList2[libIndex];
      for (j = 0; j < driveList.length; j += 7)
      {
         cntlrIdx = (driveList[j+3] << 24) + (driveList[j+2] << 16) +
                     (driveList[j+1] << 8) + driveList[j];  // 4 byte value
         scsiBus = driveList[j+4];
         scsiId  = driveList[j+5];
         drive = daTapeDriveIndex(cntlrIdx, scsiBus, scsiId);

         if (drive < cpqDaTapeDrvEntry.length)
         {
            driveCond.set(cpqDaTapeDrvEntry[drive].cpqDaTapeDrvCondition);
            driveLink = makeDriveLink("MS-DTAPE.TPL?index=" + drive,
                                       daTapeDriveName(drive), "_self");
            writeOneItemTableRow(driveCond.imageSmall() + driveLink);
            driveCount++;
         }
      }
   }
   if (driveCount == 0)  writeOneItemTableRow("None");

   writeTableTail();
}
writeBodyTail();
</script>
</html>
