// RCSfile: MS-SCSIC.JS Revision: 1.13 $

function scsiCntlrName(idx)
{
   var rc = "SCSI Controller Port " + cpqScsiCntlrEntry[idx].cpqScsiCntlrBusIndex;
   if (cpqScsiCntlrEntry[idx].cpqScsiCntlrHwLocation != "")
   {
      if (cpqScsiCntlrEntry[idx].cpqScsiCntlrHwLocation == "Slot 0")
         rc += " on System Board";
      else
         rc += " in " + cpqScsiCntlrEntry[idx].cpqScsiCntlrHwLocation;
   }
   else if (cpqScsiCntlrEntry[idx].cpqDaCntlrSlot == 0)
      rc += " on System Board";
   else
      rc += " in Slot " + cpqScsiCntlrEntry[idx].cpqScsiCntlrSlot;
   return rc;
}
function scsiCntlrCondition(idx, imageSize)
{
   var cond = new cpqCondition(cpqScsiCntlrEntry[idx].cpqScsiCntlrStatus);
   if (cpqScsiCntlrEntry[idx].cpqScsiCntlrStatus == 3)
   {
      cond.set(4);  // failed
   }
   if (imageSize == "LARGE")
      return cond.image();

   return cond.imageSmall();
}
function compileScsiCondition()
{
   this.state = 1;  // reset to unknown
   this.update(cpqScsiCntlrEntry[this.index].cpqScsiCntlrCondition);
}
function targetType(idx)
{
   var scsiType = displayItem("cpqScsiTargetType",         cpqScsiTargetEntry[idx].cpqScsiTargetType);
   var extType  = displayItem("cpqScsiTargetTypeExtended", cpqScsiTargetEntry[idx].cpqScsiTargetTypeExtended);

   if (cpqScsiTargetEntry[idx].cpqScsiTargetTypeExtended == 2)
   {
      scsiType =  extType + " " + scsiType;
   }
   else if (cpqScsiTargetEntry[idx].cpqScsiTargetTypeExtended == 4 ||  // tape library
            cpqScsiTargetEntry[idx].cpqScsiTargetTypeExtended == 5 ||  // cd library
            cpqScsiTargetEntry[idx].cpqScsiTargetTypeExtended == 6 ||  // CR3500 controller
            cpqScsiTargetEntry[idx].cpqScsiTargetTypeExtended == 7)    // tape autoloader
   {
      scsiType = extType;
   }
   return scsiType;
}
function targetName(idx)
{
   rc = targetType(idx) + " - SCSI ID " + cpqScsiTargetEntry[idx].cpqScsiTargetScsiIdIndex;
   return rc;
}
function targetStatusGraphic(idx, alignment)
{
   var thisStatus  = new cpqCondition(1);
   var targType    = cpqScsiTargetEntry[idx].cpqScsiTargetType;
   var targTypeExt = cpqScsiTargetEntry[idx].cpqScsiTargetTypeExtended;
   var localCntlr  = cpqScsiTargetEntry[idx].cpqScsiTargetCntlrIndex;
   var localBus    = cpqScsiTargetEntry[idx].cpqScsiTargetBusIndex;
   var localId     = cpqScsiTargetEntry[idx].cpqScsiTargetScsiIdIndex;
   var i;

   if (targType == 2)  // drive, use phy drive status
   {
      for (i = 0; i < cpqScsiPhyDrvEntry.length; i++)
      {
         if (cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvCntlrIndex == localCntlr &&
             cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvBusIndex == localBus &&
             cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvScsiID == localId)
         {
            thisStatus.update(cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvCondition);
         }
      }
   }
   else if (targType == 3)  // tape drive
   {
      for (i = 0; i < cpqTapePhyDrvEntry.length; i++)
      {
         if (cpqTapePhyDrvEntry[i].cpqTapePhyDrvCntlrIndex == localCntlr &&
             cpqTapePhyDrvEntry[i].cpqTapePhyDrvBusIndex == localBus &&
             cpqTapePhyDrvEntry[i].cpqTapePhyDrvScsiIdIndex == localId)
         {
            thisStatus.update(cpqTapePhyDrvEntry[i].cpqTapePhyDrvCondition);
         }
      }
   }
   else if (targTypeExt == 4)  // tape library
   {
      for (i = 0; i < cpqTapeLibraryEntry.length; i++)
      {
         if (cpqTapeLibraryEntry[i].cpqTapeLibraryCntlrIndex == localCntlr &&
             cpqTapeLibraryEntry[i].cpqTapeLibraryBusIndex == localBus &&
             cpqTapeLibraryEntry[i].cpqTapeLibraryScsiIdIndex == localId)
         {
            thisStatus.update(cpqTapeLibraryEntry[i].cpqTapeLibraryCondition);
         }
      }
   }
   else if (targTypeExt == 5)  // CD library
   {
      for (i = 0; i < cpqCdLibraryEntry.length; i++)
      {
         if (cpqCdLibraryEntry[i].cpqCdLibraryCntlrIndex == localCntlr &&
             cpqCdLibraryEntry[i].cpqCdLibraryBusIndex == localBus &&
             cpqCdLibraryEntry[i].cpqCdLibraryScsiIdIndex == localId)
         {
            thisStatus.update(cpqCdLibraryEntry[i].cpqCdLibraryCondition);
         }
      }
   }
   if (alignment == "LARGE")
      return thisStatus.image();

   return thisStatus.imageSmall(alignment);
}
function driveCapacity(item, size)
{
   var rc = parseInt(size, 10);

   if (isNaN(rc) || rc <= 0)
   {
      rc = "N/A";
   } else {
      rc = displayItem(item, size);
   }
   return rc;
}
function logDrvName(idx)
{
   var drive = cpqScsiLogDrvEntry[idx];
   var name = "Logical Drive " + drive.cpqScsiLogDrvIndex;

   if (drive.cpqScsiLogDrvFaultTol == 2)
   {
      name += " - No Fault Tolerance";
   }
   else if (drive.cpqScsiLogDrvFaultTol > 2)
   {
      name += " - " + displayItem("cpqScsiLogDrvFaultTol", drive.cpqScsiLogDrvFaultTol);
   }
   return name;
}
function phyDriveName(idx)
{
   var i;
   var name = "Unknown";
   var ctl = cpqScsiPhyDrvEntry[idx].cpqScsiPhyDrvCntlrIndex;
   var bus = cpqScsiPhyDrvEntry[idx].cpqScsiPhyDrvBusIndex;
   var tid = cpqScsiPhyDrvEntry[idx].cpqScsiPhyDrvScsiID;

   for (i = 0; i < cpqScsiTargetEntry.length; i++)
   {
      if (cpqScsiTargetEntry[i].cpqScsiTargetCntlrIndex  == ctl &&
          cpqScsiTargetEntry[i].cpqScsiTargetBusIndex    == bus &&
          cpqScsiTargetEntry[i].cpqScsiTargetScsiIdIndex == tid)
         name = targetName(i);
   }
   return name;
}
