<?php

# echo "\n// ginkgosnmp included here\n";

$sessiondir = $_SERVER['HTTP_HPSMH_SESSIONDIR'];
$tempfilename = "$sessiondir/" . substr($_SERVER["SCRIPT_URL"], 1 + strrpos($_SERVER["SCRIPT_URL"], '/')) . uniqid(".", true) . time() . ".txt";

$ginkgoset_result = "failed";

require("ginkgoprop.inc");

function DoLeafSet( $leaflist )
{
    global $tempfilename;
    global $ginkgoset_result;

    #echo "doing leaf set";

    if( 1 == count( $leaflist ))
    {
        # one leaf - set it
        $fp = fopen( $tempfilename, "w" );

        foreach ($leaflist as $key => $value)
        {
            if( !OIDWriteAccess( $key ) )
            {
                $ginkgoset_result = "not authorized";
                return;
            }

            fwrite( $fp, "$key $key setleaf $value\n" );
        }
        fwrite( $fp, "\n");

        fclose( $fp );

        if("Linux" == PHP_OS)
           $cmd = "../../../webapp-data/webagent/csginkgo\x3c$tempfilename";
        else
           $cmd = "..\\..\\..\\smhutil\\csginkgo.exe\x3c$tempfilename";

        #echo "<br>cmd:  $cmd\n";

        exec( $cmd, $out );

        #--- delete the cmd file
        unlink( $tempfilename );

        $i = 0;
        $succeeded = 1;
        foreach ($out as $line)
        {
            #echo "<br>line $i:  $line\n";

            if (0<$i)   # skip the first line
            {
                if (strpos($line, "failed")) # a set failed
                {
                    $succeeded = 0;
                }
            }
            $i++;
        }


        if ($succeeded)
        {
            # redirect to
            #echo "<br>set succeeded";
            $ginkgoset_result = 'succeeded';
        }
        else
        {
            $ginkgoset_result = 'failed';
        }

    }
    elseif ( 0 >= count( $leaflist ) )
    {
        $ginkgoset_result = 'no leaf';
    }
    else
    {
        $ginkgoset_result = 'too many leaves';

        #foreach ($leaflist as $key => $value)
        #{
        #    echo "<br>$key == $value\n";
        #}
    }
}


function DoTableSet( $indeces, $oidrows )
{
    global $tempfilename;
    global $ginkgoset_result;

    $tableleaves = array();

    # check that the right number of values are there for each oidrow
    $indexcount = count( $indeces );
    #echo "indeces($indexcount) : " . join(',', $indeces) . "\n<br>";
    foreach ($oidrows as $key => $value)
    {
        if( !OIDWriteAccess( $key ) )
        {
            $ginkgoset_result = "not authorized";
            echo ("<script>alert('not authorized for $key');</script>\n");
            return;
        }

        $splitrow = split(',' , $value);
        $rowcount = count( $splitrow );

        #echo "oid $key($rowcount) :  $value \n<br>";

        if($rowcount != $indexcount)
        {
            $ginkgoset_result = "tableset count mismatch";
            return;
        }

        $tableleaves[ $key ] = $splitrow;
    }

    # open the command file
    $fp = fopen( $tempfilename, "w" );

    # put together the set commands for the requested
    foreach( $tableleaves as $key => $value )
    {
        for($i=0; $i< count( $indeces ); $i++)
        {
            #echo "<br>set $key.$indeces[$i] to value $value[$i]\n";
            fwrite( $fp, "$key.$indeces[$i]  $key.$indeces[$i] setleaf $value[$i]\n");
        }
    }

    fclose( $fp );

    if("Linux" == PHP_OS)
       $cmd = "../../../webapp-data/webagent/csginkgo.exe\x3c$tempfilename";
    else
       $cmd = "..\\..\\..\\smhutil\\csginkgo.exe\x3c$tempfilename";

    #echo "<br>cmd:  $cmd\n";

    exec( $cmd, $out );

    #--- delete the cmd file
    unlink( $tempfilename );

    $i = 0;
    $succeeded = 1;
    foreach ($out as $line)
    {
        #echo "<br>line $i:  $line\n";

        if (0<$i)   # skip the first line
        {
            if (strpos($line, "failed")) # a set failed
            {
                $succeeded = 0;
            }
        }
        $i++;
    }


    if ($succeeded)
    {
        #echo "<br>set succeeded";
        $ginkgoset_result = 'succeeded';
    }
    else
    {
        $ginkgoset_result = 'failed';
    }

}

if( "POST" == $_SERVER["REQUEST_METHOD"])
{
    $settype = "UNKNOWN";  # default value
    $leafitems = array();

    #echo "<h2>referrer:  $originalpage</h2>";

    if( array_key_exists( "SNMPSET", $_POST ))
    {
        $settype = $_POST["SNMPSET"];
    }

    foreach ($_POST as $key => $value)
    {
       #echo "<br>$key :== $value\n";
       if("INDEX" == $key)
       {
           # these are the indeces for the sets
           $indeces = split(',', $value);
       }
       elseif ("SNMPSET" != $key)
       {
           # fixup the oid
           #echo "key $key -- value $value<br>";

           $oid = str_replace( "_", ".", $key );
           if( "." != $oid[0] )    $oid = ".$oid";

           if( "LEAF" == $settype )
           {
               if( ".0" != substr( $oid, -2 ) )   $oid = "$oid.0";
                $leafitems[ $oid ] = $value;
           }
           elseif( "TABLESET" == $settype )
           {
               $leafitems[ $oid ] = $value;
           }
       }
    }


    # process the set
    if("LEAF" == $settype)
    {
        DoLeafSet( $leafitems );
    }
    elseif("TABLESET" == $settype)
    {
        DoTableSet( $indeces, $leafitems );
    }
    else
    {
        $ginkgoset_result = 'unkown set type';
    }
}
else
{
    $ginkgoset_result = 'post only';
}



?>
