<HTML>
<HEAD>
<TITLE>UB-RD-01</TITLE>
<STYLE><!#master.css></STYLE>
<META http-equiv="Content-Type" content="text/html; charset=<!=/ACU-XE/CharSet=Message>iso-8859-1<!/CharSet>">
</HEAD>
<!#common.htm>
<SCRIPT SRC="ACUTools.js"></SCRIPT>
<SCRIPT>

InitWizKeyboard();

   //-----------------------------------------------------------------------------
   // Name: PrintLDPage()
   // Desc: This function creates the webpage that the user can use to reorder the
   //       logical drives.
   //
   // Parameters:      LDArray - array containing numbers of available LDs
   // Return Value:    none
   // Pre-conditions:  LDArray must have no repeating integers; each value must be
   //                  unique.
   // Post-conditions: none
   //                                                                    mm29May03
   //-----------------------------------------------------------------------------

   function PrintLDPage(LDArray)
   {
      document.write("<br><br>");
      document.write("<DIV id=bigHeaderBlue>");
      WriteString("PX_TAG_LDRIVE_REORDERING");
      document.write("</DIV>");
      document.write("<form name='DriveOrderForm' method=post>");

      // Make a table with the logical drive order options.
      document.write("<TABLE>");
      for(var i=0; i<LDArray.length; ++i)
      {
         document.write("<TR><TD>Change logical drive number <b>" + LDArray[i] + "</b>    to number </TD><TD>");
         LoadLDMenuOptions(32, i, LDArray[i]);
         document.write("</TD></TR>");
      }
      document.write("</TABLE>");

      document.write("</form><br />");
   }






   //-----------------------------------------------------------------------------
   // Name: LoadLDMenuOptions()
   // Desc: This function loads a pull-down menu with nLength number of items
   //       with the current selection being nSelection.
   //
   // Parameters:      nLength    - Number of logical drives that are to be
   //                               presented to the user.
   //                  nCurrentOptionValue - Current logical drive selection of
   //                    the menu option.
   //                  nCurrentOption - Current menu option.
   //
   // Return Value:    none
   // Pre-conditions:  This function assumes that the new document is already open
   // Post-conditions: The calling function needs to close the document because it
   //                  is not closed.
   //                                                                    mm29May03
   //-----------------------------------------------------------------------------

   function LoadLDMenuOptions(nLength, nCurrentOption, nCurrentOptionValue)
   {
      document.write("<select id=Drive" + nCurrentOption);
      document.write(" onchange=\"CorrectLDSelections(this," + nCurrentOption + ")\">");
      document.write(" \">");
      for(var i=1; i<(nLength+1); ++i)
      {
         document.write("<option>" + i + "</option>");
      }
      document.write("</select><br />");
      document.getElementById("Drive" + nCurrentOption).selectedIndex = nCurrentOptionValue - 1;
      //AddKBIndex("Drive" + nCurrentOption);
      //kbIdArray["Drive" + nCurrentOption].isSelect = true;
   }






   //-----------------------------------------------------------------------------
   // Name: CorrectLDSelections()
   // Desc: This function corrects what items are selected in the drop down menus
   //       for the logical drive options. For example, lets say that there are
   //       four menu options with the following logical drives selected:
   //
   //       Init: 0,1,2,3   User Change: 0,1,0,3   CorrectLDSelections: 2,1,0,3
   //
   // Parameters:      obOption   - Option object that was changed by the user.
   //                  nSelection - This represents the array offset that we are
   //                               working with.
   //
   // Return Value:    none
   // Pre-conditions:  The drop down menu must be initialized and the DriveX
   //                  naming must be used with the option objects. LDArray must
   //                  previously have been initialized.
   // Post-conditions: Every selected drop down menu option is different than any
   //                  other drop down menu selection.
   //                                                                    mm29May03
   //-----------------------------------------------------------------------------

   function CorrectLDSelections(obOption, nSelection)
   {
      var nNewValue = obOption.selectedIndex + 1;
      var nOldValue = LDArray[nSelection];

      for(var i=0; i<LDArray.length; ++i)
      {
         if(LDArray[i] == nNewValue && i != nSelection)
         {
               document.getElementById("Drive" + i).selectedIndex = nOldValue - 1;
               LDArray[i] = LDArray[nSelection];
         }
      }
      LDArray[nSelection] = nNewValue;
   }

   numChoices = 0;
   focusTag = 0;
   <!.Request=FOCUS>
   userTag = 0;
   <!.Request=TAG>

   function HandleSave()
   {
      document.next.REORDER_LDRIVE_NUMBERS.value="*" + LDArray.join(",");
      document.next.submit();
      return false;
   }
   LoadNavPage("PX_TAG_SAVE","SV('next','NU-01.htm','HandleSave()')", // 'HandleSave()'
               "PX_TAG_CANCEL","S('cancel','NU-01.htm')");
   LoadFaqPage("070,071,031,032");
   LoadProgPage("PX_TAG_LDRIVE_REORDERING",100);
   LoadLBConfigPage();
   InitWizKeyboard();
</SCRIPT>

<BODY id=BODY onload="wizLoad();" oncontextmenu="return DisableRightClick();">
<DIV id=instruction>
<SCRIPT>
//<BODY id=BODY onfocus="wizFocus();" onload="wizLoad();" onblur="wizBlur();" oncontextmenu="return DisableRightClick();">
   document.write("<p>");
   <!.Request=REORDER_LDRIVE_NUMBERS>

   // The elm request will create the LDArray
   if(LDArray)
   {
      PrintLDPage(LDArray);
   }
   document.write("</p>");
</SCRIPT>
</DIV>

<FORM autocomplete="off" name="next"  method="post" action="UB-Saving.htm?PAGE=NU-01">
    <input type='hidden' name='REORDER_LDRIVE_NUMBERS' value=''>
    <SCRIPT>
        insertUserAndFocus();
        DisplayNDRTable();
    </SCRIPT>
</FORM>

<FORM name="cancel">
    <SCRIPT>
    insertUserAndFocus();
    WriteCommand("UNDO_TRANSACTION","DEFAULT");
    </SCRIPT>
</FORM>
</BODY>
<SCRIPT SRC="wizkey.js"></SCRIPT>
</HTML>